//
// C++ Implementation: %{MODULE}
//
// Description:
//
//
// Author: %{AUTHOR} <%{EMAIL}>, (C) %{YEAR}
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "kpgdcoptalkthread.h"

#include <dcopclient.h>
#include <kdebug.h>

KPGDcopTalkThread::KPGDcopTalkThread()
 : QThread()
{
	m_bSessionClosed = false;
}


KPGDcopTalkThread::~KPGDcopTalkThread()
{
}

void KPGDcopTalkThread::setDcopClient(DCOPClient *pDcopClient)
{
  	m_pDcopClient = pDcopClient;
}

void KPGDcopTalkThread::setCommand(const QString & strCommand)
{
  	m_strCommand = strCommand;
}

void KPGDcopTalkThread::run()
{ 
	kdDebug() << "DCOP Id:" << m_pDcopClient->appId() << endl; 
  
  	if(!m_bSessionClosed)
  	{
		 msleep(1000); // wait for Console part creation command available
		 
  		// close session to make sendSession DCOP 
  		bool bClose = m_pDcopClient->send(m_pDcopClient->appId(), "session-1", "closeSession()", "");
  		if(!bClose)
    		kdDebug() << "closeSession failed " << endl;
    
    	m_bSessionClosed = true;
    }
  	
  	msleep(1000); // wait for previous operation
  	
  	// send command to Console part
	bool bSend = m_pDcopClient->send(m_pDcopClient->appId(), "session-1", "sendSession(QString)", m_strCommand); 
	if(!bSend)
		kdDebug() << "sendSession failed " << endl;
}
