/***************************************************************************
                          kpregsystray.cpp  -  description
                             -------------------
    begin                : Wed Aug 8 2001
    copyright          : (C) 2001-2003 by Huberto Gastal Mayer
    email                : beto@debian-rs.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include <qcursor.h>
#include "kpregsystray.h"
// #include <kkeydialog.h>
KpregSysTray::KpregSysTray(QPixmap normalPm, /*QPixmap *darkerPm,*/ QWidget *parent, const char *name): KSystemTray( parent, name )/*, _normalPm(normalPm), _darkerPm(darkerPm)*/
{
	doc = new QDomDocument();
	_normalPm = new QPixmap ( normalPm );
//   KKeyDialog::configure( actionCollection() ); ////////////////!!!!!!!!!!!
}

KpregSysTray::~KpregSysTray(){
}

void KpregSysTray::setPixmap( KpregSysTray::Pixmap pm )
{
    _pm = pm;
}

void KpregSysTray::setSubPoupUpMenu (KPopupMenu *menu)
{
	subMenu = menu;
}

KPopupMenu *KpregSysTray::getPoupUpMenu ()
{
	return contextMenu ();
}

void KpregSysTray::mousePressEvent( QMouseEvent *e )
{
	if( e->button() == RightButton )
	{
		subMenu -> exec( QCursor::pos() );
	}
	else if( e->button() == MidButton )
	{
		contextMenu() -> exec( QCursor::pos() );
	}
	else if( e->button() == LeftButton )
	{
		minimizeRestore ();
	}
}

void KpregSysTray::minimizeRestore()
{
	KAction* action = actionCollection()->action("minimizeRestore");
	action -> activate ();
}

void KpregSysTray::paintEvent( QPaintEvent *e )
{
/*
	QString normalPixmap = KGlobal::dirs()->findResource( "share/apps/kpreg/icons", "kpreg-normal.png" );
    QPixmap normalPm;
    normalPm.load (normalPixmap);
*/
	int x=0;
	int y=0;
/*
    int x = (width()-_normalPm->width())/2;
    int y = (height()-_normalPm->height())/2;
    if( x < 0 ) x = 0;
    if( y < 0 ) y = 0;
*/
    QPainter p;
    p.begin(this);
    p.drawPixmap( x, y, *_normalPm);
    p.end();

    KSystemTray::paintEvent( e );

}

#include "kpregsystray.moc"

