/***************************************************************************
                          kpsk.h  -  description
                             -------------------
    begin                : Son Jul  2 14:14:12 CEST 2000
    copyright            : (C) 2000 by Luc Langehegermann
    email                : lx2gt@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KPSK_H
#define KPSK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <qwidget.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <kmainwindow.h>
#include "mainview.h"
#include "dcddlg.h"
#include "server/server.h"
#include "waterfall.h"
#include "autocallchexdlg.h"
#include "kpskmeter.h"

#define STATUS_TIME 0x00    /* IDs for Status Bar Items */
#define STATUS_DATE 0x01
#define STATUS_FREQ 0x02
#define STATUS_NET  0x03
#define STATUS_AFC  0x04
#define STATUS_DCD  0x05
#define STATUS_TX   0x06
#define STATUS_QPSK 0x07
#define STATUS_CWID 0x08
#define STATUS_IMD  0x09
#define STATUS_TUNE 0x1a
#define STATUS_INC_FREQ 0x1b
#define STATUS_DEC_FREQ 0x1c
#define ABORT_TX    0x1f

#define MENU_LOG_CLEAR   0x10
#define MENU_LOG_SAVE    0x11
#define MENU_LOG_SEARCH  0x12
#define MENU_LOG_QSOINFO 0x13

#define MENU_FILE_SEND   0x20
#define MENU_FILE_SAVE   0x21   /* Not needed, but maybe someone wants it? ;-) */
#define MENU_FILE_CQ     0x22
#define MENU_FILE_AUTOCQ 0x23
#define MENU_FILE_QUIT   0x24

#define MENU_HELP_ABOUT     0x30
#define MENU_HELP_CONTENTS  0x31

#define MENU_SETTINGS_FIXTEXT   	0x40
#define MENU_SETTINGS_PERSONALS 	0x41
#define MENU_SETTINGS_DEVICES   	0x42
#define MENU_SETTINGS_APPEARENCE 	0x44
#define MENU_SETTINGS_BAND				0x45
#define MENU_SETTINGS_SENS				0x46
#define MENU_SETTINGS_AUTOCALLCHEX				0x47


class Kpsk : public KMainWindow
{
  Q_OBJECT 
  public:
    Kpsk();
    ~Kpsk();
  void writeConfig();
	PSK31info rxinfo;
  PSK31info txinfo;
	GTTextWidget* rxwindow;
	GTTextWidget* txwindow;
  kpskmeter* sMeter;
	auxWindow* aux[3];
  QCheckBox* callCheckBox;
	void transmit (bool i);
  void transmitText (QString str);
  void setTXWinFocus();
  void reInit();
private: // Private methods
  void readConfig ();
  void initMenu();
  void initStatusBar();
  bool startServer();
	mainView* view;
	dcdDlg* dcdDialog;	
	bool server_active;
	QPopupMenu* logTables;
	QPopupMenu* logMenu;
	int oldLogItem;
private slots: // Private slots
  void slotLogFind();
  void slotUpdateStatusBar();
  void slotStatusBarItemToggle (int item);
  void slotAcvtivateAutoCQ();
  void slotSendFile();
  void slotHelp();
  void slotAbout();
  void slotAbortTX();
  void slotSettingsFixtext();
  void slotSettingsPersonals();
  void slotSettingsDevices();
  void slotSettingsAppearence();
  void slotSettingsBand();
  void slotShowQSOInfo();
  void slotSettingsAutoCallChex();   //ernie
public slots:
  void slotCQ();
  void uncheckQsoInfoMenu();
};

#endif
