/***************************************************************************
                        splittergui.h  -  description
                             -------------------
    copyright            : (C) 2003 by Csaba Karai
    e-mail               : krusader@users.sourceforge.net
    web site             : http://krusader.sourceforge.net
 ---------------------------------------------------------------------------
  Description
 ***************************************************************************

  A

     db   dD d8888b. db    db .d8888.  .d8b.  d8888b. d88888b d8888b.
     88 ,8P' 88  `8D 88    88 88'  YP d8' `8b 88  `8D 88'     88  `8D
     88,8P   88oobY' 88    88 `8bo.   88ooo88 88   88 88ooooo 88oobY'
     88`8b   88`8b   88    88   `Y8b. 88~~~88 88   88 88~~~~~ 88`8b
     88 `88. 88 `88. 88b  d88 db   8D 88   88 88  .8D 88.     88 `88.
     YP   YD 88   YD ~Y8888P' `8888Y' YP   YP Y8888D' Y88888P 88   YD

                                                     H e a d e r    F i l e

 ***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SPLITTERGUI_H
#define SPLITTERGUI_H

// QtCore
#include <QUrl>
// QtWidgets
#include <QDialog>

#include <KIOWidgets/KUrlRequester>
#include <KIO/Global>

class QComboBox;
class QCheckBox;
class QDoubleSpinBox;


class SplitterGUI : QDialog
{
    Q_OBJECT
private:
    struct PredefinedDevice;

    static const QList<PredefinedDevice> &predefinedDevices();

    KIO::filesize_t                 userDefinedSize;
    int                             lastSelectedDevice;
    int                             resultCode;
    KIO::filesize_t                 division;

    QDoubleSpinBox  *spinBox;
    QComboBox       *deviceCombo;
    QComboBox       *sizeCombo;
    QCheckBox       *overwriteCb;
    KUrlRequester   *urlReq;

public:
    SplitterGUI(QWidget* parent,  QUrl fileURL, QUrl defaultDir);
    ~SplitterGUI();

    QUrl    getDestinationDir()     {
        return urlReq->url();
    }
    KIO::filesize_t getSplitSize();
    int     result()                {
        return resultCode;
    }
    bool overWriteFiles();

public slots:
    virtual void sizeComboActivated(int item);
    virtual void predefinedComboActivated(int item);
    virtual void splitPressed();

protected:
    virtual void keyPressEvent(QKeyEvent *e) Q_DECL_OVERRIDE;
};

#endif /* __SPLITTERGUI_H__ */
