/*
 *  KSeg
 *  Copyright (C) 1999-2001 Ilya Baran
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Send comments and/or bug reports to:
 *                 ibaran@mit.edu
 */

#include "G_refSearcher.H"


bool G_refSearcher::search(const G_refs &refs)
{
  int i;

  bool flag;

  //first check if any given refs are true or if all given refs are false
  flag = true;
  for(i = 0; i < int(refs.size()); ++i) {
    if(known_refs.count(refs[i]) && known_refs[refs[i]] == true) return true;
    if(known_refs.count(refs[i]) == 0) flag = false;
  }
  if(flag) return false;

  //now do the recursive search
  for(i = 0; i < int(refs.size()); ++i) {
    if(known_refs.count(refs[i])) {
      if(known_refs[refs[i]] == true) return true;
      else continue;
    }

    if(is_found(refs[i])) { //if the current object is what we're looking for, we're done.
      known_refs[refs[i]] = true;
      return true;
    }

    //temporaries have a life at least until the end of the block
    const G_refs &next = search_next(refs[i]);
    if(next.size()) 
      known_refs[refs[i]] = search(next); //recursively search    
    else known_refs[refs[i]] = false;

    if(known_refs[refs[i]] == true) return true;
  }

  return false;
}

