/***************************************************************************
                          lmsensor.h  -  description
                             -------------------
    begin                : Mon Aug 6 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef LMSENSOR_H
#define LMSENSOR_H

#include <qobject.h>
#include <kconfig.h>
#include <qstring.h>
#include <qcstring.h>

#include <sensors/sensors.h>

#include "lmsensors.h"

/**
  *@author 
  */

class LMSensor : public QObject  {
  Q_OBJECT

  friend class LMSensors;

public: 

  enum SensorType { lmTemp, lmFan, lmVoltage };

  LMSensor(LMSensors *parent=0);
	~LMSensor();

  inline SensorType getSensorType()         { return type; };
  inline const QString &getDescription()    { return description;   };
  inline double getValue() 							    { return celsius2Current(val); };
  inline double getValuePrevious() 			    { return celsius2Current(valPrevious);   };
  inline double getValueIdeal()             { return celsius2Current(valIdeal);      };
  inline double getValueMax()               { return celsius2Current(valMax);        };
  inline double getValueMin()               { return celsius2Current(valMin);        };
  inline double getCompensation()           { return celsius2Current(compensation);  };
  inline double getMultiplicator()          { return multiplicator; };
  inline bool   getAlarm()                  { return (val<valMin || val>valMax); };
  inline bool   getAlarmPrevious()          { return (valPrevious<valMin || valPrevious>valMax); };
  inline bool   getMonitorize()						  { return monitorize;   };
  inline bool   isAlarmValue(double value)  { value= current2Celsius(value); return (value<valMin || value>valMax); };

  bool monitorized();
  void setMonitorized(bool enable);
  void setDescription(const QString &str);
  void setValueIdeal(double value);
  void setValueMax(double value);
  void setValueMin(double value);
  void setCompensation(double value);
  void setMultiplicator(double value);
  KConfig *getConfig();

  double current2Celsius(double val);
  double celsius2Current(double val);
  QString getPrintMask(bool addSufix);

public slots:

  void updateValue();
  void readConfig();
  void writeConfig();

signals:

  void valueChanged(double);
  void configChanged();

protected:

  bool init(const sensors_feature_data **data, int *nr1,int *nr2);
  const sensors_chip_name *getChipName();

private:

   int        feature;
   SensorType type;
   QString    description;
   double     val;
   double     valPrevious;
   double     compensation;
   double     multiplicator;
   double     valMax;
   double     valMin;
   double     valIdeal;
   bool       monitorize;

   double     readValueFromLMSensor();
   double     calculateIdealValue();
};

#endif
