/***************************************************************************
                          lmsensorsdock.cpp  -  description
                             -------------------
    begin                : Sun Sep 23 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "lmsensorsdock.h"

#include <qobjectlist.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kapp.h>

#include <kaboutapplication.h>


LMSensorsDock::LMSensorsDock(KConfig *cfg=0, QObject *parent=0, const char *name=0): QObject(parent,name)
{
 sensors= new LMSensors(cfg);
 sensors->setMonitorized(true);

 createAlarmControl();
 createWidgets();
 createDockWidgets();
 createMenu();
}


LMSensorsDock::~LMSensorsDock()
{
 destroyWidgets();
 if(sensorsAlarm) delete sensorsAlarm;
 delete menu;
 if(sensors) delete sensors;
}


void LMSensorsDock::createMenu()
{
  menu= new KPopupMenu;
  menu->insertTitle(kapp->miniIcon(),"KSensors");
  menu->insertItem(SmallIcon("configure"),i18n("&Configure"), this, SLOT(createConfigWidget() ) ,0,101 );
  menu->insertSeparator();
  menu->insertItem(kapp->miniIcon()      ,i18n("&About KSensors"), this, SLOT(showAbout()          ) ,0,103 );
  menu->insertSeparator();
  menu->insertItem(sensorsWidget ? i18n("&Minimize"):i18n("&Restore"), this, SLOT(minimizeRestoreWidget() ) ,0,100 );
  menu->insertItem(SmallIcon("exit"),i18n("&Exit"), this, SLOT(close()),0,102);
}

void LMSensorsDock::createWidgets()
{
KConfig *cfg= sensors->getConfig();

 cfg->setGroup("General");
 if(cfg->readBoolEntry("showWidget",false)) createShowWidget();
}

void LMSensorsDock::destroyWidgets()
{
KConfig *cfg= sensors->getConfig();

 cfg->setGroup("General");
 cfg->writeEntry("showWidget",(bool)sensorsWidget);
 if(sensorsWidget) delete sensorsWidget;
 if(sensorsCfg)    delete sensorsCfg;
}

void LMSensorsDock::createDockWidgets()
{
QObjectList *list= (QObjectList *)sensors->getSensors();

 countSensors= 0;
 if(list) {
   KConfig *cfg=  sensors->getConfig();
   for(LMSensor *sensor= (LMSensor *)list->first(); sensor!=0; sensor= (LMSensor *)list->next()) {
     if( LMSensorDockPanel::readShowInDock(cfg,sensor->name()) )
       createDockSensor(sensor);
   }
 }
 if(countSensors==0) createDockSensor(0);
}

void LMSensorsDock::createAlarmControl()
{
 sensorsAlarm= new LMSensorsAlarms(sensors);
}


void LMSensorsDock::minimizeRestoreWidget()
{
 if(sensorsWidget)  delete sensorsWidget;
 else               createShowWidget();
 updateMenu();
}

void LMSensorsDock::updateMenu()
{
 menu->changeItem(100, sensorsWidget ? i18n("&Minimize") : i18n("&Restore"));
}

void LMSensorsDock::createShowWidget()
{
 if(!sensorsWidget)  {
   sensorsWidget= new LMSensorsWidget(sensors);
   connect( sensorsWidget, SIGNAL(rightMouseClicked(QMouseEvent *)), this, SLOT(mouseEventReceived(QMouseEvent *)) );
   connect( sensorsWidget, SIGNAL(destroyed()), this, SLOT(updateMenu()) );
   makeShowConfigConnections();
 }
 sensorsWidget->show();
}


void LMSensorsDock::createConfigWidget()
{
 if(!sensorsCfg) {
   sensorsCfg= new LMSensorsCfg(sensors);
   connect( sensorsCfg, SIGNAL(itemDockChanged(const char *)), this, SLOT(updateItemDock(const char *)) );
   makeShowConfigConnections();
 }
 sensorsCfg->show();
}


void LMSensorsDock::makeShowConfigConnections()
{
 if(sensorsCfg && sensorsWidget) {
   connect( sensorsCfg, SIGNAL(itemShowChanged(const char *)), sensorsWidget, SLOT(updateItemShow(const char *)) );
   connect( sensorsCfg, SIGNAL(systemUpdateIntervalChanged()), sensorsWidget, SLOT(updateUpdateInterval()) );
 }
}

void LMSensorsDock::close()
{
 delete this;
}

void LMSensorsDock::mouseEventReceived(QMouseEvent *e)
{
 if(e->type()==QEvent::MouseButtonRelease) {
   if( e->button()==LeftButton  ) minimizeRestoreWidget();
   if( e->button()==RightButton ) menu->popup(e->globalPos());
 }
}

void LMSensorsDock::createDockSensor(LMSensor *sensor)
{
  if(countSensors==0) {
    QObjectList *list= (QObjectList *)children();
    if(list)
      for(LMSensorDockPanel *sensor= (LMSensorDockPanel *)list->first(); sensor!=0; sensor= (LMSensorDockPanel *)list->next())
       delete sensor;
  }

  const char *name= sensor ?  sensor->name() : 0;
  LMSensorDockPanel *dock= new LMSensorDockPanel(sensor,name);
  connect( dock, SIGNAL(mouseEvent(QMouseEvent *)), this, SLOT(mouseEventReceived(QMouseEvent *)) );
  insertChild(dock);
  dock->show();
  if(name) countSensors++;
}

void LMSensorsDock::deleteDockSensor(LMSensorDockPanel *sensor)
{
 delete sensor;
 if(--countSensors==0) createDockSensor(0);
}

void LMSensorsDock::updateItemDock(const char *name)
{
 LMSensor *sensor= sensors->getSensor(name);

 if((bool)sensor && sensor->getSensorType()==LMSensor::lmTemp) {
   KConfig *cfg= sensors->getConfig();
   bool   fShow= LMSensorDockPanel::readShowInDock(cfg,name);
   LMSensorDockPanel *dockSensor= (LMSensorDockPanel *)child(name);
   if( fShow!=(bool)dockSensor ) {
     if(dockSensor) deleteDockSensor(dockSensor);
     else           createDockSensor(sensor);
   } else {
     if(dockSensor!=0)
       dockSensor->updateConfig();
   }
 }
}


void LMSensorsDock::showAbout()
{
KAboutApplication *dialog;

  dialog= new KAboutApplication;
  dialog->show();
  delete dialog;
}

