/***************************************************************************
                          cpudisplay.cpp  -  description
                             -------------------
    begin                : Sun Nov 25 2001
    copyright            : (C) 2001 by Miguel Novas
    email                : michaell@teleline.es
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uptimepanel.h"
#include "procinfo.h"
#include "qlcddraw.h"

#include <qcolor.h>
#include <qpainter.h>



UpTimePanel::UpTimePanel(QWidget *parent, const char *name) : Panel(parent,name)
{
 lcd= new QLCDString(this);
 lcd->setGeometry(6,25,52,15);
 lcd->setShadow(true);
 lcd->setForegroundColor(red);
 lcd->setShadowColor(darkRed);
 lcd->installEventFilter(this);

 updateInfo();
}

UpTimePanel::~UpTimePanel()
{
}

void UpTimePanel::updateInfo()
{
 int uptime= getUpTime();

 int hours  = uptime/ (60*60);
 int minutes= (uptime % (60*60)) / 60;

 QString str;
 str.sprintf("%02d:%02d",hours,minutes);
 lcd->display(str);
 update();
}

void UpTimePanel::drawContents(QPainter *p)
{
 QLcd::draw(p, 2,50,60,8,"hh:mm" ,QLcd::alignCenter,&black);
 QLcd::draw(p, 2, 6,60,8,"Up Time",QLcd::alignCenter,&black);
}
