/*
	mmessagedialog.cpp - A warning message dialog
	Copyright (C) 2004  Konrad Twardowski <kdtonline@poczta.onet.pl>

	This program is free software; you can redistribute it and/or modify
	it under the terms of the GNU General Public License as published by
	the Free Software Foundation; either version 2 of the License, or
	(at your option) any later version.

	This program is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	GNU General Public License for more details.

	You should have received a copy of the GNU General Public License
	along with this program; if not, write to the Free Software
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "miscutils.h"
#include "mmainwindow.h"
#include "mmessagedialog.h"

#include <qdatetime.h>
#include <qhbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qlcdnumber.h>
#include <qtimer.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kpopupmenu.h>
#include <kpushbutton.h>
#include <kwin.h>

// public

MMessageDialog::MMessageDialog(const int delay, const Action::Type actionToExecute, const QString &text)
	: KDialog(ks_main, "MMessageDialog", true),
	_dialogDelay(delay),
	_lastTime(-1),
	_action(actionToExecute)
{
	setCaption(i18n("Message"));
	setPaletteBackgroundColor(yellow);
	setPaletteForegroundColor(black);

	// main layout
	QVBoxLayout *l = new QVBoxLayout(this, 5);

	// message text
	QLabel *t_message = new QLabel(this);
	QFont f = QFont(t_message->font());
	f.setPointSize(16);
	t_message->setFont(f);
	t_message->setPaletteBackgroundColor(yellow);
	t_message->setPaletteForegroundColor(black);
	t_message->setAlignment(AlignCenter);
	t_message->setFrameShape(QFrame::StyledPanel);
	t_message->setFrameShadow(QFrame::Plain);
	t_message->setLineWidth(4);
	t_message->setMargin(20);
	t_message->setSizePolicy(QSizePolicy(QSizePolicy::Preferred, QSizePolicy::Expanding));
	t_message->setText(text);

	// bottom layout
	QHBox *bottomBox = new QHBox(this);
	bottomBox->setSpacing(5);

	// seconds
	l_seconds = new QLCDNumber(bottomBox);
	l_seconds->display(_dialogDelay);
	l_seconds->setFrameShape(QFrame::NoFrame);
	l_seconds->setSegmentStyle(QLCDNumber::Flat);
	MiscUtils::setHint(l_seconds, i18n("Remaining time."));

	// continue button
	b_continue = new KPushButton(
		ks_actions->getIcon(_action), ks_actions->getName(_action),
		bottomBox, "KPushButton::b_continue"
	);
	b_continue->setPaletteBackgroundColor(yellow);
	b_continue->setPaletteForegroundColor(black);

	// confirm continue
	KPopupMenu *pm_confirm = new KPopupMenu(this, "KPopupMenu::pm_confirm");
	pm_confirm->insertItem(
		SmallIcon("button_ok"), i18n("&I'm Sure"),
		this, SLOT(slotContinue()), CTRL + Key_Return
	);
	b_continue->setPopup(pm_confirm);

	// cancel button
	KPushButton *b_cancel = new KPushButton(KStdGuiItem::cancel(), bottomBox, "KPushButton::b_cancel");
	b_cancel->setDefault(true);
	b_cancel->setPaletteBackgroundColor(yellow);
	b_cancel->setPaletteForegroundColor(black);
	connect(b_cancel, SIGNAL(clicked()), SLOT(slotCancel()));

	l->addWidget(t_message);
	l->addWidget(bottomBox);

	// init time checker
	_checkTimer = new QTimer(this);
	connect(_checkTimer, SIGNAL(timeout()), SLOT(slotCheck()));
	_checkTimer->start(500);

	MiscUtils::pack(this);

	// make sure it is visible
	// code from KAlarm
	WId id = winId();
	KWin::setState(id, NET::StaysOnTop | NET::Sticky);
	KWin::setOnAllDesktops(id, true);
}

MMessageDialog::~MMessageDialog()
{
}

// public slots

void MMessageDialog::slotCancel()
{
	done(Rejected);
}

// private slots

void MMessageDialog::slotCheck()
{
	QTime t = QTime::currentTime();

	if (t.second() == _lastTime)
		return;

	l_seconds->display(_dialogDelay);

	// timeout?
	if (_dialogDelay == 0)
	{
		slotContinue();

		return;
	}

	MiscUtils::notifyUser(_dialogDelay);

	_lastTime = t.second();
	_dialogDelay--;
}

void MMessageDialog::slotContinue()
{
	_checkTimer->stop();
	ks_actions->exec(_action);
	done(Accepted);
}
