/*
   ksmp3play - Curses-based MP3 player

   Copyright (C) 2001 Karl Soderstrom

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software Foundation,
   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/

#include "ksmp3play.h"
#include <netinet/in.h>
#include <netdb.h>
#include <sys/socket.h>
#include <arpa/inet.h>
#include <unistd.h>

// Ruthlessly stolen from plaympeg.c (SMPEG example)
int
tcp_open (char *address, int port)
{
  struct sockaddr_in stAddr;
  struct hostent *host;
  int sock;
  struct linger l;

  memset (&stAddr, 0, sizeof (stAddr));
  stAddr.sin_family = AF_INET;
  stAddr.sin_port = htons (port);

  if ((host = gethostbyname (address)) == NULL)
    return (0);

  stAddr.sin_addr = *((struct in_addr *) host->h_addr_list[0]);

  if ((sock = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
    return (0);

  l.l_onoff = 1;
  l.l_linger = 5;
  if (setsockopt (sock, SOL_SOCKET, SO_LINGER, (char *) &l, sizeof (l)) < 0)
    return (0);

  if (connect (sock, (struct sockaddr *) &stAddr, sizeof (stAddr)) < 0)
    return (0);

  return (sock);
}

int
http_open (char *arg)
{
  char *host;
  int port;
  char *request = 0;
  int tcp_sock;
  char http_request[1024];
  char c;

  /* Check for URL syntax */
  if (strncmp (arg, "http://", strlen ("http://")))
    return (0);

  /* Parse URL */
  port = 80;
  host = arg + strlen ("http://");
  if ((request = strchr (host, '/')) == NULL)
    return (0);
  *request++ = 0;
  if (strchr (host, ':') != NULL)	/* port is specified */
    {
      port = atoi (strchr (host, ':') + 1);
      *strchr (host, ':') = 0;
    }

  /* Open a TCP socket */
  if (!(tcp_sock = tcp_open (host, port)))
    {
      perror ("http_open");
      return (0);
    }

  /* Send HTTP GET request */
  sprintf (http_request,
	   "GET /%s HTTP/1.0\r\n"
	   "User-Agent: Mozilla/2.0 (ksmp3play %s)\r\n"
	   "Pragma: no-cache\r\n"
	   "Host: %s\r\n" "Accept: */*\r\n" "\r\n", request, VERSION, host);
  send (tcp_sock, http_request, strlen (http_request), 0);

  /* Parse server reply */
  do
    read (tcp_sock, &c, sizeof (char));
  while (c != ' ');
  read (tcp_sock, http_request, 4 * sizeof (char));
  http_request[4] = 0;
  if (strcmp (http_request, "200 "))
    {
      fprintf (stderr, "http_open: ");
      do
	{
	  read (tcp_sock, &c, sizeof (char));
	  fprintf (stderr, "%c", c);
	}
      while (c != '\r');
      fprintf (stderr, "\n");
      return (0);
    }

  return (tcp_sock);
}
