/***************************************************************************
                          quickdocumentdialog.cpp  -  description
                             -------------------
    begin                : Tue Oct 30 2001
    copyright            : (C) 2001 by Brachet Pascal
    email                : pascal.brachet@free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "quickdocumentdialog.h"
#include <klocale.h>

quickdocumentdialog::quickdocumentdialog(QWidget *parent, const char *name)
    :KDialogBase( parent, 0L, true, name, Ok | Cancel, Ok )
{
	setCaption(name);
  QWidget *page = new QWidget(this);
  setMainWidget(page);

  QGridLayout *gbox = new QGridLayout( page, 3, 2, spacingHint() );
  gbox->addRowSpacing( 0, fontMetrics().lineSpacing() );

  QLabel_1= new QLabel(page,"NoName");
  QLabel_1->setText(i18n("Document Class"));

  QLabel_2= new QLabel(page,"NoName");
  QLabel_2->setText(i18n("Typeface Size"));

  QLabel_3= new QLabel(page,"NoName");
  QLabel_3->setText(i18n("Paper Size"));

  QLabel_4= new QLabel(page,"NoName");
  QLabel_4->setText(i18n("Encoding"));

  combo1 = new QComboBox( FALSE, page, "comboBox" );
  combo1->insertItem( "article" );
  combo1->insertItem( "report ");
  combo1->insertItem( "letter" );
  combo1->insertItem( "book" );

  combo2 = new QComboBox( FALSE, page, "comboBox" );
  combo2->insertItem( "10pt" );
  combo2->insertItem( "11pt" );
  combo2->insertItem( "12pt" );

  combo3 = new QComboBox( FALSE, page, "comboBox" );
  combo3->insertItem( "a4paper" );
  combo3->insertItem( "a5paper" );
  combo3->insertItem( "b5paper" );
  combo3->insertItem( "letterpaper" );
  combo3->insertItem( "legalpaper" );
  combo3->insertItem( "executivepaper" );

  combo4 = new QComboBox( FALSE, page, "comboBox" );
  combo4->insertItem( "latin1" );
  combo4->insertItem( "latin2" );
  combo4->insertItem( "latin3" );
  combo4->insertItem( "latin5" );
  combo4->insertItem( "ascii" );
  combo4->insertItem( "decmulti" );
  combo4->insertItem( "cp850" );
  combo4->insertItem( "cp852" );
  combo4->insertItem( "cp437" );
  combo4->insertItem( "cp437de" );
  combo4->insertItem( "cp865" );
  combo4->insertItem( "applemac" );
  combo4->insertItem( "next" );
  combo4->insertItem( "ansinew" );
  combo4->insertItem( "cp1252" );
  combo4->insertItem( "cp1250" );

  checkbox1 = new QCheckBox( page, "checkbox");
  checkbox1->setFocusPolicy( QWidget::TabFocus );
  checkbox1->setText( i18n("AMS packages" ));
  checkbox1->setAutoRepeat( FALSE );
  checkbox1->setAutoResize( FALSE );
  checkbox1->setChecked( TRUE );

  gbox->addWidget(QLabel_1 , 0, 0 );
  gbox->addWidget(combo1 , 0, 1 );
  gbox->addWidget(QLabel_2 , 1, 0 );
  gbox->addWidget(combo2 , 1, 1 );
  gbox->addWidget(QLabel_3 , 2, 0 );
  gbox->addWidget(combo3 , 2, 1 );
  gbox->addWidget(QLabel_4 , 3, 0 );
  gbox->addWidget(combo4 , 3, 1 );
  gbox->addWidget(checkbox1 , 4, 1 );
  resize(300,200);
}

quickdocumentdialog::~quickdocumentdialog(){
}



