#ifndef _KVI_SETTINGS_H_INCLUDED_
#define _KVI_SETTINGS_H_INCLUDED_

//
//   File : kvi_settings.h (/usr/build/KVICVS/kvirc/src/common/kvi_settings.h)
//   Last major modification : Sun Oct 3 1999 13:58:47 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

// Global settings for kvirc compilation

// Debug compilation
// By #undefing this you will disable all the debug output
#define COMPILE_DEBUG_SESSION

// #undef this if you don't need the localization
// you will have a english-only kvirc ,
// but everything will work a little bit faster
#define COMPILE_LOCALE_STUFF

// #define this if you want to hunt for
// kvirc memory leaks...
// (slow :)
#undef COMPILE_GCC_MEMORY_PROFILE

// Malloc checks
// If you #undef this switch , you will enable checking for
// NULL pointers returned by malloc calls.
// This will increase the code a bit...
// However ,the check for NULL pointers will not
// save you from buying new memory...kvirc
// will just avoid segfaulting , and will exit
// with a warning message.
#define COMPILE_SKIP_MEMORY_CHECKS

// Define this if you have trouble with Alarm Clock
// that stops KVirc without apparent reason.
// This will call signal(SIGALRM,SIG_IGN) in
// each new thread created (main included).
// This also can be turned on from configure
#undef COMPILE_IGNORE_SIGALARM

// Define this if you do not want to use the DCC Voice feature
#undef COMPILE_WITH_NO_SOUND

// Undefine this if you do not want the plugin support
#define COMPILE_NEED_PLUGINS

// Define this if your machine is i386 based and you want
// some assembler code optimisations to be compiled in (if possible)
#define COMPILE_i386_ASM_OPTIMISATIONS

// Define this if you want to ignore KDE
#undef COMPILE_IGNORE_KDE

//#############################################################################
// STOP HERE
//#############################################################################

#ifdef HAVE_CONFIG_H
	#ifndef CONFIG_H_INCLUDED
		#define CONFIG_H_INCLUDED
		#include "../config.h"
	#endif
#endif

#ifdef HAVE_LIBJPEG
	#ifdef HAVE_JPEGLIB_H
		#ifdef HAVE_SETJMP_H
			#define COMPILE_JPEG_SUPPORT
		#endif
	#endif
#endif

#ifdef COMPILE_NEED_IGNORE_SIGALARM
	#define COMPILE_IGNORE_SIGALARM
#endif

#ifndef COMPILE_NEED_LOCALE
	#undef COMPILE_LOCALE_STUFF
#endif

#ifdef COMPILE_NEED_PLUGINS
	#ifdef HAVE_LIBDL
		#define COMPILE_PLUGIN_SUPPORT
	#endif
#endif

#ifdef COMPILE_i386_ASM_OPTIMISATIONS
	#ifdef HAVE_i386_BASED_CPU
		#if ((__GNUC__ >= 2) && (__GNUC_MINOR__ >= 7))
			#define COMPILE_i386_ASM_CODE
		#endif
	#endif
#endif

#undef COMPILE_WITH_KDE

#ifdef COMPILE_NEED_KDE
	#ifndef COMPILE_IGNORE_KDE
		#define COMPILE_WITH_KDE
	#endif
#endif

#endif //!_KVI_SETTINGS_H_INCLUDED_
