#ifndef _KVI_ADPCM_H_INCLUDED_
#define _KVI_ADPCM_H_INCLUDED_

//
//   File : kvi_adpcm.h (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_adpcm.h)
//   Last major modification : Sat Jun 19 1999 14:14:40 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Code derived from adpcm.c : Intel ADPCM coder/decoder
//   Adapted for the KVirc distribution by Szymon Stefanek (stefanek@tin.it)
//   Last revision : 19 Jun 1999
//   See kvi_adpcm.cpp for the complete copyright notice.
//
//
// adpcm.h - include file for adpcm coder.
//
// Version 1.0, 7-Jul-92.
//
//
// Average compression speed experiment: P166MMX 32MEG
//
// INPUT         | OUTPUT    | COMPRESSION TIME
// ------------------------------------------------------------------------
// shorts bytes  | bytes     | min msec.   avrg.    high peak (1 time)
// ------------------------------------------------------------------------
// 512    1024   | 256       | ~4          4          34
// 1024   2048   | 512       | ~7          8          75
// 2048   4096   | 1024      | ~13         15         175 (!!!)
// 4096   8192   | 2048      | ~26         33         91
// 8192   16384  | 4096      | ~57         80         220 (~1 sec of audio)
// 16384  32768  | 8192      | ~110        250        290
//

typedef struct adpcm_state
{
    short	valprev;	/* Previous output value */
    char	index;		/* Index into stepsize table */
} ADPCM_state;

#ifndef _KVI_ADPCM_CPP_
	extern void ADPCM_compress(short indata[],char outdata[],int len,ADPCM_state * state);
	extern void ADPCM_uncompress(char indata[],short outdata[],int len,ADPCM_state * state);
#endif

#endif //!_KVI_ADPCM_H_INCLUDED_
