#ifndef _KVI_LISTVIEW_H_INCLUDED_
#define _KVI_LISTVIEW_H_INCLUDED_

//
//   File : kvi_listview.h (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_listview.h)
//   Last major modification : Tue May 11 1999 00:02:18 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qlistview.h>
#include <qlineedit.h>

class KviFieldEditor : public QLineEdit
{
	Q_OBJECT
public:
	KviFieldEditor(QWidget * parent);
	~KviFieldEditor();
public:
	void edit(const QString &str,bool bEnd = true);
	void terminateEdit(bool bCommitChanges);
	inline void handleKeyEvent(QKeyEvent *e){ keyPressEvent(e); };
protected:
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void focusOutEvent(QFocusEvent *e);
	virtual void keyPressEvent(QKeyEvent *e);
signals:
	void editFinished(const QString &newText);
	void keyUpPressed();
	void keyDownPressed();
	void keyLeftPressed();
	void keyRightPressed();
};




class KviListView : public QListView
{
	Q_OBJECT
public:
	KviListView(QWidget * par);
	~KviListView();
protected:
	KviFieldEditor * m_pEdit;
	int m_iColumnCount;
	QListViewItem * m_pCurEditedItem;
	int             m_iCurEditedColumn;
public:
	virtual int addColumn(const QString &label,int width = -1);
	void editField(QListViewItem * it,int column,bool bEnd = true);
	bool eventFilter(QObject * o,QEvent *e);
protected slots:
	void itemDoubleClicked(QListViewItem * it);
	void editTerminated(const QString &newText);
	void editorKeyUp();
	void editorKeyDown();
	void editorKeyRight();
	void editorKeyLeft();
protected:
	void drawContentsOffset(QPainter *p,int ox,int oy,int cx,int cy,int cw,int ch);
};

#endif //!_KVI_LISTVIEW_H_INCLUDED_
