#ifndef _KVI_MDICAPTION_H_INCLUDED_
#define _KVI_MDICAPTION_H_INCLUDED_

//
//   File : kvi_mdicaption.h (/usr/build/NEW_kvirc/kvirc/src/kvilib/kvi_mdicaption.h)
//   Last major modification : Sat Mar 27 1999 13:47:09 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qwidget.h>
#include <qpixmap.h>
#include <qpoint.h>

#include "kvi_string.h"

class KviMdiChild;

/**
* Internal class
* @internal
*/

class KviMdiCaption : public QWidget
{
	Q_OBJECT
public:
	KviMdiCaption(KviMdiChild *parent,const char * name = 0);
	~KviMdiCaption();
public:
	KviStr m_szCaption;
	bool m_bActive;
	bool m_bCanMove;
	KviMdiChild *m_pParent;
	QPoint m_relativeMousePos;
	int m_iMoveResistence;
	/**
	* This is a POINTER to an icon 16x16. If this is 0 no icon is painted.
	*/
	QPixmap *m_pIcon;
public:
	void setActive(bool bActive);
	void setCaption(const char *text);
	int heightHint();
protected:
	virtual void paintEvent(QPaintEvent *e);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void leaveEvent(QEvent *);
	virtual void mouseMoveEvent(QMouseEvent *e);
};



#endif //!_KVI_MDICAPTION_H_INCLUDED_
