//
//   File : kvi_style.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_style.cpp)
//   Last major modification : Wed Apr 21 1999 21:36:26 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#include "kvi_style.h"
#include "kvi_string.h"

#include <qpixmap.h>
#include <qpainter.h>
#include <qtoolbar.h>
#include <X11/Xlib.h>

KviGuiSeparator::KviGuiSeparator(QWidget * parent)
:QFrame(parent,"gui_separator")
{
	setFrameStyle(QFrame::Panel|QFrame::Sunken);
	setMinimumSize(2,2);
}

KviGuiSeparator::~KviGuiSeparator()
{

}




KviToolBarButton::KviToolBarButton(const QPixmap &pm,const char * textLabel,const char * groupText,QObject *receiver,const char *slot,QToolBar *parent,const char *name)
:QToolButton(pm,_CHAR_2_QSTRING(textLabel),_CHAR_2_QSTRING(groupText),receiver,slot,parent,name)
{
	setFocusPolicy(QWidget::NoFocus);
}

KviToolBarButton::~KviToolBarButton()
{
}

void KviToolBarButton::drawButton(QPainter * p)
{
	// Allow setting a background pixmap to the toolbar
	const QPixmap * pix = ((QToolBar *)parent())->backgroundPixmap();
	if(pix){
		if(!pix->isNull()){
			p->drawTiledPixmap(0,0,width(),height(),*pix,x() % pix->width(),y() % pix->height());
		    if(uses3D()||isDown()||isOn()){
				QBrush br(QBrush::NoBrush);
				style().drawBevelButton(p,0,0,width(),height(),colorGroup(),isOn()||isDown(),&br);
			}
		    drawButtonLabel(p);
			return;
		}
	}
	QToolButton::drawButton(p);
}

KviTransparentWidget::KviTransparentWidget(QWidget * parent,const char * name)
:QWidget(parent,name ? name : "transparent_widget")
{
	setMinimumSize(QSize(1,1)); // no minimum size in fact....just notify qt
	setBackgroundMode(QWidget::NoBackground);
}

KviTransparentWidget::~KviTransparentWidget()
{
}

void KviTransparentWidget::paintEvent(QPaintEvent *e)
{
	if(!parent()){
		QWidget::paintEvent(e);
		return;
	}
	Display *dpy          = x11Display();
	HANDLE hMemBuffer     = handle();
	GC gc_aux             = XCreateGC(dpy,hMemBuffer,0,0);
	QColorGroup cg        = colorGroup();
	const QPixmap * pix = ((QWidget *)parent())->backgroundPixmap();
	if(pix){
		if(!pix->isNull()){
			XSetTile(dpy,gc_aux,pix->handle());
			XSetFillStyle(dpy,gc_aux,FillTiled);
		    XSetTSOrigin(dpy,gc_aux,-x(),-y());
		} else pix = 0;
	}
	if(!pix){
		XSetFillStyle(dpy,gc_aux,FillSolid);
		XSetForeground(dpy,gc_aux,cg.button().pixel());
		XSetBackground(dpy,gc_aux,cg.button().pixel());
	}
	XFillRectangle(dpy,hMemBuffer,gc_aux,0,0,width(),height());
	XFreeGC(dpy,gc_aux);
}

QSizePolicy KviTransparentWidget::sizePolicy()
{
	return QSizePolicy(QSizePolicy::Expanding,QSizePolicy::Expanding);
}


#include "m_kvi_style.moc"
