//
//   File : kvi_app_setup.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_app_setup.cpp)
//   Last major modification : Fri Apr 2 1999 02:38:05 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//#define _KVI_DEBUG_CHECK_RANGE_
//#define _KVI_DEBUG_CLASS_NAME_ "KviApp"
#include "kvi_debug.h"

#include "kvi_app.h"

#include "kvi_fileutils.h"
#include "kvi_locale.h"
#include "kvi_msgbox.h"

#include <stdlib.h> // for getenv()
#include <unistd.h> // for symlink()

#ifdef COMPILE_WITH_KDE
	#include <kconfig.h>
	#include <kstddirs.h>
#endif

#include <qfile.h>
#include <qtextstream.h>

//
// Things launched at startup:
// - Attempt to find the global KVirc directory
// - Attempt to find the local KVirc directory
//   and if it is not found , ask the user to choose one
//

bool KviApp::checkGlobalKVircDirectory(const char *dir)
{
	//First check if the help subdir exists
	KviStr szDir2(KviStr::Format,"%s/help",dir);
	if(!kvi_directoryExists(szDir2.ptr()))return false;
	//Then check if the pics subdir exists
	KviStr szDir(KviStr::Format,"%s/pics",dir);
	if(!kvi_directoryExists(szDir.ptr()))return false;
	//Now make sure that it is the dir that we're looking for.
	//Check for an image file that we need.
	szDir+="/";
	szDir+=KVI_CONNECT_STATE_IMAGE_LIBRARY_NAME;
	return kvi_fileIsReadable(szDir.ptr());
}

bool KviApp::checkLocalKVircDirectory(const char *dir)
{
	//First check if the dir exists
	if(!kvi_directoryExists(dir))return false;
	//Here we should check at least if the dir is writable...
	//How to check it?
	return true;
}


//#ifdef BRAIN_DAMAGED_AUTHOR_PARANOIA
//#define I_DO_NOT_WANT_TO_HEAR_IT_ANYMORE_THAT_KVIRC_CAN_NOT_FIND_THE_BASE_PIXMAPS

const char * usualKVircGlobalPrePath[]=
{
	"/usr/local",    "/usr",           "/usr/etc",
	"/usr/X11",      "/opt",           "/opt/kde",
	"/opt/kde2",     "/usr/X11R6",     "/",
	"/lib",          "/lib/X11",       "/etc",
	"/etc/X11",      "/usr/local/etc", "/usr/local/X11",
	"/home"   ,      "/usr/local/kde", "/usr/kde",
	0                 // /home/kvirc ?
};

const char * usualKVircGlobalDir[]=
{
	"/share/kvirc",            "/share/apps/kvirc",    
	"/apps/kvirc",             "/kvirc",
	"/kvirc/share/apps/kvirc", "/kvirc/share/kvirc", //<------ ???!!!???
	"/kvirc/share",            0
};

//#endif

void KviApp::findGlobalKVircDirectory()
{
	// Look for the installation directory
	// with the image and help files inside
#ifdef GLOBAL_KVIRC_DIR
//	printf("Trying m_szGlobalKVircDir = GLOBAL_KVIRC_DIR;\n");
	m_szGlobalKVircDir = GLOBAL_KVIRC_DIR;
//	printf("Trying if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return\n");
	if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return;
#endif
	// Since I had many problems with it
	// because of strange distributions or KDEDIRS
	// I do it in that way...
#ifdef COMPILE_WITH_KDE
	// KDE compilation ...
	// The things usually go installed into $KDEDIR/share/apps/kvirc
	// Look in the main KDE directory
	KStandardDirs * d = dirs();
	if(d){
		m_szGlobalKVircDir = locate("appdata","");
//		debug("KDE STUFF IN %s",m_szGlobalKVircDir.ptr());
		if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return;
		#ifdef HAVE_GETENV
			//KDEDIR sanity check...
			m_szGlobalKVircDir = getenv("KDEDIR");
			m_szGlobalKVircDir+="/share/apps/kvirc";
			if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return;
		#endif
	}
	// FAILED ? Check the usual way...
#endif //COMPILE_WITH_KDE
	// Non KDE compilation , or not found under $KDEDIR/share/apps/kvirc
	// Check usual directories...
	for(int j=0;usualKVircGlobalPrePath[j] != 0;j++){
		for(int i=0;usualKVircGlobalDir[i] != 0;i++){
			m_szGlobalKVircDir = usualKVircGlobalPrePath[j];
			m_szGlobalKVircDir+= usualKVircGlobalDir[i];
			if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return;	
		}
	}
	//Last resource , try $HOME and $HOME/.kde
	for(int k=0;usualKVircGlobalDir[k] != 0;k++){
		m_szGlobalKVircDir = QDir::homeDirPath();
		m_szGlobalKVircDir+= usualKVircGlobalDir[k];
		if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return;	
	}
	for(int k=0;usualKVircGlobalDir[k] != 0;k++){
		m_szGlobalKVircDir = QDir::homeDirPath();
		m_szGlobalKVircDir+= "./kde";
		m_szGlobalKVircDir+= usualKVircGlobalDir[k];
		if(checkGlobalKVircDirectory(m_szGlobalKVircDir.ptr()))return;	
	}

	m_szGlobalKVircDir="";

	// DO NOT TRANSLATE THIS
	// THE TRANSLATION DIRECTORY WAS NOT FOUND YET
	// AND THE LOCALE IS NOT INITIALIZED AT ALL
#ifdef COMPILE_WITH_KDE
	warningBox("Unable to find the shared KVIrc directory.\n"\
			"The usual path for this directory is $KDEDIR/share/apps/kvirc.\n"\
			"Are you sure that 'make install' worked correctly ?\n"\
			"Please make sure that you have read permission for that directory\n"\
			"and you have set KDEDIR correctly. You may also try to rerun 'make install'.\n"\
			"A detailed explanation of the KVIrc directory system is in the INSTALL document\n"\
			"shipped with the kvirc source distribution.\n"\
			"Trying to run anyway...");
#else
	warningBox("Unable to find the shared KVIrc directory.\n"\
			"The usual path for this directory is /usr/X11R6/share/kvirc.\n"\
			"Are you sure that 'make install' worked correctly ?\n"\
			"Please make sure that you have read permission for that directory.\n"\
			"You may also need to rerun 'make install'.\n"\
			"A detailed explanation of the KVIrc directory system is in the INSTALL document\n"\
			"shipped with the kvirc source distribution.\n"\
			"Trying to run anyway...\n");
#endif //!COMPILE_WITH_KDE
}

bool KviApp::findLocalKVircDirectory()
{
	// Here we check if we already did the setup
	// and we have the kvirc local directory saved somewhere
#ifdef COMPILE_WITH_KDE
	if(!m_pConfigFile) {  // don't do that if user supplied a config file :)
	// With kde we save the dir by placing it in the app config file
		KConfig * cfg = config();
		if(cfg){
			if(cfg->getConfigState() == KConfig::ReadWrite)
			{
				cfg->setGroup("LocalKVirc211Directory");
				m_szLocalKVircDir = cfg->readEntry("LocalKVirc211Directory","");
				// If we have it , ok...done
				if(checkLocalKVircDirectory(m_szLocalKVircDir.ptr()))return true;
			}
		}
	}
#endif
	//Check if we have a special .kvirc-VERSION.rc in $HOME
	KviStr szF(QDir::homeDirPath());
	if(m_pConfigFile)
		if(*m_pConfigFile != '/') {
			szF+="/";
			szF+=m_pConfigFile;
		} else szF=m_pConfigFile;
	else {
		szF+="/";
		szF+=KVI_HOME_CONFIG_FILE_NAME;
	}
	//If the file exists , read the first non empty line.
	QFile f(szF.ptr());
	if(f.open(IO_ReadOnly)){
		QTextStream t(&f);
		if(!t.eof()){
			do {
				m_szLocalKVircDir=t.readLine();
			} while((!t.eof()) && (m_szLocalKVircDir.isEmpty()));
		}
		f.close();
	} else {
		if(m_pConfigFile && !m_pCreateConfig){
			debug("Can't open config file %s : defaulting to ~/%s",szF.ptr(),KVI_HOME_CONFIG_FILE_NAME);
			m_pConfigFile = 0;
			return findLocalKVircDirectory();
		}
	}
	return checkLocalKVircDirectory(m_szLocalKVircDir.ptr());
}

void KviApp::loadDirectories()
{
	// First find the global (readable) one...
//	printf("Trying findGlobalKVircDirectory()\n");
	findGlobalKVircDirectory();
	// Init locale
	KviStr szLocalePath = m_szGlobalKVircDir;
	szLocalePath.append("/locale/");
	if(!kvi_initLocale(this,szLocalePath.ptr()))debug("[KVIrc]: Can't initialize the localization engine");

//	__debug_1arg("Global KVirc directory is %s",m_szGlobalKVircDir.ptr());
	// Now look for the local (writable) one
	if(!findLocalKVircDirectory()){
		//We must do the setup...ask the user..

		KviStr tmp(KviStr::Format,
			__tr("Welcome to the KVIrc setup program!\n"\
				"You will be asked to choose an existing directory now.\n"\
				"A '%s' subdirectory will be created inside. KVIrc will\n"\
				"use it to store its configuration files.\n"\
				"Make sure that you have write permission to that directory.\n"),
			KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);

		kvi_infoBox(__tr("KVIrc Setup"),tmp.ptr());

		KviStr home = QDir::homeDirPath();

		m_szLocalKVircDir=kvi_askForDirectoryName(home.ptr());
		if(m_szLocalKVircDir.isEmpty()){
			warningBox(__tr("Setup aborted."));
			exit(-1);
		}
		m_szLocalKVircDir+="/";
		m_szLocalKVircDir+=KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME;
		//Now create the dir...
		if(kvi_directoryExists(m_szLocalKVircDir.ptr())){
			tmp.sprintf(__tr("The '%s' subdirectory already exists,\n" \
							"maybe from a previous KVIrc installation.\n"\
							"If you experience any problems, try deleting the old directory."),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
			kvi_infoBox(__tr("KVIrc Setup"),tmp.ptr());
		} else if(!kvi_makeDir(m_szLocalKVircDir.ptr())){
			//Failed to make the dir...
			warningBox(__tr("Could not make the directory %s.\n"\
				"Trying alternate default $HOME/%s" ),m_szLocalKVircDir.ptr(),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
			m_szLocalKVircDir=QDir::homeDirPath();
			m_szLocalKVircDir+="/";
			m_szLocalKVircDir+=KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME;
			if(kvi_directoryExists(m_szLocalKVircDir.ptr())){
				tmp.sprintf(__tr("The '%s' subdirectory already exists, maybe from a previous KVIrc installation.\n"\
					"It can be used, but if you experience any problems, try deleting the old directory\n."\
					"and repeating the setup."),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
				kvi_infoBox(__tr("KVIrc Setup"),tmp.ptr());
			} else if(!kvi_makeDir(m_szLocalKVircDir.ptr())){
				warningBox(__tr("Could not make directory $HOME/%s.\n"\
					"Bad luck...you have some problems with you environment,\n"\
					"the $HOME/%s path is not writable or is not a directory.\n"\
					"Setup aborted."),KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME,KVI_LOCAL_KVIRC_SUBDIRECTORY_NAME);
				exit(-1);
			}
		}
		// Make local->global link
		KviStr localPath(KviStr::Format,"%s/global",m_szLocalKVircDir.ptr());
//		debug("Making a symlink from %s to %s",localPath.ptr(),m_szGlobalKVircDir.ptr());
		symlink(m_szGlobalKVircDir.ptr(),localPath.ptr());
		// Now save it
		saveKVircDirectory();
	}
//	__debug_1arg("Local KVIrc directory is %s",m_szLocalKVircDir.ptr());
}
