//
//   File : kvi_commands.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_commands.cpp)
//   Last major modification : Mon Sep 27 1999 14:22:59 by Szymon Stefanek
//
//   This file is part of the KVIrc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_app.h"
#include "kvi_uparser.h"
#include "kvi_ircsocket.h"
#include "kvi_console.h"
#include "kvi_defines.h"
#include "kvi_frame.h"
#include "kvi_options.h"
#include "kvi_error.h"
#include "kvi_locale.h"
#include "kvi_asyncdialogs.h"
#include "kvi_asyncwhois.h"
#include "kvi_alias.h"
#include "kvi_event.h"
#include "kvi_rawevent.h"
#include "kvi_query.h"
#include "kvi_uwindow.h"
#include "kvi_utoolbar.h"
#include "kvi_ircserver.h"
#include "kvi_ircview.h"
#include "kvi_input.h"

#include "kvi_fileutils.h"
#include "kvi_popupmenu.h"
#include "kvi_dcc_manager.h"
#include "kvi_dcc_chat.h"
#include "kvi_regusersdb.h"
#include "kvi_userlist.h"
#include "kvi_statusbar.h"
#include "kvi_mime.h"
#include "kvi_process.h"
#include "kvi_mdi.h"
#include "kvi_config.h"
#include "kvi_slaveio.h"
#include "kvi_config.h"
#include "kvi_scriptobject.h"

#ifdef COMPILE_PLUGIN_SUPPORT
	#include "kvi_plugin.h"
#endif

#include <qregexp.h>
#include <time.h>

#include <qwidcoll.h>
#include <qobjcoll.h>

#include <X11/Xlib.h>
#include <unistd.h>
#include <qdir.h>
#include <qfile.h>
#include <qfileinfo.h>

#include <unistd.h>

//declared in kvi_app.cpp
extern KviVariableCache       * g_pVarCache;
extern KviAliasManager        * g_pAliasManager;
extern KviEventManager        * g_pEventManager;
extern KviRawEventManager     * g_pRawEventManager;

extern KviPopupMenu           * g_pChannelPopup;
extern KviPopupMenu           * g_pConsolePopup;
extern KviPopupMenu           * g_pUserlistPopup;
extern KviPopupMenu           * g_pNotifylistPopup;
extern KviPopupMenu           * g_pQueryPopup;
extern KviPopupMenu           * g_pDccChatPopup;

extern KviConfig              * g_pUserConfig;

extern KviUserToolBarTemplate * g_pUserToolBarTemplate;

#ifdef COMPILE_PLUGIN_SUPPORT
	extern KviPluginManager   * g_pPluginManager; //created and destroyed by KviApp
#endif

//= COMMAND TABLES ==========================================================//
//
// We do not use alphabetic order here..
// The most common commands in scripting should go first in tables
// Also shorter commmands should go before the long ones
//

/*
KviCommandEntry KviUserParser::cmdTable_A_C[]=
{
	{ "BREAK"           , 5     , &KviUserParser::parseCmd_BREAK              },
	{ "CONNECT"         , 7     , &KviUserParser::parseCmd_CONNECT            },
	{ "BAN"             , 3     , &KviUserParser::parseCmd_BAN                },
	{ "CTCP"            , 4     , &KviUserParser::parseCmd_CTCP               },
	{ "ALIAS"           , 5     , &KviUserParser::parseCmd_ALIAS              },
	{ "AME"             , 3     , &KviUserParser::parseCmd_AME                },
	{ "AMSG"            , 4     , &KviUserParser::parseCmd_AMSG               },
	{ "ANOTICE"         , 7     , &KviUserParser::parseCmd_ANOTICE            },
	{ "BEEP"            , 4     , &KviUserParser::parseCmd_BEEP               },
	{ "CD"              , 2     , &KviUserParser::parseCmd_CD                 },
	{ "CONFIG"          , 6     , &KviUserParser::parseCmd_CONFIG             },
	{ "AWHOIS"          , 6     , &KviUserParser::parseCmd_AWHOIS             },
	{ "CLASS"           , 5     , &KviUserParser::parseCmd_CLASS              },
	{ "CLEAROBJECTS"    , 12    , &KviUserParser::parseCmd_CLEAROBJECTS       },
	{ "CLEAR"           , 5     , &KviUserParser::parseCmd_CLEAR              },
	{ 0                 , 0     , 0                                           }
};

KviCommandEntry KviUserParser::cmdTable_D_G[]=
{
	{ "ECHO"            , 4     , &KviUserParser::parseCmd_ECHO               },
	{ "FOREACH"         , 7     , &KviUserParser::parseCmd_FOREACH            },
	{ "DO"              , 2     , &KviUserParser::parseCmd_DO                 },
	{ "DEOP"            , 4     , &KviUserParser::parseCmd_DEOP               },
	{ "DISCONNECT"      , 10    , &KviUserParser::parseCmd_DISCONNECT         },
	{ "DESTROY"         , 7     , &KviUserParser::parseCmd_DESTROY            },
	{ "EXCEPT"          , 6     , &KviUserParser::parseCmd_EXCEPT             },
	{ "DEVOICE"         , 7     , &KviUserParser::parseCmd_DEVOICE            },
	{ "DCC"             , 3     , &KviUserParser::parseCmd_DCC                },
	{ "DIALOG"          , 6     , &KviUserParser::parseCmd_DIALOG             },
	{ "DEBUG"           , 5     , &KviUserParser::parseCmd_DEBUG              },
	{ "DIR"             , 3     , &KviUserParser::parseCmd_DIR                },
	{ "EXEC"            , 4     , &KviUserParser::parseCmd_EXEC               },
	{ "EXECV"           , 5     , &KviUserParser::parseCmd_EXECV              },
	{ "DIRBROWSER"      , 10    , &KviUserParser::parseCmd_DIRBROWSER         },
	{ "FINDTEXT"        , 8     , &KviUserParser::parseCmd_FINDTEXT           },
	{ 0                 , 0     , 0                                           }
};
*/

KviCommandEntry KviUserParser::cmdTable_A_G[]=
{
	{ "ECHO"            , 4     , &KviUserParser::parseCmd_ECHO               },
	{ "FOREACH"         , 7     , &KviUserParser::parseCmd_FOREACH            },
	{ "BREAK"           , 5     , &KviUserParser::parseCmd_BREAK              },
	{ "DO"              , 2     , &KviUserParser::parseCmd_DO                 },
	{ "DEOP"            , 4     , &KviUserParser::parseCmd_DEOP               },
	{ "CONNECT"         , 7     , &KviUserParser::parseCmd_CONNECT            },
	{ "DISCONNECT"      , 10    , &KviUserParser::parseCmd_DISCONNECT         },
	{ "DESTROY"         , 7     , &KviUserParser::parseCmd_DESTROY            },
	{ "DNS"             , 3     , &KviUserParser::parseCmd_DNS                },
	{ "BAN"             , 3     , &KviUserParser::parseCmd_BAN                },
	{ "EXCEPT"          , 6     , &KviUserParser::parseCmd_EXCEPT             },
	{ "DEVOICE"         , 7     , &KviUserParser::parseCmd_DEVOICE            },
	{ "DEHALFOP"        , 8     , &KviUserParser::parseCmd_DEHALFOP           },
	{ "DEUSEROP"        , 8     , &KviUserParser::parseCmd_DEUSEROP           },
	{ "DEOWNER"         , 7     , &KviUserParser::parseCmd_DEOWNER            },
	{ "CTCP"            , 4     , &KviUserParser::parseCmd_CTCP               },
	{ "CTCPREPLY"       , 9     , &KviUserParser::parseCmd_CTCPREPLY          },
	{ "DCC"             , 3     , &KviUserParser::parseCmd_DCC                },
	{ "ALIAS"           , 5     , &KviUserParser::parseCmd_ALIAS              },
	{ "DIALOG"          , 6     , &KviUserParser::parseCmd_DIALOG             },
	{ "DEBUG"           , 5     , &KviUserParser::parseCmd_DEBUG              },
	{ "ACTION"          , 6     , &KviUserParser::parseCmd_ME                 },
	{ "ADMIN"           , 5     , &KviUserParser::parseCmd_ADMIN              },
	{ "AME"             , 3     , &KviUserParser::parseCmd_AME                },
	{ "AMSG"            , 4     , &KviUserParser::parseCmd_AMSG               },
	{ "ANOTICE"         , 7     , &KviUserParser::parseCmd_ANOTICE            },
	{ "BEEP"            , 4     , &KviUserParser::parseCmd_BEEP               },
	{ "DIR"             , 3     , &KviUserParser::parseCmd_DIR                },
	{ "CD"              , 2     , &KviUserParser::parseCmd_CD                 },
	{ "CHANSERV"        , 8     , &KviUserParser::parseCmd_CHANSERV           },
	{ "CS"              , 2     , &KviUserParser::parseCmd_CHANSERV           },
	{ "EXEC"            , 4     , &KviUserParser::parseCmd_EXEC               },
	{ "EXECV"           , 5     , &KviUserParser::parseCmd_EXECV              },
	{ "CONFIG"          , 6     , &KviUserParser::parseCmd_CONFIG             },
	{ "AWHOIS"          , 6     , &KviUserParser::parseCmd_AWHOIS             },
	{ "DIRBROWSER"      , 10    , &KviUserParser::parseCmd_DIRBROWSER         },
	{ "CLASS"           , 5     , &KviUserParser::parseCmd_CLASS              },
	{ "CLEAROBJECTS"    , 12    , &KviUserParser::parseCmd_CLEAROBJECTS       },
	{ "CLEAR"           , 5     , &KviUserParser::parseCmd_CLEAR              },
	{ "FINDTEXT"        , 8     , &KviUserParser::parseCmd_FINDTEXT           },
	{ "GEOMETRY"        , 8     , &KviUserParser::parseCmd_GEOMETRY           },
	{ "ECHOPRIVMSG"     , 11    , &KviUserParser::parseCmd_ECHOPRIVMSG        },
	{ "GLOBOPS"         , 7     , &KviUserParser::parseCmd_GLOBOPS            },
	{ 0                 , 0     , 0                                           }
};

KviCommandEntry KviUserParser::cmdTable_H_N[]=
{
	{ "MODE"            , 4     , &KviUserParser::parseCmd_MODE               },
	{ "IF"              , 2     , &KviUserParser::parseCmd_IF                 },
	{ "HALT"            , 4     , &KviUserParser::parseCmd_HALT               },
	{ "MSG"             , 3     , &KviUserParser::parseCmd_MSG                },
	{ "ME"              , 2     , &KviUserParser::parseCmd_ME                 },
	{ "MEMOSERV"        , 8     , &KviUserParser::parseCmd_MEMOSERV           },
	{ "MS"              , 2     , &KviUserParser::parseCmd_MEMOSERV           },
	{ "MOTD"            , 4     , &KviUserParser::parseCmd_MOTD               },
	{ "KICK"            , 4     , &KviUserParser::parseCmd_KICK               },
	{ "NOTICE"          , 6     , &KviUserParser::parseCmd_NOTICE             },
	{ "JOIN"            , 4     , &KviUserParser::parseCmd_JOIN               },
	{ "NICK"            , 4     , &KviUserParser::parseCmd_NICK               },
	{ "NICKSERV"        , 8     , &KviUserParser::parseCmd_NICKSERV           },
	{ "NS"              , 2     , &KviUserParser::parseCmd_NICKSERV           },
	{ "INFO"            , 4     , &KviUserParser::parseCmd_INFO               },
	{ "INVITE"          , 6     , &KviUserParser::parseCmd_INVITE             },
	{ "HALFOP"          , 6     , &KviUserParser::parseCmd_HALFOP             },
	{ "HOST"            , 4     , &KviUserParser::parseCmd_HOST               },
	{ "IGNORE"          , 6     , &KviUserParser::parseCmd_IGNORE             },
	{ "KILL"            , 4     , &KviUserParser::parseCmd_KILL               },
	{ "NOTIFY"          , 6     , &KviUserParser::parseCmd_NOTIFY             },
	{ "LAG"             , 3     , &KviUserParser::parseCmd_LAG                },
	{ "LOCOPS"          , 6     , &KviUserParser::parseCmd_LOCOPS             },
	{ "LOG"             , 3     , &KviUserParser::parseCmd_LOG                },
	{ "LINKS"           , 5     , &KviUserParser::parseCmd_LINKS              },
	{ "HELP"            , 4     , &KviUserParser::parseCmd_HELP               },
	{ "HELPOP"          , 6     , &KviUserParser::parseCmd_HELPOP             },
	{ "HELPSERV"        , 8     , &KviUserParser::parseCmd_HELPSERV           },
	{ "HS"              , 2     , &KviUserParser::parseCmd_HELPSERV           },
	{ "LOADCONF"        , 8     , &KviUserParser::parseCmd_LOADCONF           },
	{ "LIST"            , 4     , &KviUserParser::parseCmd_LIST               },
	{ "LUSERS"          , 6     , &KviUserParser::parseCmd_LUSERS             },
	{ "KILLPROC"        , 8     , &KviUserParser::parseCmd_KILLPROC           },
	{ "KILLTIMER"       , 9     , &KviUserParser::parseCmd_KILLTIMER          },
	{ "MAP"             , 3     , &KviUserParser::parseCmd_MAP                },
	{ "MULTIMEDIA"      , 10    , &KviUserParser::parseCmd_MULTIMEDIA         },
	{ "NAMES"           , 5     , &KviUserParser::parseCmd_NAMES              },
	{ "NEWSESSION"      , 10    , &KviUserParser::parseCmd_NEWSWINDOW         },
	{ "NEWSWINDOW"      , 10    , &KviUserParser::parseCmd_NEWSWINDOW         },
	{ "NSLOOKUP"        , 8     , &KviUserParser::parseCmd_HOST               },
	{ 0                 , 0     , 0                                           }
};

KviCommandEntry KviUserParser::cmdTable_O_S[]=
{
	{ "OBJ_SETEVENT"    , 12    , &KviUserParser::parseCmd_OBJ_SETEVENT       },
	{ "OBJ_CLEAREVENT"  , 14    , &KviUserParser::parseCmd_OBJ_CLEAREVENT     },
	{ "OBJ_TRIGGEREVENT", 16    , &KviUserParser::parseCmd_OBJ_TRIGGEREVENT   },
	{ "ONOTICE"         , 7     , &KviUserParser::parseCmd_ONOTICE            },
	{ "OPTION"          , 6     , &KviUserParser::parseCmd_OPTION             },
	{ "OP"              , 2     , &KviUserParser::parseCmd_OP                 },
	{ "OPERSERV"        , 8     , &KviUserParser::parseCmd_OPERSERV           },
	{ "OS"              , 2     , &KviUserParser::parseCmd_OPERSERV           },
	{ "OWNER"           , 5     , &KviUserParser::parseCmd_OWNER              },
	{ "PART"            , 4     , &KviUserParser::parseCmd_PART               },
	{ "PRIVMSG"         , 7     , &KviUserParser::parseCmd_MSG                },
	{ "RAW"             , 3     , &KviUserParser::parseCmd_RAW                },
	{ "SAY"             , 3     , &KviUserParser::parseCmd_SAY                },
	{ "STATS"           , 5     , &KviUserParser::parseCmd_STATS              },
	{ "STATSERV"        , 8     , &KviUserParser::parseCmd_STATSERV           },
	{ "SS"              , 2     , &KviUserParser::parseCmd_STATSERV           },
	{ "SWITCH"          , 6     , &KviUserParser::parseCmd_SWITCH             },
	{ "PARSE"           , 5     , &KviUserParser::parseCmd_PARSE              },
	{ "PLAY"            , 4     , &KviUserParser::parseCmd_PLAY               },
	{ "POPUP"           , 5     , &KviUserParser::parseCmd_POPUP              },
	{ "QUIT"            , 4     , &KviUserParser::parseCmd_QUIT               },
	{ "QUOTE"           , 5     , &KviUserParser::parseCmd_RAW                },
	{ "QUERY"           , 5     , &KviUserParser::parseCmd_QUERY              },
	{ "SERVER"          , 6     , &KviUserParser::parseCmd_SERVER             },
	{ "REHASH"          , 6     , &KviUserParser::parseCmd_REHASH             },
	{ "REGISTER"        , 8     , &KviUserParser::parseCmd_REGISTER           },
	{ "STATUS"          , 6     , &KviUserParser::parseCmd_STATUS             },
	{ "RUN"             , 3     , &KviUserParser::parseCmd_RUN                },
	{ "PROCLIST"        , 8     , &KviUserParser::parseCmd_PROCLIST           },
	{ "PLUGIN"          , 6     , &KviUserParser::parseCmd_PLUGIN             },
	{ "SETCOMMENT"      , 10    , &KviUserParser::parseCmd_SETCOMMENT         },
	{ "SETFLAGS"        , 8     , &KviUserParser::parseCmd_SETFLAGS           },
	{ "SETPASS"         , 7     , &KviUserParser::parseCmd_SETPASS            },
	{ "SETHOST"         , 7     , &KviUserParser::parseCmd_SETHOST            },
	{ "SOUND"           , 5     , &KviUserParser::parseCmd_SOUND              },
	{ "SETRETURN"       , 9     , &KviUserParser::parseCmd_SETRETURN          },
	{ "OPER"            , 4     , &KviUserParser::parseCmd_OPER               },
	{ "OPENURL"         , 7     , &KviUserParser::parseCmd_OPENURL            },
	{ "SAVEOPTIONS"     , 11    , &KviUserParser::parseCmd_SAVEOPTIONS        },
	{ 0                 , 0     , 0                                           }
};

KviCommandEntry KviUserParser::cmdTable_T_Z[]=
{
	{ "TIME"            , 4     , &KviUserParser::parseCmd_TIME               },
	{ "TOPIC"           , 5     , &KviUserParser::parseCmd_TOPIC              },
	{ "WHILE"           , 5     , &KviUserParser::parseCmd_WHILE              },
	{ "WHOIS"           , 5     , &KviUserParser::parseCmd_WHOIS              },
	{ "TIMER"           , 5     , &KviUserParser::parseCmd_TIMER              },
	{ "WHOWAS"          , 6     , &KviUserParser::parseCmd_WHOWAS             },
	{ "WHO"             , 3     , &KviUserParser::parseCmd_WHO                },
	{ "UMODE"           , 5     , &KviUserParser::parseCmd_UMODE              },
	{ "UNEXCEPT"        , 8     , &KviUserParser::parseCmd_UNEXCEPT           },
	{ "UNBAN"           , 5     , &KviUserParser::parseCmd_UNBAN              },
	{ "UNREGISTER"      , 10    , &KviUserParser::parseCmd_UNREGISTER         },
	{ "USER"            , 4     , &KviUserParser::parseCmd_USER               },
	{ "USERHOST"        , 8     , &KviUserParser::parseCmd_USERHOST           },
	{ "USEROP"          , 6     , &KviUserParser::parseCmd_USEROP             },
	{ "UTOOLBAR"        , 8     , &KviUserParser::parseCmd_UTOOLBAR           },
	{ "VERSION"         , 7     , &KviUserParser::parseCmd_VERSION            },
	{ "VOICE"           , 5     , &KviUserParser::parseCmd_VOICE              },
	{ "WINDOW"          , 6     , &KviUserParser::parseCmd_WINDOW             },
	{ "WRITEPROC"       , 9     , &KviUserParser::parseCmd_WRITEPROC          },
	{ "TRY"             , 3     , &KviUserParser::parseCmd_TRY                },
	{ "WRITEFILE"       , 9     , &KviUserParser::parseCmd_WRITEFILE          },
	{ "WALLOPS"         , 7     , &KviUserParser::parseCmd_WALLOPS            },
	{ 0                 , 0     , 0                                           }
};  

//= IDEAS TO IMPLEMENT ======================================================//
//
// FOR(<operator_command>;(<expression>);<operator_command>)<command> //ouh
//
// POP %variable
// PUSH %variable
//
// LOAD <variable> <cache_identifier>
// STORE <cache_identifier> <string>
// CLEAR [cache|variables] : clears all global variables or all cache contents
//
// MAKEDIR
// FILERENAME
// FILEMOVE
// FILECOPY
// MV
// CP
// FILEREMOVE
// FILEDELETE
// PWD
// ALIAS CAT echo $readfile($0) 
// PROXY
// MIME
//
// $objectExists(object_name)
// ARRAY,SETENV,MOTD,STATS,INFO,ADMIN,VERSION,DNSEXT,CLEAR
// HOSTEXT,WINCREATE (O WINNEW),EVENT (and protect agains self-modification)
//

/*
	@command: OPERATORS
	@short:
		Variable operators, assignments, etc.
	@syntax:
		&lt;variable&gt; &lt;operator&gt; [data]
	@description:
		Operator constructs are commands just like the other ones.<br>
		All operators work with both local and global variables.<br>
		There are three types of operators:<br>
		<docsubtitle>Assignment</docsubtitle>
		&lt;variable&gt; = [string]<br>
		ASSIGNS the &lt;string&gt; to the &lt;variable&gt;<br>
		If the variable is not set yet, it is created
		and then &lt;string&gt; is assigned, otherwise
		&lt;string&gt; replaces the last value that it contained.<br>
		If &lt;string&gt; is an empty string, then the &lt;variable&gt; is unset.<br>
		Note that &lt;string&gt; can be also a numeric value.<br>
		<docsubtitle>String operators</docsubtitle>
		&lt;variable&gt; &lt;operator&gt; &lt;string&gt;<br>
		'&lt;+': Appends the &lt;string&gt; to the &lt;variable&gt;.<br>
		If the &lt;variable&gt; is not set yet, this operator is equivalent to '='.<br>
		If the &lt;string&gt; is empty, this operator does nothing.<br>
		'&lt;&lt;': Appends the &lt;string&gt; to the &lt;variable&gt;,
		separating the two strings by a single space.<br>
		If the &lt;string&gt; is empty this operator does nothing.<br>
		'&lt;,': Appends the &lt;string&gt; string to the &lt;variable&gt;
		treating it like a comma separated list of items.<br>
		If the &lt;variable&gt; is not set yet, this operator is equivalent tro '='.<br>
		If the &lt;string&gt; is empty this operator does nothing.
		<docsubtitle>Numeric operators</docsubtitle>
		&lt;variable&gt; &lt;operator&gt; [numeric value]<br>
		All numeric operators assume that the &lt;variable&gt; is a number.<br>
		'++': Increments the &lt;variable&gt; (by one).<br>
		In this case the &lt;numeric value&gt; is ignored.<br>
		This one is a bit faster than +=1.<br>
		'--': Decrements the &lt;variable&gt; (by one).<br>
		In this case the &lt;numeric value&gt; is ignored.<br>
		This one is a bit faster than -=1.<br>
		'+=': Adds the &lt;numeric value&gt; to the &lt;variable&gt; value.<br>
		'-=': Subtracts the &lt;numeric value&gt; from the &lt;variable&gt; value.<br>
		'*=': Multiplies the &lt;variable value&gt; by the &lt;numeric value&gt;.<br>
		'/=': Division: &lt;variable&gt; / &lt;numeric value&gt;.<br>
		'%=': Modulus operator.<br>
		'&=': Bitwise AND.<br>
		'|=': Bitwise OR.<br>
		'!=': Logical NOT.<br>
	@examples:
		First set the variable %var
		<example>
			%var = Ciao ciao
		</example>
		Then append a nickname...
		<example>
			%var &lt;&lt; Pragma
		</example>
		%var now contains "Ciao ciao Pragma"<br>
		Append a '!' character
		<example>
			%var &lt;+ !
		</example>
		%var now contains "Ciao ciao Pragma!"
		Now reset it.
		<example>
			%var =
		</example>
		Now %var is unset.<br>
		Reset it with a comma separated list of items
		<example>
			%var = Pragma,Diabl0,Arter|o	
			%var &lt;, MalboroLi
		</example>
		%var now contains "Pragma,Diabl0,Arter|o,MalboroLi"<br>
		Assign a string full of spaces...check the difference :)
		<example>
			%var = "            string  full   of spaces"
			%var2 =             string  full   of spaces"
			echo %var
			echo %var2
		</example>
		Now a longer example.
		<example>
			%var = l
			<a href="echo.kvihelp">echo</a> It's name starts with the letter %var!
			%var &lt;+ inux
			<a href="echo.kvihelp">echo</a> Yes, it is %var!
			%var &lt;&lt; OS
			<a href="echo.kvihelp">echo</a> Use %var!
			%var &lt;, Mac OS
			<a href="echo.kvihelp">echo</a> There are two items in this list: %var
			%var = <a href="s_strlen.kvihelp">$strlen</a>(%var)
			<a href="echo.kvihelp">echo</a> And it is %var characters long (including the comma)
			%var--
			<a href="echo.kvihelp">echo</a> Excluding the comma: %var
			%var+=%var
			<a href="echo.kvihelp">echo</a> Now it is doubled: %var
			%var =
			<a href="echo.kvihelp">echo</a> Now the var is unset (empty): (%var) !
		</example>
		Another example: toggling values (removes need for a call to <a href="s_calc.kvihelp">$calc()</a>)
		<example>
			%var = 0
		</example>
		@tab@%var is set to 0.
		<example>
			%var != %var
		</example>
		@tab@now %var is 1.
		<example>
			%var != 1
		</example>
		@tab@and 0 again.
*/

bool KviUserParser::parseCmd_LVALUE(KviCommand *c)
{
	// Ok...we have a '%' or a '$'
	// at the beginning of a command
	// It can be:
	// - A variable operation (%Var <operator> [rvalue])
	// - An object scope stuff (% or '$')
	//
	// =, ++, --, +=, -=, <<, <+, <, *=, /=, &=, |=, %=
	// %[v|V]ariable 

	__range_valid((*(c->m_ptr)==KVI_GLOBAL_VAR_CHAR) || (*(c->m_ptr) == '$'));

	KviVariableCache *cache = 0;
	KviStr szKey;
	KviStr szVariable;

	if(*(c->m_ptr) == '%')
	{
		c->m_ptr++;
	
		const char *aux = c->m_ptr;
	
		if(c->scopeObject())
		{
			cache = c->scopeObject()->varCache();
		} else {
			if(islower(*aux))cache = c->m_pLocalVarCache;
			else cache = g_pVarCache;
		}

		while(*aux && (isalnum(*aux)||(*aux == '.')||(*aux == '_')))aux++;
		szVariable.setStr(c->m_ptr,aux - c->m_ptr);
		if(szVariable.isEmpty()){
			c->setError(KVI_ERROR_MissingVariableName,__tr("VARIABLE OPERATION"));
			return false;
		}
	
		c->m_ptr = aux;
		if(*(c->m_ptr) == '['){
			c->m_ptr++;
			KviScriptObject * scObj = c->scopeObject();
			c->setScopeObject(0);
			if(!processVariableKey(c,szKey))return false;
			c->setScopeObject(scObj);
			if(szKey.isEmpty())return c->setError(KVI_ERROR_MissingDictionaryKey,__tr("VARIABLE OPERATION"),szVariable.ptr());
		}

		// object scope ?
		if(*(c->m_ptr) == '-')
		{
			if(*(c->m_ptr + 1) == '>')
			{
				c->m_ptr += 2;
				if((*(c->m_ptr) == '%') || (*(c->m_ptr) == '$'))
				{
					const char * varVal = (szKey.isEmpty() ? cache->find(szVariable.ptr()) : cache->findDictVariable(szVariable.ptr(),szKey.ptr()));
					if(varVal)
					{
						KviScriptObject * o = m_pScriptObjectController->findObjectById(varVal);
						if(o)
						{
							KviScriptObject * scObj = c->scopeObject();
							c->setScopeObject(o);
							if(!parseCmd_LVALUE(c))return false;
							c->setScopeObject(scObj);
							return true;
						} else return c->setError(KVI_ERROR_ObjectNotFound,__tr("OBJECT OPERATOR -> (LVALUE)"),varVal);
					} else return c->setError(KVI_ERROR_ObjectNotFound,__tr("OBJECT OPERATOR -> (LVALUE)"),__tr("The variable contained no object id"));
				} else return c->setError(KVI_ERROR_VariableOrIdentifierExpected,__tr("OBJECT OPERATOR -> (LVALUE)"),c->m_ptr);
			}
		}

	} else {
		// identifier
		KviStr buffer;

		// Force no pointer recognizing
		c->setRecognizeObjectScopeOperator(false);
		if(!processIdentifier(c,buffer))return false;
		c->setRecognizeObjectScopeOperator(true);

		// object scope ?
		if(*(c->m_ptr) == '-')
		{
			if(*(c->m_ptr + 1) == '>')
			{
				c->m_ptr += 2;
				if((*(c->m_ptr) == '%') || (*(c->m_ptr) == '$'))
				{
					if(buffer.hasData())
					{
						KviScriptObject * o = m_pScriptObjectController->findObjectById(buffer.ptr());
						if(o)
						{
							KviScriptObject * aux = c->scopeObject();
							c->setScopeObject(o);
							if(!parseCmd_LVALUE(c))return false;
							c->setScopeObject(aux);
							return true;
						} else return c->setError(KVI_ERROR_ObjectNotFound,__tr("OBJECT OPERATOR -> (LVALUE)"),buffer.ptr());
					} else return c->setError(KVI_ERROR_ObjectNotFound,__tr("OBJECT OPERATOR -> (LVALUE)"),__tr("The identifier/function returned no object id"));
				} else return c->setError(KVI_ERROR_VariableOrIdentifierExpected,__tr("OBJECT OPERATOR -> (LVALUE)"),c->m_ptr);
			}
		}		

		if(!c->scopeObject())c->warning(__tr("Senseless identifier/function call as LVALUE : Return value ignored (%s)"),buffer.ptr());

		return processCmdFinalPart(c);
	}

	c->skipSpace();

	KviScriptObject * scObj = c->scopeObject();
	bool bRecognizeObjectScopeOperator = c->recognizeObjectScopeOperator();
	// Neutral state
	c->setScopeObject(0);
	c->setRecognizeObjectScopeOperator(true);

	bool bRet = processOperator(c,cache,szVariable,szKey);

	c->setScopeObject(scObj);
	c->setRecognizeObjectScopeOperator(bRecognizeObjectScopeOperator);

	return bRet;
}

bool KviUserParser::processOperator(KviCommand *c,KviVariableCache *cache,KviStr &szVariable,KviStr &szKey)
{
	switch(*(c->m_ptr)){
		// Assignment
		case '=':
			c->m_ptr++;
			if(!processCmdFinalPart(c))return false;
			if(c->m_buffer.hasData()){
				if(szKey.isEmpty())cache->set(szVariable.ptr(),c->m_buffer.ptr());
				else cache->setDictVariable(szVariable.ptr(),szKey.ptr(),c->m_buffer.ptr());
			} else {
				if(szKey.isEmpty())cache->unset(szVariable.ptr());
				else cache->unsetDictVariable(szVariable.ptr(),szKey.ptr());
			}
		break;
		// Numeric addition
		case '+':
		{
			c->m_ptr++;
			KviVariable *var = (szKey.isEmpty() ? cache->getVariable(szVariable.ptr()) : cache->getDictVariable(szVariable.ptr(),szKey.ptr()));
			if(!var){
				if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_LeftOperandIsUndefined,__tr("OPERATOR +?"),szVariable.ptr());
				else {
					// recover
					if(szKey.isEmpty()){
						c->warning(__tr("OPERATOR +?: Left operand (%s) is undefined : Assuming 0"),szVariable.ptr());
						var = cache->set(szVariable.ptr(),"0");
					} else {
						c->warning(__tr("OPERATOR +?: Left operand (%s[%s]) is undefined : Assuming 0"),szVariable.ptr(),szKey.ptr());
						var = cache->setDictVariable(szVariable.ptr(),szKey.ptr(),"0");
					}
				}
			}
			bool bOk;
			int leftOp = var->szValue.toInt(&bOk);
			if(!bOk){
				// Do NOT recover this...
				// Changing the variable to a number is not a good solution
				// and not incrementing it may be dangerous in loops (infinite loop)
				c->setError(KVI_ERROR_LeftOperandIsNotANumber,__tr("OPERATOR +?"),szVariable.ptr());
				return false;
			}
			switch(*(c->m_ptr)){
				case '+': // operator ++
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					leftOp++;
					var->szValue.setNum(leftOp);
				break;
				case '=': { // operator +=
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					int rightOp = c->m_buffer.toInt(&bOk);
					if(!bOk){
						if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_RightOperandIsNotANumber,__tr("OPERATOR +="),szVariable.ptr());
						else {
							// recover
							c->warning(__tr("OPERATOR +=: Right operand is not a number : Using 1"));
							rightOp = 1;
						}
					}
					var->szValue.setNum(leftOp+rightOp);
				}
				break;
				default:
					if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_UnknownOperator,__tr("OPERATOR +?"),c->m_ptr);
					else {
						c->warning(__tr("VARIABLE OPERATION: Unknown operator +%c : Ignoring"),*(c->m_ptr));
						return processCmdFinalPart(c);
					}
				break;
			}
		}
		break;
		// Numeric subtraction		
		case '-':
		{
			c->m_ptr++;
			KviVariable *var = (szKey.isEmpty() ? cache->getVariable(szVariable.ptr()) : cache->getDictVariable(szVariable.ptr(),szKey.ptr()));
			if(!var){
				if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_LeftOperandIsUndefined,__tr("OPERATOR -?"),szVariable.ptr());
				else {
					// recover
					if(szKey.isEmpty()){
						c->warning(__tr("OPERATOR -?: Left operand (%s) is undefined : Assuming 0"),szVariable.ptr());
						var = cache->set(szVariable.ptr(),"0");
					} else {
						c->warning(__tr("OPERATOR -?: Left operand (%s[%s]) is undefined : Assuming 0"),szVariable.ptr(),szKey.ptr());
						var = cache->setDictVariable(szVariable.ptr(),szKey.ptr(),"0");
					}
				}
			}
			bool bOk;
			int leftOp = var->szValue.toInt(&bOk);
			if(!bOk){
				c->setError(KVI_ERROR_LeftOperandIsNotANumber,__tr("OPERATOR -?"),szVariable.ptr());
				return false;
			}
			switch(*(c->m_ptr)){
				case '-': // operator --
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					leftOp--;
					var->szValue.setNum(leftOp);
				break;
				case '=': { // operator -=
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					int rightOp = c->m_buffer.toInt(&bOk);
					if(!bOk){
						if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_RightOperandIsNotANumber,__tr("OPERATOR -="),szVariable.ptr());
						else {
							// recover
							c->warning(__tr("OPERATOR -=: Right operand is not a number : Using 1"));
							rightOp = 1;
						}
					}
					var->szValue.setNum(leftOp - rightOp);
				}
				break;
				default:
					if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_UnknownOperator,__tr("OPERATOR -?"),c->m_ptr);
					else {
						c->warning(__tr("VARIABLE OPERATION: Unknown operator -%c : Ignoring"),*(c->m_ptr));
						return processCmdFinalPart(c);
					}
				break;
			}
		}
		break;
		//other numeric stuff
		case '*':
		case '/':
		case '|':
		case '!':
		case '%':
		case '&':
		{
			char op = *(c->m_ptr);
			c->m_ptr++;
			KviVariable *var = (szKey.isEmpty() ? cache->getVariable(szVariable.ptr()) : cache->getDictVariable(szVariable.ptr(),szKey.ptr()));
			if(!var){
				if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_LeftOperandIsUndefined,__tr("OPERATOR [*|/!&%]?"),szVariable.ptr());
				else {
					// recover
					if(szKey.isEmpty()){
						c->warning(__tr("OPERATOR %c?: Left operand (%s) is undefined : Assuming 0"),op,szVariable.ptr());
						var = cache->set(szVariable.ptr(),"0");
					} else {
						c->warning(__tr("OPERATOR %c?: Left operand (%s[%s]) is undefined : Assuming 0"),op,szVariable.ptr(),szKey.ptr());
						var = cache->setDictVariable(szVariable.ptr(),szKey.ptr(),"0");
					}
				}
			}
			bool bOk;
			int leftOp = var->szValue.toInt(&bOk);
			if(!bOk)return c->setError(KVI_ERROR_LeftOperandIsNotANumber,__tr("NUMERIC OPERATOR"),szVariable.ptr());
			switch(*(c->m_ptr)){
				case '=': { // operator ?=
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					int rightOp = c->m_buffer.toInt(&bOk);
					if(!bOk){
						if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_RightOperandIsNotANumber,__tr("OPERATOR [*|/!&%]="),szVariable.ptr());
						else {
							// recover..use 2(for multiplications and divisions)
							c->warning(__tr("OPERATOR %c=: Right operand is not a number : Using 2"),op);
							rightOp = 2;
						}
					}
					switch(op){
						case '*': var->szValue.setNum(leftOp * rightOp); break;
						case '|': var->szValue.setNum(leftOp | rightOp); break;
						case '!': var->szValue.setNum((int)!rightOp); break;
						case '&': var->szValue.setNum(leftOp & rightOp); break;
						case '%':
							if(rightOp == 0){
								if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_DivisionByZero,__tr("OPERATOR %="),szVariable.ptr());
								else {
									c->warning(__tr("OPERATOR %=: Division by zero : Returning 0"));
									var->szValue="0";
								}
							} else var->szValue.setNum(leftOp % rightOp);
						break;
						case '/':
							if(rightOp == 0){
								if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_DivisionByZero,__tr("OPERATOR /="),szVariable.ptr());
								else {
									c->warning(__tr("OPERATOR /=: Division by zero : Returning a big number :)"));
									var->szValue.setNum((unsigned int) -1);
								}
							} else var->szValue.setNum(leftOp / rightOp);
						break;
						default: //newer here
							debug("Huh ?");
						break;
					}
				}
				break;
				default:
					if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_UnknownOperator,__tr("VARIABLE OPERATOR"),c->m_ptr);
					else {
						c->warning(__tr("VARIABLE OPERATION: Unknown operator %c : Ignoring"),*(c->m_ptr));
						return processCmdFinalPart(c);
					}
				break;
			}
		}
		break;
		//string operators
		case '<':
		{
			c->m_ptr++;
			switch(*(c->m_ptr)){
				case '+':
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					if(c->m_buffer.hasData()){
						if(szKey.isEmpty())cache->concat(szVariable.ptr(),c->m_buffer.ptr());
						else cache->concatDictVariable(szVariable.ptr(),szKey.ptr(),c->m_buffer.ptr());
					}
				break;
				case '<':
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					if(c->m_buffer.hasData()){
						if(szKey.isEmpty())cache->concatWithSeparator(szVariable.ptr(),' ',c->m_buffer.ptr());
						else cache->concatWithSeparatorDictVariable(szVariable.ptr(),szKey.ptr(),' ',c->m_buffer.ptr());
					}
				break;
				case ',':
					c->m_ptr++;
					if(!processCmdFinalPart(c))return false;
					if(c->m_buffer.hasData()){
						if(szKey.isEmpty())cache->concatWithSeparator(szVariable.ptr(),',',c->m_buffer.ptr());
						else cache->concatWithSeparatorDictVariable(szVariable.ptr(),szKey.ptr(),',',c->m_buffer.ptr());
					}
				break;
				default:
					if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_UnknownOperator,__tr("VARIABLE OPERATION"),c->m_ptr);
					else {
						c->warning(__tr("VARIABLE OPERATION: Unknown operator <%c : Ignoring"),*(c->m_ptr));
						return processCmdFinalPart(c);
					}
				break;
			}
		}
		break;
		default:
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_UnknownOperator,__tr("VARIABLE OPERATION"),c->m_ptr);
			else {
				c->warning(__tr("VARIABLE OPERATION: Unknown operator %c : Ignoring"),*(c->m_ptr));
				return processCmdFinalPart(c);
			}
		break;
	}

	return true;
}

bool KviUserParser::skipLValue(KviCommand *c)
{
	__range_valid((*(c->m_ptr)==KVI_GLOBAL_VAR_CHAR) || (*(c->m_ptr) == '$'));
	if(*(c->m_ptr) == '%')
	{
		c->m_ptr++;
		while(*(c->m_ptr) && (isalnum(*(c->m_ptr))||(*(c->m_ptr)== '.')||(*(c->m_ptr) == '_')))(c->m_ptr)++;
		if(*(c->m_ptr) == '['){
			c->m_ptr++;
			if(!skipVariableKey(c))return false;
		}

		// object scope ?
		if(*(c->m_ptr) == '-')
		{
			if(*(c->m_ptr + 1) == '>')
			{
				c->m_ptr += 2;
				if((*(c->m_ptr) == '%') || (*(c->m_ptr) == '$'))return skipLValue(c);
				else return c->setError(KVI_ERROR_VariableOrIdentifierExpected,__tr("OBJECT OPERATOR -> (LVALUE)"),c->m_ptr);
			}
		}

	} else {
		// Force no pointer recognizing
		c->setRecognizeObjectScopeOperator(false);
		if(!skipIdentifier(c))return false;
		c->setRecognizeObjectScopeOperator(true);
		// object scope ?
		if(*(c->m_ptr) == '-')
		{
			if(*(c->m_ptr + 1) == '>')
			{
				c->m_ptr += 2;
				if((*(c->m_ptr) == '%') || (*(c->m_ptr) == '$'))return skipLValue(c);
				else return c->setError(KVI_ERROR_VariableOrIdentifierExpected,__tr("OBJECT OPERATOR -> (LVALUE)"),c->m_ptr);
			}
		}		
	}

	for(;;){
		// Now skip all of the non interesting chars
		while(*(c->m_ptr) && (*(c->m_ptr) != '\\') && (*(c->m_ptr) != '\n') && (*(c->m_ptr) != KVI_GLOBAL_VAR_CHAR) &&
				(*(c->m_ptr) != ';') && (*(c->m_ptr) != '$'))++(c->m_ptr);
		// Interesting char
		switch(*(c->m_ptr)){
			case '\0': return true; break;
			case '\n': // end of command
			case ';' : ++(c->m_ptr); return true; break;
			case '$' : if(!skipIdentifier(c))return false; break;
			case KVI_GLOBAL_VAR_CHAR : if(!skipVariable(c))return false; break;
			case '\\': //escape character: append the last block to the processed buffer...
				++(c->m_ptr);
				switch(*(c->m_ptr)){
					case '\0': return true; break; //escaped nothing...
					default: ++(c->m_ptr); break;
				}
			break;
		}
	}
	return true;
}


/*
	@command: FOREACH
	@short:
		Loops through a list of items
	@syntax:
		foreach (&lt;variable&gt;[,&lt;list_of_items&gt;])&lt;command&gt;<br>
		&lt;list_of_items&gt; = &lt;item&gt;[,&lt;list_of_items&gt;]
	@description:
		Loop instruction.<br>
		For each &lt;item&gt; in the &lt;list_of_items&gt;
		assign it to the &lt;variable&gt; and execute the &lt;command&gt;.<br>
		&lt;list_of_items&gt; is a comma separated list of
		strings that may also be empty (in that case this command does nothing).<br>
		The &lt;variable&gt; CANNOT be a dictionary item and CANNOT be an object field variable.<br>
		You can immediately stop looping by calling the <a href="break.kvihelp">break</a> command
	@examples:
		<example>
			foreach(%tmp,0,1,2,3,4,5,6,7,8)<a href="echo.kvihelp">echo</a> -i %tmp This is the icon/color scheme %tmp.
		</example>
		Common use inside a popup handler
		<example>
			foreach(%var,<a href="s_selected.kvihelp">$selected</a>)<a href="ctcp.kvihelp">ctcp</a> %var ping
		</example>
		Useless (?) example (what it does ? :).<br>
		<example>
		<a href="foreach.kvihelp">foreach</a>(%t,<a href="s_range.kvihelp">$range</a>(0,1000)){
			<a href="if.kvihelp">if</a>(%t == 100)<a href="break.kvihelp">break</a>
			else <a href="echo.kvihelp">echo</a> %t
		}
		<a href="echo.kvihelp">echo</a> %t
		</example>
		Note that %t remains set to its "last value" outside the foreach loop.<br>
*/

bool KviUserParser::parseCmd_FOREACH(KviCommand *c)
{
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"FOREACH",c->m_ptr);
		return false;
	}
	++c->m_ptr;
	// Inside the params...get the variable name
	c->skipSpace();
	if(*(c->m_ptr)!=KVI_GLOBAL_VAR_CHAR){
		// this could be recoverable...but don't allow it...
		// force the user to at least read the help page :)
		c->setError(KVI_ERROR_MissingVariableName,"FOREACH",c->m_ptr);
		return false;
	}
	++c->m_ptr;
	KviVariableCache *cache;
	if(islower(*(c->m_ptr)))cache = c->m_pLocalVarCache;
	else cache = g_pVarCache;
	const char *aux = c->m_ptr;

	while(*aux && (isalnum(*aux)||(*aux == '.')||(*aux == '_')))aux++;
	KviStr szVariable(c->m_ptr,aux - c->m_ptr);
	if(szVariable.isEmpty()){
		c->setError(KVI_ERROR_MissingVariableName,"FOREACH");
		return false;
	}
	// OK...got the variable name and the variable cache pointer.
	c->m_ptr = aux;
	KviStr items,tmp;
	// Kill the last part of the variable identifier...
	if(!processFncSingleParam(c,tmp))return false;
	// now extract the list of items...

	// BUG : We have no way to treat a single variable things like "aaa,bbb"
	//       It is an intrinsic parser bug :)
	//       In the next major version of KVIrc I'll thing about it

	if(!processFncFinalPart(c,items))return false;

	QList<KviStr> itemList;
	itemList.setAutoDelete(true);
	aux = items.ptr();
	while(*aux){
		// expand the tokens in the list
		// skip the empty ones...
		while(*aux && (*aux == ' '))aux++;    //skip initial spaces
		aux = kvi_extractToken(tmp,aux,',');  //get the first available token
		if(tmp.hasData())itemList.append(new KviStr(tmp));
	}

	// K...have the list of items
	// Now iterate
	c->skipWhitespace();

	aux = c->m_ptr; //beginning of the command
	const char *endPtr = 0;
	for(KviStr * pS=itemList.first();pS;pS=itemList.next()){
		cache->set(szVariable.ptr(),pS->ptr());
		if(*(c->m_ptr) == '{'){
			if(!execCommandBlock(c)){
				if(c->breakPending()){
					c->setBreakPending(false);
					if(endPtr){ c->m_ptr = endPtr; return true; }
					else { c->m_ptr = aux; return skipCommand(c); }
				} else return false;
			}
		} else {
			if(!execSingleCommand(c)){
				if(c->breakPending()){
					c->setBreakPending(false);
					if(endPtr){ c->m_ptr = endPtr; return true; }
					else { c->m_ptr = aux; return skipCommand(c); }
				} else return false;
			}
		}
		endPtr = c->m_ptr; //save the end ptr
		c->m_ptr = aux;    //and go back
	}
	// Qt will autoclear the itemList (I hope :)
	if(endPtr){
		c->m_ptr = endPtr;
		return true;
	} else return skipCommand(c);
}

bool KviUserParser::skipForeach(KviCommand *c)
{
//	c->m_ptr += 7;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){ c->setError(KVI_ERROR_OpenParenthesisExpected,"FOREACH",c->m_ptr); return false; }
	if(!skipExpressionBody(c))return false; //maybe problems here ???
	c->skipWhitespace();
	return skipCommand(c);
}

/*
	@command: CLASS
	@short:
		Defines a new object class
	@syntax:
		class [-o] (&lt;class_name&gt;,&lt;inherited_class&gt;)<br>
		{<br>
		&nbsp;&nbsp;&nbsp;&nbsp;[event(&lt;event_name&gt;)&lt;event_handler&gt;]<br>
		&nbsp;&nbsp;&nbsp;&nbsp;[function(&lt;function_name&gt;)&lt;function_body&gt;]<br>
		&nbsp;&nbsp;&nbsp;&nbsp;...<br>
		}<br>
	@description:
		Defines a new object class.<br>
		A class cannot be defined twice: if you want to redefine a class
		you must use the [cmd]clearobjects[/cmd] command first.<br>
		To avoid this, the -o switch has been provided:<br>
		it will cause the previoous class definition to be cleared
		(just like [cmd]clearobjects[/cmd] &lt;class_name&gt; was called.<br>
		<b>WARNING: The -o switch must NOT be used inside object event handlers, object functions
		or object slots.</b>
		It may cause the objects to be deleted in a wrong moment, usually leading to a SIGSEGV.<br>
		See the <a href="syntax_objects.kvihelp">objects documentation</a>
		for more info.<br>
	@seealso:
		[cmd]clearobjects[/cmd],<br>
		<a href="syntax_objects.kvihelp">Objects documentation</a>
*/

bool KviUserParser::parseCmd_CLASS(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"CLASS",c->m_ptr);
	++c->m_ptr;
	// Inside the params
	KviStr className,inheritedClass;
	if(!processFncSingleParam(c,className))return false;
	if(!processFncFinalPart(c,inheritedClass))return false;
	if(className.isEmpty())return c->setError(KVI_ERROR_MissingObjectClass,"CLASS",__tr("Definition class name"));
	if(inheritedClass.isEmpty())return c->setError(KVI_ERROR_MissingObjectClass,"CLASS",__tr("Inherited class name"));
	KviScriptObjectClassDefinition * d= m_pScriptObjectController->lookupClassDefinition(className.ptr());
	if(d){
		if(c->hasSwitch('o'))m_pScriptObjectController->killClass(className.ptr());
		else return c->setError(KVI_ERROR_ClassAlreadyDefined,"CLASS",className.ptr());
	}
	d = m_pScriptObjectController->lookupClassDefinition(inheritedClass.ptr());
	if(!d)return c->setError(KVI_ERROR_UnknownObjectClass,"CLASS",inheritedClass.ptr());
	c->skipWhitespace();
	if(*(c->m_ptr) != '{')return c->setError(KVI_ERROR_OpenBraceExpected,"CLASS",c->m_ptr);
	++(c->m_ptr);

	KviScriptObjectClassDefinition * newOne = new KviScriptObjectClassDefinition(className.ptr(),d,false);

	while(*(c->m_ptr) != '}')
	{
		c->skipWhitespace();
		if(kvi_strEqualCIN(c->m_ptr,"event",5))
		{
			c->m_ptr += 5;
			c->skipWhitespace();
			if(*(c->m_ptr) != '('){
				delete newOne;
				return c->setError(KVI_ERROR_OpenParenthesisExpected,"CLASS",c->m_ptr);
			}
			++c->m_ptr;
			// Inside the params
			KviStr evName;
			if(!processFncFinalPart(c,evName)){
				delete newOne;
				return false;
			}
			c->skipWhitespace();
			const char *aux = c->m_ptr; //beginning of the command
			if(!skipCommand(c)){
				delete newOne;
				return false;
			}
			KviScriptEventStruct * s = new KviScriptEventStruct;
			s->szName = evName;
			s->szBuffer.setStr(aux,c->m_ptr - aux);
			newOne->addDefaultEvent(s);

		} else if(kvi_strEqualCIN(c->m_ptr,"function",8))
		{
			c->m_ptr += 8;
			c->skipWhitespace();
			if(*(c->m_ptr) != '('){
				delete newOne;
				return c->setError(KVI_ERROR_OpenParenthesisExpected,"CLASS",c->m_ptr);
			}
			++c->m_ptr;
			// Inside the params
			KviStr fncName;
			if(!processFncFinalPart(c,fncName)){
				delete newOne;
				return false;
			}
			c->skipWhitespace();
			const char *aux = c->m_ptr; //beginning of the command
			if(!skipCommand(c)){
				delete newOne;
				return false;
			}
			KviStr tmp(aux,c->m_ptr - aux);
			newOne->addFunction(fncName.ptr(),tmp.ptr());
		} else if(*(c->m_ptr) == KVI_COMMENT_BEGIN_CHAR)
		{
			// a comment
			if(!skipComment(c))return false;
		} else {
			delete newOne;
			return c->setError(KVI_ERROR_EventOrFunctionKeywordExpected,"CLASS",c->m_ptr);
		}
		c->skipWhitespace();
	}
	++(c->m_ptr);
	d->addChildClassDefinition(newOne);

	return true;
}

bool KviUserParser::skipClass(KviCommand *c)
{
//	c->m_ptr += 5;
	if(!skipSwitches(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"CLASS",c->m_ptr);
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '{')return c->setError(KVI_ERROR_OpenBraceExpected,"CLASS",c->m_ptr);
	++(c->m_ptr);
	while(*(c->m_ptr) != '}')
	{
		c->skipWhitespace();
		if(kvi_strEqualCIN(c->m_ptr,"event",5))
		{
			c->m_ptr += 5;
			c->skipWhitespace();
			if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"CLASS",c->m_ptr);
			if(!skipExpressionBody(c))return false;
			c->skipWhitespace();
			if(!skipCommand(c))return false;
		} else if(kvi_strEqualCIN(c->m_ptr,"function",8))
		{
			c->m_ptr += 8;
			c->skipWhitespace();
			if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"CLASS",c->m_ptr);
			if(!skipExpressionBody(c))return false;
			c->skipWhitespace();
			if(!skipCommand(c))return false;
		} else if(*(c->m_ptr) == KVI_COMMENT_BEGIN_CHAR)
		{
			// a comment
			if(!skipComment(c))return false;
		} else return c->setError(KVI_ERROR_EventOrFunctionKeywordExpected,"CLASS",c->m_ptr);
		c->skipWhitespace();
	}
	++(c->m_ptr);
	return true;
}

/*
	@command: SWITCH
	@short:
		Executes commands conditionally
	@syntax:
		<b>switch</b>(&lt;condition_string&gt;){<br>
		&nbsp;&nbsp;[&lt;b>case</b>(&lt;string&gt;)[:]&lt;case_command&gt;]<br>
		&nbsp;&nbsp;[&lt;b>match</b>(&lt;string&gt;)[:]&lt;match_command&gt;]<br>
		&nbsp;&nbsp;[&lt;b>case</b>(&lt;string&gt;)[:]&lt;case_command&gt;]<br>
		&nbsp;&nbsp;...<br>
		&nbsp;&nbsp;[&lt;b>case</b>(&lt;string&gt;)[:]&lt;case_command&gt;]<br>
		&nbsp;&nbsp;[&lt;b>default</b>[:]&lt;default_command&gt;]<br>
		}
	@description:
		This command first evaluates the &lt;condition_string&gt; by substituting the identifiers
		and variables.<br>
		Then sequentially evaluates the 'case','match' and 'default' labels until
		one of the following conditions:<br>
		In the <b>case</b> label, the &lt;condition_string&gt; is compared
		with &lt;string&gt;.<br>
		If the two strings are equal (case insensitive comparison), the related
		&lt;case_command&gt; is executed and the command terminates.<br>
		In the <b>match</b> label, the &lt;match_string&gt; is treated as
		a regular expression (string with wildcards), and it is compared
		with &lt;condition_string&gt;.<br>
		If the &lt;condition_string&gt; matches (case insensitive exact match)
		the &lt;match_string&gt; the related &lt;match_command&gt; is executed
		and the command terminates.<br>
		The <b>default</b> label is expected to be the last in the conditions list,
		and its related &lt;default_command&gt; is executed if none of the
		&lt;case_command&gt; and &lt;match_command&gt; were executed.<br>
		Obviously all of the labels are optional.<br>
		This command is quite faster than a sequence of consecutive [cmd]if[/cmd] commands,
		anyway, huge switches (with more than 8-9 options) should be splitted
		in more separate parts if possible.<br>
	@examples:
		Simple example.<br>
		Code equivalent to 'if(%tmp > 1)&lt;command&gt;'.
		<example>
		switch(1){
		&nbsp;&nbsp;case(<a href="s_calc">$calc</a>(%tmp > 1)):&lt;command&gt;
		}
		</example>
		More complex one:
		<example>
		switch(<a href="s_mymask">$mymask</a>){
		&nbsp;&nbsp;match(*!*@*.org): {
		&nbsp;&nbsp;&nbsp;&nbsp;<a href="echo.kvihelp">echo</a> My mask matches *!*@.org
		&nbsp;&nbsp;&nbsp;&nbsp;<a href="echo.kvihelp">echo</a> and it is <a href="s_mymask.kvihelp">$mymask</a>;
		&nbsp;&nbsp;}
		&nbsp;&nbsp;match(*!*@*.com): {
		&nbsp;&nbsp;&nbsp;&nbsp;<a href="echo.kvihelp">echo</a> My mask matches *!*@.com
		&nbsp;&nbsp;&nbsp;&nbsp;<a href="echo.kvihelp">echo</a> and it is <a href="s_mymask.kvihelp">$mymask</a>;
		&nbsp;&nbsp;}
		&nbsp;&nbsp; default: <a href="echo.kvihelp">echo</a> Not matched.
		}
		</example>
		Example with numbers.
		<example>
		switch(<a href="s_rand.kvihelp">$rand</a>(10)){
		&nbsp;&nbsp;case(0): echo The number is 0
		&nbsp;&nbsp;case(1): echo The number is 1
		&nbsp;&nbsp;case(2): echo The number is 2
		&nbsp;&nbsp;case(3): echo The number is 3
		&nbsp;&nbsp;case(4): echo The number is 4
		&nbsp;&nbsp;case(5): echo The number is 5
		&nbsp;&nbsp;default: echo The number is greater than 5
		}
		</example>
*/


bool KviUserParser::parseCmd_SWITCH(KviCommand *c)
{
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,__tr("SWITCH"),c->m_ptr);
		return false;
	}
	++c->m_ptr;
	// Get the string to compare
	KviStr string;
	if(!processFncFinalPart(c,string))return false;

	// Need an open brace
	c->skipWhitespace();
	if(*(c->m_ptr) != '{'){
		c->setError(KVI_ERROR_OpenBraceExpected,"SWITCH",c->m_ptr);
		return false;
	}
	++c->m_ptr;
	// Now loop thru case labels
	bool bDefaultEncountered = false;
	bool bCaseExecuted = false;

	for(;;){
		c->skipWhitespace();
		if(!(*(c->m_ptr))){ // Missing terminator...
			c->setError(KVI_ERROR_UnexpectedEndOfCommand,"SWITCH");
			return false;
		}
		if(*(c->m_ptr) == '}'){ // Finished
			++c->m_ptr;
			return true;
		}
 		if(*(c->m_ptr) == KVI_COMMENT_BEGIN_CHAR)
		{
			// a comment
			if(!skipComment(c))return false;
			continue;
		}
		if(bDefaultEncountered){
			// Nope...the default label was already encountered...
			// We expected the closing brace (end of switch command)
			c->setError(KVI_ERROR_EndOfSwitchExpectedAfterDefault,"SWITCH",c->m_ptr);
			return false;
		}
		if(kvi_strEqualNoLocaleCIN(c->m_ptr,"case",4)){
			c->m_ptr+=4;
			c->skipWhitespace();
			if(*(c->m_ptr) != '('){
				c->setError(KVI_ERROR_OpenParenthesisExpected,"SWITCH-CASE-LABEL",c->m_ptr);
				return false;
			}
			++c->m_ptr;
			KviStr caseLabel;
			if(!processFncFinalPart(c,caseLabel))return false;
			caseLabel.stripWhiteSpace();

			c->skipWhitespace();

			if(*(c->m_ptr) == ':'){
				++c->m_ptr;
				c->skipWhitespace();
			}

			if(!(*(c->m_ptr))){
				c->setError(KVI_ERROR_CommandExpectedAfterCase,"SWITCH-CASE-LABEL");
				return false;
			}

			if(!bCaseExecuted){ //Not executed yet...
				if(kvi_strEqualCI(caseLabel.ptr(),string.ptr())){
					if(*(c->m_ptr) == '{'){
						if(!execCommandBlock(c))return false;
					} else {
						if(!execSingleCommand(c))return false;
					}
					bCaseExecuted = true; //Ok...do not execute the default
				} else if(!skipCommand(c))return false;
			} else if(!skipCommand(c))return false;
			continue;
		}
		if(kvi_strEqualNoLocaleCIN(c->m_ptr,"match",5)){
			c->m_ptr+=5;
			c->skipWhitespace();
			
			if(*(c->m_ptr) != '('){
				c->setError(KVI_ERROR_OpenParenthesisExpected,"SWITCH-MATCH-LABEL",c->m_ptr);
				return false;
			}
			++c->m_ptr;
			KviStr matchLabel;
			if(!processFncFinalPart(c,matchLabel))return false;
			matchLabel.stripWhiteSpace();

			c->skipWhitespace();
			if(*(c->m_ptr) == ':'){
				++c->m_ptr;
				c->skipWhitespace();
			}

			if(!(*(c->m_ptr))){
				c->setError(KVI_ERROR_CommandExpectedAfterMatch,"SWITCH-MATCH-LABEL");
				return false;
			}

			if(!bCaseExecuted){ //Not executed yet...
				QRegExp exp(_CHAR_2_QSTRING(matchLabel.ptr()),false,true);
				int len = 0;
				int wasMath = exp.match(_CHAR_2_QSTRING(string.ptr()),0,&len);
				if((wasMath == 0) && (len == string.len())){
					if(*(c->m_ptr) == '{'){
						if(!execCommandBlock(c))return false;
					} else {
						if(!execSingleCommand(c))return false;
					}
					bCaseExecuted = true; //Ok...do not execute the default
				} else if(!skipCommand(c))return false;
			} else if(!skipCommand(c))return false;
			continue;
		}
		if(kvi_strEqualNoLocaleCIN(c->m_ptr,"default",7)){
			c->m_ptr+=7;
			c->skipWhitespace();
			if(*(c->m_ptr) == ':'){
				++c->m_ptr;
				c->skipWhitespace();
			}
			if(!(*(c->m_ptr))){
				c->setError(KVI_ERROR_CommandExpectedAfterDefault,"SWITCH-DEFAULT-LABEL");
				return false;
			}
			if(bCaseExecuted){
				if(!skipCommand(c))return false;
			} else {
				if(*(c->m_ptr) == '{'){
					if(!execCommandBlock(c))return false;
				} else {
					if(!execSingleCommand(c))return false;
				}
			}
			bDefaultEncountered = true;
			continue;
		}
		c->setError(KVI_ERROR_CaseDefaultMatchOrEndOfSwitchExpected,"SWITCH",c->m_ptr);
		return false;
	}
	__range_valid(false);
	return false; //newer here
}

bool KviUserParser::skipSwitch(KviCommand *c)
{
//	c->m_ptr += 6;
//	if(!skipSwitches(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){ c->setError(KVI_ERROR_OpenParenthesisExpected,__tr("SWITCH"),c->m_ptr); return false; }
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '{'){ c->setError(KVI_ERROR_OpenBraceExpected,"SWITCH",c->m_ptr); return false; }
	++c->m_ptr;
	bool bDefaultEncountered = false;
	for(;;){
		c->skipWhitespace();
		if(!(*(c->m_ptr))){ c->setError(KVI_ERROR_UnexpectedEndOfCommand,"SWITCH"); return false; }
		if(*(c->m_ptr) == '}'){ ++c->m_ptr; c->skipWhitespace(); return true; }
 		if(*(c->m_ptr) == KVI_COMMENT_BEGIN_CHAR)
		{
			if(!skipComment(c))return false;
			continue;
		}
		if(bDefaultEncountered){ c->setError(KVI_ERROR_EndOfSwitchExpectedAfterDefault,"SWITCH",c->m_ptr); return false; }
		if(kvi_strEqualNoLocaleCIN(c->m_ptr,"case",4)){
			c->m_ptr+=4;
			c->skipWhitespace();
			if(*(c->m_ptr) != '('){ c->setError(KVI_ERROR_OpenParenthesisExpected,"SWITCH-CASE-LABEL",c->m_ptr); return false; }
			if(!skipExpressionBody(c))return false;
			c->skipWhitespace();
			if(*(c->m_ptr) == ':'){ ++c->m_ptr; c->skipWhitespace(); }
			if(!(*(c->m_ptr))){ c->setError(KVI_ERROR_CommandExpectedAfterCase,"SWITCH-CASE-LABEL"); return false; }
			if(!skipCommand(c))return false;
			continue;
		}
		if(kvi_strEqualNoLocaleCIN(c->m_ptr,"match",5)){
			c->m_ptr+=5;
			c->skipWhitespace();
			if(*(c->m_ptr) != '('){ c->setError(KVI_ERROR_OpenParenthesisExpected,"SWITCH-MATCH-LABEL",c->m_ptr); return false; }
			if(!skipExpressionBody(c))return false;
			c->skipWhitespace();
			if(*(c->m_ptr) == ':'){ ++c->m_ptr; c->skipWhitespace(); }
			if(!(*(c->m_ptr))){ c->setError(KVI_ERROR_CommandExpectedAfterCase,"SWITCH-MATCH-LABEL"); return false; }
			if(!skipCommand(c))return false;
			continue;
		}
		if(kvi_strEqualNoLocaleCIN(c->m_ptr,"default",7)){
			c->m_ptr+=7;
			c->skipWhitespace();
			if(*(c->m_ptr) == ':'){ ++c->m_ptr; c->skipWhitespace(); }
			if(!(*(c->m_ptr))){ c->setError(KVI_ERROR_CommandExpectedAfterDefault,"SWITCH-DEFAULT-LABEL"); return false; }
			if(!skipCommand(c))return false;
			bDefaultEncountered = true;
			continue;
		}
		c->setError(KVI_ERROR_CaseDefaultMatchOrEndOfSwitchExpected,"SWITCH",c->m_ptr);
		return false;
	}
	__range_valid(false);
	return false; //newer here
}

/*
	@command: WHILE
	@short:
		Conditional loop
	@syntax:
		while(&lt;expression&gt;)&lt;command&gt;
	@description:
		Executes a conditional loop.<br>
		This command acts nearly as the C/C++ one.<br>
		First the &lt;expression&gt; is evaluated; the expression syntax
		is the same as in the <a href="if.kvihelp">if</a> command or in the
		<a href="s_calc.kvihelp">$calc()</a> function.<br>
		If the result of the evaluation is NON-ZERO (true), the &lt;command&gt;
		is executed, and the loop restarts from beginning.<br>
		If the result is ZERO (false), the &lt;command&gt; is NOT executed
		and the while command terminates.<br>
		Please note that nobody is going to stop you from doing infinite loops;
		you CAN hang KVIrc with a 'while(1)'.<br>
		You can stop the loop immediately by calling the <a href="break.kvihelp">break</a> command.<br>
	@examples:
		A simple one.
		<example>
		%tmp = 100;
		while(%tmp){
		@tab@echo -i=%tmp This is the icon/color scheme %tmp
		@tab@%tmp--;
		}
		</example>
		Note that the expression 'while(%tmp)' is equivalent to 'while(%tmp != 0)'
	@seealso:
		<a href="do.kvihelp">DO</a>, <a href="if.kvihelp">IF</a>
*/

bool KviUserParser::parseCmd_WHILE(KviCommand *c)
{
	// while(<expression>)<command>
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,__tr("WHILE-CONDITION"),c->m_ptr);
		return false;
	}
	const char * conditionPtr = ++(c->m_ptr);
	const char * endPtr = 0;
	const char * cmdPtr;

	for(;;){
		long expValue;
		if(!evaluateExpr(c,&expValue))return false;
		c->skipWhitespace();
		cmdPtr = c->m_ptr;
		if(expValue){
			// True...exec the command block
			if(*(c->m_ptr) == '{'){
				if(!execCommandBlock(c)){
					if(c->breakPending()){
						c->setBreakPending(false);
						if(endPtr){ c->m_ptr = endPtr; return true; }
						else { c->m_ptr = cmdPtr; return skipCommand(c); }
					} else return false;
				}
			} else {
				if(!execSingleCommand(c)){
					if(c->breakPending()){
						c->setBreakPending(false);
						if(endPtr){ c->m_ptr = endPtr; return true; }
						else { c->m_ptr = cmdPtr; return skipCommand(c); }
					} else return false;
				}
			}
		} else {
			// False...skip the command block and exit
			if(endPtr){
				c->m_ptr = endPtr;
				return true;
			} else return skipCommand(c);
		}
		endPtr = c->m_ptr;
		c->m_ptr = conditionPtr;
	}
	return true;
}

bool KviUserParser::skipWhile(KviCommand *c)
{
	// while(<expression>)<command>
//	c->m_ptr+=5;
//	if(!skipSwitches(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,__tr("WHILE-CONDITION"),c->m_ptr);
		return false;
	}
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	return skipCommand(c);
}

/*
	@command: DO
	@short:
		"Reversed" conditional loop
	@syntax:
		do &lt;command&gt; while(&lt;expression&gt;);
	@description:
		Executes a conditional loop.<br>
		This command acts like the C/C++ one, and is similar to the
		<a href="while.kvihelp">while</a> command.<br>
		The difference is that the &lt;command&gt; is always executed
		at least once.<br>
		First the &lt;command&gt; is executed, then the &lt;expression&gt; is evaluated;
		the expression syntax is the same as in the <a href="if.kvihelp">if</a> command or in the
		<a href="s_calc.kvihelp">$calc()</a> function.<br>
		If the result of the evaluation is NON-ZERO (true) the loop restarts from beginning.<br>
		If the result is ZERO (false) and the 'do' command terminates.<br>
		Please note that nobody is going to stop you from doing infinite loops;
		you CAN hang KVIrc with a 'do echo nothing; while(1)'.<br>
		You can immediately halt the looping by calling <a href="break.kvihelp">break</a>
		inside the &lt;command&gt;.<br>
	@examples:
		<example>
		%tmp = 0;
		do{
		@tab@echo -i=%tmp This is the icon/color scheme %tmp
		@tab@%tmp++;
		}while(%tmp &lt; 100);
		</example>
		Note that the expression is '%tmp &lt; 100', but the loop with %var set to 100 IS executed.
		Another simple (and useless) example.<br>
		<example>
		%tmp = 0
		do{
			%tmp++
			<a href="echo.kvihelp">echo</a> %tmp
			<a href="if.kvihelp">if</a>(%tmp == 100)<a href="break.kvihelp">break</a>
		} while(%tmp)
		</example>
	@seealso:
		<a href="while.kvihelp">WHILE</a>, <a href="if.kvihelp">IF</a>
*/

bool KviUserParser::parseCmd_DO(KviCommand *c)
{
	// do <command> while(<expression>)
	bool bBreak = false;
	c->skipWhitespace();
	const char * begin = c->m_ptr;
	for(;;){
		if(*(c->m_ptr) == '{'){
			if(!execCommandBlock(c)){
				if(c->breakPending()){
					c->setBreakPending(false);
					bBreak = true;
					c->m_ptr = begin;
					if(!skipCommand(c))return false;
				} else return false;
			}
		} else {
			if(!execSingleCommand(c)){
				if(c->breakPending()){
					c->setBreakPending(false);
					bBreak = true;
					c->m_ptr = begin;
					if(!skipCommand(c))return false;
				} else return false;
			}
		}
		c->skipWhitespace();
		if(!kvi_strEqualNoLocaleCIN(c->m_ptr,"while",5)){
			c->setError(KVI_ERROR_DoWithoutWhile,"DO-WHILE");
			return false;
		}
		c->m_ptr+=5;
		c->skipWhitespace();
		if(*(c->m_ptr) != '('){
			c->setError(KVI_ERROR_OpenParenthesisExpected,_i18n_("WHILE-CONDITION"),c->m_ptr);
			return false;
		}
		++(c->m_ptr);
		long expValue;
		if(!evaluateExpr(c,&expValue))return false;
		if((!expValue) || bBreak)break;
		
		c->m_ptr = begin;
	}
	c->skipSpace();
	if(((*(c->m_ptr)) == ';') || ((*(c->m_ptr)) == '\n')){
		++(c->m_ptr);
		return true;
	}
	if((*(c->m_ptr)) != '\0'){
		c->setError(KVI_ERROR_CommandTerminatorExpected,"WHILE",c->m_ptr);
		return false;
	}
	return true;
}


bool KviUserParser::skipDo(KviCommand *c)
{
	// do <command> while(<expression>)
//	c->m_ptr+=2;
//	if(skipSwitches(c))return false;
	c->skipWhitespace();
	if(!skipCommand(c))return false;
	c->skipWhitespace();
	if(!kvi_strEqualNoLocaleCIN(c->m_ptr,"while",5)){
		c->setError(KVI_ERROR_DoWithoutWhile,"DO-WHILE");
		return false;
	}
	c->m_ptr+=5;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,__tr("WHILE-CONDITION"),c->m_ptr);
		return false;
	}
	if(!skipExpressionBody(c))return false;
	c->skipSpace();
	if((*(c->m_ptr) != ';')&&(*(c->m_ptr) != '\n')&&(*(c->m_ptr) != '\0')){
		c->setError(KVI_ERROR_CommandTerminatorExpected,"WHILE",c->m_ptr);
		return false;
	}
	++(c->m_ptr);
	return true;
}


/*
	@command: BREAK
	@short:
		Breaks a foreach, while or do loop
	@syntax:
		break
	@description:
		Breaks the current <a href="foreach.kvihelp">foreach</a>, <a href="while.kvihelp">while</a> or <a href="do.kvihelp">do</a> loop.<br>
		Called outside a <a href="while.kvihelp">while</a>, <a href="do.kvihelp">do</a> or <a href="foreach.kvihelp">foreach</a> loop it is equivalent to <a href="halt.kvihelp">halt</a>.<br>
	@examples:
		A loop that will stop somewhere in the middle :)<br>
		<example>
		<a href="foreach.kvihelp">foreach</a>(%t,1,2,3,4,5,6,7,8,9)<a href="if.kvihelp">if</a>(%t == 4)break
		</example>
*/

bool KviUserParser::parseCmd_BREAK(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	c->setBreakPending(true);
	return false; // like halt!
}

/*
FIXME:
#warning "ALIAS : skip white space after the name ?"
#warning "ALIAS : alternative form :"
#warning "ALIAS : alias (name)"
#warning "ALIAS : {"
#warning "ALIAS :      ..."
#warning "ALIAS : }"
*/

/*
	@command: ALIAS
	@short:
		Adds or removes an alias
	@syntax:
		alias &lt;name&gt; &lt;command&gt;<br>
		alias -r [-q] &lt;name&gt;
	@description:
		Adds or removes a command alias.<br>
		The first form adds an alias with &lt;name&gt; as command name and &lt;command&gt; as body.<br>
		The &lt;name&gt; must be made of letters, digits, points ('.') and underscores ('_').<br>
		The &lt;command&gt; must start on the same line.<br>
		If an alias with the same name already exists its body is replaced by &lt;command&gt;.<br>
		The second form, with the -r switch, removes the alias named &lt;name&gt;.<br>
		If the alias &lt;name&gt; does not exist, the command aborts with an error,
		unless the -q swtich is specified (in that case the alias &lt;name&gt; is NOT removed
		and the error is ignored).<br>
		You can NOT self-modify an alias inside its body or inside another command called from its body:<br>
		'/alias MyAlias alias -r MyAlias'<br>
		is an example of self-modification: the internal 'alias -r' will abort with an error,
		unless you specify the -q switch (in that case the alias 'MyAlias' will be NOT removed and
		the execution will continue normally).<br>
	@examples:
		<example>
		alias hop { <a href="part.kvihelp">part</a> <a href="s_chan.kvihelp">$chan</a>; <a href="join.kvihelp">join</a> <a href="s_chan.kvihelp">$chan</a>; }
		</example>
		First form:
		<example>
		alias myfastkickban {
		&nbsp;	<a href="kick.kvihelp">kick</a> $1 Go sit in a corner man!
		&nbsp;	<a href="ban.kvihelp">ban</a> $1
		}
		</example>
		Remove an alias
		<example>
		alias -r hop
		</example>
*/

bool KviUserParser::parseCmd_ALIAS(KviCommand *c)
{
	// alias [-r] [-q] <alias_name> <command>
	if(!extractSwitches(c))return false;
	bool bQuiet  = c->hasSwitch('q');
	bool bRemove = c->hasSwitch('r');
	// extract the name
	const char *aux = c->m_ptr;
	while((*(c->m_ptr)) && (isalnum(*(c->m_ptr))||(*(c->m_ptr) == '_')||(*(c->m_ptr) == '.')))++(c->m_ptr);
	KviStr name;
	name.setStr(aux,(c->m_ptr) - aux);
	if(name.isEmpty()){
		// too complex to recover it.
		return c->setError(KVI_ERROR_AliasNameExpected,"ALIAS",aux);
	}
	// remove the alias if needed
	c->skipSpace();
	if(bRemove){
		if(!processCmdFinalPart(c))return false;
		if(!g_pAliasManager->removeAlias(name.ptr())){
			if(bQuiet)return true; // stay quiet
			if(g_pAliasManager->findAlias(name.ptr()))return recoverableError(c,KVI_ERROR_AliasSelfModificationNotAllowed,"ALIAS",name.ptr());
			else return recoverableError(c,KVI_ERROR_NoAliasWithThatName,"ALIAS",name.ptr());
		}		
		return true;
	}
//	c->skipWhiteSpace(); // allow to start on newline ?
	// get the alias body
	if(!(*(c->m_ptr))){
		// recoverable, but this is a real syntax error
		// force the user to read the help page
		return c->setError(KVI_ERROR_AliasBodyExpected,"ALIAS",name.ptr());
	}
	aux = c->m_ptr;
	if(!skipCommand(c))return false;
	// create the alias...
	KviAlias * a = new KviAlias;
	a->szName = name;
	a->szBuffer.setStr(aux,(c->m_ptr)-aux);
	if(a->szBuffer.isEmpty()){ c->setError(KVI_ERROR_AliasBodyExpected,"ALIAS",aux); delete a; return false; }
	if(!g_pAliasManager->addAlias(a)){
		delete a;
		return recoverableError(c,KVI_ERROR_AliasSelfModificationNotAllowed,"ALIAS",name.ptr());
	}
	return true;
}

bool KviUserParser::skipAlias(KviCommand *c)
{
//	c->m_ptr += 5;
	// alias [-r] [-q] <alias_name> <command>
	if(!skipSwitches(c))return false;
	// extract the name
	if(!(*(c->m_ptr))){ c->setError(KVI_ERROR_AliasNameExpected,"ALIAS"); return false; }
	while((*(c->m_ptr)) && (isalnum(*(c->m_ptr))||(*(c->m_ptr) == '_')||(*(c->m_ptr) == '.')))++(c->m_ptr);
	c->skipSpace();
//	if(!c->hasSwitch('r'))c->skipWhiteSpace(); //<-- must have a body...so allow to start it on a new line
	// get the alias body <-- as long as there is an alias body
//	if(!(*(c->m_ptr))){ c->setError(KVI_ERROR_AliasBodyExpected,"ALIAS"); return false; }
	return skipCommand(c);
}

/*
	@command: POPUP
	@short:
		Modifies a popup
	@syntax:
		popup [-a] &lt;popup_name&gt; &lt;popup_body&gt;<br>
		&lt;popup_body&gt; = {<br>
		@tab@[item(&lt;name&gt;[,&lt;icon_number&gt;])[:]&lt;command&gt;]<br>
		@tab@[submenu(&lt;name&gt;[,&lt;icon_number&gt;])[:]&lt;popup_body&gt;<br>
		@tab@[separator[;]]<br>
		@tab@...
		}
	@description:
		Modifies one of the user-definable popups.<br>
		There are six popups that you can modify:<br>
		channel: Accessed by right-clicking in a channel window.<br>
		console: Accessed by right-clicking in the console window.<br>
		dccchat: Accessed by right-clicking in a DCC chat window.<br>
		query: Accessed by right-clicking in a query window.<br>
		userlist: Accessed by clicking on a nickname in a channel userlist.<br>
		notifylist: Accessed by clicking on a nickname in the console notify list.<br>
		Each popup can contain: items, submenus and separators.<br>
		Each item has a &lt;name&gt; that is displayed in the popup menu,
		an optional icon (that sould be specified as a number, as for the <a href="echo.kvihelp">echo</a>
		command), and a &lt;command&gt; that is executed when the item is clicked by the user.<br>
		Each submenu has a &lt;name&gt; that is displayed in the popup menu,
		an optional icon and a &lt;popup_body&gt; that has exactly the same syntax as the main popup:<br>
		a submenu is simply a nested popup.<br>
		You can have multiple levels of nested popups.<br>
		When the /popup command is parsed, the popup specified by &lt;popup_name&gt;
		is first cleared, and then items are appended to it.<br>
		If the -a switch is specified, the popup is NOT cleared and the items
		are appended at the end.<br>
		You can NOT self-modify a popup inside its body or inside another command called from its body:<br>
		'/popup channel { item(aItem): popup channel { item(aItem): echo something; } }'<br>
		is an example of self-modification: the internal 'popup' will abort with an error.
	@examples:
		A complete userlist popup.
		<example>
		popup userlist{
		@tab@submenu(Control,<a href="s_icon.kvihelp">$icon</a>(internal)):{
		@tab@@tab@item(Op,<a href="s_icon.kvihelp">$icon</a>(op)): <a href="op.kvihelp">op</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@@tab@item(Deop,<a href="s_icon.kvihelp">$icon</a>(deop)): <a href="deop.kvihelp">deop</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@@tab@separator;
		@tab@@tab@item(Voice,<a href="s_icon.kvihelp">$icon</a>(voice)): <a href="voice.kvihelp">voice</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@@tab@item(Devoice,<a href="s_icon.kvihelp">$icon</a>(devoice)): <a href="devoice.kvihelp">devoice</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@@tab@item(Kick,<a href="s_icon.kvihelp">$icon</a>(kick)): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="kick.kvihelp">kick</a> <a href="s_window.kvihelp">$window</a> %tmp;
		@tab@@tab@item(Ban,<a href="s_icon.kvihelp">$icon</a>(ban)): <a href="ban.kvihelp">ban</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@@tab@item(Kick & Ban,<a href="s_icon.kvihelp">$icon</a>(quit)):{
		@tab@@tab@@tab@<a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>){
		@tab@@tab@@tab@@tab@<a href="ban.kvihelp">ban</a> %tmp
		@tab@@tab@@tab@@tab@<a href="kick.kvihelp">kick</a> <a href="s_chan.kvihelp">$chan</a> %tmp
		@tab@@tab@@tab@}
		@tab@@tab@}
		@tab@}
		@tab@submenu(Info,<a href="s_icon.kvihelp">$icon</a>(who)):{
		@tab@@tab@item(Whois): <a href="whois.kvihelp">whois</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@@tab@item(Whois with idle time): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="whois.kvihelp">whois</a> %tmp %tmp;
		@tab@@tab@item(Whowas): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="whowas.kvihelp">whowas</a> %tmp;
		@tab@@tab@item(Who): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="who.kvihelp">who</a> %tmp;
		@tab@@tab@item(Userlist entry): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="echo.kvihelp">echo</a> -i = <a href="s_icon.kvihelp">$icon</a>(whois) <a href="s_mask.kvihelp">$mask</a>(%tmp)
		@tab@@tab@item(Dns): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="dns.kvihelp">dns</a> <a href="s_selected.kvihelp">$selected</a>;
		@tab@}
		@tab@separator;
		@tab@submenu(Ctcp,<a href="s_icon.kvihelp">$icon</a>(ctcp_request)):{
		@tab@@tab@item(Ping,<a href="s_icon.kvihelp">$icon</a>(ping)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> PING;
		@tab@@tab@item(Version,<a href="s_icon.kvihelp">$icon</a>(kvirc)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> VERSION;
		@tab@@tab@item(Userinfo,<a href="s_icon.kvihelp">$icon</a>(who)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> USERINFO;
		@tab@@tab@item(Clientinfo,<a href="s_icon.kvihelp">$icon</a>(ctcp_request)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> CLIENTINFO;
		@tab@@tab@item(Time,<a href="s_icon.kvihelp">$icon</a>(time)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> TIME;
		@tab@@tab@item(Source,<a href="s_icon.kvihelp">$icon</a>(ctcp_reply)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> SOURCE;
		@tab@@tab@item(Finger,<a href="s_icon.kvihelp">$icon</a>(ctcp_error)):<a href="ctcp.kvihelp">ctcp</a> <a href="s_selected.kvihelp">$selected</a> FINGER;
		@tab@}
		@tab@submenu(Dcc):{
		@tab@@tab@item(Chat): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="dcc.kvihelp">dcc</a> chat %tmp;
		@tab@@tab@item(Send): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="dcc.kvihelp">dcc</a> send %tmp;
		@tab@@tab@item(Voice): <a href="foreach.kvihelp">foreach</a>(%tmp,<a href="s_selected.kvihelp">$selected</a>)<a href="dcc.kvihelp">dcc</a> voice %tmp;
		@tab@}
		@tab@separator;
		@tab@item(Query,<a href="s_icon.kvihelp">$icon</a>(own)): query <a href="s_selected.kvihelp">$selected</a>;
		}
		</example>
*/

bool KviUserParser::parseCmd_POPUP(KviCommand *c)
{
	// popup -a <popup_name> { <popup-code> }
	KviPopupMenu * target = 0;
	if(!extractSwitches(c))return false;
	bool bAppend = c->hasSwitch('a');

	const char *popup_name = c->m_ptr;

	if(kvi_strEqualNoLocaleCIN(c->m_ptr,"channel",7)){
		// Channel popup
		c->m_ptr += 7;
		target = g_pChannelPopup;
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"console",7)){
		// Console popup
		c->m_ptr += 7;
		target = g_pConsolePopup;
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"userlist",8)){
		// Userlist popup
		c->m_ptr += 8;
		target = g_pUserlistPopup;
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"notifylist",10)){
		// Notifylist popup
		c->m_ptr += 10;
		target = g_pNotifylistPopup;
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"query",5)){
		// Query popup
		c->m_ptr += 5;
		target = g_pQueryPopup;
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"dccchat",7)){
		// Dcc chat popup
		c->m_ptr += 7;
		target = g_pDccChatPopup;
	}
	c->skipSpace();

	if(!target)return c->setError(KVI_ERROR_UnknownPopup,"POPUP",popup_name); //unrecoverable
	if(target->m_bLocked)return c->setError(KVI_ERROR_PopupSelfModificationNotAllowed,"POPUP",popup_name); //unrecoverable

	KviPopupMenu * popup = new KviPopupMenu(0,"dummy_popup");

	if(bAppend)popup->copyFromPopup(target);

	if(!generatePopupFromBuffer(popup,c,bAppend)){
		delete popup;
		return false;
	}

	target->copyFromPopup(popup);

	delete popup;
	return true;
}


bool KviUserParser::skipPopup(KviCommand *c)
{
	// popup <popup_name> { <popup-code> }
//	c->m_ptr += 5;  // skip the 'popup' command
	if(!skipSwitches(c))return false;
	const char * popup_name = c->m_ptr;
	// get the popup name...
	if(kvi_strEqualNoLocaleCIN(c->m_ptr,"channel",7))c->m_ptr += 7;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"console",7))c->m_ptr += 7;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"userlist",8))c->m_ptr += 8;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"notifylist",10))c->m_ptr += 10;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"query",5))c->m_ptr += 5;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"dccchat",7))c->m_ptr += 7;
	else return c->setError(KVI_ERROR_UnknownPopup,"POPUP",popup_name); // unrecoverable
	c->skipSpace();
	if(!skipPopupBuffer(c))return false; // a command....untrue
	return true;
}

/*
#ifdef _KVI_DEBUG_CLASS_NAME_
	#warning "Unfinished UTOOLBAR HELP"
#endif
*/

/*
	@command: UTOOLBAR
	@short:
		Modifies user toolbar
	@syntax:
		utoolbar &lt;command&gt [(&lt;text&gt;[,icon[,statusbar]]) &lt;command&gt;]<br>
	@description:
		Modifies the user toolbar.<br>
		Possible commands for utoolbar are: <br>
		clear: clear the toolbar<br>
		update: update the toolbar (to see the changes)<br>
		separator: add a separator to the toolbar<br>
		button (&lt;text&gt;[,icon[,statusbar]]) &lt;command&gt;: add a button to the toolbar.<br>
		menu (&lt;text&gt;[,icon[,statusbar]]) &lt;popup-body&gt;: add a menu. See <a href="popup.kvihelp">POPUP</a> for details.<br>
	@examples:
		A toolbar with a normal button and a menu.
		<example>
		utoolbar clear;
		utoolbar button(button 1,1,Click here to see what button does) {
		@tab@echo -i=1 -w=$activewindow you clicked button 1;
		}
		utoolbar menu(menu 1,2,Click here to see what button does) {
		@tab@item(item 1,1) {
		@tab@@tab@-i=1 -w=$activewindow you clicked item 1 in menu 1;
		@tab@}
		@tab@item(item 2,2) {
		@tab@@tab@-i=2 -w=$activewindow you clicked item 2 in menu 1;
		@tab@}
		}
		utoolbar update;
		</example>
*/

bool KviUserParser::parseCmd_UTOOLBAR(KviCommand *c)
{
	c->skipSpace();

	if(kvi_strEqualNoLocaleCIN(c->m_ptr,"button",6)){
		c->m_ptr += 6;
		c->skipSpace();
		if(*(c->m_ptr) != '('){
			c->setError(KVI_ERROR_OpenParenthesisExpected,"TOOLBAR-BUTTON-LABEL",c->m_ptr);
			return false;
		}
		++c->m_ptr;
		KviStr buttonLabel;
		if(!processFncSingleParam(c,buttonLabel))return false;
		KviStr buttonImage;
		if(!processFncSingleParam(c,buttonImage))return false;
		KviStr buttonSbar;
		if(!processFncFinalPart(c,buttonSbar))return false;
		c->skipSpace();
		if(*(c->m_ptr) == ':'){ //Allowed but not required
			++c->m_ptr;
			c->skipSpace();
		}
		if(!(*(c->m_ptr)))return c->setError(KVI_ERROR_PopupItemCommandExpected,"TOOLBAR-BUTTON-LABEL");
		const char * aux = c->m_ptr;
		if(!skipCommand(c))return false;
		KviStr buffer(aux,c->m_ptr);
		if(buttonLabel.isEmpty())buttonLabel = "unnamed";
		g_pUserToolBarTemplate->insertNormalItem(buttonLabel.ptr(),buttonSbar.ptr(),buttonImage.ptr(),buffer.ptr());
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"separator",9)){
		c->m_ptr += 9;
		c->skipSpace();
		g_pUserToolBarTemplate->insertSeparatorItem();
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"clear",5)){
		c->m_ptr += 5;
		c->skipSpace();
		g_pUserToolBarTemplate->clearToolBar();
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"update",6)){
		c->m_ptr += 6;
		c->skipSpace();
		for(KviFrame *f = g_pApp->m_pFrameList->first();f;f= g_pApp->m_pFrameList->next()){
			f->updateUserToolBar();
		}
	} else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"menu",4)){
		c->m_ptr += 4;
		c->skipSpace();
		if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"TOOLBAR-BUTTON-LABEL",c->m_ptr);
		++c->m_ptr;
		KviStr buttonLabel;
		if(!processFncSingleParam(c,buttonLabel))return false;
		KviStr buttonImage;
		if(!processFncSingleParam(c,buttonImage))return false;
		KviStr buttonSbar;
		if(!processFncFinalPart(c,buttonSbar))return false;
		c->skipSpace();
		if(*(c->m_ptr) == ':'){ //Allowed but not required
			++c->m_ptr;
			c->skipSpace();
		}

		KviStr yourName(KviStr::Format,"utoolbar_script_popup_%s",buttonLabel.ptr());
		KviPopupMenu * popup = new KviPopupMenu(0,yourName.ptr());

		if(!generatePopupFromBuffer(popup,c,false)){
			delete popup;
			return false;
		}
		if(buttonLabel.isEmpty())buttonLabel = "unnamed";
		g_pUserToolBarTemplate->insertNormalItem(buttonLabel.ptr(),buttonSbar.ptr(),buttonImage.ptr(),0,popup);
		return true;
	}
	return true;
}

bool KviUserParser::skipUtoolbar(KviCommand *c)
{
	// utoolbar <command> [{ <code> }]
//	c->m_ptr += 8;  // skip the 'utoolbar' command
	c->skipWhitespace(); // whitespace allowed
	const char * ucommand = c->m_ptr;
	// get the popup name...
	if(kvi_strEqualNoLocaleCIN(c->m_ptr,"button",6)) {
		c->m_ptr += 6;
		c->skipWhitespace(); // whitespace allowed
		if(*(c->m_ptr) != '('){
			c->setError(KVI_ERROR_OpenParenthesisExpected,"UTOOLBAR - button",c->m_ptr);
			return false;
		}
		if(!skipExpressionBody(c))return false;
		c->skipWhitespace(); // whitespace allowed
		if(*(c->m_ptr) == ':'){ //Allowed but not required
			++c->m_ptr;
			c->skipSpace();
		}

		if(!skipCommand(c))return false;
	}
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"separator",9))c->m_ptr += 9;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"clear",5))c->m_ptr += 5;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"update",6))c->m_ptr += 6;
	else if(kvi_strEqualNoLocaleCIN(c->m_ptr,"menu",4)) {
		c->m_ptr += 4;
		c->skipWhitespace(); // whitespace allowed
		if(*(c->m_ptr) != '('){
			c->setError(KVI_ERROR_OpenParenthesisExpected,"UTOOLBAR - menu",c->m_ptr);
			return false;
		}
		if(!skipExpressionBody(c))return false;
		c->skipWhitespace(); // whitespace allowed
		if(*(c->m_ptr) == ':'){ //Allowed but not required
			++c->m_ptr;
			c->skipSpace();
		}

	if(!skipPopupBuffer(c))return false; // a command....untrue

	}
	else return c->setError(KVI_ERROR_UtoolbarCommandExpected,"UTOOLBAR",ucommand); // unrecoverable
	c->skipSpace();
	if(!skipCommand(c))return false;
	return true;
}

/*
#ifdef _KVI_DEBUG_CLASS_NAME_
	#warning "skip utoolbar ok ?"
#endif
*/

/*
	@command: IF
	@short:
		Executes commands conditionally
	@syntax:
		if (&lt;expression&gt;)&lt;command1&gt; [else &lt;command2&gt;]
	@description:
		Conditional command:<br>
		First the &lt;expression&gt; is evaluated; the expression<br>
		has the same syntax as used by <a href="s_calc.kvihelp">$calc()</a>:<br>
		so it can be either algebraic or boolean.<br>
		If the result of evaluation is non-zero, the &lt;command1&gt;<br>
		is executed, otherwise, if the 'else &lt;command2&gt;' part<br>
		is present, the &lt;command2&gt; is executed.<br>
		&lt;command1&gt; and &lt;command2&gt; can be either single commands<br>
		or command blocks.<br>
	@examples:
		Check if the number contained in<br>
		a variable is greater or equal than 1.<br>
		<example>
		%var = 1
		if(%var &gt;= 1)<a href="echo.kvihelp">echo</a> Yes!
		else <a href="echo.kvihelp">echo</a> No!
		</example>
		Check if the variable %var is set:<br>
		Unset variables are equvalent to empty strings.<br>
		<example>
		if("%var" == "")<a href="echo.kvihelp">echo</a> \%var is not set.
		else {
		@tab@<a href="echo.kvihelp">echo</a> \%var is set!
    	@tab@<a href="echo.kvihelp">echo</a> And it contains the string: %var.
		}
		</example>
		Complex expression.<br>
		Here we assuming that %var2 IS a number at all...<br>
		<example>
		if(("%var1" != "") && (%var2 &lt;= 2)){
    	@tab@<a href="echo.kvihelp">echo</a> \%var1 is not set
    	@tab@<a href="echo.kvihelp">echo</a> \%var2 is smaller or equal to 2.
		} else {
		@tab@<a href="echo.kvihelp">echo</a> \%var1 is set OR \%var2 is greater than 2!
		@tab@<a href="echo.kvihelp">echo</a> \%var1 contains the string %var1.
		@tab@<a href="echo.kvihelp">echo</a> \%var2 contains the number %var2.
		}
		</example>
		If %var2 is not a number, you will get a syntax error in the expression,
		something as:<br>
		Error in command: Unexpected character<br>
		Line            : 1 :if(("%var1" != "") && (%var2...<br>
		Logical location: EXPRESSION-OPERAND<br>
		Error spec.     : &lt;Contents of the variable %var 2&gt;
*/

bool KviUserParser::parseCmd_IF(KviCommand *c)
{
	// if(<expression>)<command>; else command;
	c->skipWhitespace(); // whitespace allowed
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"IF-CONDITION",c->m_ptr);
		return false;
	}
	++(c->m_ptr);

	long expValue;
	if(!evaluateExpr(c,&expValue))return false;

	c->skipWhitespace();
	if(expValue){
		// True...exec the first command block and skip the second one (if is there)
		if(*(c->m_ptr) == '{'){ if(!execCommandBlock(c))return false; }
		else { if(!execSingleCommand(c))return false; }

		c->skipWhitespace();
		if(kvi_strEqualNoLocaleCIN("else",c->m_ptr,4)){
			// skip the else part
			c->m_ptr+=4;
			c->skipWhitespace();
			if(!*c->m_ptr){
				c->setError(KVI_ERROR_MissingCommandAfterElse,"IF",c->m_ptr);
				return false;
			}
			if(!skipCommand(c))return false;
		}
	} else {
		// False...skip the first command block and exec the second one (if is there)
		if(!skipCommand(c))return false;
		c->skipWhitespace();
		if(kvi_strEqualNoLocaleCIN("else",c->m_ptr,4)){
			c->m_ptr+=4;
			c->skipWhitespace();
			if(*(c->m_ptr) == '{'){
				if(!execCommandBlock(c))return false;
				// Here c->m_ptr points to the char immediately after the closing brace
			} else {
				if(!execSingleCommand(c))return false;
				// Here c->m_ptr points to the char immediately after the separator...
			}			
		} else return true;
	}

	return true;
}

bool KviUserParser::skipIf(KviCommand *c)
{
	// skips the if command : "IF (<expression>) <command>[else <command&gt;]"
//	c->m_ptr+=2;
	c->skipWhitespace(); // whitespace allowed
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"IF-CONDITION",c->m_ptr);
		return false;
	}
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace(); // whitespace allowed
	if(!skipCommand(c))return false;
	c->skipWhitespace(); // whitespace allowed
	if(kvi_strEqualNoLocaleCIN("else",c->m_ptr,4)){
		c->m_ptr+=4;
		c->skipWhitespace();
		if(!skipCommand(c))return false;
	}
	return true;
}

/*
	@command: ECHOPRIVMSG
	@short:
		Outputs a privmsg to a KVIrc window
	@syntax:
		echoprivmsg [-w=&lt;window&gt;] [-i=&lt;icon_number&gt;] &lt;nickname&gt; &lt;mask&gt; [&lt;text&gt;]
	@description:
		Outputs the privmsg &lt;text&gt; from &lt;nickname&gt; to the specified &lt;window&gt;,
		or to the current window if the -w option is not given.<br>
		The -i switch allows selecting the color/icon scheme
		for the text to be printed ...experiment with it.<br>
		If the &lt;text&gt; is an empty string, this command does nothing.<br>
		The view widgets support a html-like links on the you can
		double-click to perform an action.<br>
		&lt;nickname&gt; is the nickname of the talking user, the &lt;mask&gt; is the
		remaining part of his mask (user@host).<br>
		This command is useful when overriding the builtin OnChannelMessage echo.<br>
		<br>
		Extended functionality:<br>
		<br>
		These are activated by special escape sequences:<br>
		<b>&lt;CR&gt;!&lt;command_data&gt;&lt;CR&gt;&lt;link_text&gt;</b><br>
		&lt;CR&gt; is a carriage return character ; you will need the [fnc]$cr[/fnc]
		identifier for inserting that.<br>
		&lt;command_data&gt; is a string containing the commands
		to be executed when &lt;link_text&gt; is
		double-clicked or right clicked.<br>
		The syntax of the &lt;command_data&gt; string is:<br>
		<b>&lt;command_data&gt; = &lt;command&gt;</b><br> or
		<b>&lt;command_data&gt; = [dbl]&lt;command&gt;[rbt]&lt;command&gt;<br>
		In the first form the &lt;command&gt; is executed when the &lt;link_text&gt;
		is double clicked.<br>In the second form the &lt;command&gt; after [dbl]
		is the double-click command, and the &lt;command&gt; after [rbt] is
		executed when the &lt;link_text&gt; is right-clicked.<br>
		In &lt;command&gt; you can use the $N positional parameters to indicate
		the n-th word in &lt;link_text&gt;.<br>
		<br>
		Note:<br>
		<br>
		The carriage return character is used to avoid remote users
		to use these escape sequences: the line feeds and carriage returns
		are implicitly "eaten" by the IRC (and DCC) transmission protocol, so you
		will never receive them from a remote source.<br>
		The use of the [fnc]$cr[/fnc] identifier may require you to use the
		escape backslash in many circumstances.<br>
*/

bool KviUserParser::parseCmd_ECHOPRIVMSG(KviCommand *c)
{
	// echoprivmsg [-w=<window&gt;] [-i=<icon_number&gt;] <text>
	if(!extractSwitches(c))return false;
	KviWindow * wnd = c->m_wnd;
	int icon = KVI_OUT_ECHO;
	if(c->hasSwitch('w')){
		KviStr tmp;
		if(!c->getSwitchValue('w',tmp)){
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingWindowName,"ECHOPRIVMSG",__tr("-w switch"));
			else c->warning(__tr("ECHOPRIVMSG: Missing window name in the -w switch (WARNING: The syntax has changed; you must use echo -w=window) : Using default window"));
		} else {
			wnd = m_pFrm->findWindow(tmp.ptr());
			if(!wnd){
				if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_WindowNotFound,"ECHOPRIVMSG",tmp.ptr());
				else c->warning(__tr("ECHOPRIVMSG: Window '%s' not found : Using default window"),tmp.ptr());
				wnd = c->m_wnd;
			}
		}
	}
	if(c->hasSwitch('i')){
		KviStr tmp;
		c->getSwitchValue('i',tmp);
		bool bOk;
		icon = tmp.toInt(&bOk) % KVI_OUT_NUM_IMAGES;
		if(!bOk){
			// Invalid -i option...
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingIconNumber,"ECHOPRIVMSG",__tr("-i option"));
			else {
				c->warning(__tr("ECHOPRIVMSG: Missing icon number : Defaulting to %d"),KVI_OUT_ECHO);
				icon = KVI_OUT_ECHO;
			}
		}
		// make sure that we not segfault...
		if(icon < 0)icon = -icon;
		if((icon > KVI_OUT_NUM_IMAGES))icon = KVI_OUT_ECHO;	
	}
	KviStr talker;
	KviStr talker_mask;
	if(!processCmdSingleToken(c))return false;
	talker = c->m_buffer;
	if(talker.isEmpty())return c->setError(KVI_ERROR_MissingParameter,"ECHOPRIVMSG");
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	talker_mask = c->m_buffer;
	if(talker_mask.isEmpty())return c->setError(KVI_ERROR_MissingParameter,"ECHOPRIVMSG");
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	m_pFrm->outputPrivmsg(wnd,icon,talker.ptr(),talker_mask.ptr(),c->m_buffer.ptr());
	return true;
}

/*
	@command: ECHO
	@short:
		Outputs text to a KVIrc window
	@syntax:
		echo [-w=<window&gt;] [-i=<icon_number&gt;] &lt;text&gt;
	@description:
		Outputs &lt;text&gt; to the specified &lt;window&gt;,
		or to the current window if the -w option is not given.<br>
		The -i switch allows selecting the color/icon scheme
		for the text to be printed ...experiment with it.<br>
		If the &lt;text&gt; is an empty string, this command does nothing.<br>
		The view widgets support a html-like links on the you can
		double-click to perform an action.<br>
		<br>
		Extended functionality:<br>
		<br>
		These are activated by special escape sequences:<br>
		<b>&lt;CR&gt;!&lt;command_data&gt;&lt;CR&gt;&lt;link_text&gt;</b><br>
		&lt;CR&gt; is a carriage return character ; you will need the [fnc]$cr[/fnc]
		identifier for inserting that.<br>
		&lt;command_data&gt; is a string containing the commands
		to be executed when &lt;link_text&gt; is
		double-clicked or right clicked.<br>
		The syntax of the &lt;command_data&gt; string is:<br>
		<b>&lt;command_data&gt; = &lt;command&gt;</b><br> or
		<b>&lt;command_data&gt; = [dbl]&lt;command&gt;[rbt]&lt;command&gt;<br>
		In the first form the &lt;command&gt; is executed when the &lt;link_text&gt;
		is double clicked.<br>In the second form the &lt;command&gt; after [dbl]
		is the double-click command, and the &lt;command&gt; after [rbt] is
		executed when the &lt;link_text&gt; is right-clicked.<br>
		In &lt;command&gt; you can use the $N positional parameters to indicate
		the n-th word in &lt;link_text&gt;.<br>
		<br>
		Note:<br>
		<br>
		The carriage return character is used to avoid remote users
		to use these escape sequences: the line feeds and carriage returns
		are implicitly "eaten" by the IRC (and DCC) transmission protocol, so you
		will never receive them from a remote source.<br>
		The use of the [fnc]$cr[/fnc] identifier may require you to use the
		escape backslash in many circumstances.<br>
	@examples:
		<example>
		echo Hello! This is my first echo test!
		echo -w = <a href="s_console.kvihelp">$console</a> This text is printed on the console.
		echo -w = <a href="s_window.kvihelp">$window</a> This text goes to the current window: <a href="s_window.kvihelp">$window</a>
		echo -i = 3 This text uses a funky color and icon.
		echo -w = <a href="s_window.kvihelp">$window</a> -i <a href="s_strlen.kvihelp">$strlen(YES)</a> Nearly same as above.
		echo \-This is a string that starts with a '-'
		echo -i = [fnc]$icon[/fnc](who) WHOIS This man ?
		echo Double click [fnc]$cr[/fnc]!echo Hey, you have clicked the link \"$1\"[fnc]$cr[/fnc]\me[fnc]$cr[/fnc]
		echo [fnc]$cr[/fnc]![cmd]whois[/cmd] $1[fnc]$cr[/fnc]\Pragma[fnc]$cr[/fnc] has joined channel #kvirc
		echo [fnc]$cr[/fnc]![dbl][cmd]whois[/cmd] $1[rbt]mypopupalias $1[fnc]$cr[/fnc]\Pragma[fnc]$cr[/fnc] has joined channel #kvirc
		</example>
*/

bool KviUserParser::parseCmd_ECHO(KviCommand *c)
{
	// echo [-w=<window&gt;] [-i=<icon_number&gt;] <text>
	if(!extractSwitches(c))return false;
	KviWindow * wnd = c->m_wnd;
	int icon = KVI_OUT_ECHO;
	if(!processCmdFinalPart(c))return false;
	if(c->hasSwitch('w')){
		KviStr tmp;
		if(!c->getSwitchValue('w',tmp)){
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingWindowName,"ECHO",__tr("-w switch"));
			else c->warning(__tr("ECHO: Missing window name in the -w switch (WARNING! The syntax has changed; you must use echo -w=window) : Using default window"));
		} else {
			wnd = m_pFrm->findWindow(tmp.ptr());
			if(!wnd){
				if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_WindowNotFound,"ECHO",tmp.ptr());
				else c->warning(__tr("ECHO: Window '%s' not found : Using default window"),tmp.ptr());
				wnd = c->m_wnd;
			}
		}
	}
	if(c->hasSwitch('i')){
		KviStr tmp;
		c->getSwitchValue('i',tmp);
		bool bOk;
		icon = tmp.toInt(&bOk) % KVI_OUT_NUM_IMAGES;
		if(!bOk){
			// Invalid -i option...
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingIconNumber,"ECHO",__tr("-i option"));
			else {
				c->warning(__tr("ECHO: Missing icon number : Defaulting to %d"),KVI_OUT_ECHO);
				icon = KVI_OUT_ECHO;
			}
		}
		// make sure that we not segfault...
		if(icon < 0)icon = -icon;
		if((icon > KVI_OUT_NUM_IMAGES))icon = KVI_OUT_ECHO;	
	}
	wnd->outputNoFmt(icon,c->m_buffer.ptr());
	return true;
}

/*
	@command: SAY
	@short:
		"Types" text in a KVIrc window.
	@syntax:
		say [-c] &lt;window&gt; &lt;text&gt;
	@description:
		Simulates entering text in the input box of a KVIrc &lt;window&gt;.<br>
		The only limitation to this command is that you cannot directly execute commands.<br>
		Nothing you 'say' to a window is interpreted as a command; text:<br>
		&nbsp;in the console is sent to the server as raw data,<br>
		&nbsp;in channel windows is sent to the server as channel text,<br>
		&nbsp;in query windows is sent to the server as query text,<br>
		&nbsp;in DCC chats is sent to the remote side,<br>
		&nbsp;in other windows is just ignored.<br>
		Multiline text is processed correctly.
		<docsubtitle>Note</docsubtitle>
		The -c switch allows executing commands.<br>
		Please use it with care. :)<br>
	@examples:
		<example>
		say <a href="s_window.kvihelp">$window</a> This text goes to the window <a href="s_window.kvihelp">$window</a>
		</example>
*/

bool KviUserParser::parseCmd_SAY(KviCommand *c)
{
	// SAY [-c] window <text>

	if(!extractSwitches(c))return false;
	bool allowCommand = c->hasSwitch('c');

	if(!processCmdFinalPart(c))return false;
	KviStr target;

	c->m_buffer.getToken(target,' ');
	if(target.isEmpty())return c->setError(KVI_ERROR_MissingTarget,"SAY");

	KviWindow *wnd = m_pFrm->findWindow(target.ptr());
	if(!wnd)return c->setError(KVI_ERROR_WindowNotFound,"SAY",target.ptr());

	KviStr tmp;
	while(c->m_buffer.getLine(tmp)){
		// Do not allow to execute commands
		if(!allowCommand)
		if((*(tmp.ptr())=='/')||(*(tmp.ptr())==g_pOptions->m_cPersonalCommandPrefix))tmp.prepend("\\");
		parseUserCommand(tmp,wnd);
	}

	return true;
}

/*
	@command: STATUS
	@short:
		Sets the statusbar text
	@syntax:
		status [-t=&lt;timeout&gt;] &lt;text&gt;
	@description:
		Sets the statusbar text to &lt;text&gt; replacing any previous one.<br>
		If the -t flag is specified, the text is cleared after &lt;timeout&gt;
		milliseconds.
	@examples:
		<example>
		status -t 1000 This text is displayed for one second.
		</example>
*/

bool KviUserParser::parseCmd_STATUS(KviCommand *c)
{
	// STATUS [-t=<timeout_in_msecs&gt;] <text>
	// If timeout<=0 there is no timeout at all.
	// No -t option = no timeout
	if(!extractSwitches(c))return false;
	int tmout = 0;
	if(c->hasSwitch('t')){
		c->getSwitchValue('t',c->m_buffer);
		bool bOk= false;
		tmout = c->m_buffer.toInt(&bOk);
		if(!bOk || tmout < 0){
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingTimeout,"STATUS");
			else c->warning(__tr("STATUS: Missing timeout : Assuming permanent text"));
			tmout = 0;
		}
		c->clearBuffer();
	}
	c->m_buffer = "";
	if(!processCmdFinalPart(c))return false;
	m_pFrm->m_pStatusBar->tempText(c->m_buffer.ptr(),tmout);
	return true;
}

/*
	@command: MSG
	@short:
		Sends a PRIVMSG
	@syntax:
		msg [-s] &lt;target&gt[,&lt;target&gt;[...]] &lt;text&gt;
	@description:
		Sends a PRIVMSG to the specified &lt;target(s)&gt;.<br>
		This command just splits the parameters and sends
		a correctly formatted PRIVMSG to the server.<br>
		It will work correctly for both nickname and channel targets.<br>
		For many servers, it is possible to use this function to
		send a PRIVMSG only to ops on a channel (using a special
		syntax for &lt;target&gt;, something like @#channel).<br>
		If the -s switch is used, the command does not output anything
		to KVIrc windows; the PRIVMSG is silently sent.
	@examples:
		<example>
		msg Pragma,#kvirc Hello!
		</example>
	@seealso:
		<a href="ame.kvihelp">AME</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="notice.kvihelp">NOTICE</a>,
		<a href="me.kvihelp">ME</a>,
		<a href="anotice.kvihelp">ANOTICE</a>
*/


bool KviUserParser::parseCmd_MSG(KviCommand *c)
{
	// MSG [-s] <target(or list of targets)> <text>
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');

	KviStr target;
	if(!processCmdFinalPart(c))return false;

	c->m_buffer.getToken(target,' ');

	if(target.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"MSG");

	// the buffer may be also empty (empty privmsg is valid)
	if(!m_pSocket->sendFmtData("PRIVMSG %s :%s",target.ptr(),c->m_buffer.ptr()))return notConnectedToServer(c,"MSG");

	if(bSilent)return true;

	KviWindow *wnd = m_pFrm->findWindow(target.ptr());

	if(wnd){
		if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
			m_pFrm->outputPrivmsg(wnd,KVI_OUT_OWN,m_pFrm->m_global.szCurrentNick.ptr(),
				m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
			return true;
		}
	}

	c->m_wnd->output(KVI_OUT_PRIVMSG,">>> %s: %s",target.ptr(),c->m_buffer.ptr());
	return true;
}



/*
	@command: AMSG
	@short:
		Sends a PRIVMSG to all channels and queries
	@syntax:
		amsg [-s] [-m] &lt;text&gt;
	@description:
		Sends a PRIVMSG to all open channels and queries.<br>
		If the -s switch is used, the command does not output anything
		to KVIrc windows; the PRIVMSG is silently sent.<br>
		Normally, all of the messages are sent in a single PRIVMSG
		with many targets, but as some servers may have a limit
		on the number of targets supported, you can force KVIrc
		to send a single PRIVMSG for each target by using the -m switch.
	@examples:
		<example>
		amsg Going down to the store...BRB!
		</example>
	@seealso:
		<a href="ame.kvihelp">AME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="notice.kvihelp">NOTICE</a>,
		<a href="me.kvihelp">ME</a>,
		<a href="anotice.kvihelp">ANOTICE</a>
*/

bool KviUserParser::parseCmd_AMSG(KviCommand *c)
{
	// AMSG [-s] [-m] <text>
	if(!extractSwitches(c))return false;

	bool bSilent = c->hasSwitch('s');
	bool bMultiple =c->hasSwitch('m');

	if(!processCmdFinalPart(c))return false;

	if(bMultiple){
		// One message for each target
		for(KviWindow *wnd =m_pFrm->m_pWinList->first();wnd;wnd=m_pFrm->m_pWinList->next()){
			// the buffer may be also empty (empty privmsg is valid)
			if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
				if(!m_pSocket->sendFmtData("PRIVMSG %s :%s",wnd->caption(),c->m_buffer.ptr()))return notConnectedToServer(c,"AMSG");
				if(!bSilent)m_pFrm->outputPrivmsg(wnd,KVI_OUT_OWN,m_pFrm->m_global.szCurrentNick.ptr(),
								m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
			}
		}
	} else {
		// Single message for all targets
		KviStr targets;
		for(KviWindow *wnd =m_pFrm->m_pWinList->first();wnd;wnd=m_pFrm->m_pWinList->next()){
			if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
				if(targets.hasData())targets.append(',');
				targets.append(wnd->caption());
				if(!bSilent)m_pFrm->outputPrivmsg(wnd,KVI_OUT_OWN,m_pFrm->m_global.szCurrentNick.ptr(),
								m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
			}
		}
		if(targets.isEmpty())return true;
		if(!m_pSocket->sendFmtData("PRIVMSG %s :%s",targets.ptr(),c->m_buffer.ptr()))return notConnectedToServer(c,"AMSG");
	}

	return true;
}

/*
	@command: NOTICE
	@short:
		Sends a NOTICE
	@syntax:
		notice [-s] &lt;target&gt[,&lt;target&gt;[...]] &lt;text&gt;
	@description:
		Sends a NOTICE to the specified &lt;target(s)&gt;.<br>
		This command just splits the parameters and sends
		a correctly formatted NOTICE to the server.<br>
		It will work correctly for nickname and channel targets.<br>
		For many servers, it is possible to use this function to
		send a NOTICE only to ops on a channel. See <a href="onotice.kvihelp">ONOTICE</a>.<br>
		If the -s switch is used, the command does not output anything
		to KVIrc windows; the NOTICE is silently sent.
	@examples:
		<example>
		notice Pragma,#kvirc Hello!
		</example>
	@seealso:
		<a href="ame.kvihelp">AME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="me.kvihelp">ME</a>,
		<a href="anotice.kvihelp">ANOTICE</a>
		<a href="onotice.kvihelp">ONOTICE</a>
*/

bool KviUserParser::parseCmd_NOTICE(KviCommand *c)
{
	// NOTICE [-s] <target(or list of targets)> <text>
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');

	KviStr target;

	if(!processCmdFinalPart(c))return false;
	c->m_buffer.getToken(target,' ');

	if(target.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"NOTICE");

	// the buffer may be also empty (empty privmsg is valid)
	if(!m_pSocket->sendFmtData("NOTICE %s :%s",target.ptr(),c->m_buffer.ptr()))return notConnectedToServer(c,"NOTICE");

	if(bSilent)return true;

	KviWindow *wnd = m_pFrm->findWindow(target.ptr());

	if(wnd){
		if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
			m_pFrm->outputPrivmsg(wnd,KVI_OUT_NOTICE,m_pFrm->m_global.szCurrentNick.ptr(),
				m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
			return true;
		}
	}

	c->m_wnd->output(KVI_OUT_NOTICE,">>> %s: %s",target.ptr(),c->m_buffer.ptr());
	return true;
}

/*
	@command: ANOTICE
	@short:
		Sends a NOTICE to all channels and queries
	@syntax:
		anotice [-s] [-m] &lt;text&gt;
	@description:
		Sends a NOTICE to all open channels and queries.<br>
		If the -s switch is used, the command does not output anything
		to the KVIrc windows; the NOTICE is silently sent.<br>
		Normally, all of the messages are sent in a single NOTICE
		with many targets, but as some servers may have a limit
		on the number of targets supported, you can force KVIrc
		to send a single NOTICE for each target by using the -m switch.
	@examples:
		<example>
		anotice Going down to the store...BBL!
		</example>
	@seealso:
		<a href="ame.kvihelp">AME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="me.kvihelp">ME</a>,
		<a href="notice.kvihelp">NOTICE</a>
*/

bool KviUserParser::parseCmd_ANOTICE(KviCommand *c)
{
	// ANOTICE [-s] [-m] <text>
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');
	bool bMultiple = c->hasSwitch('m');

	if(!processCmdFinalPart(c))return false;

	if(bMultiple){
		// One message for each target
		for(KviWindow *wnd =m_pFrm->m_pWinList->first();wnd;wnd=m_pFrm->m_pWinList->next()){
			// the buffer may be also empty (empty privmsg is valid)
			if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
				if(!m_pSocket->sendFmtData("NOTICE %s :%s",wnd->caption(),c->m_buffer.ptr()))return notConnectedToServer(c,"ANOTICE");
				if(!bSilent)m_pFrm->outputPrivmsg(wnd,KVI_OUT_NOTICE,m_pFrm->m_global.szCurrentNick.ptr(),
								m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
			}
		}
	} else {
		// Single message for all targets
		KviStr targets;
		for(KviWindow *wnd =m_pFrm->m_pWinList->first();wnd;wnd=m_pFrm->m_pWinList->next()){
			if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
				if(targets.hasData())targets.append(',');
				targets.append(wnd->caption());
				if(!bSilent)m_pFrm->outputPrivmsg(wnd,KVI_OUT_NOTICE,m_pFrm->m_global.szCurrentNick.ptr(),
								m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
			}
		}
		if(targets.isEmpty())return true;
		if(!m_pSocket->sendFmtData("NOTICE %s :%s",targets.ptr(),c->m_buffer.ptr()))notConnectedToServer(c,"ANOTICE");
	}

	return true;
}

/*
	@command: ONOTICE
	@short:
		Sends a NOTICE to all operators on a channel
	@syntax:
		onotice [-s] &lt;text&gt;
	@description:
		Sends a NOTICE to all channel operators on the current channel.<br>
		If the -s switch is used, the command does not output anything
		to the KVIrc window; the NOTICE is silently sent.
	@examples:
		<example>
		onotice Should we ban this idiot?
		</example>
	@seealso:
		<a href="ame.kvihelp">AME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="me.kvihelp">ME</a>,
		<a href="notice.kvihelp">NOTICE</a>
*/

bool KviUserParser::parseCmd_ONOTICE(KviCommand *c)
{
	// ONOTICE [-s] <target(or list of targets)> <text>
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');

	if(!processCmdFinalPart(c))return false;
	if(c->m_wnd->type() == KVI_WND_TYPE_CHANNEL){
		if(!m_pSocket->sendFmtData("NOTICE %s :%s",c->m_wnd->caption(),c->m_buffer.ptr()))return notConnectedToServer(c,"ONOTICE");
		if(bSilent)return true;
		m_pFrm->outputPrivmsg(c->m_wnd,KVI_OUT_ONOTICE,m_pFrm->m_global.szCurrentNick.ptr(),
			m_pFrm->m_global.szCurrentMaskFromServer.ptr(),c->m_buffer.ptr());
		return true;
	} else return recoverableError(c,KVI_ERROR_ThisIsNotAChannel,"ONOTICE");
}

/*
	@command: ME
	@short:
		Describes an action
	@syntax:
		me &lt;text&gt;
	@description:
		Sends a CTCP ACTION to the current channel, query or DCC chat.<br>
		The CTCP ACTION is used to describe an action or state and appears
		to the other users in the following form:<br>
		&lt;sender_nickname&gt; &lt;text&gt;.
		Equivalent to <a href="me.kvihelp">ME</a>.
	@examples:
		<example>
		me is Hungry!
		</example>
	@seealso:
		<a href="action.kvihelp">ACTION</a>
		<a href="ame.kvihelp">AME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="notice.kvihelp">NOTICE</a>,
		<a href="anotice.kvihelp">ANOTICE</a>,
		<a href="ctcp.kvihelp">CTCP</a>
*/

/*
	@command: ACTION
	@short:
		Describes an action
	@syntax:
		action &lt;text&gt;
	@description:
		Sends a CTCP ACTION to the current channel, query or DCC chat.<br>
		The CTCP ACTION is used to describe an action or state and appears
		to the other users in the following form:<br>
		&lt;sender_nickname&gt; &lt;text&gt;.<br>
		Equivalent to <a href="me.kvihelp">ME</a>.
	@examples:
		<example>
		action is Hungry!
		</example>
	@seealso:
		<a href="me.kvihelp">ME</a>,
		<a href="ame.kvihelp">AME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="notice.kvihelp">NOTICE</a>,
		<a href="anotice.kvihelp">ANOTICE</a>,
		<a href="ctcp.kvihelp">CTCP</a>
*/

bool KviUserParser::parseCmd_ME(KviCommand *c)
{
	// /me ...text
	if(!processCmdFinalPart(c))return false;
	if((c->m_wnd->type() == KVI_WND_TYPE_CHANNEL) || (c->m_wnd->type() == KVI_WND_TYPE_QUERY)){
		if(!m_pSocket->sendFmtData("PRIVMSG %s :%cACTION %s%c",c->m_wnd->caption(),0x01,c->m_buffer.ptr(),0x01))return notConnectedToServer(c,"ME");
		c->m_wnd->output(KVI_OUT_ACTION,"\r!%s\r%s\r %s",g_pOptions->m_szPrivmsgFormatNickLinkCommand.ptr(),m_pFrm->m_global.szCurrentNick.ptr(),c->m_buffer.ptr());
		return true;
	}
	if(c->m_wnd->type() == KVI_WND_TYPE_CHAT){
		KviStr tmp(KviStr::Format,"%cACTION %s%c",0x01,c->m_buffer.ptr(),0x01);
		if(((KviDccChat *)(c->m_wnd))->sendData(tmp.ptr())){
			c->m_wnd->output(KVI_OUT_ACTION,"%s %s",m_pFrm->m_global.szCurrentNick.ptr(),c->m_buffer.ptr());
		} else c->m_wnd->output(KVI_OUT_ERROR,__tr("Cannot send data: No connection")); //Don't block here
		return true;
	}
	return recoverableError(c,KVI_ERROR_ThisIsNotAQueryNorChannel,"ACTION");
}

/*
	@command: AME
	@short:
		Describes an action to all channels, queries and DCC chats.
	@syntax:
		ame &lt;text&gt;
	@description:
		Sends a CTCP ACTION to all channels, queries and DCC chats.<br>
		The CTCP ACTION is used to describe an action or state and appears
		to the other users in the following form:<br>
		&lt;sender_nickname&gt; &lt;text&gt;
	@examples:
		<example>
		ame is Hungry!
		</example>
	@seealso:
		<a href="me.kvihelp">ME</a>,
		<a href="msg.kvihelp">MSG</a>,
		<a href="amsg.kvihelp">AMSG</a>,
		<a href="notice.kvihelp">NOTICE</a>,
		<a href="anotice.kvihelp">ANOTICE</a>,
		<a href="ctcp.kvihelp">CTCP</a>
*/

bool KviUserParser::parseCmd_AME(KviCommand *c)
{
	// /ame ...text
	if(!processCmdFinalPart(c))return false;
	for(KviWindow *wnd = m_pFrm->m_pWinList->first();wnd;wnd=m_pFrm->m_pWinList->next()){
		if((wnd->type() == KVI_WND_TYPE_CHANNEL) || (wnd->type() == KVI_WND_TYPE_QUERY)){
			if(!m_pSocket->sendFmtData("PRIVMSG %s :%cACTION %s%c",wnd->caption(),0x01,c->m_buffer.ptr(),0x01))return notConnectedToServer(c,"AME");
			wnd->output(KVI_OUT_ACTION,"\r!%s\r%s\r %s",g_pOptions->m_szPrivmsgFormatNickLinkCommand.ptr(),m_pFrm->m_global.szCurrentNick.ptr(),c->m_buffer.ptr());
		} else {
			if(wnd->type() == KVI_WND_TYPE_CHAT){
				KviStr tmp(KviStr::Format,"%cACTION %s%c",0x01,c->m_buffer.ptr(),0x01);
				if(((KviDccChat *)(wnd))->sendData(tmp.ptr())){
					wnd->output(KVI_OUT_ACTION,"%s %s",m_pFrm->m_global.szCurrentNick.ptr(),c->m_buffer.ptr());
				} else wnd->output(KVI_OUT_ERROR,__tr("Cannot send data: No connection"));
			}
		}
	}
	return true;
}

/*
	@command: HELPOP
	@short:
		Requests help for server commands or sends a help request*
	@syntax:
		helpop [&lt;item&gt;]
	@description:
		Requests help on &lt;item&gt;, or sends a help request to all help operators
		if &lt;item&gt; is unrecognized.
		* The HELPOP command may not be available on all servers.
	@examples:
		<example>
		helpop ?umodes
		helpop I need help!
		</example>
	@seealso:
		<a href="locops.kvihelp">LOCOPS</a>
		<a href="globops.kvihelp">GLOBOPS</a>
		<a href="wallops.kvihelp">WALLOPS</a>
*/

bool KviUserParser::parseCmd_HELPOP(KviCommand *c)
{
	// the buffer may be also empty (empty privmsg is valid)
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->sendFmtData("HELPOP :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"HELPOP");
	return true;
}

/* Oper commands */

/*
	@command: LOCOPS
	@short:
		Sends a message to local operators
	@syntax:
		locops &lt;message&gt;
	@description:
		Sends a message to all local IRC operators on the network.<br>
		* This command requires operator privileges.
	@examples:
		<example>
		locops Yawn...
		</example>
	@seealso:
		<a href="helpop.kvihelp">HELPOP</a>
		<a href="globops.kvihelp">GLOBOPS</a>
		<a href="wallops.kvihelp">WALLOPS</a>
*/

bool KviUserParser::parseCmd_LOCOPS(KviCommand *c)
{
	// the buffer may be also empty (empty privmsg is valid)
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->sendFmtData("LOCOPS :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"LOCOPS");
	return true;
}

/*
	@command: GLOBOPS
	@short:
		Sends a message to global operators
	@syntax:
		locops &lt;message&gt;
	@description:
		Sends a message to all global IRC operators on the network.<br>
		* This command requires operator privileges.
	@examples:
		<example>
		globops Wake up, lazy arses...
		</example>
	@seealso:
		<a href="helpop.kvihelp">HELPOP</a>
		<a href="locops.kvihelp">LOCOPS</a>
		<a href="wallops.kvihelp">WALLOPS</a>
*/

bool KviUserParser::parseCmd_GLOBOPS(KviCommand *c)
{
	// the buffer may be also empty (empty privmsg is valid)
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->sendFmtData("GLOBOPS :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"GLOBOPS");
	return true;
}

/*
	@command: WALLOPS
	@short:
		Sends a message to all IRC operators
	@syntax:
		wallops &lt;message&gt;
	@description:
		Sends a message to all IRC operators on the network.<br>
		* This command requires operator privileges.
	@examples:
		<example>
		wallops server going down for upgrade, brb
		</example>
	@seealso:
		<a href="helpop.kvihelp">HELPOP</a>
		<a href="locops.kvihelp">LOCOPS</a>
		<a href="globops.kvihelp">GLOBOPS</a>
*/

bool KviUserParser::parseCmd_WALLOPS(KviCommand *c)
{
	// the buffer may be also empty (empty privmsg is valid)
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->sendFmtData("WALLOPS :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"WALLOPS");
	return true;
}

/*
	@command: KILL
	@short:
		Removes a user from the network
	@syntax:
		kill &lt;user&gt; &lt;reason&gt;
	@description:
		Requests to disconnect a user from the network.<br>
		* This command requires operator privileges.<br>
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		kill pragma stop it!
		</example>
	@seealso:
		<a href="oper.kvihelp">OPER</a>
*/

bool KviUserParser::parseCmd_KILL(KviCommand *c)
{
	if(!processCmdSingleToken(c))return false;
	KviStr target = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	bool bSent;
	if(c->m_buffer.hasData())bSent = m_pSocket->sendFmtData("KILL %s :%s",target.ptr(),c->m_buffer.ptr());
	else bSent = m_pSocket->sendFmtData("KILL %s",target.ptr());
	if(!bSent)return notConnectedToServer(c,"KILL");
	return true;
}

/*
	@command: OPER
	@short:
		Requests operator privileges
	@syntax:
		oper &lt;user&gt; &lt;password&gt;
	@description:
		Sends an OPER message to the server to obtain IRC operator privileges.<br>
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.<br>
	@examples:
		<example>
		oper pragma mypass
		</example>
	@seealso:
		<a href="kill.kvihelp">KILL</a>
		<a href="rehash.kvihelp">REHASH</a>
*/

bool KviUserParser::parseCmd_OPER(KviCommand *c)
{
	if(!processCmdSingleToken(c))return false;
	KviStr target = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	bool bSent;
	if(c->m_buffer.hasData())bSent = m_pSocket->sendFmtData("OPER %s :%s",target.ptr(),c->m_buffer.ptr());
	else bSent = m_pSocket->sendFmtData("OPER %s",target.ptr());
	if(!bSent)return notConnectedToServer(c,"OPER");
	return true;
}

/*
	@command: SETHOST
	@short:
		Changes virtual hostname*
	@syntax:
		sethost &lt;hostname&gt;
	@description:
		Sets your current hostname to <hostname>.<br>
		* This command requires operator privileges.<br>
		* The SETHOST command may not be available on all servers.
	@examples:
		<example>
		sethost irc.fema.gov
		</example>
	@seealso:
		<a href="oper.kvihelp">OPER</a>
*/

bool KviUserParser::parseCmd_SETHOST(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingHostname,"SETHOST");
	if(!m_pSocket->sendFmtData("SETHOST %s",c->m_buffer.ptr()))return notConnectedToServer(c,"SETHOST");
	return true;
}

/*
	@command: REHASH
	@short:
		Reloads server configuration
	@syntax:
		rehash [&lt;server_mask&gt;]
	@description:
		Causes the server to reload its configuration from file.<br>
		* This command requires operator privileges.
	@examples:
		<example>
		rehash pounamu.quasar.net.nz
		</example>
	@seealso:
		<a href="oper.kvihelp">OPER</a>
*/

bool KviUserParser::parseCmd_REHASH(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "REHASH";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"REHASH");
	return true;
}

/* !Oper commands */
/* Services commands */

/*
	@command: NICKSERV
	@short:
		Sends a command to nickname service (NickServ)*
	@syntax:
		nickserv &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Sends a command to the network's nickname service.<br>
		* The NICKSERV command may not be supported by all servers.
	@examples:
		<example>
		nickserv help
		nickserv set kill on
		</example>
	@seealso:
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

/*
	@command: NS
	@short:
		Sends a command to nickname service (NickServ)*
	@syntax:
		ns &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Built-in alias for <a href="nickserv.kvihelp">NICKSERV</a>.<br>
		* The NICKSERV command may not be supported by all servers.
	@examples:
		<example>
		ns help
		</example>
	@seealso:
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

bool KviUserParser::parseCmd_NICKSERV(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingServicesCommand,"NICKSERV");

	if(!m_pSocket->sendFmtData("NICKSERV :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"NICKSERV");
	return true;
}

/*
	@command: CHANSERV
	@short:
		Sends a command to channel service (ChanServ)*
	@syntax:
		chanserv &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Sends a command to the network's channel service.<br>
		* The CHANSERV command may not be supported by all servers.
	@examples:
		<example>
		chanserv help
		chanserv info #kvirc
		</example>
	@seealso:
		<a href="cs.kvihelp">CS</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

/*
	@command: CS
	@short:
		Sends a command to channel service (ChanServ)*
	@syntax:
		cs &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Built-in alias for <a href="chanserv.kvihelp">CHANSERV</a>.<br>
		* The CHANSERV command may not be supported by all servers.
	@examples:
		<example>
		cs help
		</example>
	@seealso:
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

bool KviUserParser::parseCmd_CHANSERV(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingServicesCommand,"CHANSERV");

	if(!m_pSocket->sendFmtData("CHANSERV :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"CHANSERV");
	return true;
}

/*
	@command: MEMOSERV
	@short:
		Sends a command to memo service (MemoServ)*
	@syntax:
		chanserv &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Sends a command to the network's memo service.<br>
		* The MEMOSERV command may not be supported by all servers.
	@examples:
		<example>
		memoserv help
		memoserv send Triskelios wth
		</example>
	@seealso:
		<a href="ms.kvihelp">MS</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

/*
	@command: MS
	@short:
		Sends a command to memo service (MemoServ)*
	@syntax:
		ms &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Built-in alias for <a href="memoserv.kvihelp">MEMOSERV</a>.<br>
		* The MEMOSERV command may not be supported by all servers.
	@examples:
		<example>
		ms help
		</example>
	@seealso:
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

bool KviUserParser::parseCmd_MEMOSERV(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingServicesCommand,"MEMOSERV");

	if(!m_pSocket->sendFmtData("MEMOSERV :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"MEMOSERV");
	return true;
}

/*
	@command: OPERSERV
	@short:
		Sends a command to operator service (OperServ)*
	@syntax:
		operserv &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Sends a command to the network's IRC operator service.<br>
		* This command requires operator privileges.<br>
		* The OPERSERV command may not be supported by all servers.
	@examples:
		<example>
		operserv help
		operserv mkill *!*@*.gov.au
		</example>
	@seealso:
		<a href="os.kvihelp">OS</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

/*
	@command: OS
	@short:
		Sends a command to operator service (OperServ)*
	@syntax:
		os &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Built-in alias for <a href="operserv.kvihelp">OPERSERV</a>.<br>
		* The OPERSERV command may not be supported by all servers.
	@examples:
		<example>
		os help
		</example>
	@seealso:
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

bool KviUserParser::parseCmd_OPERSERV(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingServicesCommand,"OPERSERV");

	if(!m_pSocket->sendFmtData("OPERSERV :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"OPERSERV");
	return true;
}

/*
	@command: STATSERV
	@short:
		Sends a command to statistics service (StatServ)*
	@syntax:
		statserv &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Sends a command to the network's statistics service.
		* The STATSERV command may not be supported by all servers.
	@examples:
		<example>
		statserv help
		</example>
	@seealso:
		<a href="ss.kvihelp">SS</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

/*
	@command: SS
	@short:
		Sends a command to statistics service (StatServ)*
	@syntax:
		ss &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Built-in alias for <a href="statserv.kvihelp">STATSERV</a>.
		* The STATSERV command may not be supported by all servers.
	@examples:
		<example>
		ss help
		</example>
	@seealso:
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="hs.kvihelp">HS</a>
*/

bool KviUserParser::parseCmd_STATSERV(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingServicesCommand,"STATSERV");

	if(!m_pSocket->sendFmtData("STATSERV :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"STATSERV");
	return true;
}

/*
	@command: HELPSERV
	@short:
		Sends a command to help service (HelpServ)*
	@syntax:
		helpserv &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Sends a command to the network's help service.
		* The HELPSERV command may not be supported by all servers.
	@examples:
		<example>
		helpserv help
		</example>
	@seealso:
		<a href="hs.kvihelp">HS</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
*/

/*
	@command: HS
	@short:
		Sends a command to help service (HelpServ)*
	@syntax:
		hs &lt;command&gt; [&lt;parameters&gt;]
	@description:
		Built-in alias for <a href="helpserv.kvihelp">HELPSERV</a>.
		* The HELPSERV command may not be supported by all servers.
	@examples:
		<example>
		hs help
		</example>
	@seealso:

		<a href="helpserv.kvihelp">HELPSERV</a>
		<a href="nickserv.kvihelp">NICKSERV</a>
		<a href="ns.kvihelp">NS</a>
		<a href="chanserv.kvihelp">CHANSERV</a>
		<a href="cs.kvihelp">CS</a>
		<a href="memoserv.kvihelp">MEMOSERV</a>
		<a href="ms.kvihelp">MS</a>
		<a href="operserv.kvihelp">OPERSERV</a>
		<a href="os.kvihelp">OS</a>
		<a href="statserv.kvihelp">STATSERV</a>
		<a href="ss.kvihelp">SS</a>
*/

bool KviUserParser::parseCmd_HELPSERV(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingServicesCommand,"HELPSERV");

	if(!m_pSocket->sendFmtData("HELPSERV :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"HELPSERV");
	return true;
}

/*
	@command: HELP
	@short:
		Shows help on a specified topic
	@syntax:
		help [-s] [&lt;topic&gt;]
	@description:
		Displays the help window and opens the specified command.<br>
		If no topic is specified, a list of available commands is shown.<br>
		If the -s switch is used, the &lt;topic&gt; is interpreted as
		a string to search in the help files.<br>
	@examples:
		<example>
		help <a href="join.kvihelp">join</a>
		help <a href="s_chan.kvihelp">$chan</a>
		help <a href="s_icon.kvihelp">$icon</a>
		</example>
*/

bool KviUserParser::parseCmd_HELP(KviCommand *c)
{
	// HELP [-s] <topic>
	if(!extractSwitches(c))return false;
	bool bSearch = c->hasSwitch('s');
	if(!processCmdFinalPartNoIdent(c))return false;

	if(c->m_buffer.isEmpty()){
		c->m_wnd->outputNoFmt(KVI_OUT_HELP,__tr("Available commands:"));
		KviStr tmp;
		int i;
		int idx = 0;
		for(i = 0;cmdTable_A_G[i].cmdName;i++){
			if(tmp.hasData()){
				tmp.append(", ");
				if(idx >= 3){
					tmp.append('\n');
					idx = 0;
				}
			}
			tmp.append(cmdTable_A_G[i].cmdName);
			idx++;
		}
		for(i = 0;cmdTable_H_N[i].cmdName;i++){
			tmp.append(", ");
			if(idx >= 3){
				tmp.append('\n');
				idx = 0;
			}
			tmp.append(cmdTable_H_N[i].cmdName);
			idx++;
		}
		for(i = 0;cmdTable_O_S[i].cmdName;i++){
			tmp.append(", ");
			if(idx >= 3){
				tmp.append('\n');
				idx = 0;
			}
			tmp.append(cmdTable_O_S[i].cmdName);
			idx++;
		}
		for(i = 0;cmdTable_T_Z[i].cmdName;i++){
			tmp.append(", ");
			if(idx >= 3){
				tmp.append('\n');
				idx = 0;
			}
			tmp.append(cmdTable_T_Z[i].cmdName);
			idx++;
		}
		c->m_wnd->outputNoFmt(KVI_OUT_HELP,tmp.ptr());
		c->m_wnd->outputNoFmt(KVI_OUT_HELP,__tr("'HELP command' shows help for that command"));
		c->m_wnd->outputNoFmt(KVI_OUT_HELP,__tr("'HELP index' shows the index of topics"));
		return true;
	}
	if(bSearch)m_pFrm->requestHelpSearchOn(c->m_buffer.ptr());
	else {
		c->m_buffer.toLower();
		if(*(c->m_buffer.ptr())=='$'){
			c->m_buffer.cutLeft(1);
			c->m_buffer.prepend("s_");
		}
		c->m_buffer.append(".kvihelp");
		m_pFrm->requestHelpOn(c->m_buffer.ptr());
	}
	return true;
}

/*
	@command: SETRETURN
	@short:
		Sets the return value of a sequence of commands
	@syntax:
		setreturn &lt;return_string&gt;
	@return:
		The value set
	@description:
		Sets the return value of the current sequence of commands.<br>
		Useful in implementing function-like aliases.<br>
		This command can be called more than once in a single command sequence.<br>
		The effective return value will be the one set by the last setreturn call.<br>
		You can always use <a href="s_getreturn.kvihelp">$GetReturn</a> to check
		for the current return value.<br>
		In fact you can use the return value as it was a local variable visible
		also to the caller of this sequence of commands.<br>
	@examples:
		Simple example
		<example>
			<a href="echo.kvihelp">echo</a> ${ setreturn Yahoo!; }
		</example>
		<example>
			<a href="alias.kvihelp">alias</a> sumthreenumbers setreturn <a href="s_calc.kvihelp">$calc</a>($1 + $2 + $3)
			echo ${ sumthreenumbers 13 223 3766; }
		</example>
	@seealso:
		<a href="s_getreturn.kvihelp">$getReturn</a>
*/


bool KviUserParser::parseCmd_SETRETURN(KviCommand *c)
{
	// LIST
	if(!processCmdFinalPart(c))return false;
	c->setReturnValue(c->m_buffer.ptr());
	return true;
}

/*
	@command: LIST
	@short:
		Opens the Channel List window
	@syntax:
		list
	@description:
		Opens the Channel List window.<br>
		The window will not be created until after the whole command
		sequence (in which LIST was called) has been processed.
*/

/*
#ifdef _KVI_DEBUG_CLASS_NAME_
	#warning "-r <request> ?"
#endif
*/

//Server-related commands

/*
	@command: MOTD
	@short:
		Requests the current server Message of the Day
	@syntax:
		lusers [&lt;server_mask&gt;]
	@description:
		Requests the Message of the Day of a server. This banner is normally
		displayed upon connect.
	@examples:
		<example>
		lusers
		lusers nexus.*
		lusers irc.fema.gov
		</example>
	@seealso:
		<a href="lusers.kvihelp">LUSERS</a>
*/

bool KviUserParser::parseCmd_MOTD(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "MOTD";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"MOTD");
	return true;
}

/*
	@command: LUSERS
	@short:
		Requests current server statistics
	@syntax:
		lusers [&lt;server_mask&gt;]
	@description:
		Requests statistics on the number of users and servers
		connected to a server. This information is normally displayed
		upon connect.
	@examples:
		<example>
		lusers
		lusers nexus.*
		lusers oil.rf.fema.gov
		</example>
	@seealso:
		<a href="motd.kvihelp">MOTD</a>
		<a href="motd.kvihelp">INFO</a>
		<a href="motd.kvihelp">VERSION</a>
		<a href="stats.kvihelp">STATS</a>
		<a href="time.kvihelp">TIME</a>
		<a href="motd.kvihelp">ADMIN</a>
*/

bool KviUserParser::parseCmd_LUSERS(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "LUSERS";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"LUSERS");
	return true;
}

/*
	@command: INFO
	@short:
		Requests information about a server
	@syntax:
		info [&lt;server_mask&gt;]
	@description:
		Requests general information about a server.
	@examples:
		<example>
		info
		info nexus.*
		</example>
	@seealso:
		<a href="motd.kvihelp">MOTD</a>
		<a href="lusers.kvihelp">LUSERS</a>
		<a href="version.kvihelp">VERSION</a>
		<a href="stats.kvihelp">STATS</a>
		<a href="time.kvihelp">TIME</a>
		<a href="admin.kvihelp">ADMIN</a>
*/

bool KviUserParser::parseCmd_INFO(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "INFO";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"INFO");
	return true;
}

/*
	@command: STATS
	@short:
		Queries the statistics of a server
	@syntax:
		stats &lt;query&gt; [&lt;server_mask&gt;]
	@description:
		Requests statistics of type &lt;query&gt; from a server.<br>
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		stats l
		stats o oil.rf.fema.gov
		</example>
	@seealso:
		<a href="lusers.kvihelp">LUSERS</a>
		<a href="info.kvihelp">INFO</a>
		<a href="version.kvihelp">VERSION</a>
		<a href="time.kvihelp">TIME</a>
		<a href="admin.kvihelp">ADMIN</a>
*/

bool KviUserParser::parseCmd_STATS(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingParameter,"STATS");
	if(!m_pSocket->sendFmtData("STATS %s",c->m_buffer.ptr()))return notConnectedToServer(c,"STATS");
	return true;
}

/*
	@command: TIME
	@short:
		Requests current time from a server
	@syntax:
		time [&lt;server_mask&gt;]
	@description:
		Requests the current time from the server's clock.
	@examples:
		<example>
		time
		time nexus.*
		</example>
	@seealso:
		<a href="lusers.kvihelp">LUSERS</a>
		<a href="info.kvihelp">INFO</a>
		<a href="version.kvihelp">VERSION</a>
		<a href="stats.kvihelp">STATS</a>
		<a href="admin.kvihelp">ADMIN</a>
*/

bool KviUserParser::parseCmd_TIME(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "TIME";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"TIME");
	return true;
}

/*
	@command: ADMIN
	@short:
		Lists active administrators on a server
	@syntax:
		admin [&lt;server_mask&gt;]
	@description:
		Requests a list of active administrators from a server.
	@examples:
		<example>
		admin
		admin *.fema.gov
		</example>
	@seealso:
		<a href="lusers.kvihelp">LUSERS</a>
		<a href="info.kvihelp">INFO</a>
		<a href="version.kvihelp">VERSION</a>
		<a href="stats.kvihelp">STATS</a>
		<a href="time.kvihelp">TIME/a>
*/

bool KviUserParser::parseCmd_ADMIN(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "ADMIN";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"ADMIN");
	return true;
}

/*
	@command: VERSION
	@short:
		Requests server version
	@syntax:
		version [&lt;server_mask&gt;]
	@description:
		Requests the version information of a server.
	@examples:
		<example>
		version
		version nexus.*
		</example>
	@seealso:
		<a href="lusers.kvihelp">LUSERS</a>
		<a href="info.kvihelp">INFO</a>
		<a href="stats.kvihelp">STATS</a>
		<a href="time.kvihelp">TIME</a>
		<a href="admin.kvihelp">ADMIN</a>
*/

bool KviUserParser::parseCmd_VERSION(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "VERSION";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"VERSION");
	return true;
}

/*
	@command: LAG
	@short:
		Checks the latency between two servers*
	@syntax:
		lag [[&lt;remote_server&gt;] &lt;server&gt;]
	@description:
		Requests the latency between two server be sending a LAG
		message.<br>
		* The LAG command may not be available on all servers.
	@examples:
		<example>
		lag orion.ca.us.quasarnet.org
		</example>
	@seealso:
		<a href="links.kvihelp">LINKS</a>
*/

bool KviUserParser::parseCmd_LAG(KviCommand *c)
{
	// the buffer may be also empty (: is valid arg)
	if(!m_pSocket->sendFmtData("LAG :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"LAG");
	return true;
}

bool KviUserParser::parseCmd_LIST(KviCommand *c)
{
	// LIST
	if(!processCmdFinalPart(c))return false;
	QTimer::singleShot(100,m_pFrm,SLOT(activateListWindow()));
	return true;
}

/*
	@command: SAVEOPTIONS
	@short:
		Forces KVIrc to save its configuration
	@syntax:
		saveoptions
	@description:
		Forces KVIrc to save its current configuration to file immediately.
*/

bool KviUserParser::parseCmd_SAVEOPTIONS(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	g_pOptions->save();
	return true;
}

/*
	@command: AWHOIS
	@short:
		Asynchronous WHOIS
	@syntax:
		awhois [-i[=&lt;server&gt;]] (&lt;nick&gt;[,magic]) <command>
	@description:
		Asynchronous WHOIS call.<br>
		This command sends a WHOIS command to the server and waits for the information to return.<br>
		When all returned data is processed, &lt;command&gt; is executed.<br>
		The -i switch allows the WHOIS call to be directed to a specified server.<br>
		If no &lt;server&gt; argument is specified with the -i switch, the whois is
		redirected to the server that &lt;nick&gt; is connected to.<br>
		Inside &lt;command&gt; the following identifiers can be used to obtain details about the user:<br>
		<a href="s_whoisnick.kvihelp">$whoisNick</a> (nickname)<br>
		<a href="s_whoisuser.kvihelp">$whoisUser</a> (username)<br>
		<a href="s_whoishost.kvihelp">$whoisHost</a> (host)<br>
		<a href="s_whoisreal.kvihelp">$whoisReal</a> (real name)<br>
		<a href="s_whoischannels.kvihelp">$whoisChannels</a> (channels)<br>
		<a href="s_whoisserver.kvihelp">$whoisServer</a> (server)<br>
		<a href="s_whoisstatus.kvihelp">$whoisStatus</a> (away msg)<br>
		<a href="s_whoisidle.kvihelp">$whoisIdle</a> (idle time)<br>
		<a href="s_whoisircop.kvihelp">$whoisIrcOp</a> (is irc op ?)<br>
		<a href="s_whoismagic.kvihelp">$whoisMagic</a> (magic).<br>
		<a href="s_whoissuccess.kvihelp">$whoisSuccess</a> (success or no such nick ?)<br>
		Please note that not all of the information must be necessairly available:<br>
		for example, the idle time (<a href="s_whoisidle.kvihelp">$whoisIdle</a>)
		information may be not sent by the server.<br>
		Generally you can be sure that $whoisNick,$whoisUser,$whoisHost and $whoisReal
		contain information, the other identifiers may be empty for "some" reason.<br>
		<docsubtitle>Note</docsubtitle>
		If you are not connected to a server, &lt;command&gt; will not be executed.<br>
		If the user is unknown to the server, all identifiers except <a href="s_whoisnick">$whoisnick</a> and <a href="s_whoismagic">$whoismagic</a> will be empty,
		and the <a href="s_whoissuccess.kvihelp">$whoisSuccess</a> identifier will return 0.<br>
	@examples:
		Request information about Pragma:<br>
		<example>
			awhois (pragma) {
			@tab@<a href="if.kvihelp">if</a> (<a href="s_whoissuccess">$whoissuccess</a>)
			@tab@@tab@<a href="echo.kvihelp">echo</a> No user with nickname pragma.<br>
			@tab@@tab@else <a href="echo.kvihelp">echo</a> pragma is $whoisNick!$whoisUser@$whoisHost
			}
		</example>
		Request buti's idle time, we need to redirect the query to the buti's server:<br>
		<example>
			awhois -i (buti) {
			@tab@<a href="if.kvihelp">if</a> ("$whoisidle" != "")
			@tab@tab@<a href="say.kvihelp">say</a> <a href="s_window.kvihelp">$window</a> $whoisnick is idle since $whoisidle. let's kick him! :)
			}
		</example>
		Request user information from a specific server:<br>
		<example>
			awhois -i=irc.openprojects.net (%nickname)
			{
			@tab@<a href="if.kvihelp">if</a> (<a href="s_whoissuccess.kvihelp">$whoissuccess</a>)
			@tab@@tab@<a href="echo.kvihelp">echo</a> %nickname's real name is <a href="s_whoisreal.kvihelp">$whoisReal</a>
			}
		</example>
*/


bool KviUserParser::parseCmd_AWHOIS(KviCommand *c)
{
	if(!extractSwitches(c))return false;

	c->skipWhitespace();

	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"AWHOIS",c->m_ptr);
		return false;
	}
	++(c->m_ptr);

	KviStr nick;
	if(!processFncSingleParam(c,nick))return false;
	if(nick.isEmpty()){
		c->setError(KVI_ERROR_MissingNickname,"AWHOIS");
		return false;
	}
	KviStr magic;
	if(!processFncFinalPart(c,magic))return false;

	KviStr server;

	if(c->hasSwitch('i'))
	{
		c->getSwitchValue('i',server);
		if(server.isEmpty())server = nick;
	}

	c->skipWhitespace();
	const char *aux_ptr = c->m_ptr;
	if(!skipCommand(c))return false;

	KviStr cmd(aux_ptr,c->m_ptr - aux_ptr);

	if(!m_pAsyncWhoisController->start(nick,server,c->m_wnd,cmd.ptr(),(magic.hasData() ? magic.ptr() : 0)))return notConnectedToServer(c,"AWHOIS");
	return true;
}


bool KviUserParser::skipAwhois(KviCommand *c)
{
//	c->m_ptr += 6; //skip AWHOIS
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"AWHOIS",c->m_ptr);
		return false;
	}
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	return skipCommand(c);
}


/*
	@command: EXECV
	@short:
		Executes a subprocess with asynchronous output
	@syntax:
		execv [-s] (&lt;commandline&gt;[,&lt;magicdata&gt;]) &lt;command&gt;
	@description:
		Executes a slave process in asynchronous output mode.<br>
		The process output is grabbed by kvirc and stored
		into an internal buffer.<br>
		When the process terminates (NORMALLY) the &lt;command&gt; is executed
		and the <a href="s_procstderr.kvihelp">$procstderr</a>,
		<a href="s_procstdout.kvihelp">$procstdout</a>,
		<a href="s_proccmdline.kvihelp">$proccmdline</a>,
		<a href="s_procwindow.kvihelp">$procwindow</a>,
		<a href="s_procexitcode.kvihelp">$procexitcode</a>
		and <a href="s_procpid.kvihelp">$procpid</a> identifiers
		evaluate, respectively, to the process stderr buffer,
		process stdout buffer, process commandline, the window that
		this command has been launched in, process exit code and the process pid.<br>
		If [magicdata] is specified, at the &lt;command&gt; execution time
		the <a href="s_procmagic.kvihelp">$procmagic</a> identifier
		will evaluate to the magic data passed.<br>
		Please note that if the process is killed by the /<a href="killproc.kvihelp">KILLPROC</a>
		command, the &lt;command&gt; is NOT executed.<br>
		The &lt;command&gt; is bound to the window from which this
		EXECV command was called. If that window doesn't exist,
		it is bound to the console window.<br>
		The -s switch causes the command to be executed in a subshell:<br>
		(the shell can perform various funky things to the commandline
		before executing the command; for example it will substitute
		file patterns like *.h with all of the file names matching the pattern)
		The shell name is taken from the SHELL enviroinement variable.<br>
	@examples:
		<example>
			execv(ls)<a href="echo.kvihelp">echo</a> <a href="s_procstdout.kvihelp">$procstdout</a><br>
			execv(uname -a)<a href="echo.kvihelp">echo</a> <a href="s_procstdout.kvihelp">$procstdout</a> <a href="s_proccmdline.kvihelp">$proccmdline</a>,<a href="s_procpid.kvihelp">$procpid</a><br>
			execv(uname -x)<a href="echo.kvihelp">echo</a> <a href="s_procstderr.kvihelp">$procstderr</a><br>
			execv -s (grep cantfindthis /usr/include/a*.h,<a href="s_time.kvihelp">$time</a>)<a href="echo.kvihelp">echo</a> CurrentTime: <a href="s_time.kvihelp">$time</a>, ExecvCallTime: <a href="s_procmagic.kvihelp">$procmagic</a><br>
		</example>
	@seealso:
		<a href="run.kvihelp">RUN</a>, <a href="proclist.kvihelp">PROCLIST</a>,
		<a href="killproc.kvihelp">KILLPROC</a>, <a href="writeproc.kvihelp">WRITEPROC</a>,
		<a href="exec.kvihelp">EXEC</a>
*/

/*
#warning "Return the PID of the process"
*/

bool KviUserParser::parseCmd_EXECV(KviCommand *c)
{
	if(!extractSwitches(c))return false;

	bool bExecInSubshell = c->hasSwitch('s');

	c->skipWhitespace();

	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"EXECV",c->m_ptr);
		return false;
	}
	++(c->m_ptr);

	KviStr commandline;
	if(!processFncSingleParam(c,commandline))return false;
	if(commandline.isEmpty()){
		c->setError(KVI_ERROR_MissingCommandline,"EXECV");
		return false;
	}
	KviStr magic;
	if(!processFncFinalPart(c,magic))return false;

	c->skipWhitespace();
	const char *aux_ptr = c->m_ptr;
	if(!skipCommand(c))return false;

	KviStr cmd(aux_ptr,c->m_ptr - aux_ptr);

	if(!m_pSlaveIOController->exec(commandline.ptr(),c->m_wnd,bExecInSubshell,true,cmd.ptr(),
		(magic.hasData() ? magic.ptr() : 0))){
			return recoverableError(c,KVI_ERROR_ProcessStartFailed,"EXECV",commandline.ptr());
	}

	return true;
}

bool KviUserParser::skipExecv(KviCommand *c)
{
//	c->m_ptr += 5; //skip EXECV
	if(!skipSwitches(c))return false;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"EXECV",c->m_ptr);
		return false;
	}
//	++(c->m_ptr);
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	return skipCommand(c);
}

/*
	@command: EXEC
	@short:
		Executes a subprocess
	@syntax:
		exec [-s] [-q] &lt;commandline&gt;
	@description:
		Executes a slave process.<br>
		The -s switch causes the command to be executed in a subshell.<br>
		(the shell can perform various funky things to the commandline
		before executing the command; for example it will substitute
		file patterns like *.h with all of the file names matching the pattern)
		The shell name is taken from the SHELL enviroinement variable.<br>
		The -q switch causes the command to be executed in quiet mode:<br>
		no information about process start and termination is printed.
	@examples:
		Some good examples...execute it in sequence and check the output
		of each one.<br>
		<example>
			exec ls<br>
			exec -q ls<br>
			<a href="dir.kvihelp">dir</a><br>
			exec cd ..<br>
			exec pwd<br>
			<a href="cd.kvihelp">cd</a><br>
			exec pwd<br>
			exec -s cd .. && pwd<br>
			exec echo \$HOME<br>
			exec -s echo \$HOME<br>
		</example>
	@seealso:
		<a href="run.kvihelp">RUN</a>, <a href="proclist.kvihelp">PROCLIST</a>,
		<a href="killproc.kvihelp">KILLPROC</a>, <a href="writeproc.kvihelp">WRITEPROC</a>,
		<a href="execv.kvihelp">EXECV</a>
*/


bool KviUserParser::parseCmd_EXEC(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	bool bQuiet = c->hasSwitch('q');
	bool bExecInSubshell = c->hasSwitch('s');

	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingCommandline,"EXEC");

	if(!m_pSlaveIOController->exec(c->m_buffer.ptr(),c->m_wnd,bExecInSubshell,bQuiet))
		return recoverableError(c,KVI_ERROR_ProcessStartFailed,"EXEC",c->m_buffer.ptr());

	return true;
}

/*
	@command: KILLPROC
	@short:
		Kills a slave process
	@syntax:
		killproc [-q] [all|&lt;pid&gt;]
	@description:
		Kills a slave process that has process ID &lt;pid&gt;.<br>
		If the string "all" is specified instead of the PID,
		all of the slave processes currently running are killed.<br>
		If the -q switch is specified, the command is executed in quiet mode
		and only errors are displayed.<br>
	@seealso:
		<a href="exec.kvihelp">EXEC</a>, <a href="execv.kvihelp">EXECV</a>,
		<a href="proclist.kvihelp">PROCLIST</a>, <a href="writeproc.kvihelp">WRITEPROC</a>
*/

bool KviUserParser::parseCmd_KILLPROC(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	bool bQuiet = c->hasSwitch('q');
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingPid,"KILLPROC");

	if(kvi_strEqualNoLocaleCI("all",c->m_buffer.ptr())){
		int nProc = m_pSlaveIOController->killAll();
		if(!bQuiet)c->m_wnd->output(KVI_OUT_STDIN,__tr("Killed: %d %s"),nProc,
			((nProc == 1) ? __tr("process") : __tr("processes")));
	} else {
		bool bOk = false;
		unsigned int p = c->m_buffer.toUInt(&bOk);
		if(!bOk)return recoverableError(c,KVI_ERROR_MissingPid,"KILLPROC");
		if(!m_pSlaveIOController->killProcess(p)){
			return recoverableError(c,KVI_ERROR_NoSuchProcess,"KILLPROC",c->m_buffer.ptr());
		} else {
			if(!bQuiet)c->m_wnd->output(KVI_OUT_STDIN,__tr("Killed: %u"),p);
		}
	}
	return true;
}

/*
	@command: WRITEPROC
	@short:
		Writes data to a slave process
	@syntax:
		writeproc [-q] &lt;pid&gt; [data]
	@description:
		Writes data to the stdin of a specified slave process.<br>
		If no data is specified only a &lt;LF&gt; is written.<br>
		If the -q switch is specified the command is executed in quiet mode.<br>
	@seealso:
		<a href="exec.kvihelp">EXEC</a>, <a href="execv.kvihelp">EXECV</a>,
		<a href="proclist.kvihelp">PROCLIST</a>, <a href="killproc.kvihelp">KILLPROC</a>
*/

bool KviUserParser::parseCmd_WRITEPROC(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	bool bQuiet = c->hasSwitch('q');

	KviStr pid;	
	if(!processCmdSingleToken(c))return false;
	pid = c->m_buffer;
	c->m_buffer = "";
	if(!processCmdFinalPart(c))return false;

	pid.stripWhiteSpace();
	if(pid.isEmpty())return recoverableError(c,KVI_ERROR_MissingPid,"WRITEPROC");

	bool bOk = false;
	unsigned int p = pid.toUInt(&bOk);
	if(!bOk)return recoverableError(c,KVI_ERROR_MissingPid,"WRITEPROC",pid.ptr());

	KviSlaveProcEntry * e = m_pSlaveIOController->findProcByPid(p);
	if(!e)return recoverableError(c,KVI_ERROR_NoSuchProcess,"WRITEPROC",pid.ptr());

	KviStr tmp = c->m_buffer;
	tmp.append("\n");
	if(!m_pSlaveIOController->writeProcess(e,tmp.ptr(),tmp.len())){
		return recoverableError(c,KVI_ERROR_CantWriteToProcess,"WRITEPROC",pid.ptr());
	}

	if(!bQuiet)c->m_wnd->output(KVI_OUT_STDIN,__tr("<%u>: %s"),p,c->m_buffer.ptr());
	return true;
}


/*
	@command: PROCLIST
	@short:
		Shows the list of the slave processes currently running
	@syntax:
		proclist
	@description:
		Shows the list of the slave processes currently running.<br>
		The slave processes are the ones started by /EXEC and /EXECV
	@seealso:
		<a href="exec.kvihelp">EXEC</a>, <a href="execv.kvihelp">EXECV</a>,
		<a href="killproc.kvihelp">KILLPROC</a>
*/

bool KviUserParser::parseCmd_PROCLIST(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	m_pSlaveIOController->outputProcessList(c->m_wnd);
	return true;
}


/*
	@command: DIR
	@short:
		Lists the contents of the current directory
	@syntax:
		dir [-d] [filter]
	@description:
		Lists the contents of a current working directory directory.<br>
		If the -d switch is specified, only directories are listed.<br>
		The filter is a file mask with wildcards.
*/

bool KviUserParser::parseCmd_DIR(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	bool bDirOnly = c->hasSwitch('d');

	if(!processCmdFinalPart(c))return false;

	QDir d(QDir::currentDirPath(),
		c->m_buffer.isEmpty() ? QString::null : _CHAR_2_QSTRING(c->m_buffer.ptr()),
		QDir::Name | QDir::DirsFirst | QDir::IgnoreCase,
		bDirOnly ? QDir::Dirs | QDir::Hidden : QDir::All | QDir::Hidden);
	
	const QFileInfoList * fi = d.entryInfoList();
	if(!fi){
		c->setError(KVI_ERROR_CantListDirContents,"DIR");
		return false;
	}
	QFileInfoListIterator it(*fi);
	QFileInfo *i;
	c->m_wnd->output(KVI_OUT_STDIN,__tr("Permission Owner       Size       Name"));
	while((i = it.current())){
		KviStr owner = i->owner();
		while(owner.len() < 11)owner.append(' ');
		KviStr size(KviStr::Format,"%u",i->size());
		while(size.len() < 11)size.append(' ');
		
		KviStr tmp(KviStr::Format,"%c%c%c%c%c%c%c%c%c%c %s %s",
			i->isDir() ? 'd' : (i->isSymLink() ? 'l' : '-'),
			i->permission(QFileInfo::ReadUser) ? 'r' : '-',
			i->permission(QFileInfo::WriteUser) ? 'w' : '-',
			i->permission(QFileInfo::ExeUser) ? 'x' : '-',
			i->permission(QFileInfo::ReadGroup) ? 'r' : '-',
			i->permission(QFileInfo::WriteGroup) ? 'w' : '-',
			i->permission(QFileInfo::ExeGroup) ? 'x' : '-',
			i->permission(QFileInfo::ReadOther) ? 'r' : '-',
			i->permission(QFileInfo::WriteOther) ? 'w' : '-',
			i->permission(QFileInfo::ExeOther) ? 'x' : '-',
			owner.ptr(),size.ptr());
		 tmp.append(i->fileName());
		c->m_wnd->outputNoFmt(i->isDir() ? KVI_OUT_DIR : KVI_OUT_FILE,tmp.ptr());
		++it;
	}
	return true;
}

/*
	@command: CD
	@short:
		Changes the working directory
	@syntax:
		cd &lt;directory&gt;
	@description:
		Changes the current working directory.
	@seealso:
		<a href="dir.kvihelp">DIR</a>
*/

bool KviUserParser::parseCmd_CD(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty()){
		c->setError(KVI_ERROR_MissingDirName,"CD");
		return false;
	}
	QDir d = QDir::current();
	if(!d.cd(_CHAR_2_QSTRING(c->m_buffer.ptr()))){
		c->setError(KVI_ERROR_InvalidDirectory,"CD",c->m_buffer.ptr());
		return false;
	}
	if(!d.setCurrent(d.absPath())){
		c->setError(KVI_ERROR_CantCDInThatDirectory,"CD",c->m_buffer.ptr());
		return false;
	}
	return true;
}

/*
	@command: JOIN
	@short:
		Joins a channel
	@syntax:
		join &lt;channel1&gt;{,&lt;channelN&gt;} &lt;key1&gt;{,&lt;keyN&gt;}
	@description:
		Attempts to join the specified channel(s) by sending a JOIN message
		to the server.<br>
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		join #newbie
		join #kvirc,#atmosphere
		</example>
	@seealso:
		<a href="part.kvihelp">PART</a>
		<a href="invite.kvihelp">INVITE</a>
*/

bool KviUserParser::parseCmd_JOIN(KviCommand *c)
{
	// JOIN <channel>{,<channel>} <key1>{,<key2>}
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingChannelName,"JOIN");
	if(!m_pSocket->sendFmtData("JOIN %s",c->m_buffer.ptr()))return notConnectedToServer(c,"JOIN");
	return true;
}

/*
	@command: PART
	@short:
		Parts a channel
	@syntax:
		part &lt;channel1&gt;{,&lt;channelN&gt;} &lt;part_message&gt;
	@description:
		Leaves the specified channel(s) by sending a PART message
		to the server.<br>
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		part #newbie
		part #kvirc,#atmosphere Time to sleep
		</example>
	@seealso:
		<a href="join.kvihelp">JOIN</a>
*/

bool KviUserParser::parseCmd_PART(KviCommand *c)
{
	// PART <channel>{,<channel>} <part_message>
	// If no channel is specified, if typed in a channel window
	// The current channel is left.
	if(!processCmdFinalPart(c))return false;
	KviStr channels;
	c->m_buffer.getToken(channels,' ');
	if(channels.isEmpty()){
		if(c->m_wnd->type() == KVI_WND_TYPE_CHANNEL)channels = c->m_wnd->caption();
		else return recoverableError(c,KVI_ERROR_MissingChannelName,"PART");
	}
	bool bSent;
	if(c->m_buffer.hasData())bSent = m_pSocket->sendFmtData("PART %s :%s",channels.ptr(),c->m_buffer.ptr());
	else bSent = m_pSocket->sendFmtData("PART %s",channels.ptr());
	if(!bSent)return notConnectedToServer(c,"PART");
	return true;
}

/*
	@command: LINKS
	@short:
		Requests a list of server links
	@syntax:
		links [[&lt;remote_server&gt;] <server_mask&gt;]
	@description:
		Requests information about the links of a server by sending a LINKS
		message. See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		links
		links kainga.ca.us.quasarnet.org
		</example>
	@seealso:
		<a href="map.kvihelp">MAP</a>
*/

bool KviUserParser::parseCmd_LINKS(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "LINKS";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"LINKS");
	return true;
}

/*
	@command: MAP
	@short:
		Requests a diagram of server links*
	@syntax:
		map [[&lt;remote_server&gt;] <server_mask&gt;]
	@description:
		Requests a nested tree diagram of the links of a server by sending a MAP
		message.<br>
		* The MAP command may not be available on all servers.
	@examples:
		<example>
		map
		map kainga.ca.us.quasarnet.org
		</example>
	@seealso:
		<a href="links.kvihelp">LINKS</a>
*/

bool KviUserParser::parseCmd_MAP(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	KviStr tmp = "MAP";
	if(c->m_buffer.hasData()){
		if(*(c->m_buffer.ptr()) != ' ')tmp.append(' ');
		tmp.append(c->m_buffer);
	}
	if(!m_pSocket->sendData(tmp.ptr()))return notConnectedToServer(c,"MAP");
	return true;
}

/*
	@command: WHOIS
	@short:
		Requests information about users on IRC
	@syntax:
		whois [server] &lt;nick_list&gt;
	@description:
		Requests information about users on IRC by sending a WHOIS message
		to the server.
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		whois Pragma
		</example>
		The one below shows also the IDLE time.
		<example>
		whois Pragma Pragma
		</example>
	@seealso:
		<a href="whowas.kvihelp">WHOWAS</a>
*/

bool KviUserParser::parseCmd_WHOIS(KviCommand *c)
{
	// WHOIS [server] <nick_list>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_WhoQueriesRequireANick,"WHOIS");
	if(!m_pSocket->sendFmtData("WHOIS %s",c->m_buffer.ptr()))return notConnectedToServer(c,"WHOIS");
	return true;
}

/*
	@command: WHOWAS
	@short:
		Requests database information about users on IRC
	@syntax:
		whois [entries_count] &lt;nick&gt;
	@description:
		Requests database information about users on IRC by sending a WHOWAS message
		to the server.
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.
	@examples:
		<example>
		whowas Pragma
		</example>
	@seealso:
		<a href="whois.kvihelp">WHOIS</a>
*/

bool KviUserParser::parseCmd_WHOWAS(KviCommand *c)
{
	// WHOWAS <count> <nickname>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_WhoQueriesRequireANick,"WHOWAS");
	if(!m_pSocket->sendFmtData("WHOWAS %s",c->m_buffer.ptr()))return notConnectedToServer(c,"WHOWAS");
	return true;
}

/*
	@command: WHO
	@short:
		Requests information about users on IRC
	@syntax:
		who <&lt;nick&gt;|&lt;channel&gt;>
	@description:
		Requests information about users on IRC by sending a WHO message
		to the server.
		See <a href="rfc1459.kvihelp">RFC1459</a> for the exact syntax and
		descriptions of parameters.<br>
		Because KVIrc uses the WHO numeric to update the internal userlist,
		under some circumstances you may not be able to see the replies.<br>
		To avoid this, enable the "Show internal who replies" in Options>IRC Engine>Output.
	@examples:
		<example>
		who Pragma
		who #kvirc
		</example>
	@seealso:
		<a href="whois.kvihelp">WHOIS</a>
		<a href="whowas.kvihelp">WHOWAS</a>
		<a href="names.kvihelp">NAMES</a>
		<a href="userhost.kvihelp">USERHOST</a>
*/

bool KviUserParser::parseCmd_WHO(KviCommand *c)
{
	// WHO <mask>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_WhoQueriesRequireANick,"WHO");
	if(!m_pSocket->sendFmtData("WHO %s",c->m_buffer.ptr()))return notConnectedToServer(c,"WHO");
	return true;
}

/*
	@command: USERHOST
	@short:
		Returns hostmasks of users on IRC
	@syntax:
		userhost &lt;nick_list&gt;
	@description:
		Requests the hostmasks of users on IRC by sending a USERHOST message
		to the server. &lt;nick_list&gt; is a space-separated list of at most 5 nicks.<br>
		Because KVIrc uses the USERHOST numeric to update the internal userlist,
		under some circumstances you may not be able to see the replies.
	@examples:
		<example>
		userhost Pragma
		</example>
	@seealso:
		<a href="who.kvihelp">WHO</a>
*/

bool KviUserParser::parseCmd_USERHOST(KviCommand *c)
{
	// USERHOST <nick_list>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_UserhostRequiresANick,"USERHOST");
	if(!m_pSocket->sendFmtData("USERHOST %s",c->m_buffer.ptr()))return notConnectedToServer(c,"USERHOST");
	return true;
}

/*
	@command: NAMES
	@short:
		Lists users on a channel or on IRC
	@syntax:
		names [&lt;channel&gt;]
	@description:
		Requests the list of users on a channel or on IRC by sending a NAMES
		message to the server.
	@examples:
		<example>
		names
		names #kvirc
		</example>
	@seealso:
		<a href="who.kvihelp">WHO</a>
*/

bool KviUserParser::parseCmd_NAMES(KviCommand *c)
{
	//NAMES [&lt;channel&gt;]
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->sendFmtData("NAMES %s",c->m_buffer.ptr()))return notConnectedToServer(c,"NAMES");
	return true;
}

/*
	@command: RAW
	@short:
		Sends raw data to the server
	@syntax:
		raw [-s] &lt;raw_data&gt;
	@description:
		Sends RAW data to the server.<br>
		RAW data means that the string &lt;raw_data&gt; is not
		interpreted by KVIrc, only identifiers are substituted.<br>
		The -s switch specifies to avoid the window output for the sent data.<br>
		This command is equivalent to <a href="quote.kvihelp">QUOTE</a>.
	@examples:
		<example>
		raw kill Pragma What a lamer!
		</example>
	@seealso:
		<a href="quote.kvihelp">QUOTE</a>
*/

/*
	@command: QUOTE
	@short:
		Sends raw data to the server
	@syntax:
		quote [-s] &lt;raw_data&gt;
	@description:
		This is a built-in alias for <a href="raw.kvihelp">RAW</a>.
	@seealso:
		<a href="raw.kvihelp">RAW</a>
*/

bool KviUserParser::parseCmd_RAW(KviCommand *c)
{
	// RAW [-s] <raw_data>
	// -s = silent
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');
	if(!processCmdFinalPart(c))return false;
	// can send also an empty buffer of data...just a CRLF
	if(!m_pSocket->sendData(c->m_buffer.ptr(),c->m_buffer.len()))return notConnectedToServer(c,"RAW");
	if(!bSilent)c->m_wnd->output(KVI_OUT_RAW,__tr("Raw to server: %s"),c->m_buffer.ptr());
	return true;
}

/*
	@command: INVITE
	@short:
		Invites a user to a channel
	@syntax:
		invite &lt;nick&gt; [&lt;channel&gt;]
	@description:
		Attempts to INVITE a user to &lt;channel&gt; by sending
		the INVITE message to the server. If no channel is specified, the current
		channel is used if it exists.
	@examples:
		<example>
		invite Pragma #kvirc
		</example>
*/

bool KviUserParser::parseCmd_INVITE(KviCommand *c)
{
	// INVITE <nick> <channel>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingChannelName,"INVITE");
	KviStr target;
	c->m_buffer.getToken(target,' ');
	KviStr channel;
	c->m_buffer.getToken(channel,' ');
	if(channel.isEmpty()){
		if(c->m_wnd->type() == KVI_WND_TYPE_CHANNEL)channel = c->m_wnd->caption();
		else return recoverableError(c,KVI_ERROR_MissingChannelName,"INVITE");
	}
	if(!m_pSocket->sendFmtData("INVITE %s %s",target.ptr(),channel.ptr()))return notConnectedToServer(c,"INVITE");
	return true;
}

/*
	@command: MODE
	@short:
		Sets user or channel modes
	@syntax:
		mode <target> [&lt;mode_flags&gt; [&lt;mode params&gt;]]
	@description:
		Changes (or requests) user or channel modes.<br>
		KVIrc simply takes the input parameters and sends them to the server.<br>
		Please refer to <a href="rfc1459.kvihelp">RFC1459</a> for the available flags
		and exact syntax of use.
	@examples:
		Set own user mode: become invisible and receive wallops,disable server notices.
		<example>mode Pragma +iw-s</example>
		Set the +t (topic limited) flag to channel #linux
		<example>mode #linux +t</example>
		Change flags for channel #kvirc: set mode n (no external messages),
		set mode l 100 (limit to 100 users), unset mode p (private channel)
		<example>mode #kvirc +nl-p 100</example>
		Set operator flag for Pragma on #mp3
		<example>mode #mp3 +o Pragma</example>
		Multiple mode change, one op and one devoice
		<example>mode #mp3 -v+o Pragma Diabl0</example>
		Multiple mode change: set two bans
		<example>mode #mp3 +bb *!*@*.domain.of.flooders.zzz *!*@*.damain.of.spammers.zzz</example>
		Another multiple mode change: set a ban and an exception
		<example>mode #mp3 +be *!*@*.domain.of.nukers.zzz NoNuke!*@*.domain.of.nukers.zzz</example>
*/

bool KviUserParser::parseCmd_MODE(KviCommand *c)
{
	// MODE <params>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_ModeRequiresParameters,"MODE");
	if(!m_pSocket->sendFmtData("MODE %s",c->m_buffer.ptr()))return notConnectedToServer(c,"MODE");
	return true;
}

/*
	@command: UMODE
	@short:
		Sets user modes
	@syntax:
		umode [&lt;mode_flags&gt; [&lt;mode params&gt;]]
	@description:
		Changes (or requests) your user modes.<br>
		Please refer to <a href="rfc1459.kvihelp">RFC1459</a> for the and the available flags
		and the exact syntax of use.
	@examples:
		Set own user mode: Become invisible and receive wallops, disable server notices.
		<example>umode +iw-s</example>
	@seealso:
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_UMODE(KviCommand *c)
{
	// UMODE <params>
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->sendFmtData("MODE %s %s",m_pFrm->m_global.szCurrentNick.ptr(),c->m_buffer.ptr()))return notConnectedToServer(c,"UMODE");
	return true;
}

/*
	@command: BEEP
	@short:
		Rings keyboard bell (PC speaker)
	@syntax:
		beep [-p=&lt;pitch&gt;] [-d=&lt;duration&gt;] [-s] [&lt;volume&gt;]
	@description:
		This command rings the bell on the keyboard (the PC speaker).
		The volume must be in range 0-100; the default is 100.<br>
		The pitch is specified in Hz and must be positive.<br>
		The duration is specified in milliseconds.<br>
		An invalid (or unspecified) pitch, volume or duration
		makes KVIrc to use the default values set by the X server.<br>
		The duration of the bell is only indicative and
		can be shortened by a subsequent call to /beep (that
		will override the currently playing one).<br>
		If the -s switch is specified the bell becomes synchronous:
		KVIrc waits for the ring to complete before continuing.<br>
		(WARNING: The main KVIrc thread is stopped in that case
		so if you play long notes (duration > 100),
		the entire application will appear to freeze for a while).<br>
		The precision of the bell pitch, duration and
		volume is strongly dependant on the X server and the underlying hardware.<br>
*/

bool KviUserParser::parseCmd_BEEP(KviCommand *c)
{
	// BEEP [-p pitch] [-d duration] [-s] [volume]
	if(!extractSwitches(c))return false;

	int pitch    = -1;
	int duration = -1;
	bool bSync   = c->hasSwitch('s');
	bool bOk = false;

	if(c->hasSwitch('p')){
		c->getSwitchValue('p',c->m_buffer);
		pitch = c->m_buffer.toInt(&bOk);
		if(!bOk || pitch < 0){
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingPitch,"BEEP",__tr("-p switch"));
			else c->warning(__tr("BEEP: Missing pitch : Using default"));
			pitch = -1;
		}
		c->clearBuffer();
	}
	if(c->hasSwitch('d')){
		c->getSwitchValue('d',c->m_buffer);
		duration = c->m_buffer.toInt(&bOk);
		if(!bOk || duration < 0){
			if(g_pOptions->m_bPedanticParser)return c->setError(KVI_ERROR_MissingDuration,"BEEP",__tr("-d switch"));
			else c->warning(__tr("BEEP: Missing duration : Using default"));
			duration = -1;
		}
		c->clearBuffer();
	}

	if(!processCmdFinalPart(c))return false;

	int volume = c->m_buffer.toInt(&bOk);
	if(!bOk || (volume > 100) || (volume < 0))volume = 100;

	XKeyboardState st;
	XKeyboardControl ctl;

	XGetKeyboardControl(qt_xdisplay(),&st);

	unsigned long mask = KBBellPercent;
	ctl.bell_percent = volume;
	if(pitch >= 0){
		ctl.bell_pitch    = pitch;
		mask             |= KBBellPitch;
	}
	if(duration >= 0){
		ctl.bell_duration = duration;
		mask             |= KBBellDuration;
	}
	XChangeKeyboardControl(qt_xdisplay(),mask,&ctl);

	XBell(qt_xdisplay(),100);

	if(bSync){
		if(duration >= 0)usleep(duration * 1000);
		else usleep(st.bell_duration * 1000);
	}

	ctl.bell_pitch = st.bell_pitch;
	ctl.bell_duration = st.bell_duration;
	ctl.bell_percent = st.bell_percent;

	XChangeKeyboardControl(qt_xdisplay(),mask,&ctl);
	return true;
}

/*
	@command: NICK
	@short:
		Sets or changes current nickname
	@syntax:
		nick &lt;new_nick&gt;
	@description:
		Attempts to set the current nickname to &lt;new_nick&gt; by sending
		a NICK message to the server.
	@examples:
		<example>
		nick Newbie
		</example>
	@seealso:
		<a href="user.kvihelp">USER</a>
*/

bool KviUserParser::parseCmd_NICK(KviCommand *c)
{
	// NICK <new_nick>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_NickRequiresANick,"NICK");
	if(!m_pSocket->sendFmtData("NICK %s",c->m_buffer.ptr()))return notConnectedToServer(c,"NICK");
	return true;
}

/*
	@command: USER
	@short:
		Sets user information
	@syntax:
		user &lt;username&gt; &lt;mode&gt; * &lt;ircname&gt;
	@description:
		Attempts to set the current username to &lt;username&gt;,
		current user mode to &lt;mode&gt; (bitmask), and IRC name,
		or "real name" to &lt;ircname&gt; by sending a USER message
		to the server.
	@examples:
		<example>
		user newbie 8 * New user
		</example>
	@seealso:
		<a href="nick.kvihelp">NICK</a>
*/

bool KviUserParser::parseCmd_USER(KviCommand *c)
{
	// USER :username host server [desc_str]
	if(!processCmdFinalPart(c))return false;
	KviStr user;
	c->m_buffer.getToken(user,' ');
	KviStr mode;
	c->m_buffer.getToken(mode,' ');
	KviStr server;
	c->m_buffer.getToken(server,' ');
	if(!server.hasData())return recoverableError(c,KVI_ERROR_MissingParameter,"USER");
	if(!m_pSocket->sendFmtData("USER %s %s %s :%s",user.ptr(),mode.ptr(),server.ptr(),c->m_buffer.ptr()))return notConnectedToServer(c,"USER");
	return true;
}

/*
	@command: QUIT
	@short:
		Terminates the current IRC connection or the entire application
	@syntax:
		quit [-f] [&lt;quit message&gt;]<br>
		quit -q
	@description:
		Terminates the current IRC session.<br>
		By default this command sends a QUIT message
		and waits for the server to close the connection.<br>
		If you want to force KVIrc to close the connection
		immediately after sending the QUIT message you must use the -f switch.<br>
		Forcing the connection may cause your quit message to not be
		displayed to the other IRC users; most likely it will be replaced
		by a 'Connection Closed', 'Connection reset by peer',
		or 'EOF from client'.<br>
		If the -q switch is specified, this command quits KVIrc immediately.
	@examples:
		<example>
		quit Time to sleep
		</example>
*/

bool KviUserParser::parseCmd_QUIT(KviCommand *c)
{
	// QUIT [-f] <quit-message>
	// QUIT -q
	// -f = force brutal quit
	if(!extractSwitches(c))return false;
	bool bForce = c->hasSwitch('f');
	if(c->hasSwitch('q'))g_pApp->slot_safeQuit();

	if(!processCmdFinalPart(c))return false;

	if(c->m_buffer.isEmpty()){
		if(!m_pSocket->sendData("QUIT"))return notConnectedToServer(c,"QUIT");
	} else {
		if(!m_pSocket->sendFmtData("QUIT :%s",c->m_buffer.ptr()))return notConnectedToServer(c,"QUIT");
	}
	m_pFrm->m_global.bSentQuit = true;
	if(bForce)m_pFrm->disconnectFromServer(); //Force brutal quit...
	return true;
}

/*
	@command: NEWSESSION
	@short:
		Opens a new session
	@syntax:
		newsession
	@description:
		Opens a new KVIrc session.<br>
		Equivalant to <a href="newswindow.kvihelp">NEWSWINDOW</a>.
	@seealso:
		<a href="newswindow.kvihelp">NEWSWINDOW</a>
*/

/*
	@command: NEWSWINDOW
	@short:
		Opens a new session
	@syntax:
		newswindow
	@description:
		Opens a new KVIrc session.<br>
		Equivalant to <a href="newsession.kvihelp">NEWSESSION</a>.
	@seealso:
		<a href="newsession.kvihelp">NEWSESSION</a>
*/

bool KviUserParser::parseCmd_NEWSWINDOW(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	g_pApp->createNewFrame();
	return true;
}


/*
	@command: PARSE
	@short:
		Parses (and executes) an external script file
	@return:
		Propagates the return value of the command sequence in the file
	@syntax:
		parse &lt;filename&gt; [&lt;parameters&gt;]
	@description:
		Reads a sequence of commands from the file &lt;filename&gt; and executes it.<br>
		You can use files as aliases in this way; the commands in files use exactly the same syntax.<br>
		If you specify some parameters, they will be passed as the $1..$9 identifiers.<br>
		$0 will contain the &lt;filename&gt;, $# the number of parameters passed and
		$@ the entire parameter string without modifications.<br>
	@examples:
		This will "execute" the script file "clonescan.script"
		passing #linux as the first parameter.
		<example>
		parse /usr/local/kvirc/clonescan.script #linux
		</example>
		If you have to give someone the code for an alias
		you can ship it in a such file:
		<example>
		# Script file &lt;yourAliasName&gt;.kviscript
		<a href="echo.kvihelp">echo</a> Loading alias &lt;yourAliasName&gt;...
		<a href="alias.kvihelp">alias</a> &lt;yourAliasName&gt; {
		@tab@&lt;code for your alias here&gt;
		}
		<a href="echo.kvihelp">echo</a> Alias &lt;yourAliasName&gt; loaded.
		</example>
		Then the user will be able to load that alias
		simply by PARSING the file.
		<example>
		parse &lt;yourAliasName&gt;.kviscript
		</example>
*/

bool KviUserParser::parseCmd_PARSE(KviCommand *c)
{
	// parse <filename>
	if(!processCmdFinalPart(c))return false;
	KviStr fileName;
	c->m_buffer.getToken(fileName,' ');
	if(fileName.isEmpty()){
		// No file name specified, ask it ...(async)
		KviAsyncFileDialog *pDlg = new KviAsyncFileDialog(this,c->m_wnd);
		pDlg->setJob("if($strlen($dialogresult))parse $dialogresult");
		pDlg->openFileName();
		return true;
	}
	KviStr fileBuffer;
	if(!kvi_loadFile(fileName.ptr(),fileBuffer)){
		c->setError(KVI_ERROR_CantOpenFileForReading,"PARSE",fileName.ptr());
		return false;
	}
	
	// First check if the file is an ascii file at all
	int len = fileBuffer.len();
	if(len == 0)return recoverableError(c,KVI_ERROR_NotAValidScriptFile,"PARSE",fileName.ptr());
	if(len > 30)len = 30;
	const char *fB = fileBuffer.ptr();
	while(len && *fB){
		if(!isascii(*fB))return recoverableError(c,KVI_ERROR_NotAValidScriptFile,"PARSE",fileName.ptr());
		fB++;
		len--;
	}
	KviCommand newcmd(fileBuffer.ptr(),c->m_wnd);
	newcmd.setParams(fileName,c->m_buffer.ptr());
	if(!execCommandBuffer(&newcmd)){
		if(newcmd.hasError()){
			printError(&newcmd,fileBuffer.ptr());
			return false;
		}
	}
	c->setReturnValue(newcmd.m_retBuffer.ptr());
	return true;
}

/*
	@command: HALT
	@short:
		Stops the current command sequence
	@syntax:
		halt
	@description:
		Stops the currend command sequence.<br>
		It is useful in aliases, popups and events.<br>
		In many event handlers this command stops the event execution and
		also some KVIrc output.<br>
	@examples:
		<example>
			%tmp = 1
			if(%tmp)halt
			echo \%tmp is zero! (%tmp)
		</example>
*/

bool KviUserParser::parseCmd_HALT(KviCommand *c)
{
	processCmdFinalPart(c);
	return false;
}

/*
	@command: DEBUG
	@short:
		Debug :)
	@syntax:
		debug dump_variables<br>
		debug dump_dictionaries<br>
		debug dump_aliases<br>
		debug dump_toplevel<br>
		debug dump_objects<br>
		debug dump_pending_dns<br>
		debug dump_widget &lt;pointer&gt;<br>
		debug dump_classes<br>
		debug dump_script_objects<br>
	@description:
		Dumps internal states.<br>
		It is a multipurpose command used in the development stage.<br>
		This command works only if KVIrc was compiled in debug mode.<br>
*/

bool KviUserParser::parseCmd_DEBUG(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	if(!processCmdFinalPart(c))return false;
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_variables")){
		c->m_wnd->output(KVI_OUT_KVIRC,"Variable cache dump:");
		QList<KviVariable> * l=g_pVarCache->variableList();
		for(KviVariable * v=l->first();v;v=l->next()){
			c->m_wnd->output(KVI_OUT_KVIRC,"%s: %s",v->szName.ptr(),v->szValue.ptr());
		}
		c->m_wnd->output(KVI_OUT_KVIRC,"Total: %d variables cached",l->count());
		return true;
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_dictionaries")){
		c->m_wnd->output(KVI_OUT_KVIRC,"Dictionaries dump:");
		QList<KviDictionary> * d=g_pVarCache->dictList();
		for(KviDictionary * dict=d->first();dict;dict=d->next()){
			c->m_wnd->output(KVI_OUT_KVIRC,"### Dictionary %s",dict->szName.ptr());
			QList<KviVariable> * l=dict->m_pVarCache->variableList();
			for(KviVariable * v=l->first();v;v=l->next()){
				c->m_wnd->output(KVI_OUT_KVIRC,"%s: %s",v->szName.ptr(),v->szValue.ptr());
			}
			c->m_wnd->output(KVI_OUT_KVIRC,"### Total: %d variables cached",l->count());			
		}
		c->m_wnd->output(KVI_OUT_KVIRC,"Total: %d dictionaries cached",d->count());
		return true;		
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_aliases")){
		c->m_wnd->output(KVI_OUT_KVIRC,"Aliases dump:");
		QList<KviAlias> * l=g_pAliasManager->aliasList();
		for(KviAlias *a=l->first();a;a=l->next()){
			c->m_wnd->output(KVI_OUT_KVIRC,"ALIAS %s:",a->szName.ptr());
			c->m_wnd->outputNoFmt(KVI_OUT_KVIRC,a->szBuffer.ptr());
			c->m_wnd->outputNoFmt(KVI_OUT_KVIRC,"ENDALIAS");
		}
		c->m_wnd->output(KVI_OUT_KVIRC,"Total: %d aliases cached",l->count());
		return true;
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_toplevel")){
		c->m_wnd->output(KVI_OUT_KVIRC,"Top level widgets dump:");
		QWidgetList *l = g_pApp->topLevelWidgets();
		l->setAutoDelete(false);
		QWidgetListIt it(*l);
		int cnt = 0;
		while(it.current()){
			cnt++;
			c->m_wnd->output(KVI_OUT_KVIRC,"Widget: %s, class %s, %s, rect = %d,%d,%d,%d",
				it.current()->name(),it.current()->className(),
				it.current()->isVisible() ? "visible" : "hidden",
				it.current()->x(),it.current()->y(),it.current()->width(),it.current()->height());
			++it;
		}
		delete l;
		c->m_wnd->output(KVI_OUT_KVIRC,"Total: %d top level widgets",cnt);
		return true;
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_objects")){
		c->m_wnd->output(KVI_OUT_KVIRC,"Object dump:");
		QWidgetList *l = g_pApp->topLevelWidgets();
		l->setAutoDelete(false);
		QWidgetListIt it(*l);
		KviStr spacing = "    ";
		while(it.current()){
			if(it.current()->isWidgetType() || (!c->hasSwitch('w')))
			{
				c->m_wnd->output(KVI_OUT_KVIRC,"Ptr %u: Top level object : %c%s%c, class %s, %s, rect = %d, %d, %d, %d",
					(unsigned int)it.current(),
					KVI_TEXT_BOLD,it.current()->name(),KVI_TEXT_BOLD,
					it.current()->className(),
					it.current()->isVisible() ? "visible" : "hidden",
					it.current()->x(),it.current()->y(),it.current()->width(),it.current()->height());
				dumpChildObjects(c->m_wnd,it.current(),spacing.ptr(),c->hasSwitch('w'));
			}
			++it;
		}
		delete l;
		return true;
	}
	if(kvi_strEqualCIN(c->m_buffer.ptr(),"dump_widget",11))
	{
		c->m_buffer.cutLeft(11);
		c->m_buffer.stripWhiteSpace();
		bool bOk = false;
		unsigned int ptr = c->m_buffer.toUInt(&bOk);
		if(bOk)
		{
			QWidget *w = (QWidget *)ptr;
			c->m_wnd->output(KVI_OUT_KVIRC,"Ptr %u: Widget with class %s",ptr,w->className());
			c->m_wnd->output(KVI_OUT_KVIRC,"  Qt properties:");
			c->m_wnd->output(KVI_OUT_KVIRC,"    Parent widget: %u",w->parent());
			c->m_wnd->output(KVI_OUT_KVIRC,"    Relative geometry: %d,%d,%d,%d",w->x(),w->y(),w->width(),w->height());
			c->m_wnd->output(KVI_OUT_KVIRC,"    Object name: %s",w->name());
			c->m_wnd->output(KVI_OUT_KVIRC,"    Visible ?: %s",w->isVisible() ? "Yes" : "No");
			c->m_wnd->output(KVI_OUT_KVIRC,"    WFlags: %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d",
				w->testWFlags(1 << 31),
				w->testWFlags(1 << 30),
				w->testWFlags(1 << 29),
				w->testWFlags(1 << 28),
				w->testWFlags(1 << 27),
				w->testWFlags(1 << 26),
				w->testWFlags(1 << 25),
				w->testWFlags(1 << 24),
				w->testWFlags(1 << 23),
				w->testWFlags(1 << 22),
				w->testWFlags(1 << 21),
				w->testWFlags(1 << 20),
				w->testWFlags(1 << 19),
				w->testWFlags(1 << 18),
				w->testWFlags(1 << 17),
				w->testWFlags(1 << 16),
				w->testWFlags(1 << 15),
				w->testWFlags(1 << 14),
				w->testWFlags(1 << 13),
				w->testWFlags(1 << 12),
				w->testWFlags(1 << 11),
				w->testWFlags(1 << 10),
				w->testWFlags(1 << 9),
				w->testWFlags(1 << 8),
				w->testWFlags(1 << 7),
				w->testWFlags(1 << 6),
				w->testWFlags(1 << 5),
				w->testWFlags(1 << 4),
				w->testWFlags(1 << 3),
				w->testWFlags(1 << 2),
				w->testWFlags(1 << 1),
				w->testWFlags(1)
			);
			c->m_wnd->output(KVI_OUT_KVIRC,"    WState: %d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d%d",
				w->testWState(1 << 31),
				w->testWState(1 << 30),
				w->testWState(1 << 29),
				w->testWState(1 << 28),
				w->testWState(1 << 27),
				w->testWState(1 << 26),
				w->testWState(1 << 25),
				w->testWState(1 << 24),
				w->testWState(1 << 23),
				w->testWState(1 << 22),
				w->testWState(1 << 21),
				w->testWState(1 << 20),
				w->testWState(1 << 19),
				w->testWState(1 << 18),
				w->testWState(1 << 17),
				w->testWState(1 << 16),
				w->testWState(1 << 15),
				w->testWState(1 << 14),
				w->testWState(1 << 13),
				w->testWState(1 << 12),
				w->testWState(1 << 11),
				w->testWState(1 << 10),
				w->testWState(1 << 9),
				w->testWState(1 << 8),
				w->testWState(1 << 7),
				w->testWState(1 << 6),
				w->testWState(1 << 5),
				w->testWState(1 << 4),
				w->testWState(1 << 3),
				w->testWState(1 << 2),
				w->testWState(1 << 1),
				w->testWState(1)
			);
//			c->m_wnd->output(KVI_OUT_KVIRC,"    WFlags: %u",(unsigned int)w->getWFlags());
			c->m_wnd->output(KVI_OUT_KVIRC,"  X properties:");
			XWindowAttributes a;
			XGetWindowAttributes(w->x11Display(),w->handle(),&a);
			
			c->m_wnd->output(KVI_OUT_KVIRC,"    Depth: %d",a.depth);
//			c->m_wnd->output(KVI_OUT_KVIRC,"    Class: %d (%s)",a.class,(a.class == InputOnly) ? "InputOnly" : "InputOutput");
			c->m_wnd->output(KVI_OUT_KVIRC,"    BackingStore: %d (%s)",a.backing_store,(a.backing_store == NotUseful) ? "NotUseful" : ((a.backing_store == WhenMapped) ? "WhenMapped" : "Always"));
			c->m_wnd->output(KVI_OUT_KVIRC,"    SaveUnder ?: %s",a.save_under ? "Yes" : "No");
			c->m_wnd->output(KVI_OUT_KVIRC,"    OverrideRedirect ?: %s",a.override_redirect ? "Yes": "No");
			c->m_wnd->output(KVI_OUT_KVIRC,"    MapState: %d (%s)",a.map_state,(a.map_state == IsUnmapped) ? "IsUnmapped" : ((a.map_state == IsUnviewable) ? "IsUnviewable" : "IsViewable"));
		} else c->m_wnd->output(KVI_OUT_ERROR,"Invalid pointer (%s)",c->m_buffer.ptr());
		return true;
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_pending_dns")){
		c->m_wnd->output(KVI_OUT_KVIRC,"Pending DNS calls waiting for WHOIS return");
		if(!m_pFrm->m_global.pDnsWhoisPending->isEmpty()){
			for(KviStr *s=m_pFrm->m_global.pDnsWhoisPending->first();s;s=m_pFrm->m_global.pDnsWhoisPending->next()){
				c->m_wnd->output(KVI_OUT_KVIRC,"DNS : %s",s->ptr());
			}
		} else c->m_wnd->outputNoFmt(KVI_OUT_KVIRC,"No pending DNS calls");
		return true;
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_classes"))
	{
		c->m_wnd->output(KVI_OUT_KVIRC,"Class definitions dump:");
		m_pScriptObjectController->dumpClasses(c->m_wnd);
		return true;
	}
	if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"dump_script_objects"))
	{
		c->m_wnd->output(KVI_OUT_KVIRC,"Script objects dump:");
		m_pScriptObjectController->dumpObjects(c->m_wnd);
		return true;
	}
	//missing or unrecognized option
	c->m_wnd->outputNoFmt(KVI_OUT_ERROR,"Unrecognized debug option");
	return true;
}

void KviUserParser::dumpChildObjects(KviWindow *pWnd,QObject * parent,const char *spacing,bool bWidgetsOnly)
{
	const QObjectList *l = parent->children();
	if(!l)return;
	if(l->isEmpty())return;
	QObjectListIt it(*l);
	KviStr sp(spacing);
	sp.append("    ");
	while(it.current()){
		if(it.current()->isWidgetType())
		{
			pWnd->output(KVI_OUT_KVIRC,"%sPtr %u: Object : %c%s%c, class %s",
				spacing,(unsigned int)it.current(),KVI_TEXT_BOLD,it.current()->name(),KVI_TEXT_BOLD,it.current()->className());
			dumpChildObjects(pWnd,it.current(),sp.ptr(),bWidgetsOnly);
		}
		++it;
	}
}

/*
	@command: KICK
	@short:
		Kicks users from a channel
	@syntax:
		kick &lt;channel&gt; &lt;nick_list&gt; [reason]
	@description:
		Kicks users from a specified channel with the specified reason.<br>
		Obviously you need to be an operator on the channel.<br>
		If the [reason] is not specified, the default reason (Misc options dialog)
		is used.<br>
		KVIrc sends one kick message for each nick in &lt;nick_list&gt;
	@examples:
		<example>
			kick #atmosphere Pragma,]Diabl0[ Go sit in a corner...
		</example>
	@seealso:
		<a href="invite.kvihelp">INVITE</a>
*/

bool KviUserParser::parseCmd_KICK(KviCommand *c)
{
	// KICK <channel> <nicknamelist> [reason]
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr tok1;
	c->m_buffer.getToken(tok1,' ');
	KviStr tok2;
	c->m_buffer.getToken(tok2,' ');

	if(tok1.isEmpty())return recoverableError(c,KVI_ERROR_MissingChannelName,"KICK");

	if(tok2.isEmpty())return true; //empty list of items
	if(c->m_buffer.isEmpty())c->m_buffer=g_pOptions->m_szKickMessage;

	const char *items = tok2.ptr();

	KviStr tmp;

	while(*items){
		items = kvi_extractToken(tmp,items,',');
		if(!m_pSocket->sendFmtData("KICK %s %s :%s",tok1.ptr(),tmp.ptr(),c->m_buffer.ptr()))return notConnectedToServer(c,"KICK");
	}
	return true;
}

bool KviUserParser::parseMultipleModeCommand(KviCommand *c,const char *cmdName,bool bModeAdd,char flag)
{
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr tok1;
	c->m_buffer.getToken(tok1,' ');

	if(tok1.isEmpty())return true; //empty list of items

	const char * chan;
	const char * items;

	if(c->m_buffer.hasData()){ //token 1 is assumed to be the channel name
		chan = tok1.ptr();
		items = c->m_buffer.ptr();
	} else {
		if((*(tok1.ptr()) == '#') || (*(tok1.ptr()) == '&') || (*(tok1.ptr()) == '!')){
			// a channel name, but "empty" list of items
			return true;
		}

		if(c->m_wnd->type() != KVI_WND_TYPE_CHANNEL)return recoverableError(c,KVI_ERROR_ThisIsNotAChannel,cmdName);
		chan = c->m_wnd->caption();
		items = tok1.ptr();
	}

	int nMesgs = 0;

	KviStr tmp;

	if(*items){
		KviStr param;
		KviStr szFlags;
		int i=0;
		while(*items){
			items = kvi_extractToken(tmp,items,',');
			if(param.hasData())param+=" ";
			param += tmp;
			szFlags+=flag;
			i++;
			if(i == 3){
				if(!m_pSocket->sendFmtData("MODE %s %c%s %s",chan,bModeAdd ? '+' : '-',
					szFlags.ptr(),param.ptr()))return notConnectedToServer(c,cmdName);
				param = "";
				szFlags = "";
				i = 0;
				nMesgs++;
			}
		}
		if(i != 0){
			if(!m_pSocket->sendFmtData("MODE %s %c%s %s",chan,bModeAdd ? '+' : '-',
				szFlags.ptr(),param.ptr()))return notConnectedToServer(c,cmdName);
			nMesgs++;
		}
	}
	tmp.setNum(nMesgs);
	c->setReturnValue(tmp.ptr());
	return true;
}

/*
	@command: OWNER
	@short:
		Gives owner status to a user*
	@syntax:
		owner [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Gives owner status to users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +q</a> command.<br>
		To use this command, you have to be an IRC operator.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
		* Please note that the 'q' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			owner #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			owner <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_OWNER(KviCommand *c)
{
	return parseMultipleModeCommand(c,"OWNER",true,'q');
}

/*
	@command: DEOWNER
	@short:
		Removes owner status from a user*
	@syntax:
		dewner [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Removes owner status from users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -q</a> command.<br>
		To use this command, you have to be an IRC operator.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
		* Please note that the 'q' MODE flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			deowner #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			deowner <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_DEOWNER(KviCommand *c)
{
	return parseMultipleModeCommand(c,"DEOWNER",false,'q');
}

/*
	@command: OP
	@short:
		Gives operator status to a user
	@syntax:
		op [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Gives operator status to users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +o</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
	@examples:
		Single MODE command
		<example>
			op #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			op <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_OP(KviCommand *c)
{
	return parseMultipleModeCommand(c,"OP",true,'o');
}

/*
	@command: DEOP
	@short:
		Removes operator status from a user
	@syntax:
		deop [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Removes operator status from users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -o</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
	@examples:
		Single MODE command
		<example>
			deop #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			deop <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_DEOP(KviCommand *c)
{
	return parseMultipleModeCommand(c,"DEOP",false,'o');
}

/*
	@command: HALFOP
	@short:
		Gives half-operator status to a user
	@syntax:
		halfop [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Gives half-operator status to users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +h</a> command.<br>
		To use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
		* Please note that the 'h' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			halfop #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			halfop <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_HALFOP(KviCommand *c)
{
	return parseMultipleModeCommand(c,"HALFOP",true,'h');
}

/*
	@command: DEHALFOP
	@short:
		Removes half-operator status from a user
	@syntax:
		dehalfop [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Removes half-operator status from users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -h</a> command.<br>
		To use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
		* Please note that the 'h' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			dehalfop #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			dehalfop <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_DEHALFOP(KviCommand *c)
{
	return parseMultipleModeCommand(c,"DEHALFOP",false,'h');
}

/*
	@command: VOICE
	@short:
		Gives voice status to a user
	@syntax:
		voice [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Gives voice status to users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +v</a> command.<br>
		To use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
	@examples:
		Single MODE command
		<example>
			voice #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			voice <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_VOICE(KviCommand *c)
{
	return parseMultipleModeCommand(c,"VOICE",true,'v');
}

/*
	@command: DEVOICE
	@short:
		Removes voice status from a user
	@syntax:
		devoice [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Removes voice status from users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -v</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
	@examples:
		Single MODE command
		<example>
			devoice #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			devoice <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_DEVOICE(KviCommand *c)
{
	return parseMultipleModeCommand(c,"DEVOICE",false,'v');
}

/*
	@command: USEROP
	@short:
		Gives user operator status to a user*
	@syntax:
		userop [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Gives user operator status to users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +u</a> command.<br>
		To use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
		* Please note that the 'u' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			userop #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			userop <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_USEROP(KviCommand *c)
{
	return parseMultipleModeCommand(c,"USEROP",true,'u');
}

/*
	@command: DEUSEROP
	@short:
		Removes user operator status from a user*
	@syntax:
		deuserop [&lt;channel&gt;] &lt;nick_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Removes user operator status from users on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -u</a> command.<br>
		To use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) nicknames
		in the &lt;nick_list&gt;
		* Please note that the 'u' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			deuserop #atmosphere Pragma,MalboroLi
		</example>
		Two MODE commands
		<example>
			deuserop <a href="s_chan.kvihelp">$chan</a> Pragma,MalboroLi,Arter|0,BuTi
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="deop.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_DEUSEROP(KviCommand *c)
{
	return parseMultipleModeCommand(c,"DEUSEROP",false,'u');
}

/*
	@command: BAN
	@short:
		Sets ban masks on a channel
	@syntax:
		ban [&lt;channel&gt;] &lt;mask_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Sets ban masks on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +b</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) masks
		in the &lt;mask_list&gt;
	@examples:
		Single MODE command
		<example>
			ban #atmosphere Pragma!*@*,MalboroLi!*ciao@*
		</example>
		Two MODE commands
		<example>
			ban <a href="s_chan.kvihelp">$chan</a> Pragma!*@*,MalboroLi!*@*,Arter|0!*@*,*!*@*.com
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="unban.kvihelp">UNBAN</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_BAN(KviCommand *c)
{
	return parseMultipleModeCommand(c,"BAN",true,'b');
}

/*
	@command: UNBAN
	@short:
		Unsets ban masks on a channel
	@syntax:
		unban [&lt;channel&gt;] &lt;mask_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Unsets ban masks on a channel; it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -b</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) masks
		in the &lt;mask_list&gt;
	@examples:
		Single MODE command
		<example>
			unban #atmosphere Pragma!*@*,MalboroLi!*ciao@*
		</example>
		Two MODE commands
		<example>
			unban <a href="s_chan.kvihelp">$chan</a> Pragma!*@*,MalboroLi!*@*,Arter|0!*@*,*!*@*.com
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="ban.kvihelp">BAN</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_UNBAN(KviCommand *c)
{
	return parseMultipleModeCommand(c,"UNBAN",false,'b');
}

/*
	@command: EXCEPT
	@short:
		Sets ban exception masks for a channel*
	@syntax:
		except [&lt;channel&gt;] &lt;mask_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Sets ban exception masks for a channel: it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE +e</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) masks
		in the &lt;mask_list&gt;.
		* Please note that the 'e' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			except #atmosphere Pragma!*@*,MalboroLi!*ciao@*
		</example>
		Two MODE commands
		<example>
			except <a href="s_chan.kvihelp">$chan</a> Pragma!*@*,MalboroLi!*@*,Arter|0!*@*,*!*@*.com
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="ban.kvihelp">BAN</a>,
		<a href="unban.kvihelp">UNBAN</a>,
		<a href="unexcept.kvihelp">UNEXCEPT</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_EXCEPT(KviCommand *c)
{
	return parseMultipleModeCommand(c,"EXCEPT",true,'e');
}

/*
	@command: UNEXCEPT
	@short:
		Unsets ban exception masks for a channel*
	@syntax:
		unexcept [&lt;channel&gt;] &lt;mask_list&gt;
	@return:
		The number of MODE messages effectively sent to the server
	@description:
		Unsets ban exception masks for a channel: it is a KVIrc extension
		to the IRC <a href="mode.kvihelp">MODE -e</a> command.<br>
		Obviously, to use this command, you have to be an operator on the channel.<br>
		The &lt;channel&gt; param is optional if this command is executed in a channel window.<br>
		KVIrc will send a single MODE command for each group of three (or less) masks
		in the &lt;mask_list&gt;.
		* Please note that the 'e' channel mode flag is an extension to RFC1459 and may not be supported
		on all servers.<br>
	@examples:
		Single MODE command
		<example>
			unexcept #atmosphere Pragma!*@*,MalboroLi!*ciao@*
		</example>
		Two MODE commands
		<example>
			unexcept <a href="s_chan.kvihelp">$chan</a> Pragma!*@*,MalboroLi!*@*,Arter|0!*@*,*!*@*.com
		</example>
	@seealso:
		<a href="owner.kvihelp">OWNER</a>,
		<a href="deowner.kvihelp">DEOWNER</a>,
		<a href="op.kvihelp">OP</a>,
		<a href="deop.kvihelp">DEOP</a>,
		<a href="halfop.kvihelp">HALFOP</a>,
		<a href="dehalfop.kvihelp">DEHALFOP</a>,
		<a href="voice.kvihelp">VOICE</a>,
		<a href="devoice.kvihelp">DEVOICE</a>,
		<a href="userop.kvihelp">USEROP</a>,
		<a href="deuserop.kvihelp">DEUSEROP</a>,
		<a href="ban.kvihelp">BAN</a>,
		<a href="unban.kvihelp">UNBAN</a>,
		<a href="except.kvihelp">EXCEPT</a>,
		<a href="mode.kvihelp">MODE</a>
*/

bool KviUserParser::parseCmd_UNEXCEPT(KviCommand *c)
{
	return parseMultipleModeCommand(c,"UNEXCEPT",false,'e');
}


/*
	@command: DESTROY
	@short:
		Destroys an object
	@syntax:
		destroy &lt;object_id&gt;
	@description:
		Destroys an object, freeing all of the related resources.<br>
		All of its children objects are also destroyed.<br>
		<b>If this command is called from a function call, event handler
		or signal slot of an object, the destruction is delayed until
		the function, handler or slot terminates.</b><br>
		If you destroy the [fnc]$root[/fnc] object, it will be automatically recreated:<br>
		this is a fast way to clean up all of the objects that belong to the
		current server window.<br>
	@seealso
		[fnc]$new[/fnc]()<br>
		<a href="syntax_objects.kvihelp">Objects documentation</a>
*/

bool KviUserParser::parseCmd_DESTROY(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())
	{
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_MissingObjectId,"DESTROY");
	}
	KviScriptObject * o = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o)return recoverableError(c,KVI_ERROR_ObjectNotFound,"DESTROY",c->m_buffer.ptr());
	if(!(o->parentObject()))
	{
		// warning !...it is the $root object
		o->dieAndRecreate(c->hasThisId());
	} else o->die(c->hasThisId());
	return true;
}

/*
	@command: CLEAROBJECTS
	@short:
		Clears the objects state
	@syntax:
		clearobjects [classname]
	@description:
		This command is useful in testing or in complex object oriented scripting.<br>
		If "classname" is given, it destroys all of the objects
		that inherit that class, and then removes the class definition with all of the
		derived classes.<br>
		If no "classname" is given, all of the objects are destroyed and all
		the non-builtin classes definitions are removed.<br>
		Classes cannot be defined twice, so you need to clear them before
		you can redefine them to fix some behaviour.<br>
		<b>This command <b>may NOT be called from an object function, object event handler or a slot</b>:<br>
		it may destroy the caller object "in the wrong moment" leading usually to a SIGSEGV.</b><br>
		Be careful :).<br>
	@seealso:
		[fnc]$new[/fnc]()<br>
		[fnc]$classDefined[/fnc]()<br>
		<a href="syntax_objects.kvihelp">Objects documentation</a>
*/

bool KviUserParser::parseCmd_CLEAROBJECTS(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())m_pScriptObjectController->globalReset();
	else if(!m_pScriptObjectController->killClass(c->m_buffer.ptr()))
	{
		return recoverableError(c,KVI_ERROR_UnknownObjectClass,"CLEAROBJECTS",c->m_buffer.ptr());
	}
	return true;
}


//
//bool KviUserParser::parseCmd_OBJ_SETFIELD(KviCommand *c)
//{
//	if(!processCmdSingleToken(c))return false;
//	if(c->m_buffer.isEmpty())
//	{
//		if(!processCmdFinalPart(c))return false;
//		return recoverableError(c,KVI_ERROR_MissingObjectId,"OBJ_SETFIELD");
//	}
//	KviScriptObject * o = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
//	if(!o)return recoverableError(c,KVI_ERROR_ObjectNotFound,"OBJ_SETFIELD",c->m_buffer.ptr());
//	c->clearBuffer();
//	if(!processCmdSingleToken(c))return false;
//	if(c->m_buffer.isEmpty())
//	{
//		if(!processCmdFinalPart(c))return false;
//		return recoverableError(c,KVI_ERROR_MissingObjectField,"OBJ_SETFIELD");
//	}
//	KviStr szField = c->m_buffer;
//	c->clearBuffer();
//	if(!processCmdFinalPart(c))return false;
//	o->setField(szField.ptr(),c->m_buffer.ptr());
//	return true;
//}

/*
	@command: OBJ_SETEVENT
	@short:
		Sets an object's event handler
	@syntax:
		OBJ_SETEVENT(&lt;object_id&gt;,&lt;object_event_name&gt;)&lt;commang&gt;
	@description:
		Sets an object's event handler.<br>
	@seealso:
		<a href="obj_clearevent.kvihelp">obj_clearevent</a><br>
		<a href="syntax_objects.kvihelp">Objects documentation</a>
*/

bool KviUserParser::parseCmd_OBJ_SETEVENT(KviCommand *c)
{
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){ c->setError(KVI_ERROR_OpenParenthesisExpected,"OBJ_SETEVENT",c->m_ptr); return false; }
	++(c->m_ptr);
	KviStr id,evName;
	if(!processFncSingleParam(c,id))return false;
	if(!processFncFinalPart(c,evName))return false;

	if(id.isEmpty())
	{
		c->setError(KVI_ERROR_MissingObjectId,"OBJ_SETEVENT",c->m_ptr);
	}
	KviScriptObject * o = m_pScriptObjectController->findObjectById(id.ptr());
	if(!o)return c->setError(KVI_ERROR_ObjectNotFound,"OBJ_SETEVENT",id.ptr());

	if(evName.isEmpty())return c->setError(KVI_ERROR_MissingObjectEventName,"OBJ_SETEVENT");

	c->skipWhitespace();
	const char *aux = c->m_ptr;
	if(!skipCommand(c))return false;
	KviStr evHandler(aux,c->m_ptr);
	o->setEventHandler(evName.ptr(),evHandler.ptr());
	return true;
}

bool KviUserParser::skipObj_setEvent(KviCommand *c)
{
//	c->m_ptr += 12;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){ c->setError(KVI_ERROR_OpenParenthesisExpected,"OBJ_SETEVENT",c->m_ptr); return false; }
	if(!skipExpressionBody(c))return false; //maybe problems here ???
	c->skipWhitespace();
	return skipCommand(c);
}


/*
	@command: OBJ_CLEAREVENT
	@short:
		Clears an object's event handler
	@syntax:
		OBJ_CLEAREVENT &lt;object_id&gt; &lt;object_event_name&gt;
	@description:
		Clears an object's event handler.<br>
	@seealso:
		<a href="obj_clearevent.kvihelp">obj_setevent</a><br>
		<a href="syntax_objects.kvihelp">Objects documentation</a>
*/

bool KviUserParser::parseCmd_OBJ_CLEAREVENT(KviCommand *c)
{
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())
	{
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_MissingObjectId,"OBJ_CLEAREVENT");
	}
	KviScriptObject * o = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o)return recoverableError(c,KVI_ERROR_ObjectNotFound,"OBJ_CLEAREVENT",c->m_buffer.ptr());
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())
	{
		return recoverableError(c,KVI_ERROR_MissingObjectEventName,"OBJ_CLEAREVENT");
	}
	o->removeEventHandler(c->m_buffer.ptr());
	return true;
}

/*
	@command: OBJ_TRIGGEREVENT
	@short:
		Triggers an event for a specified object
	@syntax:
		OBJ_TRIGGEREVENT &lt;object_id&gt; &lt;object_event_name&gt; [parameters]
	@description:
		Triggers a specified event for a specified object.<br>
		The parameters are passed as positional parameters to the event handler.<br>
		If no event handler has been set, this command does nothing.<br>
	@seealso:
		<a href="obj_clearevent.kvihelp">obj_setevent</a><br>
		<a href="syntax_objects.kvihelp">Objects documentation</a>
*/

bool KviUserParser::parseCmd_OBJ_TRIGGEREVENT(KviCommand *c)
{
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())
	{
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_MissingObjectId,"OBJ_TRIGGEREVENT");
	}
	KviScriptObject * o = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o)return recoverableError(c,KVI_ERROR_ObjectNotFound,"OBJ_TRIGGEREVENT",c->m_buffer.ptr());
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())
	{
		return recoverableError(c,KVI_ERROR_MissingObjectEventName,"OBJ_TRIGGEREVENT");
	}
	KviStr evName = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	
	o->triggerEvent(evName.ptr(),c->m_buffer);
	return true;
}


/*
	@command: QUERY
	@short:
		Opens a query window
	@syntax:
		query &lt;nick_list&gt; [&lt;text&gt;]
	@description:
		Opens query windows for each nickname in the nick list.<br>
		If &lt;text&gt; is specified, it is sent to each window opened.
	@examples:
		<example>
		query Pragma,<a href="s_me.kvihelp">$me</a>
		</example>
*/

bool KviUserParser::parseCmd_QUERY(KviCommand *c)
{
	// QUERY nick[[[,nick],nick]...] [text]
	if(!processCmdFinalPart(c))return false;

	// extract the first token
	KviStr listOfNicks;
	c->m_buffer.getToken(listOfNicks,' ');
	if(listOfNicks.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"QUERY");

	KviStr nick;
	const char *aux = listOfNicks.ptr();
	// Now loop...
	while(*aux){
		aux = kvi_extractToken(nick,aux,',');
		if(nick.hasData()){
			// Look if it exists
			KviQuery * query = m_pFrm->raiseOrCreateQuery(nick.ptr());
//#ifdef _KVI_DEBUG_CLASS_NAME_
//	#warning "The query should be created after a QTimer delay!"
//#endif
//			if(query){
//				// Bring it to top...
//				if(query->isMinimized())query->restore();
//				query->raise();
//				query->setFocus();
//			} else query = m_pFrm->createQuery(nick.ptr());	//create it
			if(c->m_buffer.hasData())parseUserCommand(c->m_buffer,query);
		}
	}
	return true;
}

/*
	@command: CTCP
	@short:
		Send CTCP request messages
	@syntax:
		ctcp [-s] &lt;target_list&gt; &lt;type&gt; [&lt;parameters&gt;]
	@description:
		Sends CTCP (Client-to-Client Protocol) messages to each
		target in the &lt;target_list&gt;.<br>
		A target may be a nickname or a channel.<br>
		If the [-s] switch is used, no output will be shown.
		The &lt;type&gt; can be anything, but please note that
		many clients will reply only to common ones;<br>
		PING, VERSION, CLIENTINFO, USERINFO, etc.
	@examples:
		<example>
		ctcp Pragma PING
		ctcp Pragma VERSION
		ctcp Pragma MYCTCPTYPE param1 param2
		</example>
	@seealso:
		<a href="ctcpreply.kvihelp">CTCPREPLY</a>
*/

bool KviUserParser::parseCmd_CTCP(KviCommand *c)
{

	// CTCP [-s] <target(or list of targets)> <text>
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');

	// CTCP target[[[,target],target]...] [text]
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr listOfNicks;
	c->m_buffer.getToken(listOfNicks,' ');
	if(listOfNicks.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"CTCP");

	KviStr target;
	const char *aux = listOfNicks.ptr();
	KviStr msg;
	KviStr tmp = kvi_extractToken(msg,c->m_buffer.ptr(),' ');
	msg.toUpper();
	if(tmp.hasData()){
		msg.append(' ');
		msg.append(tmp);
	}

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingCtcpType,"CTCP");

	// Now loop...
	while(*aux){
		aux = kvi_extractToken(target,aux,',');
		if(target.hasData()){
			if(kvi_strEqualNoLocaleCIN(c->m_buffer.ptr(),"PING",4)){
				if(!m_pSocket->sendFmtData("PRIVMSG %s :%cPING %u%c",target.ptr(),0x01,time(0),0x01))
					return notConnectedToServer(c,"CTCP");
			} else {
				if(!m_pSocket->sendFmtData("PRIVMSG %s :%c%s%c",target.ptr(),0x01,c->m_buffer.ptr(),0x01))
					return notConnectedToServer(c,"CTCP");
			}
			if(!bSilent){
//				KviWindow *wnd = m_pFrm->findWindow(target.ptr());
//					if(wnd&&((wnd->type() == KVI_WND_TYPE_CHANNEL)||(wnd->type() == KVI_WND_TYPE_QUERY)))
//						m_pFrm->outputPrivmsg(wnd,KVI_OUT_CTCPREQUEST,m_pFrm->m_global.szCurrentNick.ptr(),
//							m_pFrm->m_global.szCurrentMaskFromServer.ptr(),msg.ptr());
				KviWindow *pOut = g_pOptions->m_bCtcpRequestsToConsole ? m_pConsole : c->m_wnd;
				pOut->output(KVI_OUT_CTCPREQUEST,"-> %s: %s",target.ptr(),msg.ptr());
			}
		}
	}
	return true;
}

/*
	@command: CTCPREPLY
	@short:
		Send CTCP reply messages
	@syntax:
		ctcp [-s] &lt;target_list&gt; &lt;type&gt; [&lt;parameters&gt;]
	@description:
		Sends CTCP (Client-to-Client Protocol) reply messages to each
		target in the &lt;target_list&gt;.<br>
		If the [-s] switch is used, no output will be shown.
		A target may be a nickname or a channel.<br>
	@examples:
		<example>
		ctcpreply Triskelios PING
		ctcpreply Triskelios VERSION
		ctcpreply Triskelios MYCTCPTYPE param1 param2
		</example>
	@seealso:
		<a href="ctcp.kvihelp">CTCP</a>
*/

bool KviUserParser::parseCmd_CTCPREPLY(KviCommand *c)
{
	// CTCPREPLY [-s] <target(or list of targets)> <text>
	if(!extractSwitches(c))return false;
	bool bSilent = c->hasSwitch('s');

	// CTCPREPLY target[[[,target],target]...] [text]
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr listOfNicks;
	c->m_buffer.getToken(listOfNicks,' ');
	if(listOfNicks.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"CTCPREPLY");

	KviStr target;
	const char *aux = listOfNicks.ptr();
	KviStr msg;
	KviStr tmp = kvi_extractToken(msg,c->m_buffer.ptr(),' ');
	msg.toUpper();
	if(tmp.hasData()){
		msg.append(' ');
		msg.append(tmp);
	}

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingCtcpType,"CTCPREPLY");

	// Now loop...
	while(*aux){
		aux = kvi_extractToken(target,aux,',');
		if(target.hasData()){
			if(!m_pSocket->sendFmtData("NOTICE %s :%c%s%c",target.ptr(),0x01,c->m_buffer.ptr(),0x01))
				return notConnectedToServer(c,"CTCPREPLY");
			if(!bSilent){
				KviWindow *pOut = g_pOptions->m_bCtcpRepliesToConsole ? m_pConsole : c->m_wnd;
				pOut->output(KVI_OUT_CTCPREPLY,"-> %s: %s",target.ptr(),msg.ptr());
			}
		}
	}
	return true;
}

/*
	@command: SERVER
	@short:
		Connects to a server
	@syntax:
		server [-p=password] &lt;hostname&gt;[:&lt;port&gt;| &lt;port&gt;]
	@description:
		Attempts a connection to the specified server.<br>
		If [port] is not specified, the default IRC port (6667) is used.<br>
		If you are already connected to a server, this command will quit
		the current connection first.<br>
	@examples:
		<example>
		server irc.eu.dal.net:6665
		server irc.quasarnet.org 7000
		</example>
*/

bool KviUserParser::parseCmd_SERVER(KviCommand *c)
{
	// server [-p=password] <servername> [port]
	if(!extractSwitches(c))return false;
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr server;
	c->m_buffer.getToken(server,' ');

	if(server.hasData()){

		KviStr host;
		server.getToken(host,':');
		if(!c->m_buffer.isUnsignedNum())c->m_buffer = "";
		if(server.isUnsignedNum())c->m_buffer = server;
		g_pOptions->m_pServerManager->iWantThisServerToBeCurrent(host.ptr(),c->m_buffer.ptr());
		if(c->hasSwitch('p')){
			KviStr pass;
			c->getSwitchValue('p',pass);
			g_pOptions->m_pServerManager->setCurrentServerPassword(pass.ptr());
		}
	}
	// Jump out of this handler, call it from the main event loop...
	m_pFrm->doAsyncServerCommandCall();
	return true;
}

/*
	@command: LOG
	@short:
		Turns logging on/off
	@syntax:
		log [-w=&lt;window&gt;] &lt;on|off&gt; [&lt;filename&gt;]
	@description:
		Turns logging on or off for the current window.<br>
		If [filename] is not specified, a default file in the
		KVIrc Log directory is used.<br>
		If the -w switch is specified, the log commands applies
		to the specified window, otherwise to the one in that the command
		is executed in.<br>
*/

/*
#warning "$isLogging(<window>) $logFile(<window>)"
*/

bool KviUserParser::parseCmd_LOG(KviCommand *c)
{
	// /log <on|off> [filename]
	if(!extractSwitches(c))return false;
	if(!processCmdFinalPart(c))return false;

	// extract the first token
	KviStr onOff;
	c->m_buffer.getToken(onOff,' ');
	bool bOff;

	if(kvi_strEqualNoLocaleCI(onOff.ptr(),"on"))bOff = false;
	else if(kvi_strEqualNoLocaleCI(onOff.ptr(),"off"))bOff = true;
	else return recoverableError(c,KVI_ERROR_LogOnOffRequired,"LOG",onOff.ptr());

	KviWindow * wnd = c->m_wnd;
	if(c->hasSwitch('w'))
	{
		KviStr window;
		c->getSwitchValue('w',window);
		wnd = m_pFrm->findWindow(window.ptr());
		if(!wnd)return recoverableError(c,KVI_ERROR_WindowNotFound,"LOG",window.ptr());
	}

	if(wnd->m_pView){
		if(bOff)wnd->m_pView->stopLogging();
		else {
			if(c->m_buffer.isEmpty())wnd->getDefaultLogName(c->m_buffer);
			if(!wnd->m_pView->startLogging(c->m_buffer.ptr())){
				return recoverableError(c,KVI_ERROR_CantStartLogging,"LOG",c->m_buffer.ptr());
			}
		}
		return true;
	}
	return recoverableError(c,KVI_ERROR_CantStartLoggingInThisWindow,"LOG");
}

/*
	@command: DNS
	@short:
		Resolves user hostnames
	@syntax:
		dns &lt;nickname&gt;
	@description:
		Starts an asynchronous DNS call for &lt;nickname&gt;'s host.<br>
		If the user &lt;nickname&gt; is not in the internal user list,
		KVIrc first performs a WHOIS &lt;nickname&gt;.<br>
	@seealso:
		<a href="host.kvihelp">HOST</a>
		<a href="nslookup.kvihelp">NSLOOKUP</a>
*/

bool KviUserParser::parseCmd_DNS(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(m_pFrm->m_state != KviFrame::Connected)return notConnectedToServer(c,"DNS");
//	c->m_buffer.stripWhiteSpace();
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"DNS");
	KviIrcUser * u = m_pFrm->m_pUserList->findUser(c->m_buffer.ptr());
	bool bNeedWhois = false;
	if(!u)bNeedWhois = true;
	else {
		if(!u->hasHost())bNeedWhois = true;
	}
	if(bNeedWhois){
		//make the whois call first...
		c->m_wnd->output(KVI_OUT_DNS,__tr("%s's host is unknown, querying server..."),c->m_buffer.ptr());
		m_pSocket->sendFmtData("WHOIS %s",c->m_buffer.ptr());
		m_pFrm->m_global.pDnsWhoisPending->append(new KviStr(c->m_buffer));
	} else {
		if(!doAsyncDnsCallForHost(u->host(),u->nick()))return recoverableError(c,KVI_ERROR_CanNotStartDnsThread,"DNS");
	}
	return true;
}

/*
	@command: HOST
	@short:
		Resolves hostnames
	@syntax:
		host &lt;host&gt;
	@description:
		Starts an asynchronous DNS call for &lt;host&gt;.<br>
		&lt;host&gt; can be either a hostname or an IP address.
		Equivalent to <a href="nslookup.kvihelp">NSLOOKUP</a>.
	@seealso:
		<a href="nslookup.kvihelp">NSLOOKUP</a>
		<a href="dns.kvihelp">DNS</a>
		
*/

/*
	@command: NSLOOKUP
	@short:
		Resolves hostnames
	@syntax:
		nslookup &lt;host&gt;
	@description:
		Starts an asynchronous DNS call for &lt;host&gt;.<br>
		&lt;host&gt; can be either a hostname or an IP address.
		Equivalent to <a href="host.kvihelp">HOST</a>.
	@seealso:
		<a href="host.kvihelp">HOST</a>
		<a href="dns.kvihelp">DNS</a>
		
*/

bool KviUserParser::doAsyncDnsCallForHost(const char *host,const char *data)
{
	KviAsyncDns * dns = new KviAsyncDns();
	connect(dns,SIGNAL(dnsFinished(KviDnsStruct *)),this,SLOT(asyncDnsFinished(KviDnsStruct *)));
	if(!dns->resolve(host,data)){
		delete dns;
		return false;
	}
	m_pAsyncDnsList->append(dns);
	return true;
}
//
//bool KviUserParser::doAsyncWhoisCall(const char *nick)
//{
//	return m_pSocket->sendFmtData("WHOIS %s %s",nick, nick);
//}
//


bool KviUserParser::parseCmd_HOST(KviCommand *c)
{
	// /host hostname
	if(!processCmdFinalPart(c))return false;
	if(!doAsyncDnsCallForHost(c->m_buffer.ptr()))return recoverableError(c,KVI_ERROR_CanNotStartDnsThread,"HOST");
	return true;
}

void KviUserParser::asyncDnsFinished(KviDnsStruct *dns)
{
	KviWindow * pOut = g_pOptions->m_bDnsResultsToConsole ? m_pConsole : m_pFrm->activeWindow();
	if(dns->szData.hasData())pOut->output(KVI_OUT_DNS,__tr("DNS query : %s (%s)"),dns->szData.ptr(),dns->szHostToResolve.ptr());
	else pOut->output(KVI_OUT_DNS,__tr("DNS query : %s"),dns->szHostToResolve.ptr());
	if(dns->iError != KVI_ERROR_Success){
		switch(dns->iError){
			case KVI_ERROR_HostNotFound:
				pOut->outputNoFmt(KVI_OUT_DNS,__tr("Failed    : Host not found"));
			break;
			case KVI_ERROR_ValidNameButNoIpAddress:
				pOut->outputNoFmt(KVI_OUT_DNS,__tr("Failed    : Valid hostname, but has no IP address"));
			break;
			case KVI_ERROR_UnrecoverableNameserverError:
				pOut->outputNoFmt(KVI_OUT_DNS,__tr("Failed    : Unrecoverable nameserver error"));
			break;
			case KVI_ERROR_DnsTemporaneousFault:
				pOut->outputNoFmt(KVI_OUT_DNS,__tr("Failed    : DNS temporaneous fault"));
			break;
			case KVI_ERROR_DnsQueryFailed:
				pOut->outputNoFmt(KVI_OUT_DNS,__tr("Failed    : DNS query failed: Unable to resolve hostname"));
			break;
			default:
				pOut->outputNoFmt(KVI_OUT_DNS,__tr("Failed    : DNS query failed: Unknown error code"));
			break;
		}
		return;
	}
	pOut->output(KVI_OUT_DNS,__tr("Hostname  : %s"),dns->szHostname.ptr());
	pOut->output(KVI_OUT_DNS,__tr("IP address: %s"),dns->szIp.ptr());
	if(dns->szAlias1.hasData() && (dns->szAlias1 != "*"))
		pOut->output(KVI_OUT_DNS,__tr("Alias     : %s"),dns->szAlias1.ptr());
	if(dns->szAlias2.hasData() && (dns->szAlias2 != "*"))
		pOut->output(KVI_OUT_DNS,__tr("Alias     : %s"),dns->szAlias2.ptr());
	m_pAsyncDnsList->removeRef(dns->dnsParent); //will delete the KviAsyncDns object too
}

/*
	@command: DCC
	@short:
		Requests a DCC to a user
	@syntax:
		dcc &lt;mode&gt; &lt;nickname&gt; [file]
	@description:
		Requests a Direct Client Connection to a user on IRC.<br>
		The &lt;mode&gt; can be either 'chat','voice', or 'send'.<br>
		DCC chat requests a DCC in CHAT mode.<br>
		DCC voice requests a DCC in VOICE mode (a KVIrc extension).<br>
		DCC send requests a DCC file transfer for [file].<br>
		Please note that this command only sends a REQUEST;
		the remote user must acknowledge it to begin the DCC.
	@examples:
		<example>
			dcc chat Pragma
			dcc voice BuTi
			dcc send Pragma /usr/bleh/index.html
		</example>
*/

bool KviUserParser::parseCmd_DCC(KviCommand *c)
{
	// /dcc chat nick
	KviStr type;
	if(!processCmdSingleToken(c))return false;
	type = c->m_buffer;
	c->clearBuffer();
	KviStr target;
	if(!processCmdSingleToken(c))return false;
	target = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	if(!m_pSocket->isConnected())return notConnectedToServer(c,"DCC");

	if(kvi_strEqualNoLocaleCI(type.ptr(),"chat")){
		if(target.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"DCC");
		m_pFrm->m_pDccManager->requestDccChat(target.ptr());
	} else if(kvi_strEqualNoLocaleCI(type.ptr(),"voice")){
		if(target.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"DCC");
		m_pFrm->m_pDccManager->requestDccVoice(target.ptr());
	} else if(kvi_strEqualNoLocaleCI(type.ptr(),"send")){
		if(target.isEmpty())return recoverableError(c,KVI_ERROR_MissingTarget,"DCC");
		m_pFrm->m_pDccManager->requestDccSend(target.ptr(),c->m_buffer.ptr());
	} else return recoverableError(c,KVI_ERROR_UnsupportedDccType,"DCC",type.ptr());
	return true;
}

/*
	@command: TOPIC
	@short:
		Sets or changes topic for a channel
	@syntax:
		topic &lt;channel&gt; &lt;new topic&gt;
	@description:
		Sets the topic for &lt;channel&gt; to &lt;new topic&gt;.<br>
		Please note that you must be an operator on &lt;channel&gt;
		to set the topic if the 't' channel flag is set.
	@examples:
		<example>
			topic #kvirc Working on 1.0.0...be patient!
		</example>
*/

bool KviUserParser::parseCmd_TOPIC(KviCommand *c)
{
	// TOPIC <channel> <new_topic>
	if(!processCmdFinalPart(c))return false;
	KviStr channel;
	c->m_buffer.getToken(channel,' ');
	if(channel.isEmpty())return recoverableError(c,KVI_ERROR_MissingChannelName,"TOPIC");
	bool bSent;
	if(c->m_buffer.hasData())bSent = m_pSocket->sendFmtData("TOPIC %s :%s",channel.ptr(),c->m_buffer.ptr());
	else bSent = m_pSocket->sendFmtData("TOPIC %s :",channel.ptr());
	if(!bSent)return notConnectedToServer(c,"TOPIC");
	return true;
}

/*
	@command: REGISTER
	@short:
		Registers a user in the User Database
	@syntax:
		register &lt;mask&gt; &lt;flags&gt;
	@description:
		Registers a user in the KVIrc User Database.<br>
		The &lt;flags&gt; param should be a combination of the following:<br>
		b: Beep - Rings the keyboard bell on user message<br>
		i: Ignore - Ignores messages from user<br>
		n: Notify - Enables online notification for user<br>
		 More flags will be added later.
	@examples:
		<example>
			register Pragma!*@* n
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="unregister.kvihelp">UNREGISTER</a><br>
		<a href="notify.kvihelp">NOTIFY</a><br>
		<a href="ignore.kvihelp">IGNORE</a><br>
		<a href="setcomment.kvihelp">SETCOMMENT</a><br>
		<a href="setflags.kvihelp">SETFLAGS</a><br>
		<a href="setpass.kvihelp">SETPASS</a><br>
*/

bool KviUserParser::parseCmd_REGISTER(KviCommand *c)
{
	// /register <mask> <flags>
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr mask;
	c->m_buffer.getToken(mask,' ');
	if(mask.isEmpty())
		return recoverableError(c,KVI_ERROR_MissingMask,"REGISTER");

	if((mask.findFirstIdx('!') == -1) || (mask.findFirstIdx('@') == -1) || (mask.len() < 3))
		return recoverableError(c,KVI_ERROR_InvalidRegistrationMask,"REGISTER",mask.ptr());


	if(g_pOptions->m_pRegUsersDb->findExactMatch(mask.ptr()))
		return recoverableError(c,KVI_ERROR_AlreadyRegistered,"REGISTER",mask.ptr());

	if(g_pApp->m_pRegUsersDialog != 0)
		return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"REGISTER");

	KviRegisteredUser * u = new KviRegisteredUser;
	u->user.setMask(mask.ptr());

	g_pOptions->m_pRegUsersDb->registerUser(u,c->m_buffer.ptr());
	g_pApp->restartNotifyLists();

	return true;
}

/*
	@command: UNREGISTER
	@short:
		Unregisters a user
	@syntax:
		unregister &lt;mask&gt;
	@description:
		Removes a user from the KVIrc User Database.<br>
	@examples:
		<example>
			unregister Pragma!*@* n
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="register.kvihelp">REGISTER</a><br>
		<a href="notify.kvihelp">NOTIFY</a><br>
		<a href="ignore.kvihelp">IGNORE</a><br>
		<a href="setcomment.kvihelp">SETCOMMENT</a><br>
		<a href="setflags.kvihelp">SETFLAGS</a><br>
		<a href="setpass.kvihelp">SETPASS</a><br>
*/

bool KviUserParser::parseCmd_UNREGISTER(KviCommand *c)
{
	// /unregister <mask>
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingMask,"UNREGISTER");

	KviRegisteredUser * u = g_pOptions->m_pRegUsersDb->findExactMatch(c->m_buffer.ptr());

	if(!u)return recoverableError(c,KVI_ERROR_UserNotRegistered,"UNREGISTER",c->m_buffer.ptr());

	if(g_pApp->m_pRegUsersDialog != 0)
		return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"UNREGISTER");

	g_pOptions->m_pRegUsersDb->unregisterUser(u);
	g_pApp->restartNotifyLists();

	return true;
}

/*
	@command: IGNORE
	@short:
		Registers a user with the ignore flag
	@syntax:
		ignore &lt;mask_or_nickname&gt;
	@description:
		Registers a user with the ignore flag enabled.<br>
		If the user is already registered, only the 'i' flag is added.<br>
		This command is a built-in alias for <a href="register.kvihelp">register</a> i<br>
		If a nickname is specified instead of a mask, the registration mask defaults to nick!*@*
	@examples:
		<example>
		ignore Pragma
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="register.kvihelp">REGISTER</a><br>
		<a href="unregister.kvihelp">UNREGISTER</a><br>
		<a href="notify.kvihelp">NOTIFY</a><br>
		<a href="setcomment.kvihelp">SETCOMMENT</a><br>
		<a href="setflags.kvihelp">SETFLAGS</a><br>
		<a href="setpass.kvihelp">SETPASS</a><br>
*/

bool KviUserParser::parseCmd_IGNORE(KviCommand *c)
{
	// /ignore [<user>|<mask>]
	if(!processCmdFinalPart(c))return false;

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingMask,"IGNORE");
	if(c->m_buffer.findFirstIdx('!') == -1)c->m_buffer.append("!*");
 	if(c->m_buffer.findFirstIdx('@') == -1)c->m_buffer.append("@*");
	if(g_pApp->m_pRegUsersDialog != 0)
		return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"IGNORE");

	KviRegisteredUser *u = g_pOptions->m_pRegUsersDb->findExactMatch(c->m_buffer.ptr());
	if(u){
		//already there
		g_pOptions->m_pRegUsersDb->addFlags(u,"i");
		// done by addFlags
//		u->bIgnore = 1;
		return true;
	}
	u = new KviRegisteredUser;
	u->user.setMask(c->m_buffer.ptr());
	g_pOptions->m_pRegUsersDb->registerUser(u,"i");
	return true;
}

/*
	@command: NOTIFY
	@short:
		Registers a user with the notify flag
	@syntax:
		notify &lt;mask_or_nickname&gt;
	@description:
		Registers a user with the notify flag enabled.<br>
		If the user is already registered, only the 'n' flag is added.<br>
		This command is a built-in alias for <a href="register.kvihelp">register</a> n<br>
		This command also restarts the notify list.<br>
		If a nickname is specified instead of a mask, the registration mask defaults to nick!*@*
	@examples:
		<example>
		notify Pragma
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="register.kvihelp">REGISTER</a><br>
		<a href="unregister.kvihelp">UNREGISTER</a><br>
		<a href="ignore.kvihelp">IGNORE</a><br>
		<a href="setcomment.kvihelp">SETCOMMENT</a><br>
		<a href="setflags.kvihelp">SETFLAGS</a><br>
		<a href="setpass.kvihelp">SETPASS</a><br>
*/

bool KviUserParser::parseCmd_NOTIFY(KviCommand *c)
{
	// /notify [&lt;user>|<mask&gt;]
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingMask,"NOTIFY");
	if(c->m_buffer.findFirstIdx('!') == -1)c->m_buffer.append("!*");
 	if(c->m_buffer.findFirstIdx('@') == -1)c->m_buffer.append("@*");
	if(g_pApp->m_pRegUsersDialog != 0)return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"NOTIFY");

	KviRegisteredUser *u = g_pOptions->m_pRegUsersDb->findExactMatch(c->m_buffer.ptr());
	if(u){
		//already there
//		u->bNotify = 1;
		g_pOptions->m_pRegUsersDb->addFlags(u,"n");
		g_pApp->restartNotifyLists();
		return true;
	}
	u = new KviRegisteredUser;
	u->user.setMask(c->m_buffer.ptr());
	g_pOptions->m_pRegUsersDb->registerUser(u,"n");
	g_pApp->restartNotifyLists();

	return true;
}

/*
	@command: SETFLAGS
	@short:
		Sets the flags for a registered user.
	@syntax:
		setflags &lt;mask&gt; [flags]
	@description:
		Sets the flags for a registered user.<br>
		If [flags] is not given as an argument, all flags will be removed.<br>
		If the user does not exist, this command aborts with an error.<br>
		[flags] can be a string composed of characters and numbers. It is case-sensitive (b and B are considered to be two different flags).<br>
		This command also restarts the notify list.<br>
	@examples:
		<example>
		setflags Pragma nAcox
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="register.kvihelp">REGISTER</a><br>
		<a href="unregister.kvihelp">UNREGISTER</a><br>
		<a href="notify.kvihelp">NOTIFY</a><br>
		<a href="ignore.kvihelp">IGNORE</a><br>
		<a href="setcomment.kvihelp">SETCOMMENT</a><br>
		<a href="setpass.kvihelp">SETPASS</a><br>
*/

bool KviUserParser::parseCmd_SETFLAGS(KviCommand *c)
{
	// /setflags <mask> [flags]
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr mask;
	c->m_buffer.getToken(mask,' ');
	if(mask.isEmpty())return recoverableError(c,KVI_ERROR_MissingMask,"SETFLAGS");

	KviRegisteredUser * u = g_pOptions->m_pRegUsersDb->findExactMatch(mask.ptr());

	if(!u)return recoverableError(c,KVI_ERROR_UserNotRegistered,"SETFLAGS",mask.ptr());

	if(g_pApp->m_pRegUsersDialog != 0)
		return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"SETFLAGS");

	g_pOptions->m_pRegUsersDb->setFlags(u, c->m_buffer.ptr());
	g_pApp->restartNotifyLists();

	return true;
}

/*
	@command: SETPASS
	@short:
		Sets the password for a registered user.
	@syntax:
		setpass &lt;mask&gt; [password]
	@description:
		Sets the password for a registered user.<br>
		If [password] is not given as an argument, the password will be cleared.<br>
		If the user does not exist, this command aborts with an error.<br>
		[password] can be a string composed of characters and numbers. It is case-sensitive.<br>
	@examples:
		<example>
		setpass Triskelios fn25#45DSjsdjf#
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="register.kvihelp">REGISTER</a><br>
		<a href="unregister.kvihelp">UNREGISTER</a><br>
		<a href="notify.kvihelp">NOTIFY</a><br>
		<a href="ignore.kvihelp">IGNORE</a><br>
		<a href="setcomment.kvihelp">SETCOMMENT</a><br>
		<a href="setflags.kvihelp">SETFLAGS</a><br>
*/

bool KviUserParser::parseCmd_SETPASS(KviCommand *c)
{
	// /setpass <mask> [password]
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr mask;
	c->m_buffer.getToken(mask,' ');
	if(mask.isEmpty())return recoverableError(c,KVI_ERROR_MissingMask,"SETPASS");

	KviRegisteredUser * u = g_pOptions->m_pRegUsersDb->findExactMatch(mask.ptr());

	if(!u)return recoverableError(c,KVI_ERROR_UserNotRegistered,"SETPASS",mask.ptr());

	if(g_pApp->m_pRegUsersDialog != 0)
		return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"SETPASS");

	g_pOptions->m_pRegUsersDb->setPasswd(u, c->m_buffer.ptr());

	return true;
}

/*
	@command: SETCOMMENT
	@short:
		Sets the comment for a registered user.
	@syntax:
		setcomment &lt;mask&gt; [comment]
	@description:
		Sets the comment for a registered user.<br>
		If [comment] is not given as an argument, the comment will be cleared.<br>
		If the user does not exist, this command aborts with an error.<br>
		[comment] can be a string composed of any characters, including spaces.<br>
		This command also restarts the notify list.<br>
	@examples:
		<example>
		setcomment Triskelios Ack, nooo...
		</example>
	@seealso:
		<a href="s_isreg.kvihelp">$IsReg</a><br>
		<a href="s_getflags.kvihelp">$GetFlags</a><br>
		<a href="s_getflagsexact.kvihelp">$GetFlagsExact</a><br>
		<a href="s_getpass.kvihelp">$GetPass</a><br>
		<a href="s_getcomment.kvihelp">$GetComment</a><br>
		<a href="register.kvihelp">REGISTER</a><br>
		<a href="unregister.kvihelp">UNREGISTER</a><br>
		<a href="notify.kvihelp">NOTIFY</a><br>
		<a href="ignore.kvihelp">IGNORE</a><br>
		<a href="setflags.kvihelp">SETFLAGS</a><br>
		<a href="setpass.kvihelp">SETPASS</a><br>
*/

bool KviUserParser::parseCmd_SETCOMMENT(KviCommand *c)
{
	// /setcomment <mask> [comment]
	if(!processCmdFinalPart(c))return false;
	// extract the first token
	KviStr mask;
	c->m_buffer.getToken(mask,' ');
	if(mask.isEmpty())return recoverableError(c,KVI_ERROR_MissingMask,"SETCOMMENT");

	KviRegisteredUser * u = g_pOptions->m_pRegUsersDb->findExactMatch(mask.ptr());

	if(!u)return recoverableError(c,KVI_ERROR_UserNotRegistered,"SETCOMMENT",mask.ptr());

	if(g_pApp->m_pRegUsersDialog != 0)
		return recoverableError(c,KVI_ERROR_RegistrationWillBeResetByDialog,"SETCOMMENT");

	g_pOptions->m_pRegUsersDb->setComment(u, c->m_buffer.ptr());
	g_pApp->restartNotifyLists();

	return true;
}

/*
	@command: DIALOG
	@short:
		Opens a dialog
	@syntax:
		dialog(&lt;type&gt;[,&lt;parameters&gt;])&lt;command&gt;
	@description:
		Shows a dialog for interaction with the user.<br>
		<docsubtitle>Open File dialog</docsubtitle>
		dialog(openfile[,caption[,initaldir[,filter{,magicdata}]]])&lt;command&gt;<br>
		<br>
		Shows a classic "Open File" dialog with a specified caption,
		initial directory and file filter.<br>
		If the user selects a valid file name, the &lt;command&gt; will be executed.<br>
		The command may contain the <a href="s_dialogresult.kvihelp">$dialogresult</a>
		identifier that will evaluate to the file name selected by the user,
		and the <a href="s_dialogmagic.kvihelp">$dialogmagic</a> identifier that
		will evaluate to the &lt;magicdata&gt; passed to the /DIALOG call.<br>
		The &lt;command&gt; is parsed at DIALOG DESTROY TIME, and identifiers
		are evaluated at that time!!!.<br>
		If you need to evaluate identifiers at /DIALOG call time,
		you must pass it as &lt;magicdata&gt;.<br>
		See the examples below.<br>
		<docsubtitle>Open files dialog</docsubtitle>
		dialog(openfiles[,caption[,initaldir[,filter{,magicdata}]]])&lt;command&gt;<br>
		<br>
		Shows a classic save-file dialog with a specified caption,
		initial directory and file filter.<br>
		This one allows selecting more than one file name.<br>
		The command may contain the <a href="s_dialogresult.kvihelp">$dialogresult</a>
		identifier that will evaluate to the file name selected by the user,
		and the <a href="s_dialogmagic.kvihelp">$dialogmagic</a> identifier that
		will evaluate to the &lt;magicdata&gt; passed to the /DIALOG call.<br>
		If the user selects valid file names, the &lt;command&gt; will be executed.<br>
		The &lt;command&gt; is parsed at DIALOG DESTROY TIME, and identifiers
		are evaluated at that time!!!.<br>
		If you need to evaluate identifiers at /DIALOG call time,
		you must pass it as &lt;magicdata&gt;.<br>
		See the examples below.<br>
		<docsubtitle>Save file dialog</docsubtitle>
		dialog(savefile[,caption[,initalfilename[,filter{,magicdata}]]])&lt;command&gt;<br>
		<br>
		Shows a classic open-file dialog with a specified caption,
		initial filename (path) and file filter.<br>
		This one allows selecting also non existing filenames.<br>
		The command may contain the <a href="s_dialogresult.kvihelp">$dialogresult</a>
		identifier that will evaluate to the file name selected by the user,
		and the <a href="s_dialogmagic.kvihelp">$dialogmagic</a> identifier that
		will evaluate to the &lt;magicdata&gt; passed to the /DIALOG call.<br>
		If the user selects valid file names, the &lt;command&gt; will be executed.<br>
		The &lt;command&gt; is parsed at DIALOG DESTROY TIME, and identifiers
		are evaluated at that time!!!.<br>
		If you need to evaluate identifiers at /DIALOG call time,
		you must pass it as &lt;magicdata&gt;.<br>
		See the examples below.<br>
		<docsubtitle>Directory dialog</docsubtitle>
		dialog(directory[,caption[,initalpath{,magicdata}]])&lt;command&gt;<br>
		<br>
		Shows a classic directory dialog with a specified caption,
		initial path and file filter.<br>
		<docsubtitle>1 Button dialog</docsubtitle>
		dialog(1button[,caption[,info[,icon[,buttontext{,magicdata}]]]])&lt;command&gt;<br>
		<br>
		Shows a message box with a single button with a specified text,
		caption and icon.<br>
		&lt;icon&gt; can be one of: NoIcon, Warning, Critical, Information<br>
		<docsubtitle>2 Buttons dialog</docsubtitle>
		dialog(2buttons[,caption[,info[,icon[,button1text[,button2text{,magicdata}]]]]])&lt;command&gt;<br>
		<br>
		Shows a message box with two buttons button with a specified text,
		caption and icon.<br>
		<docsubtitle>3 Buttons dialog</docsubtitle>
		dialog(3buttons[,caption[,info[,icon[,button1text[,button2text[,button3text{,magicdata}]]]]]])&lt;command&gt;<br>
		<br>
		Shows a message box with three buttons button with a specified text,
		caption and icon.<br>
		<docsubtitle>Text input dialog / password dialog</docsubtitle>
		dialog(lineinput[,caption[,info[,initialText{,magicdata}]]])&lt;command&gt;<br>
		dialog(password[,caption[,info[,initialText{,magicdata}]]])&lt;command&gt;<br>
		<br>
		Shows a text input box with a specified caption, info text and initial input text.<br>
		If the type is "passowrd", stars will be shown in place of the input text.<br>
		WHen the userc will click OK in the dialog, the &lt;command&gt; will be executed
		and the <a href="s_dialogresult.kvihelp">$dialogresult</a> identifier will evaluate
		to the text typed by the user.
		<docsubtitle>Tips</docsubtitle>
		Please note that &lt;command&gt; may be bound to another window instead
		of the one in which you have executed the /dialog command.<br>
		The &lt;info&gt; text can contain newlines...use the <a href="s_lf.kvihelp">$lf</a> identifier.
		The parameters in square braces are optional: if not given, KVIrc will pass reasonable defaults.<br>
		The dialogs are executed asynchronously (KVIrc is not blocked as in the previous versions)!.<br>
		The commands following /dialog in a script will be executed while the dialog is open
		and NOT after it has been closed (as may seem at first approach...).<br>
		a code like:<br>
		<example>
		dialog(lineinput,Dialog 1)echo Dialog 1: $dialogresult
		dialog(lineinput,Dialog 2)echo Dialog 2: $dialogresult
		dialog(password,Dialog 3)echo Dialog 3: $dialogresult
		</example>
		will open three dialogs at the same time, and the related 'callback' commands may not be
		executed sequentially.<br>
		If you want to do a sequence of dialogs use nested /dialog commands:<br>
		<example>
		dialog(lineinput,Dialog 1)dialog(lineinput,Dialog 2,$dialogresult)echo Dialog 2: $dialogresult
		</example>
	@examples:
		<example>
			dialog(1button,"Test dialog","Click OK",Information,"OK",<a href="s_time.kvihelp">$time</a>)<a href="echo.kvihelp">echo</a> Button <a href="s_dialogresult.kvihelp">$dialogresult</a>,Dialog call time: <a href="s_dialogmagic.kvihelp">$dialogmagic</a>,Current time: <a href="s_time.kvihelp">$time</a>
			dialog(lineinput,"Hey!","Hey Man!<a href="s_lf.kvihelp">$LF</a>\Type some text here","Nothing",<a href="s_window.kvihelp">$window</a>){
			@tab@<a href="echo.kvihelp">echo</a> You have typed '<a href="s_dialogresult.kvihelp">$dialogresult</a>'
			@tab@<a href="echo.kvihelp">echo</a> You have called the /DIALOG command from window <a href="s_dialogmagic.kvihelp">$dialogmagic</a>
			@tab@<a href="echo.kvihelp">echo</a> The window that this command is executed in is <a href="s_window.kvihelp">$window</a>
			}
		</example>
	@seealso:
*/

// TIPS:
// icon can be: NoIcon, Warning (Warn), Critical (Crit), Information (Info)
// text can contain newlines! ($LF)

typedef struct asyncDialogTypeData
{
	const char * type;
	int len;
	int nExtraParams;  //number of params following the dialog type, (magicdata not included)
};

#define ASYNC_DIALOGS_NUMBER 9

static asyncDialogTypeData adtd[ASYNC_DIALOGS_NUMBER]=
{
	{ "openfile"   , 8 , 3 },{ "openfiles"  , 9 , 3 },
	{ "savefile"   , 8 , 2 },{ "directory"  , 9 , 2 },
	{ "1button"    , 7 , 4 },{ "2buttons"   , 8 , 5 },
	{ "3buttons"   , 8 , 6 },{ "lineinput"  , 9 , 3 },
	{ "password"   , 8 , 3 }
};

bool KviUserParser::parseCmd_DIALOG(KviCommand *c)
{

	// strings:c->m_buffer,caption,param3,...,dialog->m_szMagic
//#warning "TODO: centering the dialog (a -c switch ?)"

	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"DIALOG",c->m_ptr);
		return false;
	}
	++(c->m_ptr);
	// get the dialog type
	if(!processFncSingleParam(c,c->m_buffer))return false;
	if(c->m_buffer.isEmpty()){
		c->setError(KVI_ERROR_MissingDialogType,"DIALOG");
		return false;
	}
	// find the dialog to 'realize'
	int dlgtype = -1;
	for(int i = 0;(i < ASYNC_DIALOGS_NUMBER)&&(dlgtype < 0); i++){
		if(kvi_strEqualNoLocaleCIN(c->m_buffer.ptr(),adtd[i].type,adtd[i].len))dlgtype = i;
	}
	// found ?
	if((dlgtype < 0) || (dlgtype > 8)){ //should be just (dlgtype < 0) but...
		c->setError(KVI_ERROR_UnknownDialogType,"DIALOG",c->m_buffer.ptr());
		return false;
	}
	// process the right number of params...
	KviStr p1,p2,p3,p4,p5,p6;
	if(!processFncSingleParam(c,p1))return false;
	if(!processFncSingleParam(c,p2))return false;
	if(adtd[dlgtype].nExtraParams > 2){
		if(!processFncSingleParam(c,p3))return false;
		if(adtd[dlgtype].nExtraParams > 3){
			if(!processFncSingleParam(c,p4))return false;
			if(adtd[dlgtype].nExtraParams > 4){
				if(!processFncSingleParam(c,p5))return false;
				if(adtd[dlgtype].nExtraParams > 5){
					if(!processFncSingleParam(c,p6))return false;
				}
			}
		}
	}

	// Now execute it
	if(dlgtype < 4){
		// file dialogs...
		KviAsyncFileDialog *pDlg = new KviAsyncFileDialog(this,c->m_wnd);
		// get the magic params
		if(!processFncFinalPart(c,pDlg->m_szMagic))return false;
		// and the command (set the job for the dialog)
		c->skipWhitespace();
		const char *aux_ptr = c->m_ptr;
		if(!skipCommand(c))return false;
		pDlg->setJob(aux_ptr,c->m_ptr);
		// now complete the setup and run
		switch(dlgtype){
			case 0: //openfile
				pDlg->setCaption(p1.hasData() ? p1.ptr() : __tr("Select a File to Open"));
				if(p2.hasData())pDlg->setSelection(p2.ptr());
				if(p3.hasData())pDlg->setFilter(p3.ptr());
				pDlg->openFileName();
			break;
			case 1: //openfiles
				pDlg->setCaption(p1.hasData() ? p1.ptr() : __tr("Select Files to Open"));
				if(p2.hasData())pDlg->setSelection(p2.ptr());
				if(p3.hasData())pDlg->setFilter(p3.ptr());
				pDlg->openFileNames();
			break;
			case 2: //savefile
				pDlg->setCaption(p1.hasData() ? p1.ptr() : __tr("Choose a Filename"));
				if(p2.hasData())pDlg->setSelection(p2.ptr());
				pDlg->saveFileName();
			break;
			case 3: //directory
				pDlg->setCaption(p1.hasData() ? p1.ptr() : __tr("Select a Directory"));
				if(p2.hasData())pDlg->setSelection(p2.ptr());
				pDlg->openDirectory();
			break;
			default:
				__range_invalid(true); // impossible
			break;
		}
		return true;
	}
	if(dlgtype < 7){
		// message boxes
		KviAsyncMessageBox * pDlg = 0; //Avoid egcs warning ...
		switch(dlgtype){
			case 4: //1 button
				pDlg = new KviAsyncMessageBox(this,c->m_wnd,
					p1.hasData() ? p1.ptr() : "KVIrc",
					p2.hasData() ? p2.ptr() : _i18n_("Blah blah blah blah..."),
					p3.ptr(),
					p4.hasData() ? p4.ptr() : _i18n_("Shut up!"));
			break;
			case 5: //2 buttons
				pDlg = new KviAsyncMessageBox(this,c->m_wnd,
					p1.hasData() ? p1.ptr() : "KVIrc",
					p2.hasData() ? p2.ptr() : _i18n_("KVIrc will now send SIGKILL to itself.\nDo you wish to confirm?"),
					p3.ptr(),
					p4.hasData() ? p4.ptr() : _i18n_("Yes"),
					p5.hasData() ? p5.ptr() : _i18n_("Yes"));
			break;
			case 6: //3 buttons
				pDlg = new KviAsyncMessageBox(this,c->m_wnd,
					p1.hasData() ? p1.ptr() : "KVIrc",
					p2.hasData() ? p2.ptr() : _i18n_("What do you want to do now?"),
					p3.ptr(),
					p4.hasData() ? p4.ptr() : _i18n_("Idle"),
					p5.hasData() ? p5.ptr() : _i18n_("Raise caffeine levels"),
					p6.hasData() ? p6.ptr() : _i18n_("Go to bed"));
			break;
			default:
				__range_invalid(true); //cannot happen
			break;
		}
		// get the magic params
		if(!processFncFinalPart(c,pDlg->m_szMagic))return false;
		// and the command (set the job for the dialog)
		c->skipWhitespace();
		const char *aux_ptr = c->m_ptr;
		if(!skipCommand(c))return false;
		pDlg->setJob(aux_ptr,c->m_ptr);
		pDlg->show();
		return true;
	}
	// input box
	if(dlgtype == 7){
		KviAsyncInputBox * pDlg = new KviAsyncInputBox(this,c->m_wnd,
			p1.hasData() ? p1.ptr() : "KVIrc",
			p2.hasData() ? p2.ptr() : _i18n_("Please insert the speed of marching ants"),
			p3.hasData() ? p3.ptr() : "");
		// get the magic params
		if(!processFncFinalPart(c,pDlg->m_szMagic))return false;
		// and the command (set the job for the dialog)
		c->skipWhitespace();
		const char *aux_ptr = c->m_ptr;
		if(!skipCommand(c))return false;
		pDlg->setJob(aux_ptr,c->m_ptr);
		pDlg->show();
		return true;
	}
	KviAsyncInputBox * pDlg = new KviAsyncInputBox(this,c->m_wnd,
		p1.hasData() ? p1.ptr() : "KVIrc",
		p2.hasData() ? p2.ptr() : _i18n_("Enter the CIA access code"),
		p3.hasData() ? p3.ptr() : "", true);
	// get the magic params
	if(!processFncFinalPart(c,pDlg->m_szMagic))return false;
	// and the command (set the job for the dialog)
	c->skipWhitespace();
	const char *aux_ptr = c->m_ptr;
	if(!skipCommand(c))return false;
	pDlg->setJob(aux_ptr,c->m_ptr);
	pDlg->show();
	return true;
}


bool KviUserParser::skipDialog(KviCommand *c)
{
	// dialog (<expression>)<command>
//	c->m_ptr+=6;
	c->skipWhitespace();
	if(*(c->m_ptr) != '('){
		c->setError(KVI_ERROR_OpenParenthesisExpected,"DIALOG",c->m_ptr);
		return false;
	}
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	return skipCommand(c);
}


/*
	@command: RUN
	@short:
		Starts an external program
	@syntax:
		run [-s] &lt;commandline&gt;
	@description:
		Starts an external program.<br>
		The process is started and detached from KVIrc process.<br>
		It continues running after KVIrc has been closed.<br>
		If the -s switch is specified, the &lt;commandline&gt; is executed
		thru a shell.<br>In this way you can use shell variables or
		execute sequences of commands.<br>
	@examples:
		<example>
		run xterm
		run -s cd \$HOME && xterm -e /bin/bash -c \" ls \; sleep 10 \"
		</example>
*/

bool KviUserParser::parseCmd_RUN(KviCommand *c)
{
	if(!extractSwitches(c))return false;

	bool bExecInSubshell = c->hasSwitch('s');

//	c->skipWhitespace();

	if(!processCmdFinalPart(c))return false;

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingCommandline,"RUN");

	KviProcess proc;
	if(!proc.run(c->m_buffer.ptr(),false,false,bExecInSubshell))
		return recoverableError(c,KVI_ERROR_ProcessStartFailed,"RUN",c->m_buffer.ptr());

	return true;
}

/*
	@command: DIRBROWSER
	@short:
		Opens a MDI directory browser
	@syntax:
		dirbrowser [-t] [initial_directory]
	@description:
		Opens a directory browser MDI window.<br>
		If the initial_directory is not specified, the browser will start
		with the most recently visited directory path or with the home directory.<br>
		If the -t switch is specified, an existing browser will be closed
		(equivalent to clicking on the toolbar button).<br>
*/

bool KviUserParser::parseCmd_DIRBROWSER(KviCommand *c)
{
	if(!extractSwitches(c))return false;

	if(!processCmdFinalPart(c))return false;
	c->m_buffer.stripWhiteSpace();

	if(c->hasSwitch('t'))m_pFrm->toggleDirBrowser();
	else m_pFrm->createDirectoryBrowser(c->m_buffer.isEmpty() ? 0 : c->m_buffer.ptr());

	return true;
}

/*
#warning "-q switch ?"
*/

/*
	@command: PLUGIN
	@short:
		Loads or unloads a plugin
	@syntax:
		plugin [-q] [-u] load &lt;name&gt;
		plugin [-q] [-m] unload &lt;name&gt;
		plugin list
	@description:
		The first form loads a plugin by &lt;name&gt;.<br>
		The &lt;name&gt; may be an absolute file path, a relative file path or a module name.<br>
		An absolute path begins with '/', a "relative" path is a "libkviMODULENAME.so" name
		(that KVIrc will attempt to load from the global plugin directory).<br>
		If the &lt;name&gt; is a relative path and does not begin with "libkvi" it is treated
		as "module" name; the prefix "libkvi" and postfix ".so" are automatically added.<br>
		If the -u flag is specified, the autoload flag for the plugin is not
		set, so the plugin will not be loaded at the next startup.<br>
		If a plugin with the same name exists, it is not loaded really.<br>
		The second form of the command unloads the plugin by &lt;name&gt;.<br>
		If the -m switch is specified, &lt;name&gt; is treated as the "module" name
		to be unloaded (and the first plugin matching that module name will be unloaded),
		otherwise &lt;name&gt; is treated as the absolute file path of the
		plugin to be unloaded.<br>
		The -q switch causes succesfull operations to be executed in "quiet" mode (no output).<br>
		The third form lists the currently loaded plugins.<br>
		<b>This function will not work if the plugin support has been disabled</b>
*/

bool KviUserParser::parseCmd_PLUGIN(KviCommand *c)
{
	if(!extractSwitches(c))return false;

	KviStr type;
	if(!processCmdFinalPart(c))return false;
	c->m_buffer.getToken(type,' ');
#ifdef COMPILE_PLUGIN_SUPPORT

	if(kvi_strEqualNoLocaleCI("load",type.ptr())){
		if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_PluginFilePathExpected,"PLUGIN");

		KviStr fName;

		if(c->m_buffer.contains("/") == 0){
			if(!kvi_strEqualCIN(c->m_buffer.ptr(),"libkvi",6))
			{
				c->m_buffer.prepend("libkvi");
				c->m_buffer.append(".so");
			}
			g_pApp->getGlobalKVircDirectory(fName,KviApp::Plugins,c->m_buffer.ptr());
			if(!kvi_fileExists(fName.ptr())){
				g_pApp->getLocalKVircDirectory(fName,KviApp::Plugins,c->m_buffer.ptr());
			}
		} else fName = c->m_buffer;

		KviPluginData * d = g_pPluginManager->findPlugin(fName.ptr());
		if(!d)
		{
			// not yet loaded
			d = g_pPluginManager->loadPlugin(fName.ptr(),!(c->hasSwitch('u')));
			if(!d)return recoverableError(c,KVI_ERROR_CantLoadPlugin,"PLUGIN",fName.ptr());
	
			if(!c->hasSwitch('q'))
			{
				c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Loaded plugin %s"),d->filename.ptr());
				c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Module name : %s"),d->description->module_name);
				c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Service name: %s"),d->description->service_name);
				c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Version     : %s"),d->description->version);
				c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Author      : %s"),d->description->author);
				c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Description : %s"),d->description->description);
			}
			KviPluginCommandStruct plgcmd;
			plgcmd.app     = g_pApp;
			plgcmd.handle  = d->handle;
			plgcmd.params  = 0;
			plgcmd.window  = m_pConsole;
			plgcmd.frame   = m_pFrm;
			plgcmd.error   = KVI_ERROR_NoError;
			plgcmd.console = m_pConsole;
			plgcmd.sock    = m_pSocket;
	
			if(!g_pPluginManager->executeInitRoutine(d,&plgcmd)){
				g_pPluginManager->unloadPlugin(d->filename.ptr());
				return recoverableError(c,KVI_ERROR_CantExecutePluginInitRoutine,"PLUGIN",c->m_buffer.ptr());
			}
		} // else already loaded!

	} else if(kvi_strEqualNoLocaleCI("unload",type.ptr())){
		if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_PluginFilePathExpected,"PLUGIN");
		if(c->hasSwitch('m'))
		{
			if(!g_pPluginManager->unloadPluginByModuleName(c->m_buffer.ptr()))
				return recoverableError(c,KVI_ERROR_NoSuchPlugin,"PLUGIN",c->m_buffer.ptr());
		} else {
			if(!g_pPluginManager->unloadPlugin(c->m_buffer.ptr()))
				return recoverableError(c,KVI_ERROR_NoSuchPlugin,"PLUGIN",c->m_buffer.ptr());
		}
		if(!c->hasSwitch('q'))c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Unloaded plugin %s"),c->m_buffer.ptr());
	} else if(kvi_strEqualNoLocaleCI("list",type.ptr())){
		QList<KviPluginData> * l = g_pPluginManager->pluginList();
		int nPlugins = 0;
		for(KviPluginData * d = l->first();d;d=l->next()){
			c->m_wnd->output(KVI_OUT_PLUGIN,__tr("%cPlugin %s"),KVI_TEXT_BOLD,d->filename.ptr());
			c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Module name : %s"),d->description->module_name);
			c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Service name: %s"),d->description->service_name);
			c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Version     : %s"),d->description->version);
			c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Author      : %s"),d->description->author);
			c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Description : %s"),d->description->description);
			nPlugins++;
		}
		c->m_wnd->output(KVI_OUT_PLUGIN,__tr("Total %d plugins loaded"),nPlugins);
	} else return recoverableError(c,KVI_ERROR_InvalidPluginOperation,"PLUGIN");
	return true;
#else
	return recoverableError(c,KVI_ERROR_NoPluginSupport,"PLUGIN");
	return false;
#endif
}

/*
	@command: LOADCONF
	@short:
		Loads popups, aliases, events or user toolbar from an external config
	@syntax:
		loadconf &lt;type&gt; &lt;filename&gt;
	@description:
		Loads the specified configuration options from the file
		&lt;filename&gt;.<br>
		The &lt;type&gt; param can be one of 'aliases','popups','events','toolbar' and 'rawevents'.<br>
		This is rather an internal command used to savel/load scripts.
*/

bool KviUserParser::parseCmd_LOADCONF(KviCommand *c)
{
	KviStr type;
	if(!processCmdFinalPart(c))return false;
	c->m_buffer.getToken(type,' ');

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_ConfigFilePathExpected,"LOADCONF");

	KviStr error;
	if(kvi_strEqualNoLocaleCI("aliases",type.ptr())){
		if(!g_pAliasManager->load(c->m_buffer.ptr(),error))
			c->m_wnd->output(KVI_OUT_ERROR,__tr("Failed loading aliases from file %s: %s"),c->m_buffer.ptr(),error.ptr());
	} else if(kvi_strEqualNoLocaleCI("events",type.ptr())){
		if(!g_pEventManager->load(c->m_buffer.ptr(),error))
			c->m_wnd->output(KVI_OUT_ERROR,__tr("Failed loading events from file %s: %s"),c->m_buffer.ptr(),error.ptr());
	} else if(kvi_strEqualNoLocaleCI("rawevents",type.ptr())){
		if(!g_pRawEventManager->load(c->m_buffer.ptr(),error))
			c->m_wnd->output(KVI_OUT_ERROR,__tr("Failed loading raw events from file %s: %s"),c->m_buffer.ptr(),error.ptr());
	} else if(kvi_strEqualNoLocaleCI("popups",type.ptr())){
		if(!KviPopupMenu::loadAllPopups(c->m_buffer.ptr(),error))
			c->m_wnd->output(KVI_OUT_ERROR,__tr("Failed loading popups from file %s: %s"),c->m_buffer.ptr(),error.ptr());
	} else if(kvi_strEqualNoLocaleCI("toolbar",type.ptr())){
		if(!KviUserToolBarTemplate::loadToolBarTemplate(c->m_buffer.ptr(),error))
			c->m_wnd->output(KVI_OUT_ERROR,__tr("Failed loading toolbar from file %s: %s"),c->m_buffer.ptr(),error.ptr());
		for(KviFrame *f = g_pApp->m_pFrameList->first();f;f=g_pApp->m_pFrameList->next())f->updateUserToolBar();
	} else return recoverableError(c,KVI_ERROR_InvalidConfigType,"LOADCONF");
	return true;
}


/*
	@command: WINDOW
	@short:
		Manages MDI windows
	@syntax:
		window &lt;windowname&gt; &lt;operation&gt; [parameters]
	@description:
		Manages properties of existing windows.<br>
		Available operations: close, dock, undock, minimize, maximize, savebuffer,
		restore, highlight, raise, clear, move, resize, background, icons, commandline, open, setclose.<br>
		<docsubtitle>Close operation</docsubtitle>
		window &lt;windowname&gt; close<br><br>
		Closes the specified window.<br>
		WARNING: If the window to be closed is the
		one that the command is executed in, the command
		gets "reparented" to the console window.<br>
		<docsubtitle>Dock/Undock</docsubtitle>
		window &lt;windowname&gt; dock<br>
		window &lt;windowname&gt; undock<br><br>
		Docks / undocks the specified window.<br>
		If the window is already docked/undocked, this command does nothing.<br>
		<docsubtitle>Minimize/Maximize & Restore operations</docsubtitle>
		window &lt;windowname&gt; minimize<br>
		window &lt;windowname&gt; maximize<br>
		window &lt;windowname&gt; restore<br><br>
		<docsubtitle>Highlight operation</docsubtitle>
		window &lt;windowname&gt; highlight<br><br>
		Highlights the task bar button of the window
		just like a new text has been shown inside.<br>
		If the window is the active one, this command does nothing.<br>
		<docsubtitle>Clear operation</docsubtitle>
		window &lt;windowname&gt; clear<br><br>
		Clears the window text buffer.<br>
		<docsubtitle>Move operation</docsubtitle>
		window &lt;windowname&gt; move &lt;x&gt;,&lt;y&gt;<br><br>
		Moves the specified window to the location x,y.<br>
		If the window is docked the location is relative to the
		top left corner of the main MDI window, otherwise is relative
		to the top left corner of the screen.<br>
		<docsubtitle>Resize operation</docsubtitle>
		window &lt;windowname&gt; resize &lt;width&gt;,&lt;height&gt;<br><br>
		Resizes the specified window.<br>
		<docsubtitle>Raise operation</docsubtitle>
		window &lt;windowname&gt; raise<br><br>
		Activates the specified window (makes it current).<br>
		May not work with some window managers for undocked windows.<br>
		<docsubtitle>Background operation</docsubtitle>
		window &lt;windowname&gt; background &lt;image path&gt;<br><br>
		Sets the background image for the specified window.<br>
		The image path can be absolute or relative to the KVIrc pics directory.<br>
		If 'none' is specified as the image path, the current private background pixmap
		is set to the default one or to the default color if no default pixmap is set by the user.<br>
		<docsubtitle>Timestamp operation</docsubtitle>
		window &lt;windowname&gt; timestamp [on|off]<br><br>
		enables or disables the timestamp for the specified window.<br>
		<docsubtitle>Icons operation</docsubtitle>
		window &lt;windowname&gt; icons [on|off]<br><br>
		enables or disables the text icons display for the specified window.<br>
		<docsubtitle>Savebuffer operation</docsubtitle>
		window &lt;windowname&gt; savebuffer &lt;filename&gt;<br><br>
		Saves the current text buffer to file &lt;filename&gt;
		<docsubtitle>Commandline operation</docsubtitle>
		window &lt;windowname&gt; commandline &lt;commandline_text&gt;
		Sets the commandline input text of the specified window and
		warps the cursor to the end of the line.<br>
		This operation aborts with an error if the window has no commandline input.<br>
		In combination with the <a href="s_commandline.kvihelp">$commandline</a>
		identifier it can be used for example for colorising the current
		commandline text in a funky way.<br>
		<docsubtitle>Open operation</docsubtitle>
		window &lt;windowname&gt; open
		Opens a new User window with name &lt;windowname&gt;.<br>
		&lt;windowname&gt; must begin with the '*' character.<br>
		If a window with that name already exists,
		it is activated.<br>
		<docsubtitle>Input operation</docsubtitle>
		window &lt;windowname&gt; input [on|off]<br>
		Shows or hides the input field in userwindows. The input box can be hidden,
		but it will always work.
		<docsubtitle>List operation</docsubtitle>
		window &lt;windowname&gt; list [on|off]<br>
		Shows or hides the listbox in userwindows.
		<docsubtitle>View operation</docsubtitle>
		window &lt;windowname&gt; view [on|off]<br>
		Shows or hides the view in userwindows.
		<docsubtitle>listadd operation</docsubtitle>
		window &lt;windowname&gt; listadd <text><br>
		Appends an item to the listbox, labeled with text.
		<docsubtitle>listremove operation</docsubtitle>
		window &lt;windowname&gt; listremove <index><br>
		Removes an item to the listbox.
		<docsubtitle>listclear operation</docsubtitle>
		window &lt;windowname&gt; listclear<br>
		Clears the listbox.
		<docsubtitle>Caption operation</docsubtitle>
		window &lt;windowname&gt; caption &lt;text&gt;<br>
		Change the caption for (user)windows. This command only changes the visible caption, not
		the window name.
		<docsubtitle>setclose</docsubtitle>
		window &lt;windowname&gt; setclose [on|off]<br>
		Enables or disables the close button for a specified window.<br>
	@examples:
		<example>
		window $console close
		</example>
*/

bool KviUserParser::parseCmd_WINDOW(KviCommand *c)
{
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingWindowName,"WINDOW",c->m_ptr);
	KviWindow *win = m_pFrm->findWindow(c->m_buffer.ptr());
	KviStr window = c->m_buffer;
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingWindowOperation,"WINDOW",c->m_ptr);
	KviStr command = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;

	if(kvi_strEqualNoLocaleCI("open",command.ptr())){
		if(!win) {
			if(*window.ptr() == '*') m_pFrm->createUWindow(window.ptr());
			else return recoverableError(c,KVI_ERROR_InvalidWindowName,"WINDOW",c->m_ptr);
		}
		//else the winname already exists!...what to do ? signal an error ? bring it to top ?
		else	// took this from "raise"
		if(win->mdiParent()){
			if(win->isMinimized())win->restore();
			if(m_pFrm->m_pMdi->topChild() != win->mdiParent()){
				m_pFrm->m_pMdi->setTopChild(win->mdiParent(),true);
			}
			if((!m_pFrm->isActiveWindow()) ||
				 (!m_pFrm->activeWindow()->isAttached()))g_pApp->raiseTopLevelWidget(win);
		} else g_pApp->raiseTopLevelWidget(win);

		return true; //must return (do not show the "unknown operation" warning
	} else {
		// Avoid segfaulting :)
		if(!win)return recoverableError(c,KVI_ERROR_WindowNotFound,"WINDOW",c->m_buffer.ptr());
	}

	if(kvi_strEqualNoLocaleCI(command.ptr(),"input")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"on")) // show input
				((KviUWindow *)(win))->hasInput(true);
			else
				((KviUWindow *)(win))->hasInput(false); // hide input
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"list")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"on")) // show list
				((KviUWindow *)(win))->hasList(true);
			else
				((KviUWindow *)(win))->hasList(false); // hide list
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"view")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"on")) // show view
				((KviUWindow *)(win))->hasView(true);
			else
				((KviUWindow *)(win))->hasView(false); // hide view
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"setclose")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"on")) // enable the close button
				((KviUWindow *)(win))->enableClose(true);
			else
				((KviUWindow *)(win))->enableClose(false); // disable the close button
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"caption")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
//			if(!m_pFrm->findWindow(c->m_buffer.ptr())) {  // Avoid using exsisting names ?
				if(win->mdiParent())win->mdiParent()->setCaption(c->m_buffer.ptr());
				else win->setCaption(c->m_buffer.ptr());
//			}
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"listadd")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			((KviUWindow *)(win))->listAdd(c->m_buffer.ptr());
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"listremove")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			int index;
			if(sscanf(c->m_buffer.ptr(),"%d",&index) == 1)
			((KviUWindow *)(win))->listRemove(index);
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"listclear")){
		if(win->m_type == KVI_WND_TYPE_UWINDOW) {
			((KviUWindow *)(win))->listClear();
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"close")){
		win->close();
		if(c->m_wnd == win)c->m_wnd = m_pConsole; //reparent this command!!!
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"dock")){
		if(!win->isAttached())win->attach();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"undock")){
		if(win->isAttached())win->detach();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"minimize")){
		win->minimize();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"maximize")){
		win->maximize();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"restore")){
		win->restore();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"highlight")){
		win->highlight();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"raise")){
		if(win->mdiParent()){
//			if(win->isMinimized() || win->isMaximized())win->restore(); i don't like that behaviout
			if(win->isMinimized())win->restore();
			if(m_pFrm->m_pMdi->topChild() != win->mdiParent()){
				m_pFrm->m_pMdi->setTopChild(win->mdiParent(),true);
			}
			if((!m_pFrm->isActiveWindow()) ||
				 (!m_pFrm->activeWindow()->isAttached()))g_pApp->raiseTopLevelWidget(win);
		} else g_pApp->raiseTopLevelWidget(win);
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"clear")){
		if(!win->m_pView){
			return recoverableError(c,KVI_ERROR_ThisWindowHasNoTextBuffer,"WINDOW",window.ptr());
		} else win->m_pView->clearBuffer();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"move")){
		int x,y;
		if(sscanf(c->m_buffer.ptr(),"%d, %d",&x,&y) != 2){
			return recoverableError(c,KVI_ERROR_WindowPositionXYExpected,"WINDOW",c->m_buffer.ptr());
		}
		if(win->mdiParent()){
			if(win->isMinimized() || win->isMaximized())win->restore();
			win->mdiParent()->move(x,y);
		} else win->move(x,y);
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"resize")){
		int w,h;
		if(sscanf(c->m_buffer.ptr(),"%d, %d",&w,&h) != 2){
			return recoverableError(c,KVI_ERROR_WindowSizeExpected,"WINDOW",c->m_buffer.ptr());
		}
		if(win->mdiParent()){
			if(win->isMinimized() || win->isMaximized())win->restore();
			win->mdiParent()->resize(w,h);
		} else win->resize(w,h);
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"background")){
		if(!win->m_pView){
			return recoverableError(c,KVI_ERROR_ThisWindowHasNoTextBuffer,"WINDOW",window.ptr());
		} else {
			if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingFileName,"WINDOW");
			if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"none")){
				QPixmap null_pix;
				win->m_pView->setPrivateBackgroundPixmap(null_pix);				
			} else {
				KviStr szImage;
				if(!g_pApp->findImage(szImage,c->m_buffer.ptr())){
					return recoverableError(c,KVI_ERROR_CantOpenFileForReading,"WINDOW",c->m_buffer.ptr());
				}
				QPixmap pix(szImage.ptr());
				if(pix.isNull()){
					return recoverableError(c,KVI_ERROR_UnknownImageFormat,"WINDOW",szImage.ptr());
				}
				win->m_pView->setPrivateBackgroundPixmap(pix);
			}
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"timestamp")){
		if(!win->m_pView)return recoverableError(c,KVI_ERROR_ThisWindowHasNoTextBuffer,"WINDOW",window.ptr());
		else win->m_pView->setTimestamp(kvi_strEqualCI(c->m_buffer.ptr(),"on"));
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"icons")){
		if(!win->m_pView)return recoverableError(c,KVI_ERROR_ThisWindowHasNoTextBuffer,"WINDOW",window.ptr());
		else win->m_pView->setShowImages(kvi_strEqualCI(c->m_buffer.ptr(),"on"));
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"savebuffer")){
		if(!win->m_pView)return recoverableError(c,KVI_ERROR_ThisWindowHasNoTextBuffer,"WINDOW",window.ptr());
		else {
			if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingFileName,"WINDOW");
			if(!win->m_pView->saveBuffer(c->m_buffer.ptr())){
				return recoverableError(c,KVI_ERROR_UnableToSaveBuffer,"WINDOW",c->m_buffer.ptr());
			}
		}
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"commandline")){
		if(!win->m_pInput)return recoverableError(c,KVI_ERROR_ThisWindowHasNoCommandline,"WINDOW",window.ptr());
		else win->m_pInput->setText(c->m_buffer.ptr());
	} else return recoverableError(c,KVI_ERROR_UnknownWindowOperation,"WINDOW",command.ptr());

	return true;
}

/*
	@command: GEOMETRY
	@short:
		Handles geometry settings
	@syntax:
		geometry &gt;operation&lt; [parameters]
	@description:
		Manages mdi geometry.<br>
		Available operations: expand, tile, cascade.<br>
		<docsubtitle>Expand</docsubtitle>
		geometry expand [ H | V ]<br><br>
		Expands all windows in the current frame.<br>
		By specifying H or V you can expand windows horizontal or vertical.
		If you leave the parameter, windows will be expanded their maximum size,
		both horizontal and vertical.<br>
		<docsubtitle>Tile</docsubtitle>
		geometry tile [ anodine | pragmaH | pragmaV ]<br>
		This will tile the windows in the specified mode (like in menubar).
		If no parameter is specified to tile, anodine's tile will be used.<br>
		<docsubtitle>Cascade</docsubtitle>
		geometry cascade [ max ]<br>
		This will cascade the windows.
		If max is specified windows will be cascaded with maximal size.<br>
	@seealso:
		<a href="window.kvihelp">window</a>
*/

bool KviUserParser::parseCmd_GEOMETRY(KviCommand *c)
{
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingWindowOperation,"GEOMETRY",c->m_ptr);
	KviStr command = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;

	if(kvi_strEqualNoLocaleCI(command.ptr(),"expand")){
		if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"H")) // expand horizontal
			m_pFrm->m_pMdi->expandHorizontal();
		else if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"V")) // expand vertical
			m_pFrm->m_pMdi->expandVertical();
		else											// expand h+v
			m_pFrm->m_pMdi->expand();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"cascade")){
		if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"max")) // expand horizontal
			m_pFrm->m_pMdi->cascadeMaximized();
		else											// expand h+v
			m_pFrm->m_pMdi->cascadeWindows();
	} else if(kvi_strEqualNoLocaleCI(command.ptr(),"tile")){
		if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"pragmaH")) // expand horizontal
			m_pFrm->m_pMdi->tilePragmaHorizontal();
		else if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"pragmaV")) // expand vertical
			m_pFrm->m_pMdi->tilePragmaVertical();
		else											// expand h+v
			m_pFrm->m_pMdi->tileAnodine();
	} else return recoverableError(c,KVI_ERROR_UnknownWindowOperation,"GEOMETRY",command.ptr());

	return true;
}


/*
	@command: CLEAR
	@short:
		Clears the text buffer of the current window
	@syntax:
		clear
	@description:
		Clears the text buffer of the current window.<br>
		This is more or less equivalent to <a href="window.kvihelp">window</a>,
		but works only for the current window and will not give an error
		if the window has no text view.<br>
	@seealso:
		<a href="window.kvihelp">window</a>
*/

bool KviUserParser::parseCmd_CLEAR(KviCommand *c)
{
	if(c->m_wnd->m_pView)c->m_wnd->m_pView->clearBuffer();
	return processCmdFinalPart(c);
}

/*
	@command: OPENURL
	@short:
		Run the web browser.<br>
	@syntax:
		openurl &lt;url&gt;
	@description:
		Attempts to run the user specified browser and open the specified url.<br>
*/

bool KviUserParser::parseCmd_OPENURL(KviCommand *c)
{
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingUrl,"OPENURL");
	KviStr tmp = g_pOptions->m_szBrowserCommandline;
	tmp.stripWhiteSpace();
	if(tmp.hasData()){
		tmp.replaceAll('%',c->m_buffer.ptr());
		tmp.stripWhiteSpace();
		if(tmp.hasData()){
			KviStr stat(KviStr::Format,__tr("Opening url %s"),c->m_buffer.ptr());
			m_pFrm->m_pStatusBar->tempText(stat.ptr(),5000);
			KviProcess proc;
			if(!proc.run(tmp.ptr()))c->warning(__tr("[OPENURL]: Could not execute %s"),tmp.ptr());
			return true;
		}
	}
	return recoverableError(c,KVI_ERROR_MissingBrowserCommandlineOption,"OPENURL");
}

/*
	@command: FINDTEXT
	@short:
		Searches for text strings in a window.<br>
	@syntax:
		findtext [-w = &lt;window&gt;] [-p] &lt;text_string&gt;
	@description:
		Finds the next (or previous) line of text that contains at least one occurence of
		&lt;text_string&gt; in the output widget of a window.<br>
		If the -w switch is not specified, the current window is used.<br>
		The -p switch makes the search go backwards.<br>
		When a line is found, it will be set to be the bottom line in the text view.<br>
		This search function is case-insensitive.<br>
*/

bool KviUserParser::parseCmd_FINDTEXT(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_NoTextToFind,"FINDTEXT");
	KviWindow * pWnd = c->m_wnd;
	KviStr wnd;
	if(c->hasSwitch('w'))
	{
		if(!c->getSwitchValue('w',wnd))return recoverableError(c,KVI_ERROR_MissingWindowName,"FINDTEXT");
		pWnd = m_pFrm->findWindow(wnd.ptr());
		if(!pWnd)return recoverableError(c,KVI_ERROR_WindowNotFound,"FINDTEXT",wnd.ptr());
	}
	if(!pWnd->m_pView)return recoverableError(c,KVI_ERROR_ThisWindowHasNoTextBuffer,"FINDTEXT",wnd.ptr());
	if(c->hasSwitch('p'))pWnd->m_pView->findPrev(c->m_buffer.ptr());
	else pWnd->m_pView->findNext(c->m_buffer.ptr());
	return true;
}

/*
	@command: TIMER
	@short:
		Starts a timer
	@syntax:
		timer [-s] [-w = &lt;window&gt;] (&lt;name&gt;,&lt;timeout&gt;[,magic_data])&lt;command&gt;
	@description:
		Starts a timer with a specified timeout in milliseconds.<br>
		Each time that the timer "fires", the &lt;command&gt; is executed.<br>
		If the -s switch is used, the timer fires only once (single shot).<br>
		If the -w switch is used, the timer is bound to the specified &lt;window&gt;,
		otherwise is bound to the current one.<br>
		If the window that the timer is bound to will be closed
		the timer will be automatically stopped (So if you want a timer that never stops,
		it is a good idea to bind it to the console).<br>
		The &lt;command&gt; will be also executed in that window.<br>
		The timer &lt;name&gt; is used to refer the timer when killing it (see <a href="killtimer.kvihelp">KILLTIMER</a>.<br>
		It is also available in the &lt;command&gt; trough the <a href="s_timername.kvihelp">$timername</a> identifier.<br>
		The magic data is a string that may contain identifers to be parsed at /TIMER call time.<br>
		It will be then available in the &lt;command&gt; trough the <a href="s_timermagic.kvihelp">$timermagic</a> identifier.<br>
	@examples:
		<example>
			timer -s -w = <a href="s_console.kvihelp">$console</a> (myTimer,10000,$window at $time) echo -w=$window This is the timer $timername, it was executed in the window $timermagic : now it is $time
		<example>
	@seealso:
		<a href="killtimer.kvihelp">killtimer</a>,
		<a href="s_timermagic.kvihelp">$timermagic</a>,
		<a href="s_timername.kvihelp">$timername</a>
		<a href="s_istimer.kvihelp">$IsTimer()</a>
*/

// timer [-s] [-w=<window&gt;] (name,timeout_in_msecs[,magic])<command>
// -s : single shot
// -w=window


bool KviUserParser::parseCmd_TIMER(KviCommand *c)
{
	if(!extractSwitches(c))return false;
	KviWindow * wnd = c->m_wnd;
	if(c->hasSwitch('w')){
		KviStr tmp;
		if(c->getSwitchValue('w',tmp)){
			wnd = m_pFrm->findWindow(tmp.ptr());
			if(!wnd){
				c->warning(__tr("TIMER: Window not found (%s) : Binding to current window"),tmp.ptr());
				wnd = c->m_wnd;
			}
		} else c->warning(__tr("TIMER: Missing window name : Binding to current window"));
	}
	if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"TIMER",c->m_ptr);
	++(c->m_ptr);
	// get the timer name
	KviStr name;
	if(!processFncSingleParam(c,name))return false;
	name.replaceAll('*',".");
	if(name.isEmpty())return c->setError(KVI_ERROR_MissingTimerName,"TIMER");
	KviStr timeout;
	if(!processFncSingleParam(c,timeout))return false;
	bool bOk = false;
	int tmOut = timeout.toInt(&bOk);
	if(!bOk)return c->setError(KVI_ERROR_InvalidTimeout,"TIMER",timeout.ptr());
	if(tmOut < 0){
		c->warning(__tr("TIMER: Invalid timeout (%d) : Using default of 1000 msec."),tmOut);
		tmOut = 1000;
	}
	KviStr magic;
	if(!processFncFinalPart(c,magic))return false;

	KviWindowTimer * t = new KviWindowTimer;
	t->window     = wnd;
	t->timeout    = tmOut;
	t->name       = name;
	t->magic      = magic;
	t->singleShot = c->hasSwitch('s');

	c->skipWhitespace();
	const char *aux_ptr = c->m_ptr;
	if(!skipCommand(c)){
		delete t;
		return false;
	}
	t->job.append(aux_ptr,c->m_ptr - aux_ptr);

	addTimer(t);
	return true;
}

bool KviUserParser::skipTimer(KviCommand *c)
{
//	c->m_ptr+=5;
	if(!skipSwitches(c))return false;
	if(*(c->m_ptr) != '(')return c->setError(KVI_ERROR_OpenParenthesisExpected,"TIMER",c->m_ptr);
//	++(c->m_ptr);
	if(!skipExpressionBody(c))return false;
	c->skipWhitespace();
	return skipCommand(c);
}

/*
	@command: KILLTIMER
	@short:
		Stops a set of timers or lists running ones
	@syntax:
		killtimer [-l] [-q] &lt;timer-name-regexp&gt;
	@description:
		Kills all of the timers that match the &lt;timer-name-regexp&gt;.<br>
		If the -l switch is specified, the matching timers will be only listed, and not killed.<br>
		If the -q switch is specified, there will be no visual confirmation after the timers have been killed.<br>
	@seealso:
		<a href="timer.kvihelp">timer</a>,
		<a href="s_timermagic.kvihelp">$timermagic</a>,
		<a href="s_timername.kvihelp">$timername</a>,
		<a href="s_istimer.kvihelp">$IsTimer()</a>
*/

bool KviUserParser::parseCmd_KILLTIMER(KviCommand *c)
{
	// killtimer [-l] [-q] <name-regexp>
	if(!extractSwitches(c))return false;
	bool bListOnly = c->hasSwitch('l');
	bool bQuiet    = c->hasSwitch('q');
	if(!processCmdFinalPart(c))return false;
	c->m_buffer.stripWhiteSpace();
	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingTimerName,"TIMER");
	QRegExp rexp(_CHAR_2_QSTRING(c->m_buffer.ptr()),false,true);
	QList<KviWindowTimer> l;
	l.setAutoDelete(false);
	for(KviWindowTimer * t=m_pTimerList->first();t;t=m_pTimerList->next()){
		int len=0;
		if(rexp.match(_CHAR_2_QSTRING(t->name.ptr()),0,&len) == 0){
			if(len == t->name.len()){
				l.append(t);
			}
		}
	}

	if(l.isEmpty() && (!bQuiet))return recoverableError(c,KVI_ERROR_NoMatchingTimers,"TIMER",c->m_buffer.ptr());

	if(bListOnly){
		for(KviWindowTimer * tim=l.first();tim;tim=l.next()){
			c->m_wnd->output(KVI_OUT_TIME,__tr("Timer  : %s"),tim->name.ptr());
			c->m_wnd->output(KVI_OUT_TIME,__tr("Window : %s"),tim->window->caption());
			c->m_wnd->output(KVI_OUT_TIME,__tr("Timeout: %d %s"),tim->timeout,tim->singleShot ? __tr("msecs. (single shot)") : __tr("msecs."));
			c->m_wnd->output(KVI_OUT_TIME,__tr("Magic  : %s"),tim->magic.ptr());
		}
	} else {
		for(KviWindowTimer * tim=l.first();tim;tim=l.next())removeTimer(tim->name.ptr());
		if(!bQuiet)c->m_wnd->output(KVI_OUT_TIME,__tr("Killed %d timer(s)"),l.count());
	}
	return true;
}

/*
	@command: OPTION
	@short:
		Sets an internal option
	@syntax:
		option -l<br>
		option &lt;option name&gt; [option value]
	@description:
		Sets a value of an internal option.<br>
		"option -l" shows a list of available options and relative types.<br>
		- The "RGB color" options accept a value made of three unsigned numbers (range: 0-255) separated by commas (127,45,80).<br>
		These are the Red, Green and Blue components of the color.<br>
		- The "Boolean" options accept '0', '1', 'true' or 'false' as values.<br>
		- The "String" options accept a (eventually empty) string as value.<br>
		- The "Text color" accept a value from 0 to 15.<br>
		For background color settings, a value of 100 is allowed to indicate "transparent" background.<br>
		- The "Integer" options accept a number as value.<br>
		- The "Font" options accept a font setting with the following syntax:<br>
			&lt;font_family&gt;,&lt;point_size&gt;		
	@seealso:
		<a href="s_option.kvihelp">$option()</a>
*/


bool KviUserParser::parseCmd_OPTION(KviCommand *c)
{
	// OPTION <option name> <value>
	c->skipSpace();
	if(!processCmdFinalPart(c))return false;
	KviStr option_name;
	c->m_buffer.getToken(option_name,' ');
	if(option_name.isEmpty())return c->setError(KVI_ERROR_MissingOptionName,"OPTION");
	if(kvi_strEqualNoLocaleCI(option_name.ptr(),"-l")){
		// list the available options
		c->m_wnd->output(KVI_OUT_INTERNAL,__tr("List of available option names and types:"));
		for(int i=0;g_pOptions->optColorsTable[i].optName;i++)
			c->m_wnd->output(KVI_OUT_INTERNAL,__tr("%s : RGB color"),g_pOptions->optColorsTable[i].optName);
		for(int i=0;g_pOptions->optBoolTable[i].optName;i++)
			c->m_wnd->output(KVI_OUT_INTERNAL,__tr("%s : Boolean"),g_pOptions->optBoolTable[i].optName);
		for(int i=0;g_pOptions->optStringsTable[i].optName;i++)
			c->m_wnd->output(KVI_OUT_INTERNAL,__tr("%s : String"),g_pOptions->optStringsTable[i].optName);
		for(int i=0;g_pOptions->optTextTable[i].optName;i++)
			c->m_wnd->output(KVI_OUT_INTERNAL,__tr("%s : Text color"),g_pOptions->optTextTable[i].optName);
		for(int i=0;g_pOptions->optIntTable[i].optName;i++)
			c->m_wnd->output(KVI_OUT_INTERNAL,__tr("%s : Integer"),g_pOptions->optIntTable[i].optName);
		for(int i=0;g_pOptions->optFontsTable[i].optName;i++)
			c->m_wnd->output(KVI_OUT_INTERNAL,__tr("%s : Font"),g_pOptions->optFontsTable[i].optName);
		return true;
	}

	bool found_option = false;
	int  opt_flags    = 0;

	KviOptionEntry * optTable;

	switch(tolower(*(option_name.ptr()))){
		case 'c': optTable = g_pOptions->optColorsTable;  break;
		case 'b': optTable = g_pOptions->optBoolTable;    break;
		case 'f': optTable = g_pOptions->optFontsTable;   break;
		case 's': optTable = g_pOptions->optStringsTable; break;
		case 't': optTable = g_pOptions->optTextTable;    break;
		case 'i': optTable = g_pOptions->optIntTable;     break;
		default:
			return recoverableError(c,KVI_ERROR_NoSuchOption,"OPTION",option_name.ptr());
		break;
	}

	for(int i=0;optTable[i].optName;i++){
		if(kvi_strEqualNoLocaleCI(optTable[i].optName,option_name.ptr())){
			found_option=true;
			opt_flags = optTable[i].optType & KVI_OPT_FLAG_MASK;
			if(c->m_buffer.isEmpty()){
				if((optTable[i].optType & KVI_OPT_TYPE_MASK) != KVI_OPT_STR){
					return recoverableError(c,KVI_ERROR_MissingOptionValue,"OPTION",option_name.ptr());
				}
			}
			switch (optTable[i].optType & KVI_OPT_TYPE_MASK) {
				case KVI_OPT_BOOL:	
					if(kvi_strEqualCS(c->m_buffer.ptr(),"1"))
						*((bool *)(optTable[i].optValue))=true;
					else if(kvi_strEqualCS(c->m_buffer.ptr(),"0"))
						*((bool *)(optTable[i].optValue))=false;
					else if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"true"))
						*((bool *)(optTable[i].optValue))=true;
					else if(kvi_strEqualNoLocaleCI(c->m_buffer.ptr(),"false"))
						*((bool *)(optTable[i].optValue))=false;
					else return recoverableError(c,KVI_ERROR_InvalidOptionType,"OPTION",option_name.ptr());
					break;
				case KVI_OPT_CLR:
					{
						int r,g,b;
						if(sscanf(c->m_buffer.ptr(),"%d , %d , %d",&r,&g,&b) == 3){
							((QColor *)(optTable[i].optValue))->setRgb(r,g,b);
						} else return recoverableError(c,KVI_ERROR_InvalidOptionType,"OPTION",option_name.ptr());
					}
					break;
				case KVI_OPT_PCLR:
					{
						int r,g,b;
						if(sscanf(c->m_buffer.ptr(),"%d , %d , %d",&r,&g,&b) == 3){
							if(((QColor **)(optTable[i].optValue))!= 0){
								(*((QColor **)(optTable[i].optValue)))->setRgb(r,g,b);
							} else return c->setError(KVI_ERROR_InternalError,"OPTION");
						} else return recoverableError(c,KVI_ERROR_InvalidOptionType,"OPTION",option_name.ptr());
					}
					break;
				case KVI_OPT_FNT:
						KviConfig::setFontProperties(c->m_buffer,((QFont *)(optTable[i].optValue)));
					break;
				case KVI_OPT_TXTF:
					{
						bool bOk = false;
						unsigned char value = c->m_buffer.toUChar(&bOk);
						if((!bOk) || (value > 15))return recoverableError(c,KVI_ERROR_InvalidOptionType,"OPTION",option_name.ptr());
						else (*((unsigned char *)(optTable[i].optValue))) = value;
					}
					break;
				case KVI_OPT_INT:
					{
						bool bOk = false;
						int value = c->m_buffer.toInt(&bOk);
						if(bOk)(*((int *)(optTable[i].optValue))) = value;
						else return recoverableError(c,KVI_ERROR_InvalidOptionType,"OPTION",option_name.ptr());
					}
					break;
				case KVI_OPT_TXTB:
					{
						bool bOk = false;
						unsigned char value = c->m_buffer.toUChar(&bOk);
						if((!bOk) || ((value > 15) && (value != KVI_TRANSPARENT)))return recoverableError(c,KVI_ERROR_InvalidOptionType,"OPTION",option_name.ptr());
						else (*((unsigned char *)(optTable[i].optValue))) = value;
					}
					break;
				case KVI_OPT_STR:
						*((KviStr *)(optTable[i].optValue))=c->m_buffer;
					break;
				default: //never here
					break;
			} // switch
		}
	}
	if(!found_option)return recoverableError(c,KVI_ERROR_NoSuchOption,"OPTION",option_name.ptr());

	if(opt_flags){
		switch(opt_flags){
			case KVI_OPT_CAPTION:
				for(KviFrame *f = g_pApp->m_pFrameList->first();f;f= g_pApp->m_pFrameList->next())
					f->updateCaption();
			break;
			case KVI_OPT_GUI:
				g_pApp->triggerGlobalRepaint();
			break;
			default: //newer here
			break;
		}
	}
	return true;

}

/*
	@command: PLAY
	@short:
		Plays a file :)
	@syntax:
		play &lt;filename&gt;
	@description:
		This command first tries to find the file on the local storage devices:<br>
		If the filename is an absolute path it checks for its existence.<br>
		If the filename is a relative path, it first tries to pre-guess
		the file MIME type from the extension and if it can be done
		looks in the save path for that MIME type.<br>
		If the file is still not found, KVIrc tries the following directories:<br>
		KVIrc Local incoming directory.<br>
		KVIrc Local pics directory.<br>
		KVIrc Local audio directory.<br>
		KVIrc Global pics directory.<br>
		KVIrc Global audio directory.<br>
		Home direcory.<br>
		At this point, if the file cannot be found at all KVIrc guesses the <a href="doc_mimetypes.kvihelp">MIME type</a>
		from the filename and tries to execute the corresponding commandline,
		hoping that the "player" program will be able to find the file;<br>
		if the file is found, KVIrc guesses the <a href="doc_mimetypes.kvihelp">MIME type</a> from the filename
		and by reading the first bytes of the file (if the <a href="doc_mimetypes.kvihelp">MIME type</a> has "magic bytes" specified),
		then tries to execute the corresponding commandline.<br>
		It may look a bit complicated...:)...yes, it is.<br>
		Example:<br>
		If you want to be able to play mp3 files, open the "general options" dialog
		and choose the MIME type options (Misc/MIME types).<br>
		Add a new MIME type and edit it in the following way:<br>
		In the "name" field write "MPEG-Layer 3 audio".<br>
		In the "file mask" field write "*.mp3".<br>
		In the "commandline" field type "<a href="run.kvihelp">run</a> xmms <a href="s_execfilename.kvihelp">$ExecFileName</a>".<br>
		Type OK and then try to /PLAY &lt;file&gt;.mp3.<br>
		KVIrc will recognise that the file as a "MPEG-Layer 3 audio" file
		and run the command "xmms &lt;file&gt;.mp3".<br>
		Notes:<br>
		- The "save path" field in the MIME types tab is used when you're downloading files by DCC.
		Autoaccepted files matching this MIME type will be saved to the corresponding directory).<br>
		- The "magic bytes" field is used to find best MIME type matches if the file
		is available for reading.<br>
		It is a regular expression that defines the first bytes of the header of the file
		that matches the MIME type.<br>
	@seealso:
		<a href="doc_mimetypes.kvihelp">MIME types documentation</a>, <a href="multimedia.kvihelp">MULTIMEDIA</a>,
		<a href="sound.kvihelp">SOUND</a>
*/

bool KviUserParser::parseCmd_PLAY(KviCommand *c)
{
	// PLAY filename
	c->skipSpace();

	if(!processCmdFinalPart(c))return false;

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingFileName,"PLAY");

	KviStr szPath;
	// Find the file
	bool bExists = g_pApp->findUserFile(szPath,c->m_buffer.ptr());
	// If it does not exist, find the first mime type that matches and
	// then just run the command, hoping that the inquired program will
	// be able to find it itself
	KviMimeType * m = g_pOptions->m_pMimeManager->findMatch(szPath.ptr(),bExists);

	if(m){
		if(m->commandline.hasData()){
			g_pApp->executeFileWithCommand(m->commandline.ptr(),szPath.ptr(),m_pFrm);
		} else return recoverableError(c,KVI_ERROR_NoCommandlineForMimeType,"PLAY",m->mimeName.ptr());
	} else return recoverableError(c,KVI_ERROR_NoMimeTypeMatching,"PLAY",szPath.ptr());

	return true;
}

/*
	@command: MULTIMEDIA
	@short:
		Plays a file and sends the related CTCP MULTIMEDIA to the current target
	@syntax:
		multimedia &lt;filename&gt;
	@description:
		When typed in a channel or query, this command <a href="play.kvihelp">plays</a> the specified file
		and then sends a "CTCP MULTIMEDIA &lt;filename&gt;" to the current target (channel or query remote end).<br>
		Typed in another type of window this command is equivalent to <a href="play.kvihelp">PLAY</a>.<br>
		You can find more info about CTCP MULTIMEDIA in <a href="doc_ctcp_multimedia.kvihelp">this</a> document.<br>
	@seealso:
		<a href="sound.kvihelp">SOUND</a>, <a href="play.kvihelp">PLAY</a>,
		<a href="doc_ctcp_multimedia.kvihelp">Ctcp Multimedia documentation</a>
*/



bool KviUserParser::parseCmd_MULTIMEDIA(KviCommand *c)
{
	return parseCmd_MULTIMEDIAORSOUND(c,"MULTIMEDIA");
}

/*
	@command: SOUND
	@short:
		Plays a file and sends the related CTCP SOUND to the current target
	@syntax:
		sound &lt;filename&gt;
	@description:
		When typed in a channel or query, this command <a href="play.kvihelp">plays</a> the specified file
		and then sends a "CTCP SOUND &lt;filename&gt;" to the current target (channel or query remote end).<br>
		Typed in another type of window this command is equivalent to <a href="play.kvihelp">PLAY</a>.<br>
		In KVIrc, CTCP SOUND is equivalent to CTCP MULTIMEDIA : KVIrc will process both in the same way.<br>
		You can find more info about CTCP MULTIMEDIA in <a href="doc_ctcp_multimedia.kvihelp">this</a> document.<br>
	@seealso:
		<a href="multimedia.kvihelp">MULTIMEDIA</a>, <a href="play.kvihelp">PLAY</a>,
		<a href="doc_ctcp_multimedia.kvihelp">Ctcp Multimedia documentation</a>
*/

bool KviUserParser::parseCmd_SOUND(KviCommand *c)
{
	return parseCmd_MULTIMEDIAORSOUND(c,"SOUND");
}

bool KviUserParser::parseCmd_MULTIMEDIAORSOUND(KviCommand *c,const char * ctcpName)
{
	// MULTIMEDIA filename
	c->skipSpace();

	if(!processCmdFinalPart(c))return false;

	if(c->m_buffer.isEmpty())return recoverableError(c,KVI_ERROR_MissingFileName,ctcpName);

	// ensure that it is a valid file name
	KviStr file = c->m_buffer;
	int idx = file.findLastIdx('/');
	if(idx >= 0)file.cutLeft(idx + 1);
	if(file.isEmpty())return recoverableError(c,KVI_ERROR_MissingFileName,ctcpName);

	KviStr szPath;
	// Find the file
	bool bExists = g_pApp->findUserFile(szPath,c->m_buffer.ptr());

	if(!bExists)return recoverableError(c,KVI_ERROR_CantOpenFileForReading,ctcpName);

	KviMimeType * m = g_pOptions->m_pMimeManager->findMatch(szPath.ptr(),bExists);

	if(m)
	{
		if(m->commandline.hasData())
		{
			g_pApp->executeFileWithCommand(m->commandline.ptr(),szPath.ptr(),m_pFrm);
		} else return recoverableError(c,KVI_ERROR_NoCommandlineForMimeType,ctcpName,m->mimeName.ptr());
	} else return recoverableError(c,KVI_ERROR_NoMimeTypeMatching,ctcpName,szPath.ptr());

	if((c->m_wnd->type() == KVI_WND_TYPE_CHANNEL)||(c->m_wnd->type() == KVI_WND_TYPE_QUERY))
	{
		if(!m_pSocket->sendFmtData("PRIVMSG %s :%c%s %s%c",c->m_wnd->caption(),
			0x01,ctcpName,file.ptr(),0x01))return notConnectedToServer(c,ctcpName);
		c->m_wnd->output(KVI_OUT_MULTIMEDIA,__tr("%s plays %s"),m_pFrm->m_global.szCurrentNick.ptr(),file.ptr());
	}

	if(g_pOptions->m_bListenToMultimediaFileRequests)
	{
		// remember the file...
		m_pFrm->addMultimediaFileOffert(szPath);
	}

	return true;
}


/*
	@command: CONFIG
	@short:
		Writes lists or removes entries of the global config file
	@syntax:
		config [&lt;section&gt; &lt;key&gt; &lt;value&gt;]<br>
		config -r [section [key]]<br>
		config -l<br>
		config -f<br>
	@description:
		Writes entries in the global config file.<br>
		The &lt;value&gt; is stored in the specified &lt;section&gt;
		of the config file and associated with the specified &lt;key&gt;.<br>
		If the -r switch is specified, entries are removed:<br>
		If a [section] and [key] is given, that specific [key] is removed.<r>
		If only a [section] is given, the whole [section] is removed.<br>
		If no [section] is specified, the whole config file is cleared.<br>
		If the -f switch is specified the config file is flushed to disk.<br>
		KVIrc automatically flushes the config file when exiting.<br>
		Passing an empty string as &lt;value&gt; is equivalent to
		calling "config -r section key".<br>
		If the -l switch is specified, all of the config entries are listed in the current window.<br>
		Note: The config files work well with single line values.<br>
		If you need to store multiline data using the /CONFIG command
		you must transform the newlines in some other strings
		and then retransform it back when reading it again.<br>
	@seealso:
		<a href="s_config.kvihelp">$config()</a>
*/

bool KviUserParser::parseCmd_CONFIG(KviCommand *c)
{
	// config section key value
	if(!extractSwitches(c))return false;
	if(!processCmdFinalPart(c))return false;
	KviStr section;
	KviStr key;
	c->m_buffer.getToken(section,' ');
	c->m_buffer.getToken(key,' ');

	if(c->hasSwitch('r')){
		// remove entries
		if(section.hasData()){
			if(key.hasData()){
				g_pUserConfig->setGroup(section.ptr());
				g_pUserConfig->clearKey(key.ptr());
			} else g_pUserConfig->clearGroup(section.ptr());
		} else g_pUserConfig->clear();
	} else if(c->hasSwitch('l')){
			// List the whole config
			KviStr tmp;
			g_pUserConfig->getContentsString(tmp);
			c->m_wnd->output(KVI_OUT_INTERNAL,tmp.ptr());
	} else if(c->hasSwitch('f')){
		g_pUserConfig->sync();
	} else {
		c->m_buffer.stripWhiteSpace();
		if(section.hasData()){
			if(key.hasData()){
				g_pUserConfig->setGroup(section.ptr());
				if(c->m_buffer.isEmpty())g_pUserConfig->clearKey(key.ptr());
				else g_pUserConfig->writeEntry(key.ptr(),c->m_buffer.ptr());
			} else return recoverableError(c,KVI_ERROR_MissingKey,"CONFIG");
		} else return recoverableError(c,KVI_ERROR_MissingSection,"CONFIG");
	}
	return true;
}

/*
	@command: TRY
	@short:
		Tries the execution of a block of code
	@syntax:
		try &lt;command&gt;
	@description:
		Executes a block of code without generating errors.<br>
		This is useful when you want to test the existence of a command or
		identifier (for example, if you do not know if an alias has been defined
		or a plugin that exports a given command is currently enabled).<br>
		If the execution of the command encountered an error, the <a href="s_tryresult.kvihelp">$tryresult</a>
		identifier will contain 0, otherwise 1.<br>
		Please note that this will not save you from syntax errors in the block of code.<br>
		It can just check for "well written" unknown identifiers and commands.<br>
	@examples:
		This will return 1<br>
		<example>
			try <a href="echo.kvihelp">echo Hihi :)
		</example>
		This may return 1 or 0<br>
		<example>
			try {
			&nbsp;&nbsp;myalias par1 par2
			}
			if(<a href="s_tryresult.kvihelp">$tryresult</a>)<a href="echo.kvihelp">echo</a> Alias "myalias" is defined
			else <a href="echo.kvihelp">echo</a> Alias "myalias" is not defined.
		</example>
		This will return 0.<br>
		<example>
		try a_command_name_that_does_not_exist some_parameters
		</example>
	@seealso:
		<a href="s_tryresult.kvihelp">$tryResult</a>
*/

bool KviUserParser::parseCmd_TRY(KviCommand *c)
{
	c->skipWhitespace();
	if(!(*(c->m_ptr)))return c->setError(KVI_ERROR_MissingCommandBlockToTry,"TRY");
	const char *aux = c->m_ptr;
	if(!skipCommand(c))return false;
	const char *endPtr = c->m_ptr;
	c->m_ptr = aux;
	if((*(c->m_ptr)) == '{')m_szLastTryResult = (execCommandBlock(c) ? "1" : "0");
	else m_szLastTryResult = (execSingleCommand(c) ? "1" : "0");
	c->setError(KVI_ERROR_NoError,"","");
	c->m_ptr = endPtr;
	return true;
}

bool KviUserParser::skipTry(KviCommand *c)
{
//	c->m_ptr+=3;
	c->skipWhitespace();
	if(!(*(c->m_ptr)))return c->setError(KVI_ERROR_MissingCommandBlockToTry,"TRY");
	return skipCommand(c);
}

/*
	@command: WRITEFILE
	@short:
		Writes a buffer of data to a file
	@syntax:
		writefile [-a] [-n] &lt;filename&gt; &lt;data&gt;
	@description:
		Writes the &lt;data&gt; string to the file &lt;filename&gt;.<br>
		If the -a switch is specified, the &lt;data&gt; string is appended
		to the end of the existing file, otherwise, the file is first truncated
		to length 0 and then the data is written.<br>
		If the file does not exist, it is created.<br>
		If the -n switch is specified, a trailing newline is written.<br>
		&lt;data&gt; can be also an empty string.<br>
	@examples:
		<example>
			writefile <a href="s_kvircdir.kvihelp">$KvircDir</a>/test.txt TEST
		</example>
		A longer one...
		<example>
			%file = <a href="s_getenv.kvihelp">$getEnv</a>(HOME)/myfunps
			writefile -n %file echo Take a look at the KVIrc process
			writefile -a -n %file ps u | grep kvirc
			writefile -a %file echo Yeah!
			<a href="exec.kvihelp">exec</a> -q chmod 0777 %file
			<a href="exec.kvihelp">exec</a> -q %file
		</example>
	@seealso:
		<a href="s_readfile.kvihelp">$ReadFile()</a>
*/

bool KviUserParser::parseCmd_WRITEFILE(KviCommand *c)
{
	// writefile [-a] [-n] <filename> <data>
	if(!extractSwitches(c))return false;
	KviStr filename;
	if(!processCmdSingleToken(c))return false;
	filename = c->m_buffer;
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	if(filename.isEmpty())return recoverableError(c,KVI_ERROR_MissingFileName,"WRITEFILE");
	QFile f(filename.ptr());
	int mode = IO_WriteOnly;

	if(c->hasSwitch('a'))mode |= IO_Append;
	else mode |= IO_Truncate;

	if(!f.open(mode))return recoverableError(c,KVI_ERROR_CantOpenFileForWriting,"WRITEFILE",filename.ptr());
	if(c->hasSwitch('n'))c->m_buffer.append('\n');
	if(f.writeBlock(c->m_buffer.ptr(),c->m_buffer.len()) < c->m_buffer.len()){
		debug("WARNING: WRITEFILE: write() failure: wrote less data than requested");
	}
	f.close();
	return true;
}

/*
	@command: CONNECT
	@short:
		Connects an objects signal to a slot
	@syntax:
		connect &lt;src&gt; &lt;signal&gt; &lt;dst&gt; &lt;slot&gt;
	@description:
		Connects the &tl;src&gt; object's signal to the &lt;dst&gt; object's slot.<br>
		Mutliple signals can be connected to the same slot and multiple slots
		can handle a single signal.<br>
		A single slot can be connected multiple times to the same slot.<br>
		To disconnect a signal / slot use the [cmd]disconnect[/cmd] command.<br>
		The signals / slots are automatically disconnected when one of the objects
		(src or dst) is being destroyed.<br>
	@examples:

	@seealso:
		[cmd]disconnect[/cmd],<br>
		<a href="syntax_objects.kvihelp#signals">Objects documentation</a>
*/

bool KviUserParser::parseCmd_CONNECT(KviCommand *c)
{
	// connect src signal dst slot
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingObjectId,__tr("CONNECT"),__tr("Source object expected"));
	KviScriptObject * o1 = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o1){
		KviStr tmp = c->m_buffer.ptr();
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_ObjectNotFound,__tr("CONNECT"),tmp.ptr());
	}
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingSignalName,__tr("CONNECT"));
	KviStr signal = c->m_buffer;
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingObjectId,__tr("CONNECT"),__tr("Destination object expected"));
	KviScriptObject * o2 = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o2){
		KviStr tmp = c->m_buffer.ptr();
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_ObjectNotFound,__tr("CONNECT"),tmp.ptr());
	}
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingSlotName,__tr("CONNECT"));
	KviScriptObject::connectSignalSlot(o1,signal.ptr(),o2,c->m_buffer.ptr());
	return true;
}

/*
	@command: DISCONNECT
	@short:
		Disconnects an object's signal from a slot
	@syntax:
		disconnect &lt;src&gt; &lt;signal&gt; &lt;dst&gt; &lt;slot&gt;
	@description:
		Disconnects the &tl;src&gt; object's signal from the &lt;dst&gt; object's slot.<br>
		See the documentation for [cmd]connect[/cmd] and the 
		<a href="syntax_objects.kvihelp#signals">Object signals/slots documentation</a>
		for more info.<br>
	@examples:

	@seealso:
		[cmd]connect[/cmd],<br>
		<a href="syntax_objects.kvihelp#signals">Objects documentation</a>
*/

bool KviUserParser::parseCmd_DISCONNECT(KviCommand *c)
{
	// disconnect src signal dst slot
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingObjectId,__tr("DISCONNECT"),__tr("Source object expected"));
	KviScriptObject * o1 = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o1){
		KviStr tmp = c->m_buffer.ptr();
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_ObjectNotFound,__tr("DISCONNECT"),tmp.ptr());
	}
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingSignalName,__tr("DISCONNECT"));
	KviStr signal = c->m_buffer;
	c->clearBuffer();
	if(!processCmdSingleToken(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingObjectId,__tr("DISCONNECT"),__tr("Destination object expected"));
	KviScriptObject * o2 = m_pScriptObjectController->findObjectById(c->m_buffer.ptr());
	if(!o2){
		KviStr tmp = c->m_buffer.ptr();
		if(!processCmdFinalPart(c))return false;
		return recoverableError(c,KVI_ERROR_ObjectNotFound,__tr("DISCONNECT"),tmp.ptr());
	}
	c->clearBuffer();
	if(!processCmdFinalPart(c))return false;
	if(c->m_buffer.isEmpty())return c->setError(KVI_ERROR_MissingSlotName,__tr("DISCONNECT"));
	KviScriptObject::disconnectSignalSlot(o1,signal.ptr(),o2,c->m_buffer.ptr());
	return true;
}

