#ifndef _KVI_DCC_VOICE_H_INCLUDED_
#define _KVI_DCC_VOICE_H_INCLUDED_

//
//   File : kvi_dcc_chat.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dcc_voice.h)
//   Last major modification : Thu Feb 11 1999 20:06:34 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_window.h"
#include "kvi_thread.h"
#include "kvi_string.h"

#include "kvi_adpcm.h"

#include <qqueue.h>
#include <qpushbutton.h>
#include <qlabel.h>

class KviDccVoice;

#define KVI_DCC_VOICE_STATE_IDLE 0
#define KVI_DCC_VOICE_STATE_TALK 1
//#define KVI_DCC_VOICE_STATE_PLAYBACK 2

//each buffer is ~0.128 sec of audio
//Read from sound card buffer in bytes!
#define KVI_READ_BUF_SIZE_IN_CHARS 2048 
#define KVI_READ_BUF_SIZE_IN_SHORTS 1024
//By now should be same as above
#define KVI_WRITE_BUF_SIZE_IN_CHARS 2048
#define KVI_WRITE_BUF_SIZE_IN_SHORTS 1024 
//4:1 compression
#define KVI_COMPRESSED_SAMPLE_SIZE_IN_CHARS 512

//a compressed saple readed or ready to send
typedef struct SampleStruct{
	char buffer[KVI_COMPRESSED_SAMPLE_SIZE_IN_CHARS];
	SampleStruct *next;
};

typedef struct KviDccVoiceStruct
{
	KviStr nick;
	KviStr username;
	KviStr host;
	KviStr szAddress;

	unsigned long uAddress; //an internet address in network byte order
	unsigned short uPort; // a port in host byte order
	KviDccVoice *dccVoiceParent;

	KviStr soundDevice;
	int soundFd; //sound file descriptor
	bool fullDuplex;
	char soundReadBuffer[KVI_READ_BUF_SIZE_IN_CHARS];
	char soundWriteBuffer[KVI_WRITE_BUF_SIZE_IN_CHARS];
	ADPCM_state writeAdpcm;
	ADPCM_state readAdpcm;
	// send queue
	SampleStruct * sendHead;
	SampleStruct * sendTail;
	int lastSentSize;
	int completeBuffers;
	int lastReadSize;
//	// receive queue
	SampleStruct * recvHead;
	SampleStruct * recvTail;
	SampleStruct * tempSample;
	int recvQueueCount;
	// Play state and relative mutex
	bool bPlaying;
	pthread_mutex_t playMutex;

	volatile int state; // (volatile?)
	int prevState;
	KviStr tmpBuffer;

	bool use090CompatibleCompression;
	unsigned short int uPortToListenOn;
};

class KviDccVoice : public KviWindow
{
	Q_OBJECT
public:		// Consruction & Destruction
	KviDccVoice(KviFrame *lpFrm,const char *name);
	~KviDccVoice();
public:		// Fields
	pthread_t m_thread;
	bool m_bThreadRunning;
	KviDccVoiceStruct * m_pDccVoiceStruct;
	KviStr m_szRemoteNick;
	KviStr m_szRemoteMask;
	KviStr m_szLocalNick;
	KviStr m_szLocalMask;
	QLabel      * m_pStatLabel;
	QPushButton * m_pTalkButton;
public:		// Methods
	void acceptDccRequest(const char *nick,const char *username,const char *host,unsigned long uAddress,unsigned short uPort);
	void requestDcc(const char *nick,const char *username,const char *host);
//	bool sendData(const char *buffer);
protected:	// Protected methods
	virtual QPixmap * myIconPtr();
	virtual void resizeEvent(QResizeEvent *);
	virtual void applyOptions();
	virtual bool event(QEvent *e);

//	int openSoundCardForWriting(KviDccVoiceStruct * dcc);
//	int openSoundCardForReading(KviDccVoiceStruct * dcc);
	int checkSoundCard(KviDccVoiceStruct * dcc);
protected slots:
	void talkPressed();
	void talkReleased();
};

#endif //_KVI_DCC_VOICE_H_INCLUDED_
