//
//   File : kvi_dlgregusers.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_dlgregusers.cpp)
//   Last major modification : Fri May 28 1999 01:45:46 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#define _KVI_DLGREGUSERS_CPP_

#include "kvi_dlgregusers.h"
#include "kvi_options.h"
#include "kvi_defines.h"

#include "kvi_app.h"
#include "kvi_string.h"
#include "kvi_locale.h"
//#include "kvi_quickhelp.h"
#include "kvi_regusersdb.h"

#include "kvi_listview.h"
#include <qpushbutton.h>
#include "kvi_selectors.h"

#include <qlayout.h>
#include <qframe.h>
#include <qtooltip.h>

/* FIXME:  "save geometry of this dialog! (kvi_options.cpp, i guess)" */

KviDlgRegUsers::KviDlgRegUsers(QWidget *parent)
:QTabDialog(parent,"dlgregusers")
{
	setCaption(_i18n_("KVIrc: Registered Users"));

	QWidget * tab;
	QGridLayout *g;

	// ======== Registered users - tab =======
	tab = new QWidget(this);
	g = new QGridLayout(tab,2,2,10,4);


	// add another field ??? ---> something like the name in eggdrop...
	// (like a static nick, as unique identifier)
	m_pRegBox = new KviListView(tab);
	m_pRegBox->addColumn(_CHAR_2_QSTRING(__tr("Nickname")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(__tr("Username")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(__tr("Hostname")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(__tr("Flags")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(__tr("Password")));
	m_pRegBox->addColumn(_CHAR_2_QSTRING(__tr("Comment")));
	QToolTip::add(m_pRegBox->viewport(),
		__tr("Built-in flags:\n"\
			"b: Beep\n"\
			"n: Notify\n"\
			"i: Ignore"));

	QListViewItem * it;

	for(KviRegisteredUser * u = g_pOptions->m_pRegUsersDb->m_pRegList->first();u;u=g_pOptions->m_pRegUsersDb->m_pRegList->next())
	{
//		KviStr flags = u->bNotify ? "n" : "";
//		if(u->bIgnore)flags.append('i');
//		BuTi --- replaced this by u->allFlags		
		it = new QListViewItem(m_pRegBox,_CHAR_2_QSTRING(u->user.nick()),
			_CHAR_2_QSTRING(u->user.username()),_CHAR_2_QSTRING(u->user.host()),_CHAR_2_QSTRING(u->allFlags.ptr()),
			_CHAR_2_QSTRING(u->passwd.ptr()),_CHAR_2_QSTRING(u->comment.ptr()));
	}

	g->addMultiCellWidget(m_pRegBox,0,0,0,1);

	QPushButton * btn = new QPushButton(_CHAR_2_QSTRING(__tr("&Add User")),tab);
	connect(btn,SIGNAL(clicked()),this,SLOT(addNewUser()));
	g->addWidget(btn,1,0);

	btn = new QPushButton(_CHAR_2_QSTRING(__tr("&Remove User")),tab);
	connect(btn,SIGNAL(clicked()),this,SLOT(removeSelectedUsers()));
	g->addWidget(btn,1,1);

	g->activate();

	addTab(tab,_i18n_("&User Database"));


	// ======== Options - tab =======
	tab = new QWidget(this);
	g = new QGridLayout(tab,9,1,10,4);

	KviNewBoolSelector * b1 = new KviNewBoolSelector(tab,__tr("Enable notify list"),&(g_pOptions->m_bEnableNotifyList));
	g->addWidget(b1,0,0);

	KviNewIntegerSelector * i = new KviNewIntegerSelector(tab,__tr("Notify list check timeout:"),
		&(g_pOptions->m_iNotifyListCheckTimeoutInSecs),KviNewIntegerSelector::Int,
		10,65535,60,g_pOptions->m_bEnableNotifyList,100,0,0," second(s)");
	g->addWidget(i,1,0);
	connect(b1,SIGNAL(toggled(bool)),i,SLOT(setEnabled(bool)));


	QFrame *r = new QFrame(tab);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(r,2,0);

	KviNewBoolSelector * b = new KviNewBoolSelector(tab,__tr("Use DALnet 'watch' method"),
		&(g_pOptions->m_bEnableDalNetStyleNotifyMethod),g_pOptions->m_bEnableNotifyList);
	g->addWidget(b,3,0);
	connect(b1,SIGNAL(toggled(bool)),b,SLOT(setEnabled(bool)));

	r = new QFrame(tab);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(r,4,0);

	b = new KviNewBoolSelector(tab,__tr("Enable ignore on privmsg"),&(g_pOptions->m_bEnableIgnoreOnPrivmsg));
	g->addWidget(b,5,0);
	b = new KviNewBoolSelector(tab,__tr("Enable ignore on notice"),&(g_pOptions->m_bEnableIgnoreOnNotice));
	g->addWidget(b,6,0);
	b = new KviNewBoolSelector(tab,__tr("Verbose ignore"),&(g_pOptions->m_bVerboseIgnore));
	g->addWidget(b,7,0);

	r = new QFrame(tab);
	g->addWidget(r,8,0);
	g->setRowStretch(8,1);

	g->activate();

	addTab(tab,_i18n_("&Notify && Ignore"));

	// ======== common buttons =======

	setHelpButton(_CHAR_2_QSTRING(__tr("What's &This?")));
	connect(this,SIGNAL(helpButtonPressed()),g_pApp,SLOT(slot_whatIsThisRequest()));
	setOkButton(__tr("&OK"));
	setCancelButton(__tr("&Cancel"));
}

KviDlgRegUsers::~KviDlgRegUsers()
{

}

void KviDlgRegUsers::addNewUser()
{
	QListViewItem * it;
	it = new QListViewItem(m_pRegBox,_CHAR_2_QSTRING("*"),_CHAR_2_QSTRING("*"),_CHAR_2_QSTRING("*"),_CHAR_2_QSTRING(""));
}

void KviDlgRegUsers::removeSelectedUsers()
{
	QListViewItem * it = m_pRegBox->firstChild();
	while(it){
		QListViewItem *aux = it;
		it = it->nextSibling();
		if(aux->isSelected())delete aux;
	}
}

void KviDlgRegUsers::done(int r)
{
	QTabDialog::done(r);
	if(r == Accepted){


		KviNewBoolSelector::commitAll(this);
		KviNewIntegerSelector::commitAll(this);

		g_pOptions->m_pRegUsersDb->clear(); //Autodelete is true!
		QListViewItem * it = m_pRegBox->firstChild();	
		while(it){
			KviStr nick = it->text(0);	// nickname
			nick.stripWhiteSpace();
			KviStr user = it->text(1);	// user
			user.stripWhiteSpace();
			if(user.isEmpty())user = "*";
			KviStr host = it->text(2);	// host
			host.stripWhiteSpace();
			if(host.isEmpty())host = "*";
			KviStr flag = it->text(3);	// flags
			flag.stripWhiteSpace();
			KviStr passwd = it->text(4);	// password
			passwd.stripWhiteSpace();
			KviStr comment = it->text(5);	// comment
			comment.stripWhiteSpace();

			if(nick.hasData()){
				KviRegisteredUser * u = new KviRegisteredUser;
				u->user.setNick(nick.ptr());
				u->user.setUsername(user.ptr());
				u->user.setHost(host.ptr());
				g_pOptions->m_pRegUsersDb->registerUser(u,flag.ptr());
				g_pOptions->m_pRegUsersDb->setPasswd(u,passwd.ptr());
				g_pOptions->m_pRegUsersDb->setComment(u,comment.ptr());
			}
			it = it->nextSibling();
		}
	}

	emit finished((r == Accepted));
}

void KviDlgRegUsers::closeEvent(QCloseEvent *)
{
	emit finished(false);
}


#include "m_kvi_dlgregusers.moc"
