#ifndef _KVI_DLGSERVER_H_INCLUDED_
#define _KVI_DLGSERVER_H_INCLUDED_

//
//   File : kvi_dlgserver.cpp (/usr/build/NEW_kvirc/kvirc/kvirc/kvi_dlgserver.h)
//   Last major modification : Sun Jan 17 1999 15:34:57 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qtabdialog.h>
#include <qlistview.h>
#include <qlineedit.h>

#include "kvi_string.h"
#include "kvi_ircserver.h"

class QComboBox;
class QPushButton;
class KviFrame;

class KviIrcServerFieldEditor : public QLineEdit
{
	Q_OBJECT
public:
	KviIrcServerFieldEditor(QWidget *parent);
	~KviIrcServerFieldEditor();
public:
	void edit(const char *text);
	void handleKeyEvent(QKeyEvent *e);
	void terminateEdit(bool bCommitChanges);
signals:
	void editFinished(const char *text);
protected:
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void focusOutEvent(QFocusEvent *);
protected slots:
	void pressedReturnKey();
};

class KviIrcServerListItem : public QListViewItem
{
public:
	KviIrcServerListItem(QListView *w,KviIrcServer *ptr);
	~KviIrcServerListItem();
public:
	KviIrcServer * m_ptr;
};

class KviIrcProxyListItem : public QListViewItem
{
public:
	KviIrcProxyListItem(QListView *w,KviIrcProxy *ptr);
	~KviIrcProxyListItem();
public:
	KviIrcProxy * m_ptr;
};

class KviDlgOptServer : public QTabDialog
{
	friend class KviFrame;
	Q_OBJECT
public:
	KviDlgOptServer(QWidget *parent);
	~KviDlgOptServer();
public:
	KviFrame	*m_pFrm;
private:
	enum KviOptDlgServerField { Host,Port,Description,Password,Ip,IpV6 };
	enum KviOptDlgProxyField { ProxyHost,ProxyPort,ProxyUsername,ProxyPassword,ProxyIp };
	KviIrcServerManager * m_pManager;
	KviIrcProxyManager  * m_pProxyManager;
	QComboBox *m_pNetCombo;
	QListView *m_pSrvList;
	QListView *m_pProxyList;
	QPushButton *m_pDelNet;
	QPushButton *m_pEditSrv;
	QPushButton *m_pDelSrv;
	QPushButton *m_pSort;
	QPushButton *m_pNewSrv;
	QPushButton *m_pDelProxy;
	QPushButton *m_pEditProxy;
	KviIrcServerFieldEditor *m_pEditor;
	KviIrcServerFieldEditor *m_pProxyEditor;
	KviOptDlgServerField m_curEditedServerField;
	KviOptDlgProxyField m_curEditedProxyField;
	KviIrcServerListItem *m_curEditedServerItem;
	KviIrcProxyListItem *m_curEditedProxyItem;
signals:
	void finished(bool bAccepted);
protected slots:
	virtual void done(int r);
	virtual void closeEvent(QCloseEvent *);
	void currentNetworkChanged(const QString &damn);
	void currentServerChanged(QListViewItem *it);
	void currentProxyChanged(QListViewItem *it);
	void serverDoubleClicked(QListViewItem *i);
	void proxyDoubleClicked(QListViewItem *i);
	void deleteNetwork();
	void newNetwork();
	void deleteServer();
	void newProxy();
	void editProxy();
	void deleteProxy();
	void newServer();
	void editServer();
	void sortServers();
	void importFromIni();
	void serverEditFinished(const char *text);
	void proxyEditFinished(const char *text);
private:
	void fillNetCombo();
	void fillServerList(KviIrcNetwork *net);
	void fillProxyList();
	void enableServerButtons(bool bEnable);
	void enableProxyButtons(bool bEnable);
	void editServerField(KviIrcServerListItem *it,KviOptDlgServerField field);
	void editProxyField(KviIrcProxyListItem *it,KviOptDlgProxyField field);
protected:
	virtual bool eventFilter(QObject *,QEvent *e);
};

#endif //!_KVI_DLGSERVER_H_INCLUDED_
