//
//   File : kvi_dns.cpp (/usr/build/NEW_kvirc/kvirc/kvilib/kvi_dns.cpp)
//   Last major modification : Sun Jan 10 1999 20:17:30 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_dns.h"
#include "kvi_settings.h" //for COMPILE_NEED_IPV6
#include "kvi_error.h"
#include "kvi_options.h"

//#ifdef _KVI_DEBUG_CHECK_RANGE_
// What's this ? if COMPILE_DEBUG_SESSION is #undef'ed this won't compile !
// I uncommented two lines here... -- Kristoff
//
// You're right , I messed the include when implementing the IPV6 Stuff..
// this whole file needs to be cleaned up....I'll do it once...
// -- Pragma
//

#include "kvi_netutils.h"
//#endif

#include <qevent.h>

// Declared and managed by KviApp (kvi_app.cpp)
extern KviThreadEventDispatcher * g_pThreadEventDispatcher;

//
// Threaded implementaion
// I have spent a couple of days on this stuff...
//

//
// One note:
//     WHOM DO I SHOT ?
//

//
//[02:23:17] [Da_P] :struct hostent  *gethostbyname_r
//[02:23:17] [Da_P] :        (const char *,           struct hostent *, char *, int, int *h_errnop);
//[02:23:23] [Da_P] :(for SunOS 5.5.1)
//[02:23:27] [posix] :hey man, kvirc is OK... :-)
//[02:24:11] [Pragma] :SunOS...obviously also this is different....:(
//[02:24:18] [Da_P] :Freud__:- try wget.
//[02:24:25] [Pragma] :How do i check for SunOS ? #ifdef(_SUN_) ?
//[02:24:27] [Da_P] :Pragma:- lemme find my DEC.
//[02:24:36] [_Doctor_] :hi linux :-)
//[02:24:42] [Da_P] :Pragma:- I am no autoconf wizard :)
//[02:24:48] [Pragma] :ahah
//[02:24:53] [posix] :#ifdef __SYSV_H
//

#ifndef _BSD_SOURCE
	#define _BSD_SOURCE 1
#endif

#include <netdb.h>
#include <sys/socket.h>

// I found it unuseful by now...
//static void kvi_dnsCleanup(void * data)
//{
//	debug("Async DNS cleanup");
//	// Cleanup function for the dns worker thread
//	// just in case that it is cancelled while the
//	// mutex is locked...mmmmh
//	// It can happen ?....
//	// Anyway....the FAQ suggests to do this , so here it goes.
//	pthread_mutex_unlock(&(((KviDnsStruct *)data)->mutex));
//	pthread_mutex_destroy(&(((KviDnsStruct *)data)->mutex));
//}

//
// The implementation of these two functions was suggested
// by a threads-FAQ found somewhere on the net.
// 

static struct hostent * kvi_threadSafeGetHostByAddr(const char *addr,int len,int type,struct hostent * entry,int * errorcode)
{
	struct hostent *pHostEntry;
#if defined(__GLIBC__)
	/*
		Linux, others if they are using GNU libc.  We could also use Posix.1g
		getaddrinfo(), which should eventually be more portable and is easier to
		use in a mixed IPv4/IPv6 environment.
	*/
    char tmp[8192]; // What the hell is this for ?
    if(gethostbyaddr_r(addr,len,type,entry,tmp,sizeof(tmp),&pHostEntry,errorcode) < 0)return 0;
	else return pHostEntry;
#elif defined(sun) || defined(__SYSV_H) || defined(__sun) || defined (__sun__)
    /*
		Solaris 2.[456].
	*/
    char tmp[8192];
    return gethostbyaddr_r(addr,len,type,entry,tmp,sizeof(tmp),errorcode);

#elif defined(__osf__) || defined(hpux) || defined(__hpux) || defined(__hpux__)

	/*
		On Digital Unix 4.0 plain gethostbyname is thread-safe because it uses
		thread specific data (and a h_errno macro).  HPUX is rumoured to use
		this method as well.  This will go wrong on Digital Unix 3.2, but this
		whole file is not going to compile there anyway because version 3.2 has
		DCE threads instead of Posix threads.
	*/
	pHostEntry = gethostbyaddr(addr,len,type);
	*errorcode = h_errno;
	return pHostEntry;
#else
	pHostEntry = gethostbyaddr(addr,len,type);
	*errorcode = h_errno;
	return pHostEntry;

	#warning "Sorry , I do not know how to do thread-safe DNS lookups on your system."
	#warning "Make sure that you have glibc2 installed on your system."
	#warning "In case that you're using libc5 , you will also have to upgrade"
	#warning "the X libraries to the thread-safe ones."
	#warning "By now failing to the default non thread-safe gethostbyaddr() call."
#endif
}

static struct hostent * kvi_threadSafeGetHostByName(const char *hostname,struct hostent * entry,int * errorcode)
{
	struct hostent *pHostEntry;
#if defined(__GLIBC__)
	/*
		Linux, others if they are using GNU libc.  We could also use Posix.1g
		getaddrinfo(), which should eventually be more portable and is easier to
		use in a mixed IPv4/IPv6 environment.
	*/
    char tmp[8192]; // What the hell is this for ?
    if(gethostbyname_r(hostname,entry,tmp,sizeof(tmp),&pHostEntry,errorcode) < 0)return 0;
	else return pHostEntry;

#elif defined(sun) || defined(__SYSV_H) || defined(__sun) || defined (__sun__)
   /*
		Solaris 2.[456].
	*/
    char tmp[8192];
    return gethostbyname_r(hostname,entry,tmp,sizeof(tmp),errorcode);

#elif defined(__osf__) || defined(hpux) || defined(__hpux) || defined(__hpux__)
	/*
		On Digital Unix 4.0 plain gethostbyname is thread-safe because it uses
		thread specific data (and a h_errno macro).  HPUX is rumoured to use
		this method as well.  This will go wrong on Digital Unix 3.2, but this
		whole file is not going to compile there anyway because version 3.2 has
		DCE threads instead of Posix threads.
	*/
	pHostEntry = gethostbyname(hostname);
	*errorcode = h_errno;
	return pHostEntry;
#else
	pHostEntry = gethostbyname(hostname);
	*errorcode = h_errno;
	return pHostEntry;

	#warning "Sorry , I do not know how to do thread-safe DNS lookups on your system."
	#warning "Failing to the default non thread-safe gethostbyname() call."
#endif

}

static void * kvi_syncDnsCall(void * data)
{
	__debug("DNS thread running");

	kvi_threadInitialize();

//  Damn...if gethostbyname is cancelled brutally , all subsequent calls
//  will never return...what's wrong ?
//
//  [root@localhost kvirc]man pthreat_setcanceltype
//  ...
//  BUGS
//       POSIX  specifies that a number of system calls (basically,
//       all  system  calls  that  may  block,  such  as   read(2),
//       write(2),  wait(2),  etc.)  and library functions that may
//       call these system calls (e.g.  fprintf(3))  are  cancella-
//       tion  points.   LinuxThreads  is not yet integrated enough
//       with the C library to implement this, and thus none of the
//       C library functions is a cancellation point.                             
//  ...
//  Also gethostbyname & co. are NOT ASYNCCANCEL safe.
//  Fail into deferred cancel type.
//
//	pthread_setcanceltype(PTHREAD_CANCEL_DEFERRED,0); // needs to be deferred for gethostbyname & co.
//
//  the above code is not in kvi_threadInit()
//
	KviDnsStruct * dns = (KviDnsStruct *)data;
	dns->iError = KVI_ERROR_Success;
	dns->szHostToResolve.stripWhiteSpace();

#ifdef COMPILE_NEED_IPV6
	if(dns->bIpV6)
	{
		if(dns->szHostToResolve.isEmpty())dns->iError = KVI_ERROR_NoHostToResolve;
		else {
//			struct in6_addr in6Addr;
			struct addrinfo * pRet;
			struct addrinfo hints;
			hints.ai_flags = 0;
			hints.ai_family = PF_INET6;
			hints.ai_socktype = SOCK_STREAM;
			hints.ai_addrlen = 0;
			hints.ai_canonname = 0;
			hints.ai_addr = 0;
			hints.ai_next = 0;
			int retVal = getaddrinfo(dns->szHostToResolve.ptr(),0,&hints,&pRet);
			if(retVal != 0)
			{
				switch(retVal)
				{

					case EAI_ADDRFAMILY: dns->iError = KVI_ERROR_HostNotFound; break;
					case EAI_NODATA:     dns->iError = KVI_ERROR_ValidNameButNoIpAddress; break;
					case EAI_FAIL:       dns->iError = KVI_ERROR_UnrecoverableNameserverError; break;
					case EAI_AGAIN:      dns->iError = KVI_ERROR_DnsTemporaneousFault; break;
					//EAI_ADDRFAMILY  address family for hostname not supported
					//EAI_BADFLAGS    invalid value for ai_flags
					//EAI_FAMILY      ai_family not supported
					//EAI_MEMORY      memory allocation failure
					//EAI_NONAME      hostname nor servname provided, or not known
					//EAI_SERVICE     servname not supported for ai_socktype
					//EAI_SOCKTYPE    ai_socktype not supported				
					//EAI_SYSTEM      system error returned in errno
					default:             dns->iError = KVI_ERROR_DnsQueryFailed; break;
				}
			} else {
				dns->szHostname = pRet->ai_canonname ? pRet->ai_canonname : dns->szHostToResolve.ptr();
				kvi_binaryIpToString_V6(((sockaddr_in6 *)(pRet->ai_addr))->sin6_addr,dns->szIp);
				dns->szAlias1 = "*";
				dns->szAlias2 = "*";
			}
			freeaddrinfo(pRet);
		}
		QEvent *e = new QEvent(QEvent::User);
		g_pThreadEventDispatcher->postEvent(e,dns->dnsParent);
		return 0;
	}
#endif

	struct in_addr inAddr;
	struct hostent *pHostEntry = 0;
	struct hostent hostBuffer;
	int myError;

	if(dns->szHostToResolve.isEmpty())dns->iError = KVI_ERROR_NoHostToResolve;
	else {
		if(kvi_stringIpToBinaryIp(dns->szHostToResolve.ptr(),&inAddr)){
			kvi_threadTestCancel(); //test for cancellation
			pHostEntry = kvi_threadSafeGetHostByAddr((const char *)&inAddr,sizeof(inAddr),AF_INET,&hostBuffer,&myError);
		} else {
			kvi_threadTestCancel(); //test for cancellation
			pHostEntry = kvi_threadSafeGetHostByName(dns->szHostToResolve.ptr(),&hostBuffer,&myError);
		}
		kvi_threadTestCancel();

		if(!pHostEntry)
		{
			switch(myError){
				case HOST_NOT_FOUND: dns->iError = KVI_ERROR_HostNotFound; break;
				case NO_ADDRESS:     dns->iError = KVI_ERROR_ValidNameButNoIpAddress; break;
				case NO_RECOVERY:    dns->iError = KVI_ERROR_UnrecoverableNameserverError; break;
				case TRY_AGAIN:      dns->iError = KVI_ERROR_DnsTemporaneousFault; break;
				default:             dns->iError = KVI_ERROR_DnsQueryFailed; break;
			}
		} else {
			kvi_threadTestCancel();
			dns->szHostname = pHostEntry->h_name;
			dns->szIp = inet_ntoa( * (struct in_addr*)pHostEntry->h_addr);
			kvi_threadTestCancel();
			if(pHostEntry->h_aliases[0]){
				dns->szAlias1 = pHostEntry->h_aliases[0];
				dns->szAlias2 = pHostEntry->h_aliases[1] ? pHostEntry->h_aliases[1] : "*";
			} else {
				dns->szAlias1 = "*";
				dns->szAlias2 = "*";
			}
		}
	}

	kvi_threadTestCancel();

	QEvent *e = new QEvent(QEvent::User);
	g_pThreadEventDispatcher->postEvent(e,dns->dnsParent);

	__debug("DNS Thread exiting");
	return 0;
}

static void kvi_syncDnsCallNoThread(KviDnsStruct * dns)
{
	dns->iError = KVI_ERROR_Success;
	dns->szHostToResolve.stripWhiteSpace();

#ifdef COMPILE_NEED_IPV6
	if(dns->bIpV6)
	{
		if(dns->szHostToResolve.isEmpty())dns->iError = KVI_ERROR_NoHostToResolve;
		else {
//			struct in6_addr in6Addr;
			struct addrinfo * pRet;
			struct addrinfo hints;
			hints.ai_flags = 0;
			hints.ai_family = PF_INET6;
			hints.ai_socktype = SOCK_STREAM;
			hints.ai_addrlen = 0;
			hints.ai_canonname = 0;
			hints.ai_addr = 0;
			hints.ai_next = 0;
			int retVal = getaddrinfo(dns->szHostToResolve.ptr(),0,&hints,&pRet);
			if(retVal != 0)
			{
				switch(retVal)
				{

					case EAI_ADDRFAMILY: dns->iError = KVI_ERROR_HostNotFound; break;
					case EAI_NODATA:     dns->iError = KVI_ERROR_ValidNameButNoIpAddress; break;
					case EAI_FAIL:       dns->iError = KVI_ERROR_UnrecoverableNameserverError; break;
					case EAI_AGAIN:      dns->iError = KVI_ERROR_DnsTemporaneousFault; break;
					//EAI_ADDRFAMILY  address family for hostname not supported
					//EAI_BADFLAGS    invalid value for ai_flags
					//EAI_FAMILY      ai_family not supported
					//EAI_MEMORY      memory allocation failure
					//EAI_NONAME      hostname nor servname provided, or not known
					//EAI_SERVICE     servname not supported for ai_socktype
					//EAI_SOCKTYPE    ai_socktype not supported				
					//EAI_SYSTEM      system error returned in errno
					default:             dns->iError = KVI_ERROR_DnsQueryFailed; break;
				}
			} else {
				dns->szHostname = pRet->ai_canonname ? pRet->ai_canonname : dns->szHostToResolve.ptr();
				kvi_binaryIpToString_V6(((sockaddr_in6 *)(pRet->ai_addr))->sin6_addr,dns->szIp);
//				dns->szIp = inet_ntop( * (struct in6_addr*)pHostEntry->h_addr);
				dns->szAlias1 = "*";
				dns->szAlias2 = "*";
			}
			freeaddrinfo(pRet);
		}
		QEvent *e = new QEvent(QEvent::User);
		g_pThreadEventDispatcher->postEvent(e,dns->dnsParent);
		return;
	}
#endif

	struct in_addr inAddr;
	struct hostent *pHostEntry = 0;

	if(dns->szHostToResolve.isEmpty())dns->iError = KVI_ERROR_NoHostToResolve;
	else {
		if(kvi_stringIpToBinaryIp(dns->szHostToResolve.ptr(),&inAddr))
		{
			pHostEntry = gethostbyaddr((const char *)&inAddr,sizeof(inAddr),AF_INET);
		} else {
			pHostEntry = gethostbyname(dns->szHostToResolve.ptr());
		}
		if(!pHostEntry)
		{
			switch(h_errno)
			{
				case HOST_NOT_FOUND: dns->iError = KVI_ERROR_HostNotFound; break;
				case NO_ADDRESS:     dns->iError = KVI_ERROR_ValidNameButNoIpAddress; break;
				case NO_RECOVERY:    dns->iError = KVI_ERROR_UnrecoverableNameserverError; break;
				case TRY_AGAIN:      dns->iError = KVI_ERROR_DnsTemporaneousFault; break;
				default:             dns->iError = KVI_ERROR_DnsQueryFailed; break;
			}
		} else {
			dns->szHostname = pHostEntry->h_name;
			kvi_binaryIpToString(* ((struct in_addr*)(pHostEntry->h_addr)),dns->szIp);
			if(pHostEntry->h_aliases[0]){
				dns->szAlias1 = pHostEntry->h_aliases[0];
				dns->szAlias2 = pHostEntry->h_aliases[1] ? pHostEntry->h_aliases[1] : "*";
			} else {
				dns->szAlias1 = "*";
				dns->szAlias2 = "*";
			}
		}
	}
	QEvent *e = new QEvent(QEvent::User);
	g_pThreadEventDispatcher->postEvent(e,dns->dnsParent);
}

KviAsyncDns::KviAsyncDns()
:QObject()
{
	__debug("Async DNS created");
	m_bThreadRunning = false;
	m_dnsStruct = 0;
	g_pThreadEventDispatcher->registerObject(this);
}

KviAsyncDns::~KviAsyncDns()
{
	__debug("Async DNS dying");
	g_pThreadEventDispatcher->unregisterObject(this);
	if(m_bThreadRunning)kvi_threadCancel(m_thread);
	if(m_dnsStruct)delete m_dnsStruct;
}

bool KviAsyncDns::abort()
{
	if(!m_bThreadRunning)return false;
	kvi_threadCancel(m_thread);
	if(m_dnsStruct)delete m_dnsStruct;
	m_dnsStruct = 0;
	m_bThreadRunning = false;
	return true;
}

bool KviAsyncDns::resolve(const char *hostname,const char *data,bool bIpV6)
{
	__debug("Going to resolve");
	if(m_bThreadRunning)return false;
	if(m_dnsStruct != 0)delete m_dnsStruct;
	m_dnsStruct = new KviDnsStruct;
	m_dnsStruct->szHostToResolve=hostname;
	m_dnsStruct->dnsParent = this;
#ifdef COMPILE_NEED_IPV6
	m_dnsStruct->bIpV6 = bIpV6;
#endif
	if(data)m_dnsStruct->szData = data;

	if(g_pOptions->m_bForceSyncDns)
	{
		kvi_syncDnsCallNoThread(m_dnsStruct);
		return true;
	}

	__debug("Creating the thread");
	if(kvi_threadCreate(&m_thread,0,kvi_syncDnsCall,m_dnsStruct) != 0)
	{
		delete m_dnsStruct;
		m_dnsStruct = 0;
		return false;
	} else m_bThreadRunning = true;
	return true;
}

bool KviAsyncDns::event(QEvent *e)
{
	if(e->type() == QEvent::User){
		// Job was succesfully done!
		__debug("Dns FINISHED");
		m_bThreadRunning = false;
		emit dnsFinished(m_dnsStruct);
		return true;
	} else return QObject::event(e);
}

KviDnsStruct * KviAsyncDns::forgetDnsStruct()
{
	if(m_bThreadRunning)return 0;
	KviDnsStruct *s = m_dnsStruct;
	m_dnsStruct = 0;
	return s;
}

#include "m_kvi_dns.moc"
