#ifndef _KVI_IRCVIEW_H_INCLUDED_
#define _KVI_IRCVIEW_H_INCLUDED_
//
//   File : kvi_ircview.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_ircview.h)
//   Last major modification : Fri Mar 19 1999 05:39:01 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qwidget.h>
#include <qpixmap.h>
#include <qcolor.h>
#include <qscrollbar.h>
#include <qfile.h>
#include <qlist.h>

#include "kvi_string.h"
#include "kvi_regusersdb.h"

//#define KVI_IRCVIEW_MAX_TEXT_BLOCKS 64
//it is really enough...16 * 64 = 1 KB (maximum) for each text line

typedef struct KviIrcViewTextAttribute
{
	int   block_idx;                    //index in the data_ptr of the beginning of the block
	int   block_len;                    //length in chars of the block (excluding the terminator)
	char  attribute;                    //attribute type
	char  attr_fore;                    //optional foreground color for KVI_TEXT_COLOR attribute
	char  attr_back;                    //optional background color for KVI_TEXT_COLOR attribute
	char *escape_cmd;                   //KVI_TEXT_ESCAPE attribute command buffer (non zeroed for other attributes!!!)
};

typedef struct KviIrcViewTextBlock
{
	char                    *block_ptr;    //pointer to the character that begins the block
	int                      block_len;    //length if the block in characters
	int                      block_width;  //width of the block in pixels
	KviIrcViewTextAttribute *attr_ptr;     //pointer to attributes or 0 for word wraps
};

typedef struct KviIrcViewTextLine
{
	char                    *data_ptr;  //pointer to the "string"
	int                      data_len;  //length of the allocated buffer (including the terminator)
	int                      msg_type;

	int                      attr_len;  //number of allocated attr structures
	KviIrcViewTextAttribute *attr_ptr;  //pointer to the allocated structures
	// Precalculated text blocks
	int                      line_wraps;
	int                      max_line_width;       //width that the blocks were calculated for
	int                      num_text_blocks; //number of allocated text blocks
	KviIrcViewTextBlock     *text_blocks_ptr; //pointer to the allocated text blocks

	KviIrcViewTextLine      *prev_line;
	KviIrcViewTextLine      *next_line;
};



typedef struct KviIrcViewTextBlockSelectionInfo
{
	int selection_type;
	int part_1_length;
	int part_1_width;
	int part_2_length;
	int part_2_width;
	int part_3_length;
	int part_3_width;
};

//FIRST LINE (prev_line = 0) <---m_pFirstLine
//LINE
//--------------------SCREEN--
//LINE
//LINE
//LINE
//LINE <-------------------------m_pCurLine
//--------------------SCREEN--
//LAST LINE (next_line = 0) <----m_pLastLine

class KviWindow;
class KviFrame;

class KviIrcViewScrollBar : public QScrollBar
{
	friend class KviIrcView;
	Q_OBJECT
public:
	KviIrcViewScrollBar(int mi,int ma,int ls, int ps, int v,Orientation o,QWidget * par,const char * name)
		: QScrollBar(mi,ma,ls,ps,v,o,par,name){};
	~KviIrcViewScrollBar(){};
};

/**
* IrcView class....don't take it as a good programming example.
*/

class KviIrcView : public QWidget
{
	Q_OBJECT
public:
	KviIrcView(QWidget *parent,KviFrame *pFrm,KviWindow *pWnd);
	~KviIrcView();
private:
	KviIrcViewTextLine  *m_pFirstLine;
	KviIrcViewTextLine  *m_pCurLine;    // Bottom line in the view
	KviIrcViewTextLine  *m_pLastLine;
	// Highliting of links
	KviIrcViewTextBlock *m_pLastLinkUnderMouse;
	int                  m_iLastLinkRectTop;
	int                  m_iLastLinkRectHeight;

	int                  m_iNumLines;
	int                  m_iMaxLines;
	QPixmap             *m_pPrivateBackgroundPixmap;
	KviIrcViewScrollBar *m_pScrollBar;
	int                  m_iLastScrollBarValue;
	int                  m_iFontLineSpacing;
	int                  m_iFontLineWidth;
	int                  m_iFontDescent;
	int                  m_iFontCharacterWidth[256];    //1024 bytes fixed
	int                  m_iWrapMargin;
	int                  m_iMouseButtonPressX;
	int                  m_iMouseButtonPressY;
	int                  m_iMouseButtonCurrentX;
	int                  m_iMouseButtonCurrentY;
	int                  m_iSelectionBegin;
	int                  m_iSelectionTop;
	int                  m_iSelectionEnd;
	int                  m_iSelectionBottom;
	int                  m_iSelectionLeft;
	int                  m_iSelectionRight;
	bool                 m_bSelecting;
	bool                 m_bDoubleClicked;
	bool                 m_bSkipScrollBarRepaint;
	bool                 m_bShowImages;
	int                  m_iSelectTimer;
	bool                 m_bTimestamp;
	KviStr               m_szLastSelection;
	KviStr               m_szLastStrippedSelection;
	KviStr               m_szLastSelectionLine;
	KviStr               m_szLastStrippedSelectionLine;
	KviStr               m_szLastDoubleClickedEscape;
	KviStr               m_szLastDoubleClickedEscapeCmd;
	int                  m_iLastSelectionLineLen;
	int                  m_iLastStrippedSelectionLineLen;
//	KviIrcViewTextBlock m_TextBlock[KVI_IRCVIEW_MAX_TEXT_BLOCKS];
	KviWindow           *m_pKviWindow;
//	int                 m_iNumTextBlocks;
	KviIrcViewTextBlockSelectionInfo m_TextBlockSelectionInfo;
	QFile               *m_pLogFile;
	KviFrame            *m_pFrm;
	bool                 m_bAcceptDrops;
	int                  m_iUnprocessedPaintEventRequests;
	bool                 m_bPostedPaintEventPending;
	QList<KviIrcViewTextLine> * m_pMessagesStoppedWhileSelecting;
	bool		     m_bBeeping;
public:
	/**
	* The most useful api is this one...
	*/
	void enableDnd(bool bEnable);
	void appendText(int msg_type,const char *data_ptr,bool bRepaint=true);
	void removeHeadLine(bool bRepaint=false);
	void emptyBuffer(bool bRepaint=true);
	void getTextBuffer(KviStr &buffer);
	void setMaxBufferSize(int maxBufSize,bool bRepaint=true);
	int  maxBufferSize(){ return m_iMaxLines; }; //Never used ?
	void setShowImages(bool bShow,bool bRepaint=true);
	void setTimestamp(bool bTimestamp);
	bool timestamp(){ return m_bTimestamp; }; //Never used ?
	bool imagesVisible(){ return m_bShowImages; }; //Never used ?
	bool saveBuffer(const char *filename);
	void findNext(const char * text);
	void findPrev(const char * text);
//	void setParentKviWindow(KviWindow *pWin);
	KviWindow * parentKviWindow(){ return m_pKviWindow; };
	/**
	* A null pixmap passed here unsets the private backgrdound.
	*/
	void setPrivateBackgroundPixmap(const QPixmap &pixmap,bool bRepaint=true);
	bool hasPrivateBackgroundPixmap(){ return (m_pPrivateBackgroundPixmap != 0); };
	/**
	* Stops previous logging session too...
	*/
	bool startLogging(const char *filename);
	void stopLogging();
	bool isLogging(){ return (m_pLogFile != 0); };
	void add2Log(const char *buffer,int buf_len=-1);

	bool initBeeping(const char *user);
	void startBeeping(const char *user);
	void stopBeeping(const char *user);
	bool isBeeping(){ return m_bBeeping; };

	void prevLine();
	void nextLine();
	void nextPage();
	void prevPage();

	virtual void wheelEvent(QWheelEvent *e);
public slots:
	void toggleBeeping();
	void toggleLogging();
	void toggleTimestamp();
	void toggleImages();
	void clearBuffer();
	void logToFile();
	void saveBufferToFile();
signals:
//	/**
//	* The user selected some text , what we do with that?
//	*/
//	void textSelected(KviIrcView *this_ptr,KviWindow *parent_win,const char *text);
//	/**
//	* The user double clicked a highlighted url...what we do with that?
//	*/
//	void urlDoubleClicked(const char *url);
	/**
	* The user right clicked on the view...what we do with that ?
	*/
	void contextPopupRequested(KviIrcView *this_ptr);
	void dndEntered();
	void fileDropped(const char *);
private:
	void getDoubleClickCommand(KviStr &buffer,const char * escape_cmd);
	void getRightClickCommand(KviStr &buffer,const char * escape_cmd);
	void resizeMemBuffer();
	void appendLine(KviIrcViewTextLine *ptr,bool bRepaint);
	void postUpdateEvent();
	void fastScroll(int lines = 1);
	const char * getTextLine(int msg_type,const char * data_ptr,KviIrcViewTextLine *line_ptr);
	void calculateLineWraps(KviIrcViewTextLine *ptr,int maxWidth);
	void recalcFontVariables(const QFont &font);
	bool checkSelectionBlock(KviIrcViewTextLine * line,int left,int bottom,int bufIndex);
	void checkForDoubleClickedUrlOrEscape(KviIrcViewTextLine * line,int left,int bottom,int bufIndex);
	void calculateSelectionBounds();
	void drawBlockPart(char curFore,char curBack,bool curBold,bool curUnderline,
		int curLeftCoord,int curBottomCoord,const char *data,int len,int wdth);
	void drawSelectedText(char curAttribute,char curFore,char curBack,
		int curLeftCoord,int curBottomCoord,const char *text_ptr,int len,int wdth);
	KviIrcViewTextBlock * getLinkUnderMouse(int xPos,int yPos,int *rectTop,int *rectHeight);
protected:
	virtual void paintEvent(QPaintEvent *);
	virtual void resizeEvent(QResizeEvent *);
	virtual void mousePressEvent(QMouseEvent *e);
	virtual void mouseReleaseEvent(QMouseEvent *e);
	virtual void mouseDoubleClickEvent(QMouseEvent *e);
	virtual void mouseMoveEvent(QMouseEvent *e);
//	virtual void leaveEvent(QEvent *);
	virtual void timerEvent(QTimerEvent *e);
	virtual void fontChange(const QFont &oldFont);
	virtual void dragEnterEvent(QDragEnterEvent *e);
	virtual void dropEvent(QDropEvent *e);
	virtual bool event(QEvent *e);
protected slots:
	virtual void scrollBarPositionChanged(int newValue);
};

#endif //_KVI_IRCVIEW_H_INCLUDED_
