//
//   File : kvi_listbox.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_listbox.cpp)
//   Last major modification : Thu Mar 25 1999 02:32:43 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviListBox"
#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"

#include "kvi_listbox.h"

#define _KVI_LISTBOX_CPP_
#include "kvi_defines.h"
#include "kvi_options.h"
#include "kvi_locale.h"

#include "kvi_frame.h"
#include "kvi_statusbar.h"
#include "kvi_uparser.h"
#include "kvi_window.h"
#include "kvi_query.h"
#include "kvi_event.h"

#include <qbitmap.h>

#include <X11/Xlib.h>
#ifdef COMPILE_USE_AA_FONTS
	#include <X11/Xft/Xft.h>
#endif

#undef TrueColor
// Damn!

#include <qdragobject.h>
#include <qstringlist.h>

/* FIXME: "MalboroLi says that sometimes nicks disappear , and reappear when the scroll bar is moved....circumstances ?" */

// This is declared in kvi_ircview.cpp
extern Display * g_display;

// declared in kvi_app.cpp
extern QPixmap * g_pListBoxOpPixmap;
extern QPixmap * g_pListBoxVoicePixmap;
extern QPixmap * g_pListBoxHelpOpPixmap;
extern QPixmap * g_pListBoxUserOpPixmap;
extern QPixmap * g_pListBoxOwnerPixmap;

extern KviEventManager * g_pEventManager;

#ifdef COMPILE_USE_AA_FONTS
	extern XftFont * g_pXftFont;
	extern XftDraw * g_pXftDraw;
	extern int qt_use_xft (void); // qpainter_x11.cpp
	extern void *qt_ft_font (const QFont *f); // qfont_x11.cpp
	extern XftDraw * qt_lookup_ft_draw (Drawable draw, bool paintEventClipOn, QRegion *crgn);
#endif

KviListBox::KviListBox(QWidget *parent,KviWindow * parentWnd,KviUserParser * parser,KviFrame * pFrm)
:QWidget(parent,"userlist_box")
{
	m_pMemBuffer = new QPixmap(width(),height());
	m_pScrollBar = new KviListBoxScrollBar(this,"userlist_scrollbar");
	connect(m_pScrollBar,SIGNAL(valueChanged(int)),this,SLOT(scrollBarMoved(int)));
	m_pScrollBar->hide();
	m_pFrm = pFrm;
	m_pClientList = new KviIrcUserChanList(pFrm->m_pUserList);
	m_iCurTopItem = 0;
	m_pParent = parentWnd;
	m_pUserParser = parser;
	setAcceptDrops(true);
	QSize s(KVI_LISTBOX_MINIMUM_WIDTH,KVI_LISTBOX_MINIMUM_HEIGHT);
	setMinimumSize(s);
}

KviListBox::~KviListBox()
{
	delete m_pMemBuffer;
	delete m_pClientList;
}

void KviListBox::wheelEvent(QWheelEvent *e)
{
	m_pScrollBar->wheelEvent(e);
}

QList<KviStr> * KviListBox::createNickStringList()
{
	QList<KviStr> *ret = new QList<KviStr>;
	ret->setAutoDelete(true);
	for(KviIrcUser * u=m_pClientList->firstUser();u;u=m_pClientList->nextUser()){
		ret->append(new KviStr(u->nick()));
	}
	return ret;
}

KviIrcUser * KviListBox::firstOp()
{
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->oFlag)return data->pNode->pUser;
	}
	return 0;
}

void KviListBox::join(const KviIrcUser &user,char bOp,char bVoice,char bHalfOp,char bUserOp,char bOwner,bool bRepaint)
{
	m_pClientList->join(user,bOp,bVoice,bHalfOp,bUserOp,bOwner);
	if(bRepaint){
		updateScrollBar();
		paintEvent(0);
	}
}

bool KviListBox::nickChange(const KviIrcUser &nicker,const char *nick)
{
	bool bRet = m_pClientList->nickChange(nicker,nick);
	if(bRet){
		updateScrollBar();
		paintEvent(0);
	}
	return bRet;
}

void KviListBox::part(const char *nick)
{
	m_pClientList->part(nick);
	updateScrollBar();
	paintEvent(0);
}

void KviListBox::part(const KviIrcUser &user)
{
	m_pClientList->part(user);
	updateScrollBar();
	paintEvent(0);
}

void KviListBox::partAll()
{
	m_pClientList->clearList();
	updateScrollBar();
	paintEvent(0);
}

void KviListBox::select(const char *nick)
{
	if(!m_pClientList->select(nick))return;
	KviIrcUserChanData * data = m_pClientList->findData(nick);
	KviStr szMask;
	data->pNode->pUser->mask(szMask);
	m_pFrm->m_pStatusBar->tempText(szMask.ptr(),KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
	paintEvent(0);
}

void KviListBox::select(const KviIrcUser &user)
{
	if(!m_pClientList->select(user))return;
	KviIrcUserChanData * data = m_pClientList->findData(user.nick());
	KviStr szMask;
	data->pNode->pUser->mask(szMask);
	m_pFrm->m_pStatusBar->tempText(szMask.ptr(),KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
	paintEvent(0);
}

void KviListBox::selectAll()
{
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData())
		data->extFlag = 1;
	paintEvent(0);
}

void KviListBox::deselect(const char *nick)
{
	m_pClientList->deselect(nick);
	paintEvent(0);
}

void KviListBox::deselect(const KviIrcUser &user)
{
	if(!m_pClientList->deselect(user))return;
	paintEvent(0);
}

void KviListBox::deselectAll()
{
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData())
		data->extFlag = 0;
	paintEvent(0);
}

bool KviListBox::owner(const KviIrcUser &user,char bOwner)
{
	bool bRet = m_pClientList->owner(user,bOwner);
	paintEvent(0);
	return bRet;
}

bool KviListBox::owner(const char *nick,char bOwner)
{
	bool bRet = m_pClientList->op(nick,bOwner);
	paintEvent(0);
	return bRet;
}


bool KviListBox::op(const KviIrcUser &user,char bOp)
{
	bool bRet = m_pClientList->op(user,bOp);
	paintEvent(0);
	return bRet;
}

bool KviListBox::op(const char *nick,char bOp)
{
	bool bRet = m_pClientList->op(nick,bOp);
	paintEvent(0);
	return bRet;
}

bool KviListBox::halfop(const KviIrcUser &user,char bHalfOp)
{
	bool bRet = m_pClientList->halfop(user,bHalfOp);
	paintEvent(0);
	return bRet;
}

bool KviListBox::halfop(const char *nick,char bHalfOp)
{
	bool bRet = m_pClientList->halfop(nick,bHalfOp);
	paintEvent(0);
	return bRet;
}

bool KviListBox::voice(const KviIrcUser &user,char bVoice)
{
	bool bRet = m_pClientList->voice(user,bVoice);
	paintEvent(0);
	return bRet;
}

bool KviListBox::voice(const char *nick,char bVoice)
{
	bool bRet = m_pClientList->voice(nick,bVoice);
	paintEvent(0);
	return bRet;
}

bool KviListBox::userop(const KviIrcUser &user,char bUserOp)
{
	bool bRet = m_pClientList->userop(user,bUserOp);
	paintEvent(0);
	return bRet;
}

bool KviListBox::userop(const char *nick,char bUserOp)
{
	bool bRet = m_pClientList->userop(nick,bUserOp);
	paintEvent(0);
	return bRet;
}

void KviListBox::scrollBarMoved(int value)
{
	m_iCurTopItem = value;
	if(m_iCurTopItem > (m_pClientList->count()-1))m_iCurTopItem = m_pClientList->count()-1;
	if(m_iCurTopItem < 0)m_iCurTopItem = 0;
	paintEvent(0);
}

void KviListBox::doRepaint()
{
	updateScrollBar();
	paintEvent(0);
}

void KviListBox::paintEvent(QPaintEvent *)
{
	if(!isVisibleToTLW())return;
	int widgetWidth = m_pScrollBar->isVisible() ? width()-KVI_LISTBOX_SCROLLBAR_WIDTH : width();
	int widgetHeight = height();

	g_display        = m_pMemBuffer->x11Display();
	m_hMemBuffer     = m_pMemBuffer->handle();
	GC gc_aux        = XCreateGC(g_display,m_hMemBuffer,0,0);

	//Draw the background
	XSetLineAttributes(g_display,gc_aux,0,LineSolid,CapButt,JoinMiter);
	if(g_pOptions->m_pixListBoxBack->isNull()){
		XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxBack.pixel());
		XSetBackground(g_display,gc_aux,g_pOptions->m_clrListBoxBack.pixel());
		XSetFillStyle(g_display,gc_aux,FillSolid );
	} else {
		XSetTile(g_display,gc_aux,g_pOptions->m_pixListBoxBack->handle());
		XSetFillStyle(g_display,gc_aux,FillTiled);
	}
   	XFillRectangle(g_display,m_hMemBuffer,gc_aux,0,0,widgetWidth,widgetHeight);
	XSetFillStyle(g_display,gc_aux,FillSolid);

	// Bottom of the cell to paint
	int yCurCellBottom = KVI_LISTBOX_VERTICAL_BORDER + g_pOptions->m_iListBoxCellHeight - g_pOptions->m_iListBoxBaseLineOffset;
	// Maximum y coordinate for yCurCellBottom
	int yBottomBorder = widgetHeight-KVI_LISTBOX_VERTICAL_BORDER;
	// x coordinate of the text
	int xLeft = KVI_LISTBOX_HORIZONTAL_BORDER;
	// increase it if the images are enabled (and if there are ops or voiced users inside)
	if(g_pOptions->m_bListBoxShowImages &&
		(m_pClientList->opCount() || m_pClientList->voiceCount() || m_pClientList->halfopCount() ||
			m_pClientList->useropCount() || m_pClientList->ownerCount()))xLeft+=18;
	// availableSpace for text
	int availableXSpace = widgetWidth - (KVI_LISTBOX_HORIZONTAL_BORDER+xLeft);

	if(m_pClientList->count() && 
		(widgetHeight > (g_pOptions->m_iListBoxCellHeight+(KVI_LISTBOX_VERTICAL_BORDER * 2))) &&
		(widgetWidth > (xLeft+KVI_LISTBOX_HORIZONTAL_BORDER)))
	{
		//Have items inside and have vertical && horizontal space for at least one item
		KviIrcUserChanData * data = m_pClientList->firstData();

		if(m_iCurTopItem > 0){
			// Skip the first items that are not visible
			__range_valid(m_iCurTopItem < m_pClientList->count());
			__range_valid(m_pScrollBar->isVisible());
			for(int i = 0;data && (i< m_iCurTopItem); i++)data = m_pClientList->nextData();
		}

		if(data){
#ifdef COMPILE_USE_AA_FONTS
			if(qt_use_xft())
			{
				g_pXftFont = (XftFont *)qt_ft_font(&(g_pOptions->m_fntListBox));
				g_pXftDraw = qt_lookup_ft_draw (m_hMemBuffer,false,0);
				if(!g_pXftDraw)
				{
					XSetFont(g_display,gc_aux,g_pOptions->m_fntListBox.handle());
					g_pXftFont = 0;
				}
			} else {
#endif
			XSetFont(g_display,gc_aux,g_pOptions->m_fntListBox.handle());
#ifdef COMPILE_USE_AA_FONTS
			g_pXftFont = 0;
			g_pXftDraw = 0;
			}
#endif
			// Now we point to the first item to paint
			for( ; data && (yCurCellBottom < yBottomBorder); data = m_pClientList->nextData()){

				if(g_pOptions->m_bListBoxShowImages && ((data->oFlag != 0) || (data->vFlag != 0) ||
					(data->hFlag != 0) || (data->uFlag != 0) || (data->qFlag != 0))){
					//Paint the pixmap first
					//Calculate the position of the image
					int imageYPos = yCurCellBottom + g_pOptions->m_iListBoxBaseLineOffset - ((g_pOptions->m_iListBoxCellHeight + 16) / 2);
					//Set the mask if needed
					QPixmap *pix;
					if (data->qFlag != 0)pix = g_pListBoxOwnerPixmap;
					else if (data->oFlag != 0)pix = g_pListBoxOpPixmap;
					else if (data->hFlag != 0)pix = g_pListBoxHelpOpPixmap;
					else if (data->vFlag != 0)pix = g_pListBoxVoicePixmap;
					else pix = g_pListBoxUserOpPixmap;
					//QPixmap *pix=(data->oFlag != 0) ? g_pListBoxOpPixmap : g_pListBoxVoicePixmap;
					if(pix->mask()){
						XSetClipMask(g_display,gc_aux,pix->mask()->handle());
						XSetClipOrigin(g_display,gc_aux,KVI_LISTBOX_HORIZONTAL_BORDER,imageYPos);
					}
					//Draw the pixmap
					XCopyArea(g_display,pix->handle(),m_hMemBuffer,gc_aux,0,0,16,16,KVI_LISTBOX_HORIZONTAL_BORDER,imageYPos);
					XSetClipMask(g_display,gc_aux,None);
				}
				// Now the text
				if(data->extFlag != 0){
					//Selected item
					XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxSeleBack.pixel());
//					XSetBackground(g_display,gc_aux,g_pOptions->m_clrListBoxSeleBack.pixel());
				   	XFillRectangle(g_display,m_hMemBuffer,gc_aux,xLeft,
						(yCurCellBottom+g_pOptions->m_iListBoxBaseLineOffset)-g_pOptions->m_iListBoxCellHeight,
						availableXSpace,g_pOptions->m_iListBoxCellHeight);
					XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxSeleFore.pixel());
#ifdef COMPILE_USE_AA_FONTS
					if(g_pXftFont)
					{
						XftColor color;
						QColor * clr = &(g_pOptions->m_clrListBoxSeleFore);
						color.color.red = clr->red() | clr->red() << 8;
						color.color.green = clr->green() | clr->green() << 8;
						color.color.blue = clr->blue() | clr->blue() << 8;
						color.color.alpha = 0xffff;
						color.pixel = clr->pixel();
						XftDrawString8(g_pXftDraw,&color,g_pXftFont,xLeft,
							yCurCellBottom,(unsigned char *)data->pNode->pUser->nick(),strlen(data->pNode->pUser->nick()));
					} else
#endif
					XDrawString(g_display,m_hMemBuffer,gc_aux,xLeft,
						yCurCellBottom,data->pNode->pUser->nick(),strlen(data->pNode->pUser->nick()));
				} else {
					if(data->qFlag != 0)XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxOwner.pixel());
					else if(data->oFlag != 0)XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxOp.pixel());
					else if(data->hFlag != 0)XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxHalfOp.pixel());
					else if(data->vFlag != 0)XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxVoice.pixel());
					else if(data->uFlag != 0)XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxUserOp.pixel());
					else XSetForeground(g_display,gc_aux,g_pOptions->m_clrListBoxNormal.pixel());
#ifdef COMPILE_USE_AA_FONTS
					if(g_pXftFont)
					{
						XftColor color;
						QColor * clr;
						if(data->qFlag != 0)clr = &(g_pOptions->m_clrListBoxOwner);
						else if(data->oFlag != 0)clr = &(g_pOptions->m_clrListBoxOp);
						else if(data->hFlag != 0)clr = &(g_pOptions->m_clrListBoxHalfOp);
						else if(data->vFlag != 0)clr = &(g_pOptions->m_clrListBoxVoice);
						else if(data->uFlag != 0)clr = &(g_pOptions->m_clrListBoxUserOp);
						else clr = &(g_pOptions->m_clrListBoxNormal);
						color.color.red = clr->red() | clr->red() << 8;
						color.color.green = clr->green() | clr->green() << 8;
						color.color.blue = clr->blue() | clr->blue() << 8;
						color.color.alpha = 0xffff;
						color.pixel = clr->pixel();
						XftDrawString8(g_pXftDraw,&color,g_pXftFont,xLeft,
							yCurCellBottom,(unsigned char *)data->pNode->pUser->nick(),strlen(data->pNode->pUser->nick()));
					} else
#endif
					XDrawString(g_display,m_hMemBuffer,gc_aux,xLeft,
						yCurCellBottom,data->pNode->pUser->nick(),strlen(data->pNode->pUser->nick()));
				}
				yCurCellBottom += g_pOptions->m_iListBoxCellHeight;
			}
		}
		
	}

	//Need to draw the sunken rect around the view now...
	XSetLineAttributes(g_display,gc_aux,1,LineSolid,CapButt,JoinMiter);
	XSetForeground(g_display,gc_aux,colorGroup().dark().pixel());
	XDrawLine(g_display,m_hMemBuffer,gc_aux,0,0,widgetWidth,0);
	XDrawLine(g_display,m_hMemBuffer,gc_aux,0,0,0,widgetHeight);
	XSetForeground(g_display,gc_aux,colorGroup().light().pixel());
	XDrawLine(g_display,m_hMemBuffer,gc_aux,1,widgetHeight-1,widgetWidth-1,widgetHeight-1);
	XDrawLine(g_display,m_hMemBuffer,gc_aux,widgetWidth-1,1,widgetWidth-1,widgetHeight);

	//COPY TO THE DISPLAY
	XCopyArea(g_display,m_hMemBuffer,this->handle(),gc_aux,0,0,widgetWidth,widgetHeight,0,0);
	XFreeGC(g_display,gc_aux);
}

void KviListBox::resizeEvent(QResizeEvent *)
{
	m_pMemBuffer->resize(width(),height());
	updateScrollBar();
}

void KviListBox::updateScrollBar()
{
	// Update the scrollbar
	int maxItems = (height() - (KVI_LISTBOX_VERTICAL_BORDER * 2)) / g_pOptions->m_iListBoxCellHeight;
	if(maxItems < 0)maxItems = 0;
	if(maxItems < m_pClientList->count()){
		m_pScrollBar->setGeometry(width()-KVI_LISTBOX_SCROLLBAR_WIDTH,0,KVI_LISTBOX_SCROLLBAR_WIDTH,height());
		m_pScrollBar->setRange(0,m_pClientList->count()-maxItems);
		if(!m_pScrollBar->isVisible()){
			m_iCurTopItem = 0;
/* FIXME:  "Check the width for the scrollbar ?" */
			m_pScrollBar->show();
		} else {
/* FIXME: "Check this : scrollbar scrolled to the end , wait for some nicks to leave and check the results..." */
			if(m_iCurTopItem > (m_pClientList->count()-maxItems))m_iCurTopItem = m_pClientList->count() - maxItems;
		}
	} else {
		if(m_pScrollBar->isVisible())m_pScrollBar->hide();
		m_iCurTopItem = 0;
	}
}

void KviListBox::mousePressEvent(QMouseEvent *e)
{
	if(e->button() & (LeftButton | RightButton)){
		// Selection handling
		int item = itemFromPos(e->pos());
		if(item >=0){
			m_iLastSelectedItem = item;
			if(!(e->state() & ShiftButton)){
				// Deselect all
				for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
					data->extFlag = 0;
				}
			}
			// Select-invert this item
			KviIrcUserChanData *data = m_pClientList->firstData();
			for(int i = 0;data && (i<item); i++)data = m_pClientList->nextData();
			if(data){
				if(data->extFlag == 0)data->extFlag = 1;
				else data->extFlag = (e->button() & LeftButton) ? 0 : 1; //Right button does not unselect!
				KviStr szMask;
				data->pNode->pUser->mask(szMask);
				m_pFrm->m_pStatusBar->tempText(szMask.ptr(),KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
			}
			paintEvent(0);
		}
		m_iLastSelectedItem = item;
	}
	// Popup if it was the right button and we clicked a visible item...
	if((e->button() & RightButton) && (m_iLastSelectedItem >= 0))emit rightClicked();
/* FIXME: "And middleButtonPress ?" */
}

void KviListBox::mouseDoubleClickEvent(QMouseEvent *e)
{
	if(e->button() & (LeftButton)){
		// Selection handling
		int item = itemFromPos(e->pos());
		if(item >=0){
			m_iLastSelectedItem = item;
			if(!(e->state() & ShiftButton)){
				// Deselect all
				for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
					data->extFlag = 0;
				}
			}
			// Select-invert this item
			KviIrcUserChanData *data = m_pClientList->firstData();
			for(int i = 0;data && (i<item); i++)data = m_pClientList->nextData();
			if(data){
				if(data->extFlag == 0)data->extFlag = 1;
				KviStr szMask;
				data->pNode->pUser->mask(szMask);
				m_pFrm->m_pStatusBar->tempText(szMask.ptr(),KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
				bool bHalted = false;
				if(g_pEventManager->eventEnabled(KviEvent_OnNickDoubleClicked)){
					KviStr tmp = data->pNode->pUser->nick();
					bHalted = m_pUserParser->callEvent(KviEvent_OnNickDoubleClicked,m_pParent,tmp);
				}
				if(!bHalted)m_pFrm->raiseOrCreateQuery(data->pNode->pUser->nick());
					// Default action...
//					m_pUserParser->parseCommand("TIMER -s (internal_timer,100)QUERY %s",m_pParent);
//					KviQuery * query = m_pFrm->findQuery(data->pNode->pUser->nick());
///* FIXME:  "THIS HAS TO BE DONE THRU A QTIMER::SINGLESHOT!" */
//					if(query){
//						// Bring it to top...
//						if(query->isMinimized())query->restore();
//						query->raise();
//						query->setFocus();
//					} else query = m_pFrm->createQuery(data->pNode->pUser->nick()); //create it
//				}
			}
			paintEvent(0);
		}
		m_iLastSelectedItem = item;
	}
}

void KviListBox::mouseMoveEvent(QMouseEvent *e)
{
	if(e->state() & LeftButton){
		// Selection handling
		int item = itemFromPos(e->pos());
		if(item >=0 && (item != m_iLastSelectedItem)){ //Do not do it more than once for each item...
			if(!(e->state() & ShiftButton)){
				// Deselect all
				for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
					data->extFlag = 0;
				}
			}
			// Select-invert this item
			KviIrcUserChanData *data = m_pClientList->firstData();
			for(int i = 0;data && (i<item); i++)data = m_pClientList->nextData();
			if(data){
				if(data->extFlag == 0)data->extFlag = 1;
				else data->extFlag = 0;
				KviStr szMask;
				data->pNode->pUser->mask(szMask);
				m_pFrm->m_pStatusBar->tempText(szMask.ptr(),KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
			}
			paintEvent(0);
		}
		m_iLastSelectedItem = item;
	}
}

void KviListBox::dragEnterEvent(QDragEnterEvent *e)
{
//	__enter("dragEnterEvent");
	e->accept(m_pClientList->count() && QUriDrag::canDecode(e));
}

void KviListBox::dragMoveEvent(QDragMoveEvent *e)
{
//	__enter("dragMoveEvent");
	if(m_pClientList->count() == 0)return;
	int item = itemFromPos(e->pos());
	if(item != m_iLastSelectedItem){ //Do not do it more than once for each item...
		// Deselect all
		for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
			data->extFlag = 0;
		}
		if(item >=0){
			// Select-invert this item
			KviIrcUserChanData *data = m_pClientList->firstData();
			for(int i = 0;data && (i<item); i++)data = m_pClientList->nextData();
			if(data){
				data->extFlag = 1;
				KviStr szMask;
				data->pNode->pUser->mask(szMask);
				szMask.prepend(__tr("Drop the file to DCC SEND it to "));
				m_pFrm->m_pStatusBar->tempText(szMask.ptr(),KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
			}	
		} else m_pFrm->m_pStatusBar->tempText(__tr("Drop the file over a nickname to start the DCC SEND"),
				KVI_LISTBOX_USERMASK_STATUSBAR_SHOW_TIME);
		paintEvent(0);
	}
	m_iLastSelectedItem = item;
//	__leave("dragMoveEvent");
}

void KviListBox::dropEvent(QDropEvent *e)
{
	if(m_pClientList->count() == 0)return;
	int item = itemFromPos(e->pos());
	// Deselect all
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		data->extFlag = 0;
	}
	if(item >=0){
		// Select-invert this item
		KviIrcUserChanData *data = m_pClientList->firstData();
		for(int i = 0;data && (i<item); i++)data = m_pClientList->nextData();
		if(data){
			data->extFlag = 1;
			QStringList list;
			if(QUriDrag::decodeLocalFiles(e,list)){
				if(!list.isEmpty()){
					QStringList::ConstIterator it = list.begin(); //kewl ! :)
    				for( ; it != list.end(); ++it ){
						KviStr tmp = *it; //wow :)
						if(*(tmp.ptr()) != '/')tmp.prepend("/"); //HACK HACK HACK for Qt bug (?!?)
						tmp.prepend(" ");
						tmp.prepend(data->pNode->pUser->nick());
						tmp.prepend("/DCC SEND ");
						m_pUserParser->parseUserCommand(tmp,m_pParent);
					}
				}
			}
		}
	}
	paintEvent(0);
	m_iLastSelectedItem = item;
}

void KviListBox::mouseReleaseEvent(QMouseEvent *e)
{
	m_iLastSelectedItem = -1;
}

int KviListBox::itemFromPos(QPoint pos)
{
	pos.setY(pos.y()-KVI_LISTBOX_VERTICAL_BORDER);
	int item=(pos.y() / g_pOptions->m_iListBoxCellHeight)+m_iCurTopItem;
	if((item < 0)||(item >= m_pClientList->count()))item = -1;
	return item;
}

void KviListBox::appendNickList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(bFirstDone)buffer.append(',');
		else bFirstDone = true;
		buffer.append(data->pNode->pUser->nick());
	}
}

void KviListBox::appendOwnerList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->qFlag != 0){ //Owner
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}

void KviListBox::appendOpList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->oFlag != 0){ //Op
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}

void KviListBox::appendNOpList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->oFlag == 0){ //Non-Op
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}

void KviListBox::appendHalfOpList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->hFlag != 0){ //Halfop
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}

void KviListBox::appendVoiceList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->vFlag != 0){ //Voice
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}
void KviListBox::appendUserOpList(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->uFlag != 0){ //Userop
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}


void KviListBox::appendSelectedNicknames(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->extFlag != 0){ //Selected
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
		}
	}
}

void KviListBox::appendSelectedMasks(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->extFlag != 0){ //Selected
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->nick());
			buffer.append('!');
			buffer.append(data->pNode->pUser->username());
			buffer.append('@');
			buffer.append(data->pNode->pUser->host());
		}
	}
}

void KviListBox::appendSelectedHosts(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->extFlag != 0){ //Selected
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->host());
		}
	}
}

void KviListBox::appendSelectedUsernames(KviStr &buffer)
{
	bool bFirstDone = false;
	for(KviIrcUserChanData * data=m_pClientList->firstData();data;data=m_pClientList->nextData()){
		if(data->extFlag != 0){ //Selected
			if(bFirstDone)buffer.append(',');
			else bFirstDone = true;
			buffer.append(data->pNode->pUser->username());
		}
	}
}
#include "m_kvi_listbox.moc"
