#ifndef _KVI_REGUSERSDB_H_INCLUDED_
#define _KVI_REGUSERSDB_H_INCLUDED_

//
//   File : kvi_regusersdb.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_regusersdb.h)
//   Last major modification : Fri May 28 1999 00:26:26 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kvi_string.h"
#include "kvi_ircuser.h"

#include <qlist.h>

typedef struct KviRegisteredUser
{
	KviIrcUser user;
	KviStr allFlags;
	KviStr passwd;
	KviStr comment;
	char   bNotify;
	char   bIgnore;
};

class KviRegisteredUsersDb
{
public:
	KviRegisteredUsersDb();
	~KviRegisteredUsersDb();
public:
	QList<KviRegisteredUser> * m_pRegList;
public:
	void registerUser(KviRegisteredUser * u,const char *flags);
	void unregisterUser(KviRegisteredUser *u);
	void clear();
//	void copyList(QList<KviRegisteredUser> *dst,QList<KviRegisteredUser> *src);
	KviRegisteredUser * findUserByMask(const char *mask);
	KviRegisteredUser * findIgnoredUserByMask(const char *mask);
	KviRegisteredUser * findUserWithFlagByMask(const char *mask,char flag);
	KviRegisteredUser * findExactMatch(const char *mask);
	bool load(const char *filename,KviStr &error);
	bool save(const char *filename);
	void getWatchString(KviStr &buf);
	void getNotifyString(KviStr &buf);
	void getFlags(const char *mask, KviStr &buf);
	void getFlagsExact(const char *mask, KviStr &buf);
	void addFlags(KviRegisteredUser * u,const char *flags);
	void setFlags(KviRegisteredUser * u,const char *flags);
	void deleteFlags(KviRegisteredUser * u,const char *flag);
	void setPasswd(KviRegisteredUser * u,const char *passwd);
	void getPasswd(KviRegisteredUser * u,KviStr &buf);
	void setComment(KviRegisteredUser * u,const char *comment);
	void getComment(KviRegisteredUser * u,KviStr &buf);
};

#endif //!_KVI_REGUSERSDB_H_INCLUDED_
