#ifndef _KVI_SCRIPTEDITOR_H_INCLUDED_
#define _KVI_SCRIPTEDITOR_H_INCLUDED_

//
//   File : kvi_scripteditor.h (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_scripteditor.h)
//   Last major modification : Sun Mar 28 1999 16:11:48 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include <qmultilineedit.h>
#include <qpixmap.h>
//#include <qpopupmenu.h>
#include <qfontmetrics.h>
#include <qlabel.h>
#include <qglobal.h>

class KviScriptEditorWidget : public QMultiLineEdit
{
	Q_OBJECT
public:
	KviScriptEditorWidget(QWidget *parent);
	~KviScriptEditorWidget();
private:
	QPixmap * m_pMemBuffer;
	int m_spaceWidth;
	int m_tabWidth;
	int m_xWidth;
	int m_textState;
	QFontMetrics * m_pFm;
	int m_iLastCursorRow;
	int m_iLastCursorCol;
public:
	virtual void setEnabled(bool bEnabled);
signals:
	void cursorRowChanged(int row);
	void cursorColChanged(int col);
	void message(const QString &);
protected:
	void completion();
	int textWidthWithTabs(const char *s,int nChars);
	QColor * getColor(const char *s,int len);
	int extractNextWord(const char *s);
	int getSpacesAndTabsLen(const char *s,int nChars,int curNChars,int *width);
	virtual void paintCell(QPainter * painter,int row,int col);
	virtual void resizeEvent(QResizeEvent *e);
	virtual void setFont(const QFont &font);
	virtual void keyPressEvent(QKeyEvent *e);
};

class KviScriptEditor : public QWidget
{
	Q_OBJECT
public:
	KviScriptEditor(QWidget * parent);
	~KviScriptEditor();
protected:
	KviScriptEditorWidget * m_pEditor;
	QLabel                * m_pAux1;
	QLabel                * m_pAux2;
	QLabel                * m_pRowLabel;
	QLabel                * m_pColLabel;
public:
	KviScriptEditorWidget * editor(){ return m_pEditor; };
	void setText(const QString &text);
	QString text();
	virtual void setEnabled(bool bEnabled);
protected slots:
	void cursorRowChanged(int row);
	void cursorColChanged(int col);
	void saveToFile();
	void loadFromFile();
};

inline void KviScriptEditor::setText(const QString &text)
{
	m_pEditor->setText(text);
}


inline QString KviScriptEditor::text()
{
	return m_pEditor->text();
}

#endif //!_KVI_SCRIPTEDITOR_H_INCLUDED_
