//
//   File : kvi_popupmenu.cpp (/usr/build/NEW_kvirc/kvirc/src/kvirc/kvi_popupmenu.cpp)
//   Last major modification : Wed Apr 21 1999 21:36:26 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//   Copyright (C) 1999-2000 Till Busch (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

//#define _KVI_DEBUG_CLASS_NAME_ "KviUserToolBar"
//#define _KVI_DEBUG_CHECK_RANGE_
#include "kvi_debug.h"
#include "kvi_utoolbar.h"

#include "kvi_app.h"
#include "kvi_frame.h"
#include "kvi_uparser.h"
#include "kvi_error.h"
#include "kvi_defines.h"
#include "kvi_locale.h"
#include "kvi_fileutils.h"
#include "kvi_window.h"
#include "kvi_style.h"
#include "kvi_options.h"

#include <qpixmap.h>
#include <qiconset.h>
#include <qcursor.h>
#include <qobjectlist.h>

#include <qtoolbar.h>
#include <qtoolbutton.h>


//#warning "Add an option to have the icons ALWAYS smalL"

// declared in kvi_app.cpp
extern QPixmap * g_pixViewOut[KVI_OUT_NUM_IMAGES];

extern KviUserToolBarTemplate * g_pUserToolBarTemplate; //kvi_options.cpp
//extern int g_iLastSelectedScriptTab;  // kvi_dlgscript.cpp

KviUserToolBar::KviUserToolBar(KviFrame *frame,QMainWindow::ToolBarDock dock)
:QToolBar("KviUserToolBar",frame,dock,true,"KviUserToolbar")
{
	m_pDataList   = new QList<KviUserToolBarData>;
	m_pDataList->setAutoDelete(true);
	m_pFrame      = frame;
	m_pParent     = frame;
	m_bLocked     = false;
	m_id          = 1;
	setBackgroundMode(QWidget::PaletteBackground);
}

KviUserToolBar::KviUserToolBar(KviFrame *frame, QWidget *parent)
:QToolBar("KviTestToolBar",frame,parent, false, "KviUserToolBar")
{
	m_pDataList   = new QList<KviUserToolBarData>;
	m_pDataList->setAutoDelete(true);
	m_pFrame      = frame;
	m_pParent     = parent;
	m_bLocked     = false;
	m_id          = 1;
//	m_pEditPopup  = 0;
//	installEventFilter(this);
	setBackgroundMode(QWidget::PaletteBackground);
}

bool KviUserToolBar::isEmpty()
{
	return m_pDataList->isEmpty();
}

// Qt actually kills the MouseButtonPress event...we need to do it in some other way
//bool KviUserToolBar::eventFilter(QObject * o,QEvent *e)
//{
//	if(e->type() == QEvent::MouseButtonPress){
//		if(((QMouseEvent *)e)->button() & RightButton){
//			if() ->popup(QCursor::pos());
//			return true;
//		}
//	}
//	return false;
//}

void KviUserToolBar::copyFromTemplate(KviUserToolBarTemplate *toolbar, bool /*unnused*/)
{
	__range_valid(toolbar);
	setUpdatesEnabled(false);
	clearAll();
	for(KviUserToolBarData * d=toolbar->m_pDataList->first();d;d=toolbar->m_pDataList->next()){
		switch(d->type) {
			case KviUserToolBar::Separator :
				insertSeparatorItem();
				break;
			case KviUserToolBar::Button :
				insertNormalItem(d->text.ptr(),d->sbar.ptr(),d->image.ptr(),d->buffer.ptr());
				break;
			case KviUserToolBar::Menu :
				{
				KviStr yourName(KviStr::Format,"utoolbar_script_popup_%s",d->text.ptr());
				KviPopupMenu * m = new KviPopupMenu(0,yourName.ptr());
				m->copyFromPopup(d->menu);
				insertNormalItem(d->text.ptr(),d->sbar.ptr(),d->image.ptr(),0, m);
				}
				break;
			default : break; // no other types
		}
	}

//	setStretchableWidget(new KviTransparentWidget(this));
	setUpdatesEnabled(true);
//	if (bEditPopup) {
//		 = new QPopupMenu(this, "ToolbarEditPopup");
//		->insertItem(__tr("Edit toolbar"),this,SLOT(slot_editToolBar()));
//	}
}

//void KviUserToolBar::slot_editToolBar()
//{
////	g_iLastSelectedScriptTab = 3;
//	g_pApp->slot_doScriptDialog();
//}

void KviUserToolBar::insertSeparatorItem()
{
	KviUserToolBarData *data = new KviUserToolBarData;
	KviGuiSeparator * sep = new KviGuiSeparator(this);
	(void)sep;
	data->id = 0;
	data->buffer = " ";
	data->button=0;
	data->menu=0;
	data->text= "";
	data->image= "";
	data->type=KviUserToolBar::Separator;
	m_pDataList->append(data);
	m_id++;
}

int KviUserToolBar::insertNormalItem(const char *name, const char *sbar,const char *img,const char *buffer, KviPopupMenu *menu)
{
	KviUserToolBarData *data = new KviUserToolBarData;

// ================================================================ get image
	bool bDone = false;
	KviStr pName(name);
	m_pFrame->m_pUserParser->processString(name,(KviWindow *)m_pFrame->m_pConsole,pName);
	KviStr image(img);
	if(image.hasData()){
		if(image.isNum()){
			bool bOk=false;
			int imId = image.toInt(&bOk);
			if(imId >= 0){
				imId = imId % KVI_OUT_NUM_IMAGES;
				data->button = new KviToolButton(m_id, *g_pixViewOut[imId],pName.ptr(),sbar,this,0,this);
				data->button->setUsesBigPixmap(g_pOptions->m_bUseBigUToolbarPixmaps);
				data->button->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);
				data->menu = menu;
				connect(data->button, SIGNAL(idClicked(int)), this, SLOT(buttonClicked(int)));
				data->buffer = buffer;
				data->id = m_id;
				data->text = name;
				data->sbar = sbar;
				data->image = image;
				data->buffer.stripWhiteSpace();
				if(menu)
					data->type=KviUserToolBar::Menu;
				else
					data->type=KviUserToolBar::Button;
				m_pDataList->append(data);
				m_id++;
				bDone = true;
			}
		} else {
			KviStr imagePath;
			if(g_pApp->findImage(imagePath,image.ptr())){
				QPixmap pix(imagePath.ptr());
				if(!pix.isNull()){
					data->button = new KviToolButton(m_id, pix,pName.ptr(),sbar,this,0,this);
					data->button->setUsesBigPixmap(g_pOptions->m_bUseBigUToolbarPixmaps);
					data->button->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);
					connect(data->button, SIGNAL(idClicked(int)), this, SLOT(buttonClicked(int)));
					data->id = m_id;
					data->text = name;
					data->sbar = sbar;
					data->image = image; //Not imagePath!..so if it is moved we will be able to find it again
					data->buffer = buffer;
					data->menu = menu;
					data->buffer.stripWhiteSpace();
					if(menu)
						data->type=KviUserToolBar::Menu;
					else
						data->type=KviUserToolBar::Button;
					m_pDataList->append(data);
					m_id++;
					bDone = true;
				} else debug("Unable to locate image file %s",image.ptr());
			}
		}
	}
	if(!bDone) {
		QPixmap pix(16,16); //Non null one
		data->button = new KviToolButton(m_id, pix,pName.ptr(),sbar,this,0,this);
		data->button->setUsesBigPixmap(g_pOptions->m_bUseBigUToolbarPixmaps);
		data->button->setUsesTextLabel(g_pOptions->m_bUseTextToolbarComment);
		connect(data->button, SIGNAL(idClicked(int)), this, SLOT(buttonClicked(int)));
		data->id = m_id;
		data->text = name;
		data->sbar = sbar;
		data->image = image; //Not imagePath!..so if it is moved we will be able to find it again
		data->buffer = buffer;
		data->menu = menu;
		data->buffer.stripWhiteSpace();
		if(menu)
			data->type=KviUserToolBar::Menu;
		else
			data->type=KviUserToolBar::Button;
		m_pDataList->append(data);
		m_id++;
	}
//	debug("Added ID  (%d)",data->id);
//	debug("  name:   (%s)",data->text.ptr());
//	debug("  image:  (%s)",data->image.ptr());
//	debug("  sbar:   (%s)",data->sbar.ptr());
//	debug("  buffer: (%s)",data->buffer.ptr());
//	debug("  List-count %d",m_pDataList->count());
	return data->id;
}

void KviUserToolBar::buttonClicked(int id)
{
//	debug("buttonClicked: %d",id);
//	debug(" List-count %d",m_pDataList->count());
	for(KviUserToolBarData * d=m_pDataList->first();d;d=m_pDataList->next()){
//	debug(" testing: %d",id);
		if(d->id == id){
//				debug("    found:  %d",id);
			if (d->menu) {
//				debug("    menu->doPopup");
				d->menu->doPopup(this,SLOT(popupClicked(const KviStr &)),d->button->mapToGlobal(QPoint(0,height())));
				return;
			}
//			debug("    buffer: %s",d->buffer.ptr());
			m_bLocked = true;
			m_pFrame->m_pUserParser->parseCommand(d->buffer.ptr(),(KviWindow *)(m_pFrame->m_pConsole));
			m_bLocked = false;
			return;
		}
	}
	debug("Oops... cannot find button %d",id);
}

void KviUserToolBar::popupClicked(const KviStr &dataBuffer)
{
	m_pFrame->m_pUserParser->parseCommand(dataBuffer.ptr(),(KviWindow *)(m_pFrame->m_pConsole));
}

void KviUserToolBar::clearToolBar()
{
    if ( !children() )
	return;
    QObjectList list = *children();
    for (QObjectListIt it(list); it.current(); ++it) {
	if ( it.current()->isWidgetType() )
	    delete it.current();
    }
}


void KviUserToolBar::clearAll()
{
	// no leaks ?????
	KviUserToolBarData * data;
	while((data = m_pDataList->first())){
		if(data->button != 0)delete data->button;
		data->button=0;
		m_pDataList->removeFirst();
	}
	m_pDataList->clear();
	clearToolBar();
	m_id=1;
}

KviUserToolBar::~KviUserToolBar()
{
	clearAll();
	delete m_pDataList;
}

// ========================================================================


bool KviUserToolBarTemplate::loadToolBarTemplate(const char *filename,KviStr &error)
{
	KviStr buffer;
	if(!kvi_loadFile(filename,buffer)){
		error = _i18n_("Unable to load file");
		return false;
	}

	if(!kvi_strEqualCSN(KVI_MAGIC_STRING,buffer.ptr(),KVI_MAGIC_STRING_LENGTH)){
		error = _i18n_("Invalid magic in KVIrc configuration file");
		return false; //not a kvirc file
	}

	buffer.cutLeft(KVI_MAGIC_STRING_LENGTH);

	while(buffer.hasData()){
		buffer.stripLeftWhiteSpace();

		if(!kvi_strEqualCSN("[TOOLBAR",buffer.ptr(),8)){
			error = _i18n_("Invalid TOOLBAR label");
			return false;
		}

		buffer.cutLeft(8);
		buffer.stripLeftWhiteSpace();

		KviUserToolBarTemplate *target = g_pUserToolBarTemplate;

		buffer.stripLeftWhiteSpace();
		if(!kvi_strEqualNoLocaleCIN("bytes ",buffer.ptr(),6)){
			error = __tr("Syntax error in [TOOLBAR] label");
			return false;
		}

		buffer.cutLeft(6);
		buffer.stripLeftWhiteSpace();

		if(!isdigit(*(buffer.ptr()))){
			error = _i18n_("Syntax error in [TOOLBAR] label (digit expected)");
			return false;
		}

		KviStr numBytes;
		if(!buffer.getToken(numBytes,']')){
			error = _i18n_("Syntax error in [TOOLBAR] label (can not extract toolbar length)");
			__debug(buffer.ptr());
			return false;
		}

		bool bOk = false;
		int bytes = numBytes.toInt(&bOk);
		if(!bOk){
			error = _i18n_("Unrecogized token ");
			error +=numBytes;
			__debug(buffer.ptr());
			return false;
		} //syntax error again...someone messed with the file

		buffer.cutLeft(1); //cut the \n
		if(buffer.len() < bytes){
			error = _i18n_("Toolbar buffer smaller than declared length (");
			error += numBytes;
			error +=")";
			__debug(buffer.ptr());
			return false;
		}

		KviStr toolbarBuf = buffer.left(bytes);
		buffer.cutLeft(bytes);

		buffer.stripLeftWhiteSpace();

		if(!kvi_strEqualCSN("[ENDTOOLBAR]\n",buffer.ptr(),13)){
			error = __tr("Something went wrong with the toolbar buffer lenght");
			__debug(buffer.ptr());
			return false;
		}
		buffer.cutLeft(13);

/*		if(target->m_bLocked){
			error = __tr("Attempted to self-modify a locked toolbar");
			debug("WARNING : Attempt to self-modify locked toolbar, skipping");
			return false;
		}
*/
		if(!target->loadFromDataBuffer(toolbarBuf,error)){
			__debug(toolbarBuf.ptr());
			return false;
		}
	}
	return true;
}

bool KviUserToolBarTemplate::loadFromDataBuffer(KviStr &buffer,KviStr &error)
{
//	clearAll();
	m_pDataList->clear();
	buffer.stripLeftWhiteSpace();

	while(buffer.hasData()){
		if(kvi_strEqualNoLocaleCIN("[separator]\n",buffer.ptr(),12)){
			buffer.cutLeft(12);
			insertSeparatorItem();
		} else if(kvi_strEqualNoLocaleCIN("[button]\n",buffer.ptr(),9)){
			buffer.cutLeft(9);
			KviStr image,name,sbar,bytes;
			if(!buffer.getLine(image)){
				error = __tr("Unexpected end of buffer");
				return false;
			}
			buffer.stripLeftWhiteSpace();
			if(!buffer.getLine(name)){
				error = __tr("Unexpected end of buffer");
				return false;
			}
			buffer.stripLeftWhiteSpace();
			if(!buffer.getLine(sbar)){
				error = __tr("Unexpected end of buffer");
				return false;
			}
			buffer.stripLeftWhiteSpace();
			if(!buffer.getLine(bytes)){
				error = __tr("Unexpected end of buffer");
				return false;
			}

			if(!kvi_strEqualNoLocaleCIN("image=",image.ptr(),6)){
				error = __tr("Unrecognized item image label");
				return false;
			}
			image.cutLeft(6);
			image.stripWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("name=",name.ptr(),5)){
				error = __tr("Unrecognized item name label");
				return false;
			}
			name.cutLeft(5);
			name.stripWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("statusbar=",sbar.ptr(),10)){
				error = __tr("Unrecognized item statusbar label");
				return false;
			}
			sbar.cutLeft(10);
			sbar.stripWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("bytes=",bytes.ptr(),6)){
				error = __tr("Unrecognized item length label");
				return false;
			}
			bytes.cutLeft(6);
			bytes.stripWhiteSpace();
			bool bOk = false;
			int bLen = bytes.toInt(&bOk);
			if(!bOk){
				error = __tr("Unrecognized item length");
				return false;
			}
			if((bLen < 0) || (bLen > buffer.len())){
				error = __tr("Buffer is shorter than the declared length");
				return false;
			}
			KviStr pBuf = buffer.left(bLen);
			buffer.cutLeft(bLen);
			buffer.stripLeftWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("[endbutton]\n",buffer.ptr(),12)){
				error = __tr("Somethng went wrong with the buffer length");
				return false;
			}
			buffer.cutLeft(12);
			insertNormalItem(name.ptr(),sbar.ptr(),image.ptr(),pBuf.ptr());

		} else if(kvi_strEqualNoLocaleCIN("[menu]\n",buffer.ptr(),7)){
			buffer.cutLeft(7);
			KviStr image,name,sbar,bytes;
			if(!buffer.getLine(image)){
				error = __tr("Unexpected end of buffer");
				return false;
			}
			buffer.stripLeftWhiteSpace();
			if(!buffer.getLine(name)){
				error = __tr("Unexpected end of buffer");
				return false;
			}
			buffer.stripLeftWhiteSpace();
			if(!buffer.getLine(sbar)){
				error = __tr("Unexpected end of buffer");
				return false;
			}
			buffer.stripLeftWhiteSpace();
			if(!buffer.getLine(bytes)){
				error = __tr("Unexpected end of buffer");
				return false;
			}

			if(!kvi_strEqualNoLocaleCIN("image=",image.ptr(),6)){
				error = __tr("Unrecognized menu image label");
				return false;
			}
			image.cutLeft(6);
			image.stripWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("name=",name.ptr(),5)){
				error = __tr("Unrecognized menu name label");
				return false;
			}
			name.cutLeft(5);
			name.stripWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("statusbar=",sbar.ptr(),10)){
				error = __tr("Unrecognized item statusbar label");
				return false;
			}
			sbar.cutLeft(10);
			sbar.stripWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("bytes=",bytes.ptr(),6)){
				error = __tr("Unrecognized menu length label");
				return false;
			}
			bytes.cutLeft(6);
			bytes.stripWhiteSpace();
			bool bOk = false;
			int bLen = bytes.toInt(&bOk);
			if(!bOk){
				error = __tr("Unrecognized menu length");
				return false;
			}
			if((bLen < 0) || (bLen > buffer.len())){
				error = __tr("Buffer is shorter than the declared length");
				return false;
			}
			KviStr mBuf = buffer.left(bLen);
			buffer.cutLeft(bLen);
			buffer.stripLeftWhiteSpace();
			if(!kvi_strEqualNoLocaleCIN("[endmenu]\n",buffer.ptr(),10)){
				error = __tr("Something went wrong with the buffer length");
				return false;
			}
			buffer.cutLeft(10);

			KviStr yourName(KviStr::Format,"utoolbar_script_popup_%s",name.ptr());


			KviPopupMenu *menu = new KviPopupMenu(0,yourName.ptr());
			if(!menu->loadFromDataBuffer(mBuf,error)){
				delete menu;
				return false;
			}

			insertNormalItem(name.ptr(),sbar.ptr(),image.ptr(),0,menu);

		} else {
			error = __tr("Unrecognized toolbar item");
			return false;
		}

		buffer.stripLeftWhiteSpace();
	}
	return true;
}

bool KviUserToolBarTemplate::saveToolBarTemplate(const char *filename)
{
	QFile f(filename);
	if(!f.open(IO_WriteOnly | IO_Truncate))return false;

	f.writeBlock(KVI_MAGIC_STRING,KVI_MAGIC_STRING_LENGTH);

	g_pUserToolBarTemplate->save(&f);

	f.close();
	return true;
}

void KviUserToolBarTemplate::save(QFile *f)
{
	f->writeBlock("[TOOLBAR",8);
	f->writeBlock(" bytes ",7);

	KviStr buffer;
	buildDataBuffer(buffer);

	KviStr szNBytes(KviStr::Format,"%d",buffer.len());
	f->writeBlock(szNBytes.ptr(),szNBytes.len());
	f->writeBlock("]\n",2);
	f->writeBlock(buffer.ptr(),buffer.len());
	f->writeBlock("\n[ENDTOOLBAR]\n",14);
}

void KviUserToolBarTemplate::buildDataBuffer(KviStr &str)
{
	for(KviUserToolBarData * d=m_pDataList->first();d;d=m_pDataList->next()){
		switch (d->type) {
		case KviUserToolBar::Separator:
			str.append("[separator]\n");
		continue;
		case KviUserToolBar::Button: {
			str.append("[button]\n");
			str.append("image=");
			if(d->image.hasData())str.append(d->image);
			str.append("\nname=");
			str.append(d->text);
			str.append("\nstatusbar=");
			str.append(d->sbar);
			str.append("\nbytes=");
			KviStr tmp(KviStr::Format,"%d",d->buffer.len());
			str.append(tmp);
			str.append("\n");
			str.append(d->buffer);
			str.append("\n[endbutton]\n");
		}
		continue;

		case KviUserToolBar::Menu:
			str.append("[menu]\n");
			str.append("image=");
			if(d->image.hasData())str.append(d->image);
			str.append("\nname=");
			str.append(d->text);
			str.append("\nstatusbar=");
			str.append(d->sbar);
			KviStr auxBuf;
			d->menu->buildDataBuffer(auxBuf);
			str.append("\nbytes=");
			KviStr tmp(KviStr::Format,"%d",auxBuf.len());
			str.append(tmp);
			str.append("\n");
			str.append(auxBuf);

			str.append("\n[endmenu]\n");
		}
	}
}

/*

	I've tried to use this one to save the config files:
	the only way that it could work , is to parse the
	toolbar (and then aliases, events and popup)
	configs after the first frame is created,
	and this could be done (with some hacks , like moving the
	Event_OnStartup out of the KviFrame constructor ,
	removing loadToolBar()&co. from KviOptions::load()...).
	The main problem in using this method is that it is
	not "syntax error safe".
	It is allowed to an user to save a button
	(menu or anything else) buffer with a syntax error inside.
	That syntax error will stop the parsing of the config file
	and "destroy" all the other buttons (menus or anything else).
	No solution for this yet , so by now I'll leave it commented
	and stick to the old method.


void KviUserToolBarTemplate::buildDataBuffer(KviStr &str)
{
	for(KviUserToolBarData * d=m_pDataList->first();d;d=m_pDataList->next()){
		switch (d->type) {
		case KviUserToolBar::Separator:
			str.append("utoolbar separator\n");
		continue;
		case KviUserToolBar::Button: {
			str.append("utoolbar button(");
			str.append(d->text);
			str.append(",");
			if(d->image.hasData())str.append(d->image);
			str.append(",");
			if(d->image.hasData())str.append(d->sbar);
			str.append("): ");
			str.append("{\n");
			str.append(d->buffer);
			str.append("\n}\n");
		}
		continue;

		case KviUserToolBar::Menu:
			str.append("utoolbar menu(");
			str.append(d->text);
			str.append(",");
			if(d->image.hasData())str.append(d->image);
			str.append(",");
			if(d->image.hasData())str.append(d->sbar);
			str.append("): ");
			str.append("{\n");
			KviStr auxBuf;
			d->menu->buildPDataBuffer(auxBuf);
			str.append(auxBuf);
			str.append("}\n");
		}
	}
}
*/

// =======================================================
// =======================================================

KviUserToolBarTemplate::KviUserToolBarTemplate()
{
	m_pDataList   = new QList<KviUserToolBarData>;
	m_pDataList->setAutoDelete(true);
	m_id		  = 1;
}

KviUserToolBarTemplate::~KviUserToolBarTemplate()
{
}

bool KviUserToolBarTemplate::isEmpty()
{
	return m_pDataList->isEmpty();
}

int KviUserToolBarTemplate::insertSeparatorItem()
{
	KviUserToolBarData *data = new KviUserToolBarData;
	data->id = 0;
	data->buffer = " ";
	data->button=0;
	data->text= "";
	data->image= "";
	data->sbar= "";
	data->type=KviUserToolBar::Separator;
	m_pDataList->append(data);
	m_id++;
	return data->id;
}

int KviUserToolBarTemplate::insertNormalItem(const char *name, const char *sbar,const char *img,const char *buffer, KviPopupMenu * menu)
{
	KviUserToolBarData *data = new KviUserToolBarData;
	data->id = m_id++;
	data->buffer = buffer;
	data->button=0;
	data->text= name;
	data->image= img;
	data->sbar=sbar;
	data->menu=menu;
	if(menu)
		data->type=KviUserToolBar::Menu;
	else
		data->type=KviUserToolBar::Button;
	m_pDataList->append(data);
	return data->id;
}

void KviUserToolBarTemplate::clearToolBar()
{
	m_pDataList->clear();
}

void KviUserToolBarTemplate::copyFromToolBar(KviUserToolBar *toolbar)
{
	__range_valid(toolbar);
	clearToolBar();
	for(KviUserToolBarData * d=toolbar->m_pDataList->first();d;d=toolbar->m_pDataList->next()){
		switch(d->type) {
			case KviUserToolBar::Separator :
				insertSeparatorItem();
				break;
			case KviUserToolBar::Button :
				insertNormalItem(d->text.ptr(),d->sbar.ptr(),d->image.ptr(),d->buffer.ptr());
				break;
			case KviUserToolBar::Menu :
				{
				KviStr yourName(KviStr::Format,"utoolbar_script_popup_%s",d->text.ptr());
				KviPopupMenu * m = new KviPopupMenu(0,yourName.ptr());
				m->copyFromPopup(d->menu);
				insertNormalItem(d->text.ptr(),d->sbar.ptr(),d->image.ptr(),0, m);
				}
				break;
			default : break; // no other types
		}
	}
}


// ================== class KviToolButton
/*
KviToolButton::KviToolButton(int id, const QIconSet & pm, const QString & textLabel, const QString & grouptext, QObject * receiver, const char * slot, QToolBar * parent)
:KviToolBarButton(pm, textLabel, grouptext, receiver, slot, parent, textLabel)
{
	m_BtnId = id;
	disconnect(this, SIGNAL(clicked()),this,slot);
	connect(this, SIGNAL(clicked()), this, SLOT(wasClicked()));
	debug("created (iconset) %d",m_BtnId);
}
*/
KviToolButton::KviToolButton(int id, const QPixmap & pm, const char * textLabel, const char * grouptext, QObject * receiver, const char * slot, QToolBar * parent)
:KviToolBarButton(pm, textLabel, grouptext, receiver, slot, parent, textLabel)
{
	m_BtnId = id;
	disconnect(this, SIGNAL(clicked()),this,slot);
	connect(this, SIGNAL(clicked()), this, SLOT(wasClicked()));
//	debug("created (pixmap) %d",m_BtnId);
}

KviToolButton::~KviToolButton()
{
//	debug("deleted ID %d",m_BtnId);
	disconnect(this, SIGNAL(clicked()));
}

void KviToolButton::wasClicked()
{
//	debug("wasClicked ---> idClicked (%d)", m_BtnId);
	emit idClicked(m_BtnId);
}

#include "m_kvi_utoolbar.moc"
