//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Till Bush (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
#ifndef _KVI_ABOUT_H_INCLUDED_
#define _KVI_ABOUT_H_INCLUDED_

#include <qdialog.h>
#include <qtimer.h>
#include <qscrollview.h>
#include <qpixmap.h>
#include <qlabel.h> 

class KviOpaqueLabel;

class KviDlgAbout : public QDialog {
	Q_OBJECT

public:
	KviDlgAbout(QWidget *parent=0);
	~KviDlgAbout();

protected:

signals:
	void closed();

private slots:
	void close();
	virtual void closeEvent(QCloseEvent *);
	virtual void paintEvent(QPaintEvent *);
	void scrollText();

private:
	int posy;
//	int m_img;
//	int m_last_img;
//	int m_img_direction;
	int w,h;
	int m_text_height;
	char *m_text;
	KviOpaqueLabel *m_pfield;
	QWidget *m_pview;
	QPixmap *m_ppix_text;
//	QPixmap *m_ppix[3];
	QPixmap *m_pBackground;
	virtual void mouseReleaseEvent(QMouseEvent *e);
};

#endif
