//
//   SPEAK plugin for KVirc 1.1 Phoenix.
//
//   This plugin enables you to use IBM's ViaVoiceOutloud to speak
//   messages to you.  Messages that are directed to you, over the
//   Relay Chat, can be spoken outloud or sentences spoken by specific
//   people can also heard outloud.
//
//   To use the plugin, one needs to have a working IBM ViaVoice
//   Outloud, which can be retrieved from IBM's site.  For information
//   about IBM ViaVoice http://www-4.ibm.com/software/speech/dev/
//
//   Copyright (C) rn E. Hansen (oe.hansen@gamma.telenordia.se)
//   Copyright (C) Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#ifndef LIBKVISPEAK_H
#define LIBKVISPEAK_H

#include "setupData.h"
#include "smileyClassData.h"
#include "kvi_string.h"
#include "trees.h"

class QTextStream;
class QListView;
class smileyNode;
class KviApp;

struct eci_user {
  KviStr name;
  KviStr voice;
};

struct Voice {
  int s_gender;
  int s_headsize;;
  int s_pitch_base;
  int s_pitch_fluc;
  int s_roughness;
  int s_speed;
  int s_volume;
  int s_breathy;
};

class eciVoiceSetup : public eciSetupData {
  Q_OBJECT

private:
  eci_user* _user;
  int       _gender;
  int       _index;

  void setVoice(int);
  void showAnnotations();
  KviStr buildVoice();
public:
  eciVoiceSetup(eci_user *,QWidget *p=0,const char* name=0);
  ~eciVoiceSetup();

  void setup(eci_user *);

protected slots:
  void grandpa();
  void genderValue(bool); 
  void volumeValue(int);
  void pitchBaseValue(int);
  void female();
  void cancelPressed();
  void male1();
  void testPressed();
  void male2();
  void speedValue(int);
  void headValue(int);
  void okPressed();
  void breathinessValue(int);
  void child();
  void grandma();
  void pitchRangeValue(int);
  void roughnessValue(int);
};

class smileyClass : public smileyClassData
{
  Q_OBJECT

private:
  bool _smileys_loaded;

  void insertSmileys(QListView *, smileyNode *);

public:

  smileyClass(QWidget *parent = NULL, const char *name = NULL);
  virtual ~smileyClass();

  void init();
  void editSmileys();
  void load(KviStr&);

protected slots:

  void loadBase();
  void insertItem();
  void removeItem();
  void okPressed();
  void updateItem();
  void saveBaseAs();
  void selectShortHand(QListViewItem*);
};

class smileyNode : public Node
{
 protected:
  bool   _caseSense;
  KviStr _key, _english;

 public:
  smileyNode(const QString&,const QString&,bool);
  smileyNode(const KviStr&,const KviStr&,bool);
  ~smileyNode();

  KviStr Key()                { return _key;                     };
  const KviStr& English()     { return _english;                 };
  bool CaseSense()            { return _caseSense;               };

  int Compare(smileyNode *p)  { return Compare(p->Key());        };
  int Compare(Node *p)        { return Compare((smileyNode *)p); };
  int Compare(void *);
  int Compare(const KviStr&);
};

#endif
