/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvistatoptions.h ---
  *
  * This is a plugin for KVirc 2.0 Phoenix. It allows you to see
  * statistics of your IRC sessions - total words said etc.
  * More features are still to come.
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  *
  *
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/

#ifndef __KVISTATOPTIONS_H__
#define __KVISTATOPTIONS_H__

#include <qlist.h>
#include "kvirc_plugin.h"

// class QTab;
class QTabDialog;
class QLabel;
class QCheckBox;
class QVButtonGroup;
class QRadioButton;
class QComboBox;
class QSlider;

// Type of stats report performed on join to a channel
#define ShowNoStatsOnJoin			0
#define ShowFullStatsOnJoin			1
#define ShowCustomStatsOnJoin		2

// indexes of Custom Stats checkboxes
#define ShowJoinsOnJoin				0
#define ShowWordsOnJoin				1
#define ShowKicksOnJoin				2
#define ShowBansOnJoin				3
#define ShowTopicsOnJoin			4

// indexes of SysTray Widget checkboxes
#define SysTrayEnabled					5
#define SysTrayShowWords				6
#define SysTrayShowJoins				7
#define SysTrayShowKicks				8
#define SysTrayShowBans					9
#define SysTrayShowTopics				10

#define ScrollingNever					0	
#define ScrollingAlways					1
#define ScrollingWhenNeeded				2

class KviStatOptions : public QTabDialog
{
	Q_OBJECT
public:
	KviStatOptions();
	~KviStatOptions() {}

// Used to set the options - check/uncheck checkboxes, set correct
// radioButton checked
	void setOptions( unsigned int numOfRadioBtnChecked, bool , bool ,
		 bool , bool , bool );
		
// Same as above but for SysTray widget options
	void setSysTrayOptions( bool, bool, bool, bool, bool, bool );
	
// and for scrolling options
	void setScrollingOptions( int, int, int, bool dir_left );
		
// Used to read the options, sets numOfRadioBtnChecked to number of
// radioButton checked (stats showing on join), sets the bool variables to
// correct values, depending on which option from "Custom stats" is chosen
	void getOptions( int &numOfRadioBtnChecked, bool &, bool &, bool &,
		bool &, bool & );
	
// Similar to above, but for SysTray widget
	void getSysTrayOptions( bool &, bool &, bool &, bool &, bool &, bool & );
	
// and for scrolling
	void getScrollingOptions( int &, int &, int &, bool & );
		
private slots:
// Called everytime a specific button is pressed - toggles tabs, buttons etc
	void slotToggle();
// I need another one, with an int parameter....
	void slotToggleScroll(int);
		
private:
	QList<QRadioButton> rbuttons;
	QList<QCheckBox> cboxes;
	QList<QLabel> labels;
	QVBox *m_pCustomStatsTab;
	QSlider *delaySlider;
	QSlider *smoothnessSlider;
	QComboBox *dirBox;
	QComboBox *scrollBox;
};

#endif	// __KVISTATOPTIONS_H__

