/**vim: ts=4, wrap, tw=80
  *
  *		--- libkvistatsystraywidget.h ---
  *
  * This is a plugin for KVirc 2.0 Phoenix. It allows you to see
  * statistics of your IRC sessions - total words said etc.
  * More features are still to come.
  *
  * (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
  * 
  * This program is FREE software. You can redistribute it and/or
  * modify it under the terms of the GNU General Public License
  * as published by the Free Software Foundation; either version 2
  * of the License, or (at your opinion) any later version.
  *
  * This program is distributed in the HOPE that it will be USEFUL,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  * See the GNU General Public License for more details.

  * You should have received a copy of the GNU General Public License
  * along with this program. If not, write to the Free Software Foundation,
  * Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
  **/


#ifndef __LIBKVISTATDOCKWIDGET_H__
#define __LIBKVISTATDOCKWIDGET_H__

#include "kvi_systray.h"

class KviFrame;
class KviStatChan;
class KviStatWindow;
class QPixmap;
class QPopupMenu;

class KviStatSysTrayWidget : public KviSysTrayWidget
{
	Q_OBJECT
public:	
	KviStatSysTrayWidget(KviSysTray * parent,KviFrame * frm,
		const char * tooltip = 0);
	~KviStatSysTrayWidget();
	
	virtual QPixmap * icon();
	KviFrame * frame() const;
	
// set display options in this order:
//                 words, joins, kicks, bans, topics
	void setOptions( bool, bool, bool, bool, bool );
	void setScrollingOptions( int, int, int, bool );
	void setStartDate( const char * dupa ) { m_startDate = dupa; }

protected:
	virtual void paintEvent( QPaintEvent *);
	virtual void timerEvent( QTimerEvent *);
	virtual void mousePressEvent( QMouseEvent *);
	
signals:
	void wantOptions();
	
private:
// scrolling options:
	int scrollingWhen;
	bool wantScrolling;
	int textXPos;			// position of the text
	int textDelay;			// delay of the text
	int textJump;			// how manu pixels the text moves on each timerEvent
	bool textDirectionLeft;	// if TRUE text scrolls from right to left
	KviSysTray *m_pParent;
	KviFrame * m_pFrm;
	QPopupMenu *rmbPopup;	// popup for RMB click
	
//	bool m_showingConsoleStats;
//	ulong m_sessions, m_kicks, m_bans, m_joins, m_topics;
	QString m_startDate;
	
// display options:
	bool m_showWords;
	bool m_showJoins;
	bool m_showKicks;
	bool m_showBans;
	bool m_showTopics;

private slots:
	void slotHide();
};

inline KviFrame * KviStatSysTrayWidget::frame() const { return m_pFrm; }

#endif	// __LIBKVISTATDOCKWIDGET_H__
