//=============================================================================
//
//   Copyright (C) 2003 Your Name (you@mailhost)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

//
// The following two lines are standard for all plugins
//
#define __KVIRC_PLUGIN__
#include "kvirc_plugin.h"

/**
 * The /HELLO command handler.
 * It will be called by KVIrc when the HELLO command
 * is invoked by the user (in the commandline or a script).
 * The 'window' field of the 'cmd' structure points
 * to the window where the /HELLO command has been executed in.
 */
bool hello_plugin_command_hello(KviPluginCommandStruct *cmd)
{
	// Output 'Hello world!'
	cmd->window->output(KVI_OUT_HAPPY, "Hello world!");
	return true; // Success
}

/**
 * The plugin init routine.
 * It is called by KVIrc when the plugin is loaded.
 * You should place the following plugin internal initialization here:
 * - install hooks for events with 'kvirc_plugin_add_hook'
 * - insert new commands with 'kvirc_plugin_register_command'
 * - initialize your structures
 * - load your plugin config file
 * - ...
 * If the plugin is loaded at KVIrc startup (automatically),
 * the cmd structure contains only one meaningful field: handle.
 * The other fields are set to 0 and should not be used.
 * If the plugin is loaded by the /PLUGIN load command
 * the cmd->window field is set to point to the window
 * where the /PLUGIN command has been executed in.
 * In that case (if cmd->window is non-zero), you can
 * output something to that window.
 */
bool hello_plugin_init(KviPluginCommandStruct *cmd)
{
	// Check if the cmd->window field is non-zero
	if( cmd->window ) {
		// Yes, we can output something to that window
		cmd->window->output(KVI_OUT_HAPPY, "HELLO WORLD! :)");
	} else {
		// No, the plugin was loaded at KVIrc startup.
		// We'll output the "hello world" to the console.
		debug("[hello plugin]: HELLO WORLD!");
	}

	//
	// Here we register the HELLO command.
	// The user will be able to use it by typing /HELLO
	//
	kvirc_plugin_register_command(cmd->handle, "HELLO", hello_plugin_command_hello);

	// If your plugin initialization fails for some reason,
	// you should return 'false' here.
	// In that case the plugin will be immediately unloaded
	// (without executing the cleanup routine).
	// If your plugin initialization went OK, just return
	// 'true' here to indicate success. You are up and running.
	return true; // Success
}

/**
 * The plugin definition structure
 * It MUST be named 'kvirc_plugin'
 * It is the first symbol that KVIrc looks for in a plugin
 */
KviPlugin kvirc_plugin =
{
	"Hello world",                          // Plugin name
	"A sample plugin",                      // Description
	"0.1",                                  // Version
	"Your Name <you@mailhost>",             // Author info
	"<html>" \
	"This plugin exports<br>" \
		"the <b>HELLO</b> command."
		"</html>",                          // Commands/styles exported
	hello_plugin_init,                      // Init routine
	0,                                      // Cleanup routine
	0,                                      // Configuration routine
	0                                       // Help routine
};
