#ifndef _KVI_MEMMOVE_H_INCLUDED_
#define _KVI_MEMMOVE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_memmove.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_settings.h"

#ifndef _KVI_MEMMOVE_CPP_

	// In fastmove the src and dst may not overlap
	extern void *kvi_memmove(void *dst_ptr, const void *src_ptr, int len);

	#ifdef COMPILE_i386_ASM_CODE

	inline void kvi_fastmove(void *dst_ptr, const void *src_ptr, int len)
	{
		__asm__ __volatile__(
			"	cld\n"
			"	shr $1,%0\n"
			"	jnc 1f\n"
			"	movsb\n"
			"1:\n"
			"	shr $1,%0\n"
			"	jnc 2f\n"
			"	movsw\n"
			"2:\n"
			"	repnz; movsl\n"
			: "=c" (len), "=&S" (src_ptr), "=&D" (dst_ptr)
			: "0"  (len), "1"   (src_ptr), "2"   (dst_ptr)
		);
	}

	#else // COMPILE_i386_ASM_CODE
		extern void kvi_fastmove(void *dst_ptr, const void *src_ptr, int len);
	#endif
#endif // _KVI_MEMMOVE_CPP_

#endif // _KVI_MEMMOVE_H_INCLUDED_
