#ifndef _KVI_INTEGERSELECTOR_KDE_H_INCLUDED_
#define _KVI_INTEGERSELECTOR_KDE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_integerselector_kde.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <knuminput.h>

#include "kvi_string.h"

class KviIntegerSelector : public KIntNumInput
{
	Q_OBJECT
public:
	enum IntSelectorType { Int, UInt, UShort, Short };
	KviIntegerSelector(
		QWidget *parent, const char *description, void *pNumber, IntSelectorType type, int lowerBound, int upperBound,
		int defValue, bool bEnabled = true, int fieldWidth = -1, const char *name = 0, const char *suffix = ""
	);
	~KviIntegerSelector();
private:
	IntSelectorType  m_type;
	void            *m_pNumber;
	int              m_iFieldWidth;
public:
	virtual void commitChanges();
	 static void commitAll(QWidget *);
	void resizeEvent(QResizeEvent *);
};

#endif // _KVI_INTEGERSELECTOR_KDE_H_INCLUDED_
