// =============================================================================
//
//      --- kvi_dns.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003 Robin Verduijn <robin@debian.org>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviDNS"

#include "kvi_dns.h"
#include "kvi_error.h"
#include "kvi_settings.h"

KviDns::KviDns()
	: QDns()
{
	m_dnsData = 0;
}

KviDns::~KviDns()
{
	clearData();
}

void KviDns::clearData()
{
	if( m_dnsData ) {
		delete m_dnsData;
		m_dnsData = 0;
	}
}

bool KviDns::abort()
{
	if( !isWorking() ) return false;
	clearData();
	return true;
}

bool KviDns::resolve(const char *hostname, bool bIPv6)
{
	if( isWorking() ) return false;

	setRecordType(QDns::A);
	clearData();
	m_dnsData = new KviDnsData();
	m_dnsData->hostname = hostname;
	m_dnsData->bIPv6    = bIPv6;
	m_dnsData->parent   = this;
#ifdef COMPILE_NEED_IPV6
	if( bIPv6 )
		setRecordType(QDns::Aaaa);
#endif
	connect(this, SIGNAL(resultsReady()), this, SLOT(slotProcessResults()));
	setLabel(hostname);
	return true;
}

void KviDns::slotProcessResults()
{
	m_dnsData->iError    = KVI_ERROR_Success;
	m_dnsData->addresses = addresses();
	if( m_dnsData->addresses.empty() ) {
		m_dnsData->iError = KVI_ERROR_HostNotFound;
	}
	if( m_dnsData->hostname.isEmpty() )
		m_dnsData->iError = KVI_ERROR_NoHostToResolve;

	emit finished(m_dnsData);
}

KviDnsData *KviDns::releaseData()
{
	if( isWorking() ) return 0;

	KviDnsData *data = m_dnsData;
	m_dnsData = 0;
	return data;
}

#include "m_kvi_dns.moc"
