// =============================================================================
//
//      --- kvi_error.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviError"

#define _KVI_ERROR_CPP_

#include <string.h>

#include "kvi_debug.h"
#include "kvi_locale.h"
#include "kvi_settings.h"

static const char *g_kviErrorStringTable[] = {
	_i19n_("No error"),                                                            // NoError
	_i19n_("Unknown error"),                                                       // UnknownError
	_i19n_("No child process: not started or killed before completing operation"), // NoChildProcess
	_i19n_("No host to resolve"),                                                  // NoHostToResolve
	_i19n_("Host not found"),                                                      // HostNotFound
	_i19n_("Valid name, but the host has no IP address"),                          // ValidNameButNoIpAddress
	_i19n_("Unrecoverable nameserver error"),                                      // UnrecoverableNameserverError
	_i19n_("Temporary DNS fault, try again"),                                      // DnsTemporaryFault
	_i19n_("DNS query failed"),                                                    // DnsQueryFailed
	_i19n_("Invalid IP address"),                                                  // InvalidIpAddress
	_i19n_("Another connection in progress"),                                      // AnotherConnectionInProgress
	_i19n_("Socket creation failed"),                                              // SocketCreationFailed
	_i19n_("Async socket operation not supported (fcntl failed)"),                 // AsyncSocketFailed
	_i19n_("Bad file descriptor"),                                                 // BadFileDescriptor
	_i19n_("Out of address space"),                                                // OutOfAddressSpace
	_i19n_("Kernel networking panic"),                                             // KernelNetworkingPanic
	_i19n_("Connection refused by remote host"),                                   // ConnectionRefused
	_i19n_("Connection attempt timed out"),                                        // ConnectionTimedOut
	_i19n_("Network is unreachable"),                                              // NetworkUnreachable
	_i19n_("Remote end closed connection"),                                        // RemoteEndClosedConnection
	_i19n_("You are not connected to a server"),                                   // NotConnectedToServer
	_i19n_("Broken pipe"),                                                         // BrokenPipe
	_i19n_("Cannot find a server to contact. Please select a server in the "\
	       "server options dialog."),                                              // NoServerEntries
	_i19n_("Unable to lookup local socket name."),                                 // GetsocknameFailed
	_i19n_("Invalid proxy address."),                                              // InvalidProxyAddress
	_i19n_("Unrecognized proxy reply"),                                            // UnrecognizedProxyReply
	_i19n_("Proxy connection rejected."),                                          // ProxyConnectionRejected
	_i19n_("No acceptable authentication methods"),                                // ProxyNoAcceptableMethods
	_i19n_("Proxy authorisation failed"),                                          // ProxyAuthFailed
	_i19n_("Proxy error: general socks failure"),                                  // ProxyReply01GeneralSOCKSFailure
	_i19n_("Proxy error: connection not allowed"),                                 // ProxyReply02ConnectionNotAllowed
	_i19n_("Proxy error: target network unreachable"),                             // ProxyReply03NetworkUnreachable
	_i19n_("Proxy error: target host unreachable"),                                // ProxyReply04HostUnreachable
	_i19n_("Proxy error: target host refused the connection"),                     // ProxyReply05ConnectionRefused
	_i19n_("Proxy error: target connection failed: TTL Expired"),                  // ProxyReply06TTLExpired
	_i19n_("Proxy error: command not supported"),                                  // ProxyReply07CommandNotSupported
	_i19n_("Proxy error: address type not supported"),                             // ProxyReply08AddressTypeNotSupported
	_i19n_("Proxy error: invalid address"),                                        // ProxyReply09InvalidAddress
	_i19n_("Proxy error: 91: request failed"),                                     // ProxyReply91RequestFailed
	_i19n_("Proxy error: 92: ident failed"),                                       // ProxyReply92IdentFailed
	_i19n_("Proxy error: 93: ident not matching"),                                 // ProxyReply93IdentNotMatching
	_i19n_("This executable was compiled without sound support"),                  // CompiledWithNoSound
	_i19n_("The soundcard device is already open"),                                // SoundCardAlreadyOpen
	_i19n_("Could not open the soundcard device (/dev/dsp)"),                      // CanNotOpenDevDsp
	_i19n_("Could not initialize soundcard: unsupported format, channels "\
	       "number or sample rate"),                                               // CanNotInitializeSoundCard
	_i19n_("Dummy: missing file name"),                                            // MissingFileName
	_i19n_("Missing closing brace"),                                               // MissingClosingBrace
	_i19n_("Unknown command"),                                                     // UnknownCommand
	_i19n_("Missing variable name"),                                               // MissingVariableName
	_i19n_("Unknown operator"),                                                    // UnknownOperator
	_i19n_("Unknown identifier"),                                                  // UnknownIdentifier
	_i19n_("Unknown function"),                                                    // UnknownFunction
	_i19n_("Unexpected end of command"),                                           // UnexpectedEndOfCommand
	_i19n_("Missing operator"),                                                    // MissingOperator
	_i19n_("Missing window name"),                                                 // MissingWindowName
	_i19n_("Window not found"),                                                    // WindowNotFound
	_i19n_("Missing icon number"),                                                 // MissingIconNumber
	_i19n_("Invalid option/switch"),                                               // InvalidOption
	_i19n_("Cannot find external help data files, or cannot open it for reading.\n"\
	       "Please check your installation"),                                      // CannotFindHelpFiles
	_i19n_("No help available on that... try /HELP index"),                        // NoHelpAvailable
	_i19n_("Could not open the file for reading"),                                 // CannotOpenFileForReading
	_i19n_("Left operand is not a numeric value"),                                 // LeftOperandIsNotANumber
	_i19n_("Right operand is not a numeric value"),                                // RightOperandIsNotANumber
	_i19n_("Left operand is undefined"),                                           // LeftOperandIsUndefined
	_i19n_("Unbalanced parenthesis"),                                              // ParenthesisMismatch
	_i19n_("Unexpected character"),                                                // UnexpectedCharacter
	_i19n_("Oops... Internal error?"),                                             // InternalError
	_i19n_("Missing command after else"),                                          // MissingCommandAfterElse
	_i19n_("Open parenthesis expected"),                                           // OpenParenthesisExpected
	_i19n_("Missing command after while"),                                         // MissingCommandAfterWhile
	_i19n_("Single string operand"),                                               // SingleStringOperand
	_i19n_("Operand does not match operator"),                                     // OperandDoesNotMatchOperator
	_i19n_("Division by zero"),                                                    // DivisionByZero
	_i19n_("Unexpected end in string"),                                            // UnexpectedEndInString
	_i19n_("Do without while"),                                                    // DoWithoutWhile
	_i19n_("Command terminator expected"),                                         // CommandTerminatorExpected
	_i19n_("Missing dialog type"),                                                 // MissingDialogType
	_i19n_("Unknown dialog type"),                                                 // UnknownDialogType
	_i19n_("Alias name expected"),                                                 // AliasNameExpected
	_i19n_("Alias body expected"),                                                 // AliasBodyExpected
	_i19n_("Missing channel name"),                                                // MissingChannelName
	_i19n_("Mode requires parameters"),                                            // ModeRequiresParameters
	_i19n_("Open brace '{' expected"),                                             // OpenBraceExpected
	_i19n_("Case, match, default command or end of switch expected"),              // CaseDefaultMatchOrEndOfSwitchExpected
	_i19n_("Command expected after 'default'"),                                    // CommandExpectedAfterDefault
	_i19n_("Command expected after 'case()'"),                                     // CommandExpectedAfterCase
	_i19n_("End of switch expected after 'default' action"),                       // EndOfSwitchExpectedAfterDefault
	_i19n_("Command expected after 'match()'"),                                    // CommandExpectedAfterMatch
	_i19n_("NICK requires a nickname!"),                                           // NickRequiresANick
	_i19n_("Popup menu item command definition expected"),                         // PopupItemCommandExpected
	_i19n_("Item, popup or separator expected"),                                   // ItemPopupOrSeparatorExpected
	_i19n_("Unknown popup"),                                                       // UnknownPopup
	_i19n_("This is not a channel"),                                               // ThisIsNotAChannel
	_i19n_("Missing target"),                                                      // MissingTarget
	_i19n_("Who queries require nickname parameters"),                             // WhoQueriesRequireANick
	_i19n_("Missing CTCP type"),                                                   // MissingCtcpType
	_i19n_("This is not a query/channel"),                                         // ThisIsNotAQueryNorChannel
	_i19n_("Log on/off required"),                                                 // LogOnOffRequired
	_i19n_("Could not start logging in this window"),                              // CannotStartLoggingInThisWindow
	_i19n_("Could not start logging."),                                            // CannotStartLogging
	_i19n_("Could not start the DNS thread."),                                     // CanNotStartDnsThread
	_i19n_("Unsupported DCC type"),                                                // UnsupportedDccType
	_i19n_("Missing user mask"),                                                   // MissingMask
	_i19n_("User already registered"),                                             // AlreadyRegistered
	_i19n_("Invalid registration mask: must be of type nick!user@host and "\
	       "can contain the '*' wildcard"),                                        // InvalidRegistrationMask
	_i19n_("The registration dialog is open, please add/remove the user from "\
	       "that dialog, or close it before using this command"),                  // RegistrationWillBeResetByDialog
	_i19n_("User not registered"),                                                 // UserNotRegistered
	_i19n_("Cannot self-modify the alias while executing it"),                     // AliasSelfModificationNotAllowed
	_i19n_("Cannot self-modify the popup while executing it"),                     // PopupSelfModificationNotAllowed
	_i19n_("The file is not a valid KVIrc script"),                                // NotAValidScriptFile
	_i19n_("Invalid parameter, string length expected"),                           // StringLengthExpected
	_i19n_("Invalid parameter, string index expected"),                            // StringIndexExpected
	_i19n_("Missing timeout"),                                                     // MissingTimeout
	_i19n_("No mime type matching"),                                               // NoMimeTypeMatching
	_i19n_("No commandline specified for mimetype"),                               // NoCommandlineForMimeType
	_i19n_("Missing timer name"),                                                  // MissingTimerName
	_i19n_("Invalid timeout"),                                                     // InvalidTimeout
	_i19n_("Invalid port"),                                                        // InvalidPort
	_i19n_("No matching timers"),                                                  // NoMatchingTimers
	_i19n_("Missing option name"),                                                 // MissingOptionName
	_i19n_("No such option"),                                                      // NoSuchOption
	_i19n_("Missing option value"),                                                // MissingOptionValue
	_i19n_("Invalid option type"),                                                 // InvalidOptionType
	_i19n_("No alias with that name"),                                             // NoAliasWithThatName
	_i19n_("Invalid range value"),                                                 // InvalidRangeValue
	_i19n_("Missing commandline"),                                                 // MissingCommandline
	_i19n_("Process start failed"),                                                // ProcessStartFailed
	_i19n_("Missing window operation"),                                            // MissingWindowOperation
	_i19n_("Unknown window operation"),                                            // UnknownWindowOperation
	_i19n_("This window has no text buffer"),                                      // ThisWindowHasNoTextBuffer
	_i19n_("Window position X, Y Expected"),                                       // WindowPositionXYExpected
	_i19n_("Window size expected"),                                                // WindowSizeExpected
	_i19n_("Unknown image format"),                                                // UnknownImageFormat
	_i19n_("Unable to save text buffer"),                                          // UnableToSaveBuffer
	_i19n_("Missing nickname"),                                                    // MissingNickname
	_i19n_("Unsigned integer expected"),                                           // UnsignedIntegerExpected
	_i19n_("Config file path expected"),                                           // ConfigFilePathExpected
	_i19n_("Invalid config type"),                                                 // InvalidConfigType
	_i19n_("This window has no commandline input"),                                // ThisWindowHasNoCommandline
	_i19n_("Missing pitch"),                                                       // MissingPitch
	_i19n_("Missing duration"),                                                    // MissingDuration
	_i19n_("Channel not found"),                                                   // ChannelNotFound
	_i19n_("Missing directory name"),                                              // MissingDirName
	_i19n_("Unable to list directory contents"),                                   // CannotListDirContents
	_i19n_("Invalid directory"),                                                   // InvalidDirectory
	_i19n_("Cannot enter that directory"),                                         // CannotEnterThatDirectory
	_i19n_("Missing pid"),                                                         // MissingPid
	_i19n_("No such process"),                                                     // NoSuchProcess
	_i19n_("Could not write to process"),                                          // CannotWriteToProcess
	_i19n_("Invalid window name. You forgot the *."),                              // InvalidWindowName
	_i19n_("Missing dictionary key"),                                              // MissingDictionaryKey
	_i19n_("Missing dictionary name"),                                             // MissingDictionaryName
	_i19n_("Plugin file path expected"),                                           // PluginFilePathExpected
	_i19n_("Invalid plugin operation"),                                            // InvalidPluginOperation
	_i19n_("No plugin support in this executable"),                                // NoPluginSupport
	_i19n_("No such plugin"),                                                      // NoSuchPlugin
	_i19n_("Unable to load plugin"),                                               // CannotLoadPlugin
	_i19n_("Could not execute plugin init routine"),                               // CannotExecutePluginInitRoutine
	_i19n_("Missing parameter"),                                                   // MissingParameter
	_i19n_("Invalid parameter"),                                                   // InvalidParameter
	_i19n_("Invalid operation"),                                                   // InvalidOperation
	_i19n_("Missing key"),                                                         // MissingKey
	_i19n_("Missing section"),                                                     // MissingSection
	_i19n_("Utoolbar command expected: button, separator, menu, update, clear"),   // UtoolbarCommandExpected
	_i19n_("Missing command block to try"),                                        // MissingCommandBlockToTry
	_i19n_("Could not open the file for writing"),                                 // CannotOpenFileForWriting
	_i19n_("Missing object class"),                                                // MissingObjectClass
	_i19n_("Missing object name"),                                                 // MissingObjectName
	_i19n_("Missing object parent"),                                               // MissingObjectParent
	_i19n_("Unknown object class"),                                                // UnknownObjectClass
	_i19n_("Nonexistant parent object"),                                           // NonexistantParentObject
	_i19n_("Object not found"),                                                    // ObjectNotFound
	_i19n_("Missing object field name"),                                           // MissingObjectField
	_i19n_("Missing object ID"),                                                   // MissingObjectId
	_i19n_("Missing object event name"),                                           // MissingObjectEventName
	_i19n_("No such object function"),                                             // NoSuchObjectFunction
	_i19n_("Object function call failure"),                                        // ObjectFunctionFailure
	_i19n_("Class already defined"),                                               // ClassAlreadyDefined
	_i19n_("Event or Function keyword expected"),                                  // EventOrFunctionKeywordExpected
	_i19n_("Invalid class override"),                                              // InvalidClassOverride
	_i19n_("Variable or identifier expected"),                                     // VariableOrIdentifierExpected
	_i19n_("Not connected"),                                                       // NotConnected
	_i19n_("The object is not a socket"),                                          // ObjectIsNotASocket
	_i19n_("The socket object has no connections to accept"),                      // NoConnectionToAccept
	_i19n_("No text to find"),                                                     // NoTextToFind
	_i19n_("No such Qt property"),                                                 // NoSuchQtProperty
	_i19n_("The object is not a widget"),                                          // ObjectIsNotAWidget
	_i19n_("Missing signal name"),                                                 // MissingSignalName
	_i19n_("Missing slot name"),                                                   // MissingSlotName
	_i19n_("Unsupported Qt property"),                                             // UnsupportedQtProperty
	_i19n_("Missing URL"),                                                         // MissingUrl
	_i19n_("Missing browser commandline: set it in the misc options dialog!"),     // MissingBrowserCommandlineOption
	_i19n_("Object is not a popup menu"),                                          // ObjectIsNotAPopup
	_i19n_("Missing hostname"),                                                    // MissingHostname
	_i19n_("Missing services command"),                                            // MissingServicesCommand
	_i19n_("Userhost queries require nickname parameters"),                        // UserhostRequiresANick
	_i19n_("User command requires username, host, server, and "\
	       "optionally, description"),                                             // UserRequiresUHS
	_i19n_("DCC thread aborted"),                                                  // DccThreadAborted
	// End
	0
};

const char *kvi_getErrorString(int errorNum)
{
	__range_valid(errorNum < KVI_ERROR_NUMBER_OF_ERRORS);
	if( errorNum < 0 ) {
		// Unhandled system errors (errno value not handled in switches)
#ifdef HAVE_STRERROR
		__debug_1arg("Negative error for us... strerr error %s", strerror(errorNum));
		return strerror(-errorNum);
#else
		__debug_1arg("Have no strerror, errorNum was %d", -errorNum);
		errorNum = KVI_ERROR_UnknownError;
#endif
	}
	return _i18n_(g_kviErrorStringTable[errorNum]);
}
