// =============================================================================
//
//      --- kvi_strsub.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviStrsub"

#define _KVI_STRSUB_CPP_

#include "kvi_config.h"
#include "kvi_string.h"
#include "kvi_strsub.h"

KviStrSub::KviStrSub()
{
	m_pList = new QPtrList<KviStrSubItem> ();
	m_pList->setAutoDelete(true);
}

KviStrSub::~KviStrSub()
{
	if( m_pList ) {
		delete m_pList;
		m_pList = 0;
	}
}

bool KviStrSub::save(KviConfig *cfg)
{
	cfg->writeEntry("WordCount", m_pList->count());

	int i = 0;
	for( KviStrSubItem *item = m_pList->first(); item; item = m_pList->next() ) {
		KviStr key(KviStr::Format, "Original_%d", i);
		cfg->writeEntry(key.ptr(), item->szOriginal.ptr());
		key.sprintf("Subst_%d", i);
		cfg->writeEntry(key.ptr(), item->szSubstitute.ptr());
		i++;
	}
	return true;
}

bool KviStrSub::load(KviConfig *cfg)
{
	int count = cfg->readIntEntry("WordCount", 0);

	for( int i = 0; i < count; i++ ) {
		KviStrSubItem *item = new KviStrSubItem;
		KviStr key(KviStr::Format, "Original_%d", i);
		item->szOriginal = cfg->readEntry(key.ptr());
		key.sprintf("Subst_%d", i);
		item->szSubstitute = cfg->readEntry(key.ptr());
		m_pList->append(item);
	}
	return true;
}
