// =============================================================================
//
//      --- kvi_boolselector.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviBoolSelector"

#include <qobjectlist.h>

#include "kvi_boolselector.h"
#include "kvi_string.h"

KviBoolSelector::KviBoolSelector(QWidget *parent, const char *description, bool *pBool, bool bEnabled, const char *name)
	: QCheckBox(_CHAR_2_QSTRING(description), parent, name)
{
	m_pBool = pBool;
	setChecked(*pBool);
	setEnabled(bEnabled);
}

KviBoolSelector::~KviBoolSelector()
{
	// Nothing here
}

void KviBoolSelector::commitChanges()
{
	*m_pBool = isChecked();
}

void KviBoolSelector::commitAll(QWidget *w)
{
	QObjectList *l = w->queryList("KviBoolSelector");
	if( !l ) return;
	QObjectListIt it(*l);
	while( it.current() ) {
		((KviBoolSelector *) it.current())->commitChanges();
		++it;
	}
	delete l;
}

#include "m_kvi_boolselector.moc"
