#ifndef _KVI_DCC_EVENT_H_INCLUDED_
#define _KVI_DCC_EVENT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_dcc_event.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qevent.h>

#include "kvi_string.h"

#define KVI_DCC_EVENT_ERROR                   1
#define KVI_DCC_EVENT_MSG                     2
#define KVI_DCC_EVENT_DATA                    3
#define KVI_DCC_EVENT_LISTENING               4
#define KVI_DCC_EVENT_DCCSENDSTATUS           5
#define KVI_DCC_EVENT_FINISHED                6
#define KVI_DCC_EVENT_ENABLETALK              7
#define KVI_DCC_EVENT_DISABLETALK             8
#define KVI_DCC_EVENT_BUFFEREDTIME            9
#define KVI_DCC_EVENT_CONNECTIONESTABLISHED  10

class KviDccEvent : public QEvent
{
public:
	KviDccEvent(int type, const char *data);
	~KviDccEvent();

	KviStr m_dataString;
	int    m_type;
	int    m_param;
};

#endif // _KVI_DCC_EVENT_H_INCLUDED_
