// =============================================================================
//
//      --- kvi_asyncdialog.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviAsyncDialog"

#include "kvi_asyncdialog.h"
#include "kvi_userparser.h"

KviAsyncDialog::KviAsyncDialog(KviUserParser *parser, KviWindow *pWnd)
{
	m_pParser = parser;
	m_pWnd    = pWnd;
	m_pParser->addAsyncDialog(this);
}

KviAsyncDialog::~KviAsyncDialog()
{
	m_pParser->removeAsyncDialog(this);
}

void KviAsyncDialog::setJob(const char *beginptr, const char *endptr)
{
	if( !endptr )
		m_szJob = beginptr;
	else
		m_szJob.setStr(beginptr, endptr - beginptr);
}

void KviAsyncDialog::runJob(const char *dialogresult)
{
	m_pParser->m_szLastDialogResult = dialogresult;
	m_pParser->m_szLastDialogMagic  = m_szMagic;
	m_pParser->parseAsyncDialogCallback(m_szJob, m_pWnd);
}
