#ifndef _KVI_CONSOLE_H_INCLUDED_
#define _KVI_CONSOLE_H_INCLUDED_

// =============================================================================
//
//      --- kvi_console.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_window.h"

class KviConsole : public KviWindow
{
	friend class KviHelpWindow;   // It uses our output widget
	friend class KviServerParser; // Users our list box
	Q_OBJECT
public:
	KviConsole(KviFrame *lpFrm);
	~KviConsole();
protected:
	virtual QPixmap *myIconPtr();
	virtual void     resizeEvent(QResizeEvent *);
	virtual void     applyOptions();
	virtual void     setProperties(KviWindowProperty *);
	virtual void     saveProperties();
	virtual void     youAreAttached(KviMdiChild *lpC);
protected slots:
	void listBoxRightClicked();
	void notifylistPopupClicked(const KviStr &dataBuffer);
	void viewRightClicked(KviIrcView *);
	void viewPopupClicked(const KviStr &dataBuffer);
};

#endif // _KVI_CONSOLE_H_INCLUDED_
