// =============================================================================
//
//      --- kvi_finddialog.cpp ---
//          KviWindow "Find Text" Dialog
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2001 Triskelios (trisk@quasarnet.org)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviFindDialog"

#include <qcheckbox.h>
#include <qlayout.h>

#include "kvi_combobox.h"
#include "kvi_finddialog.h"
#include "kvi_irc_view.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_pushbutton.h"
#include "kvi_window.h"

KviFindDialog::KviFindDialog(QWidget *parent)
	: KviDialog(parent, "finddialog", true)
{
	setCaption(_i18n_("Find Text"));
	m_pWin = (KviWindow *) parent;
	QGridLayout *g = new QGridLayout(this, 5, 2, 10, 4);

	KviLabel *l = new KviLabel(_i18n_("Text to find:"), this);
	g->addMultiCellWidget(l, 0, 0, 0, 1);

	m_pTextField = new KviComboBox(true, this);
	m_pTextField->setMaxCount(10);
	m_pTextField->setInsertionPolicy(KviComboBox::AtTop);
	m_pTextField->setAutoCompletion(true);
	m_pTextField->setDuplicatesEnabled(false);
	g->addMultiCellWidget(m_pTextField, 1, 1, 0, 1);

	m_pCheckBox = new QCheckBox(_i18n_("Find backwards"), this);
	g->addMultiCellWidget(m_pCheckBox, 2, 2, 0, 1);

	QFrame *r = new QFrame(this);
	r->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addMultiCellWidget(r, 3, 3, 0, 1);

	KviPushButton *b;
	b = new KviPushButton(_i18n_("&Find"), this);
	b->setDefault(true);
	connect(b, SIGNAL(clicked()), this, SLOT(findText()));
	g->addWidget(b, 4, 0);

	b = new KviPushButton(_i18n_("&Close"), this);
	connect(b, SIGNAL(clicked()), this, SLOT(reject()));
	g->addWidget(b, 4, 1);
}

void KviFindDialog::findText()
{
	if( !m_pCheckBox->isChecked() )
		m_pWin->m_pView->findNext(m_pTextField->currentText().ascii());
	else
		m_pWin->m_pView->findPrev(m_pTextField->currentText().ascii());
	if( m_pTextField->text(m_pTextField->currentItem()) != m_pTextField->currentText() ) {
		if( !m_pTextField->currentText().isNull() && !m_pTextField->currentText().isEmpty() )
			m_pTextField->insertItem(m_pTextField->currentText(), 0);
	}
}

KviFindDialog::~KviFindDialog()
{
	// Nothing here
}

#include "m_kvi_finddialog.moc"
