#ifndef _KVI_PLUGIN_H_INCLUDED_
#define _KVI_PLUGIN_H_INCLUDED_

// =============================================================================
//
//      --- kvi_plugin.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_settings.h"
#ifdef COMPILE_PLUGIN_SUPPORT

#include <qptrlist.h>

#include "kvi_string.h"
#ifndef __KVIRC_PLUGIN__
	#include "../plugins/kvirc_plugin.h"
#endif

class KviSysTrayWidget;
class KviDockableWidget;

typedef struct KviPluginData
{
	KviStr     filename;
	KviPlugin *description;
	void      *handle;
	bool       bAutoload;
	bool       bInitExecuted;
};

typedef struct KviPluginCommandHandler
{
	KviStr   cmd_name;
	bool   (*handler_routine)(KviPluginCommandStruct *);
	void    *plugin_handle;
};

typedef struct KviPluginFunctionHandler
{
	KviStr   fnc_name;
	bool   (*handler_routine)(KviPluginCommandStruct *, KviStr *);
	void    *plugin_handle;
};

class KviPluginManager
{
public:
	KviPluginManager();
	~KviPluginManager();
protected:
	QPtrList<KviPluginData>            *m_pPluginList;
	QPtrList<KviPluginCommandHandler>  *m_pCommandList;
	QPtrList<KviPluginFunctionHandler> *m_pFunctionList;
public:
	inline QPtrList<KviPluginData> *pluginList()              { return m_pPluginList; };

	KviPluginData *findPlugin(void *handle);
	KviPluginData *findPlugin(const char *);
	KviPluginData *findPluginByModuleName(const char *);
	KviPluginData *loadPlugin(const char *, bool bAutoload = true, KviStr *pErrorRet = 0);

	bool executeInitRoutine(KviPluginData *, KviPluginCommandStruct *);
	void getLastError(KviStr &buffer);
	bool unloadPlugin(const char *);
	bool unloadPluginByModuleName(const char *);

	void unregisterCommandsFor(void *handle);
	void   registerCommand(void *handle, const char *cmdname, bool (*handler_routine)(KviPluginCommandStruct *));
	void unregisterCommand(void *handle, const char *cmdname);

	KviPluginCommandHandler *findCommandHandler(const char *cmdname);

	void   registerFunction(void *handle, const char *name, bool (*handler_routine)(KviPluginCommandStruct *, KviStr *));
	void unregisterFunction(void *handle, const char *name);
	void unregisterFunctionsFor(void *handle);
	KviPluginFunctionHandler *findFunctionHandler(const char *name);

	void unregisterHooksFor(void *handle);
	void unregisterHook(void *handle, int eventindex);
	void   registerHook(void *handle, int eventindex, bool (*handler_routine)(KviPluginCommandStruct *));
	bool isHookRegistered(void *handle, int eventindex);

	void addPluginWindow(void *handle, KviFrame *frame, KviWindow *wnd, bool bShow = true);
	void removeAllPluginWindows(void *handle);

	void addPluginDockedWidget(void *handle, KviFrame *frame, KviDockableWidget *);
	void removeAllPluginDockedWidgets(void *handle);

	void addPluginSysTrayWidget(void *handle, KviFrame *frame, KviSysTrayWidget *, bool show = true);
	void removeAllPluginSysTrayWidgets(void *handle);

	void unregisterMetaObject(const char *metaObjName);

	bool load(const char *configName, KviStr &error);
	bool save(const char *configName);
private:
	void unloadPluginInternal(KviPluginData *);
};

#endif // COMPILE_PLUGIN_SUPPORT

#endif // _KVI_PLUGIN_H_INCLUDED_
