#ifndef _KVI_TASKBARBUTTON_H_INCLUDED_
#define _KVI_TASKBARBUTTON_H_INCLUDED_

// =============================================================================
//
//      --- kvi_taskbarbutton.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qwidget.h>

class QPixmap;

class KviTaskBar;
class KviWindow;

class KviTaskBarButton : public QWidget
{
	friend class KviTaskBar;
	friend class KviFrame;
	friend class KviWindow;
	friend class KviHelpWindow;

	Q_OBJECT

public:
	KviTaskBarButton(QWidget *parent, KviTaskBar *pTaskBar, KviWindow *win_ptr, QPixmap *mem_buf);
	~KviTaskBarButton();
private:
	KviWindow  *m_pWindow;
	KviTaskBar *m_pTaskBar;
	QPixmap    *m_pMemBuffer;
	bool        m_bIsOn;
	bool        m_bAttached;
	bool        m_bHighlighted;
	bool        m_bAltColor;
	int         m_iProgress;
protected:
	/**
	 * Highlights this button if it is NOT PRESSED.<br>
	 * (inline)
	 */
	void highlight(bool bAltColor = false);

	/**
	 * Sets the progress for this button.<br>
	 * progress == 0 removes the progress bar.<br>
	 * (inline)
	 */
	void setProgress(int progress);

	/**
	 * Repaints the button, updating the string data and the toolTip.
	 */
	void updateButton();
	void setOn(bool bOn);
	void setAttachState(bool bAttached);

	virtual void      paintEvent(QPaintEvent *);
	virtual void mousePressEvent(QMouseEvent *);
public:
	bool isOn();
};

inline void KviTaskBarButton::setProgress(int progress)
{
	if( progress != m_iProgress ) {
		m_iProgress = progress;
		if( m_iProgress > 100 ) m_iProgress = 100;
		paintEvent(0);
	}
}

#endif // _KVI_TASKBARBUTTON_H_INCLUDED_
