// =============================================================================
//
//      --- kvi_options_gui_output.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviOptionsGuiOutput"

#include <qlayout.h>

#include "kvi_app.h"
#include "kvi_boolselector.h"
#include "kvi_colorselector.h"
#include "kvi_fontselector.h"
#include "kvi_imageselector.h"
#include "kvi_locale.h"
#include "kvi_options_gui_output.h"
#include "kvi_options.h"

/*
	@quickhelp: KviOptionsGuiOutput
	@widget: Output widget GUI options
*/
KviOptionsGuiOutput::KviOptionsGuiOutput(QWidget *parent)
	: KviOptionsWidget(parent, KVI_GENERAL_OPTIONS_WIDGET_ID_GUIOUTPUT)
{
	QGridLayout *g = new QGridLayout(this, 9, 1, KVI_GENERAL_OPTIONS_GRIDLAYOUT_BORDER, 1);

	KviColorSelector *c = new KviColorSelector(this, _i18n_("Background color:"), &(g_pOptions->m_clrViewBack));
	g->addWidget(c, 0, 0);
	KviFontSelector *f = new KviFontSelector(this, _i18n_("Font:"), &(g_pOptions->m_fntView));
	g->addWidget(f, 1, 0);

	QFrame *fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr, 2, 0);

	m_pOutputImageSelector = new KviImageSelector(this,
		_i18n_("Use background image:"), &(g_pOptions->m_szViewBack), g_pOptions->m_pixViewBack
	);
	g->addWidget(m_pOutputImageSelector, 3, 0);

	fr = new QFrame(this);
	fr->setFrameStyle(QFrame::Sunken | QFrame::HLine);
	g->addWidget(fr, 4, 0);

	KviBoolSelector *b = new KviBoolSelector(this, _i18n_("Show message images"), &(g_pOptions->m_bShowImages));
	g->addWidget(b, 5, 0);
	b = new KviBoolSelector(this, _i18n_("Timestamp output lines"), &(g_pOptions->m_bTimestamp));
	g->addWidget(b, 6, 0);
	b = new KviBoolSelector(this, _i18n_("Add margin after first word wrap"), &(g_pOptions->m_bWrapMargin));
	g->addWidget(b, 7, 0);

	fr = new QFrame(this);
	g->addWidget(fr, 8, 0);
	g->setRowStretch(8, 1);
}

KviOptionsGuiOutput::~KviOptionsGuiOutput()
{
	// Nothing here
}

void KviOptionsGuiOutput::commitChanges()
{
	commitColorSelectors();
	commitFontSelectors();
	commitImageSelectors();
	KviBoolSelector::commitAll(this);
	g_pOptions->loadOutputBackgroundImage(m_pOutputImageSelector->getImage());
	g_pApp->triggerGlobalRepaint();
}

#include "m_kvi_options_gui_output.moc"
