#ifndef _KVI_SCRIPT_SPINBOX_H_INCLUDED_
#define _KVI_SCRIPT_SPINBOX_H_INCLUDED_

// =============================================================================
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_script_widget.h"

class KviScriptSpinBox : public KviScriptWidget
{
	Q_OBJECT
public:
	KviScriptSpinBox(KviScriptObjectController *, KviScriptObject *, const char *name, KviScriptObjectClassDefinition *);
	~KviScriptSpinBox();

	virtual bool init(QPtrList<KviStr> *params);
	static void initializeClassDefinition(KviScriptObjectClassDefinition *);

	int       builtinFunction_VALUE(QPtrList<KviStr> *params, KviStr &buffer);
	int builtinFunction_SETMINVALUE(QPtrList<KviStr> *params, KviStr &buffer);
	int builtinFunction_SETMAXVALUE(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_SETVALUE(QPtrList<KviStr> *params, KviStr &buffer);
	int builtinFunction_SETWRAPPING(QPtrList<KviStr> *params, KviStr &buffer);
	int    builtinFunction_WRAPPING(QPtrList<KviStr> *params, KviStr &buffer);
	int     builtinFunction_SETSTEP(QPtrList<KviStr> *params, KviStr &buffer);
	int   builtinFunction_SETSUFFIX(QPtrList<KviStr> *params, KviStr &buffer);
	int      builtinFunction_SUFFIX(QPtrList<KviStr> *params, KviStr &buffer);
	int  builtinFunction_CLEANVALUE(QPtrList<KviStr> *params, KviStr &buffer);
};

#endif // _KVI_SCRIPT_SPINBOX_H_INCLUDED_
