// =============================================================================
//
//      --- kvi_systray_bar.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviSysTrayBar"

#include "kvi_frame.h"
#include "kvi_systray.h"
#include "kvi_systray_bar.h"

KviSysTrayBar::KviSysTrayBar(KviFrame *parent)
	: KviToolBar("Systray bar", parent, parent, Qt::DockTop, false, "systray_toolbar")
{
	m_pSysTray = new KviSysTray(this);
	setHorizontalStretchable(true);
	setVerticalStretchable(false);
	setStretchableWidget(m_pSysTray);
	setBackgroundMode(PaletteBackground);
}

KviSysTrayBar::~KviSysTrayBar()
{
	// Nothing here
}

#include "m_kvi_systray_bar.moc"
