// =============================================================================
//
//      --- kvi_aboutdialog.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Till Bush (buti@geocities.com)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviAboutDialog"

#define __KVIRC_PLUGIN__

#include <qbitmap.h>
#include <qlayout.h>
#include <qpainter.h>
#include <qsimplerichtext.h>
#include <qtimer.h>

#include "kvi_about.h"
#include "kvi_aboutdialog.h"
#include "kvi_label.h"
#include "kvi_locale.h"
#include "kvi_pushbutton.h"
#include "kvirc_plugin.h"

KviAboutDialog *g_pAboutDialog = 0;
void *g_about_plugin_handle = 0;

static const char *const no_xpm[] =
{
	"41 8 2 1",
	" 	c None",
	"+	c #FFFFFF",
	"                                         ",
	"                  +++++     +++   +++++  ",
	" +  +            ++   ++   ++++  ++   ++ ",
	" ++ + +++            +++  ++ ++  ++   ++ ",
	" ++++ + +         ++++   ++  ++   ++++++ ",
	" + ++ + +  ++    +++     +++++++      ++ ",
	" +  + +++  ++    +++++++     ++   +++++  ",
	"                                         "
};

KviAboutDialog::KviAboutDialog(QWidget *parent)
	: KviDialog(parent)
{
	setCaption(_i18n_("About KVIrc"));
	QGridLayout *g = new QGridLayout(this, 3, 1, 10, 4);
	KviStr szImage;
	m_pfield = new KviLabel(this);
	m_pfield->setFrameStyle(QFrame::Panel | QFrame::Sunken);
	g->addWidget(m_pfield, 1, 0);
	posY = 0;

	m_pBackground = new QPixmap();
	m_pBackground->fill(Qt::black);
	if( g_pApp->findImage(szImage, "about.png") )
		m_pBackground->load(szImage.ptr());
	w = 320;
	h = 300;
	m_pBackground->resize(w, h);
	m_pfield->setFixedSize(w, h);

	QSimpleRichText doc(g_szAboutText, QFont(KVI_DEFAULT_FONT, 14));
	doc.setWidth(w - 8);
	m_text_height = doc.height();

	// Draw text and shadow
	m_ppix_text = new QPixmap(w, m_text_height);
	m_ppix_text->fill(Qt::black);
	QPainter p(m_ppix_text);

	QRect rect(0, 0, 640, 20000);
	doc.draw(&p, 0, 0, rect, colorGroup());
	m_ppix_text->setMask(m_ppix_text->createHeuristicMask(false));

	KviPushButton *btn_ok = new KviPushButton(_i18n_("&Close"), this);
	btn_ok->setDefault(true);
	g->addWidget(btn_ok, 2, 0);
	connect(btn_ok, SIGNAL(clicked()), this, SLOT(close()));

	QTimer *timer = new QTimer(m_pfield);
	connect(timer, SIGNAL(timeout()), SLOT(scrollText()));
	timer->start(45);
}

void KviAboutDialog::scrollText()
{
	posY++;
	repaint(false);
}

void KviAboutDialog::paintEvent(QPaintEvent *)
{
	QPixmap tmp_pix(*m_pBackground);
	QPainter p(&tmp_pix);
	bitBlt(&tmp_pix, 4, (h - posY) + 4, m_ppix_text, 1, 1, -1, -1);

	if( posY > h + m_text_height + 4 )
		posY = 0;
	p.end();
	bitBlt(m_pfield, 1, 1, &tmp_pix, 1, 1, w - 2, h - 2);
}

void KviAboutDialog::mouseReleaseEvent(QMouseEvent *e)
{
	if( (e->state() & ControlButton) && (e->state() & ShiftButton) )
		m_pBackground = new QPixmap((const char **) no_xpm);
}

KviAboutDialog::~KviAboutDialog()
{
	delete m_ppix_text;   m_ppix_text   = 0;
	delete m_pBackground; m_pBackground = 0;
}

void about_plugin_dialog_closed(KviAboutDialog *dlg)
{
	delete dlg;
	g_pAboutDialog = 0;
}

void KviAboutDialog::closeEvent(QCloseEvent *)
{
	about_plugin_dialog_closed(this);
}

void KviAboutDialog::close()
{
	about_plugin_dialog_closed(this);
}

bool about_plugin_command_aboutkvirc(KviPluginCommandStruct *cmd)
{
	if( !g_pAboutDialog ) {
		g_pAboutDialog = new KviAboutDialog();
		g_pAboutDialog->show();
	}
	return true;
}

/**
 * Init routine.
 */
bool about_plugin_init(KviPluginCommandStruct *cmd)
{
	g_about_plugin_handle = cmd->handle;

	kvirc_plugin_register_command(cmd->handle, "ABOUTKVIRC", about_plugin_command_aboutkvirc);
	return true;
}

void about_plugin_cleanup()
{
	if( g_pAboutDialog ) {
		delete g_pAboutDialog;
		g_pAboutDialog = 0;
	}
	kvirc_plugin_unregister_command(g_about_plugin_handle, "ABOUTKVIRC");
}

/**
 * Plugin definition structure.
 */
KviPlugin kvirc_plugin =
{
	"About",
	"The KVIrc 'Hall of Fame'",
	"1.0",
	"Till Bush <buti@geocities.com>\n"
		"Szymon Stefanek <stefanek@tin.it>",
	"<html>"
		"Exports the <b>/ABOUTKVIRC</b> command."
		"</html>",
	about_plugin_init,
	about_plugin_cleanup,
	0,
	0
};

#include "m_kvi_aboutdialog.moc"
