#ifndef _KVI_STAT_SYSTRAY_H_INCLUDED_
#define _KVI_STAT_SYSTRAY_H_INCLUDED_

// =============================================================================
//
//        --- kvi_stat_systray.h ---
//
//   This is a plugin for KVIrc 2. It allows you to see
//   statistics of your IRC sessions - total words said etc.
//   More features are still to come.
//
//   (c) Krzysztof Godlewski <kristoff@poczta.wprost.pl>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include "kvi_systray_widget.h"

class KviFrame;
class KviPopupMenu;

class KviStatSysTray : public KviSysTrayWidget
{
	Q_OBJECT
public:
	KviStatSysTray(KviSysTray *parent, KviFrame *frm, const char *tooltip = 0);
	~KviStatSysTray();

	virtual QString icon();
	KviFrame *frame() const;

	/**
	 * Set display options in this order:
	 * words, joins, kicks, bans, topics.
	 */
	void setOptions(bool, bool, bool, bool, bool);
	void setScrollingOptions(int, int, int, bool);
	void setStartDate(const char *date);

protected:
	virtual void paintEvent(QPaintEvent *);
	virtual void timerEvent(QTimerEvent *);
	virtual void mousePressEvent(QMouseEvent *);

signals:
	void wantOptions();

private:
	// Scrolling options:
	int  scrollingWhen;
	bool wantScrolling;
	int  textXPos;            // Position of the text.
	int  textDelay;           // Delay of the text.
	int  textJump;            // How manu pixels the text moves on each timerEvent.
	bool textDirectionLeft;   // If TRUE text scrolls from right to left.
	KviSysTray   *m_pParent;
	KviFrame     *m_pFrm;
	KviPopupMenu *rmbPopup;     // Popup for RMB click

	QString m_startDate;

	// Display options:
	bool m_showWords;
	bool m_showJoins;
	bool m_showKicks;
	bool m_showBans;
	bool m_showTopics;

private slots:
	void slotHide();
};

inline KviFrame *KviStatSysTray::frame() const { return m_pFrm; }

#endif // _KVI_STAT_SYSTRAY_H_INCLUDED_
