#ifndef _KVI_LOADSCRIPT_H_INCLUDED_
#define _KVI_LOADSCRIPT_H_INCLUDED_

// =============================================================================
//
//      --- kvi_loadscript.h ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#include <qptrlist.h>

#include "kvi_dialog.h"
#include "kvi_string.h"

class QCheckBox;
class QTextEdit;

class KviLabel;
class KviListBox;
class KviPushButton;

typedef struct KviScriptDefinition
{
	KviStr szName;
	KviStr szVersion;
	KviStr szAuthor;
	KviStr szEMail;
	KviStr szDate;
	KviStr szGenerator;
	KviStr szLanguageTag;
	KviStr szDescription;
	KviStr szWarnings;
	KviStr szKvsFileName;
};

class KviLoadScript : public KviDialog
{
	Q_OBJECT
public:
	KviLoadScript(QWidget *parent);
	~KviLoadScript();
public:
	KviPushButton  *m_pOkButton;
	KviListBox     *m_pListBox;

	QPtrList<KviScriptDefinition> *m_pScriptList;

	KviLabel        *m_pScriptName;
	KviLabel        *m_pScriptAuthor;
	KviLabel        *m_pScriptEMail;
	KviLabel        *m_pScriptVersion;
	KviLabel        *m_pScriptDate;
	KviLabel        *m_pScriptGenerator;
	KviLabel        *m_pScriptLanguageTag;
	QTextEdit       *m_pScriptDescription;
	QTextEdit       *m_pScriptWarnings;
	QCheckBox       *m_pRemoveEventsCheck;
	QCheckBox       *m_pRemoveAliasesCheck;
	QCheckBox       *m_pRemovePopupsCheck;
public:
	void getSelectedScriptFileName(KviStr &buffer, bool &bRemoveAliases, bool &bRemovePopups, bool &bRemoveEvents);
protected:
	void scanScriptDirectory();
signals:
	void finished(bool bAccepted);
protected slots:
	void okPressed();
	void cancelPressed();
	void scriptSelected(int idx);

	virtual void closeEvent(QCloseEvent *);
};

#endif // _KVI_LOADSCRIPT_H_INCLUDED_
